//B. Vandeportaele 2022
//export scad vers vrml avec couleur

// srs 2019 supporte iges, igs, step, stl, stp, wrl, jt
// https://en.wikibooks.org/wiki/OpenSCAD_User_Manual/First_Steps/Changing_the_color_of_an_object

// We can change the color of an object by giving it RGB values. Instead of the traditional RGB values from 0 to 255 floating point values are used from 0.0 to 1.0. Note: changing the colors works only in Preview mode (F5); render mode (F6) does not currently support color. 

//BVDP a testé en 2022, les exports n'intègrent pas la couleur non plus

//export: 
//https://en.wikibooks.org/wiki/OpenSCAD_User_Manual/Export

sz=10;

color(c=[1,0,0]) translate([-sz,0,0]) cube(sz);
color(c=[0,1,0]) translate([0,0,0]) cube(sz);
color(c=[0,0,1]) translate([sz,0,0]) cube(sz);

//dégradé
longueurdegrade=50;
nbdegrades=10;
for (r=[0:1/(nbdegrades-1):1]){    
    #echo(r);
    color(c=[r,0,0]) translate([r*longueurdegrade,20,0]) cube([longueurdegrade/(nbdegrades-1),sz,sz]);
    color(c=[0,r,0]) translate([r*longueurdegrade,40,0]) cube([longueurdegrade/(nbdegrades-1),sz,sz]);
    color(c=[0,0,r]) translate([r*longueurdegrade,60,0]) cube([longueurdegrade/(nbdegrades-1),sz,sz]);
    
}