//B. Vandeportaele 2022

epaisseur=2;
eps=0.1;
larg=66;
prof=105;
haut=20;


resolutionpart=60;//default value for the constant printerpart, it can be changed through command line using -D
//https://en.wikibooks.org/wiki/OpenSCAD_User_Manual/Using_OpenSCAD_in_a_command_line_environment
//use compile.sh to generate the stl files in stl/ subdirectory
resolution=resolutionpart;  //assign the constant value to a variable to be able to test it, even if the constant hasn't been defined in command line
 
 
///////////////////////////////////////// 
module base(){
union(){
    
    difference(){
cube([larg,prof,haut]);
translate([epaisseur,epaisseur,epaisseur+eps])
cube([larg-2*epaisseur,prof-2*epaisseur,haut-epaisseur]);    
        interrupteur();
     
chargeur();
        led();
                    trousjauge(6.5); //trous plus gros pour passer le tournevis
}
fixation_jauge(1);
texte();
}
}

///////////////////////////////////////// 
module batterie(){
    translate([13,3,10]) 
              rotate([0,0,90])
color("red",1.0) rotate([0,90,0]) cylinder(h=65,d=18,$fn=resolutionpart);
}

///////////////////////////////////////// 
module chargeur(){
      translate([64,-1,epaisseur]) 
              rotate([0,0,90])
color("blue",1.0)    
    cube([26,12,19]);
}

///////////////////////////////////////// 
module esp(){
      translate([3,70,6]) 
              
color("blue",1.0)    
  cube([58,31,13]);
}
///////////////////////////////       
module interrupteur(){
    
          translate([25,-0.1,epaisseur])               
color("yellow",1.0)    
    cube([21+0.5,19+0.5,12+0.5]); //tient compte des causses
}

///////////////////////////////       
module led(){
    
         translate([12,100.1,10+epaisseur])               
color("green",1.0)    
    cube([6,10,6]);
}
  ///////////////////////////////////////// 

///////////////////////////////////////// 
module texte()
{
    if (resolution>10){ // texte effacé si resolution<=10
    translate([62,104,+12]){

    rotate([0,0,180])  {    
    rotate([90,0,0])
    scale([0.7,0.7,1])
        linear_extrude(height =2) {       text( "IUT GEII", font = "Liberation Sans");
        }
    }
        translate([0,0,+-10])
            rotate([0,0,180])  {    
    rotate([90,0,0])
    scale([0.7,0.7,1])
        linear_extrude(height =2) {       text( "BVDP 2022", font = "Liberation Sans");
        }
    }
        /*
    translate([-24,-33.5,-13])
    rotate([90,0,0])
    scale([0.7,0.7,1])        
            linear_extrude(height =2) {       text( "LPRO ROB", font = "Liberation Sans");
            }
    translate([-24,-33.5,-22])
    rotate([90,0,0])
    scale([0.7,0.7,1])        
            linear_extrude(height =2) {       text( "BVDP 2019", font = "Liberation Sans");
            }
        */
        }
        
    }
}
///////////////////////////////////////// 

/*
position_hx711=[-45,18,-9]; //pour déplacer l'HX711
  ///////////////////////////////////////// 
module trou_HX711(){
        translate(position_hx711)
       for (i=[-1:2:1]) 
           for (j=[-1:2:1]) 
              translate([0,i*(17.5/2),j*25/2])
             rotate([0,90,0]) 
                    #cylinder(h = 20, d = 2.7, center = true,$fn=resolution);  
       }
  ///////////////////////////////////////// 
module HX711(istrou)      {
    difference()
    {
    translate(position_hx711)
        cube([4,24,31],center=true);
      trou_HX711();
       }             
}
///////////////////////////////////////// 
*/
///////////////////////////////////////// 
   position_jauge=[larg/2+6,prof/2-8,15]; //pour déplacer la jauge et les trous , léger offset en à cause de la batterie
orientation_jauge=[0,0,90];
///////////////////////////////////////// 
module trousjauge(diametre_trou=3.1)
{

  translate(position_jauge)
              rotate(orientation_jauge) 
      rotate([90,0,0]) 
          for (i=[-1:2:1]) {
              translate([i*(11.1),0,0])
                    #cylinder(h = 100, d = diametre_trou, center = true,$fn=resolution);  
               translate([i*(11.1+7.3),0,0])
                    #cylinder(h = 100, d = diametre_trou, center = true,$fn=resolution);  
          }
      }
///////////////////////////////////////// 
///////////////////////////////////////// 
dim_jauge=[45.2,6,9.5];
///////////////////////////////////////// 
module jauge()
{
   difference(){ 
        translate(position_jauge)        
              rotate(orientation_jauge) 
                    cube(dim_jauge,center=true);
        trousjauge();     
      }
}
///////////////////////////////////////// 
///////////////////////////////////////// 

///////////////////////////////       
module bord_arrondi(dim_bord_arrondi) //longueur + rayon
{
    difference(){  
     cube([dim_bord_arrondi[0],dim_bord_arrondi[1],dim_bord_arrondi[1]],center=false);  
     rotate(90,[0,1,0])      
        # cylinder(h = dim_bord_arrondi[0]+0.1, r = dim_bord_arrondi[1], center = false,$fn=resolution);    
    }
 }
///////////////////////////////       

///////////////////////////////       

module fixation_jauge(n){  //n=0 pour fixation au robot et 1 pour le gripper
        for  (i=[0,1]){  //pour les 2 trous de fixation
            difference(){  
                dim_cube_fix_jauge=[16,8,18.5];
                jeu_jauge=0.2;                
                    union(){
                        translate(position_jauge)        
                            rotate(orientation_jauge)     
                                //translate([-14.5+n*29,-7+(dim_jauge[1]+dim_cube_fix_jauge[1]+jeu_jauge)*i,-3.9]){  //z peu dépendre de-n*5                
                                translate([14.5-n*29,-7+(dim_jauge[1]+dim_cube_fix_jauge[1]+jeu_jauge)*i,-3.9-(n-1)*4]){ 
                                    cube(dim_cube_fix_jauge,center=true);    
                                    r_bords_arrondi=2;
                                    rotate(i*180,[0,0,1])   
                                        rotate(n*180,[0,1,0])    
                                            translate([-(dim_cube_fix_jauge[0]/2),-r_bords_arrondi-(dim_cube_fix_jauge[1]/2),-(3.1*r_bords_arrondi)+(dim_cube_fix_jauge[2]/2)+n+2.9])           
                                                bord_arrondi([dim_cube_fix_jauge[0],r_bords_arrondi]);
                        }
                    }
                    trousjauge();
                }
        }
}

///////////////////////////////       
//fixation_jauge(0);
module partie_haute(){
    
        translate(position_jauge) 
    translate([0,0,7.7]) 
    //          rotate([0,0,90])
color("magenta",1.0)
    difference(){
 cylinder(h=2,d=70,$fn=resolutionpart);
            translate([0,0,-3]) 
        #cylinder(h=10,d=3,$fn=resolutionpart);
}
    fixation_jauge(0);
    /*
union(){
    
    difference(){
cube([larg,prof,haut]);
translate([epaisseur,epaisseur,epaisseur+eps])
cube([larg-2*epaisseur,prof-2*epaisseur,haut-epaisseur]);    
        interrupteur();
     
chargeur();
        led();
                    trousjauge(6.5); //trous plus gros pour passer le tournevis
}
fixation_jauge(1);
texte();
}*/
}
///////////////////////////////       

//translate([2.5,epaisseur+18/2,epaisseur+18/2]) 


printerpart=0;//default value for the constant printerpart, it can be changed through command line using -D
//https://en.wikibooks.org/wiki/OpenSCAD_User_Manual/Using_OpenSCAD_in_a_command_line_environment
//use compile.sh to generate the stl files in stl/ subdirectory
type=printerpart;  //assign the constant value to a variable to be able to test it, even if the constant hasn't been defined in command line
//pour visualisation de l'assemblage
space=1; //free space between assembled parts
if (type==0)
 {
  interrupteur();
     batterie();
chargeur();
esp();
jauge();
//HX711(); //à coller sous l'esp entre les broches
base();
     led();
     
     partie_haute();
 }
   ////////////////////////////////////
//pour impression via script compile.sh
if (type==1)
    //difference(){
        base();
//partie_haute(); }
if (type==2)
    translate([-40,45,25])
  rotate([180,0,0]) 
    partie_haute();