#!/usr/bin/python3
#2022 B.Vandeportaele
# https://docs.python.org/fr/3/library/xml.etree.elementtree.html#module-xml.etree.ElementTree
# https://docs.python.org/fr/3/library/xml.html


import os
import sys
import xml.etree.ElementTree as ET
'''
tree = ET.parse('country_data.xml')
root = tree.getroot()
for child in root:
    print(child.tag, child.attrib)
print(root[0][1].text)

for neighbor in root.iter('neighbor'):
    print(neighbor.attrib)

for country in root.findall('country'):
    rank = country.find('rank').text
    name = country.get('name')
    print(name, rank)
'''
#Element.find() finds the first child with a particular tag,
#and Element.text accesses the element's text content.
#Element.get() accesses the element's attributes:


debugActif=False

################################################################################

def createVRMLFile(filename_in,filename_out):    
    #tree = ET.parse('test_couleur.amf')
    tree = ET.parse(filename_in)    
    root = tree.getroot()
    print(root.tag, root.attrib)
    for child in root:
      if debugActif: print("tag: "+str(child.tag)+ " attrib: "+str(child.attrib))
    for material in root.iter('material'):
        if debugActif: print(material.attrib)
    filecontent =  """#VRML V2.0 utf8
# File generated by amf2wrl B. Vandeportaele 2022
"""
    for object in root.iter('object'):
        if debugActif: print(object.attrib)
        num=object.attrib.get('id')
        if debugActif: print(num)
        if debugActif: print("recherche material")
        for material in root.findall('material'):
            if debugActif: print(material.attrib)
            if (material.attrib == object.attrib):            
                r=material[0].find('r').text
                g=material[0].find('g').text
                b=material[0].find('b').text
                a=material[0].find('a').text
                if debugActif: print("material trouvé: "+ str(r) +" " + str(g) +" " + str(b))        
        filecontent +=  """Shape {
appearance DEF M"""+str(num)+""" Appearance {
material Material {
diffuseColor """+ str(r) +" " + str(g) +" " + str(b) +"""
}
}
geometry IndexedFaceSet {
coord Coordinate {
point [
"""
        #object[0][0][0][0][0] ->        <Element 'x' at 0x7fa07fe08720>
        for mesh in object.iter('mesh'):
          for vertices in mesh.iter('vertices'):
             for vertex in vertices.iter('vertex'):
                 for coordinates in vertex.iter('coordinates'):
                     #print(coordinates[0])
                     for x in coordinates.iter('x'):
                         if debugActif: print(x.text)
                         filecontent +=  x.text +" "
                     for y in coordinates.iter('y'):
                         if debugActif: print(y.text)
                         filecontent +=  y.text +" "                        
                     for z in coordinates.iter('z'):
                         if debugActif: print(z.text)
                         filecontent +=  z.text +""",
"""
        filecontent+="""]
}
coordIndex [
"""
        for volume in mesh.iter('volume'):             
             for triangle in volume.iter('triangle'):
                if debugActif: print(triangle)
                for v1 in triangle.iter('v1'):
                    if debugActif: print(v1.text)
                    filecontent +=  v1.text +" "
                for v2 in triangle.iter('v2'):
                    if debugActif: print(v2.text)
                    filecontent +=  v2.text +" "                        
                for v3 in triangle.iter('v3'):
                    if debugActif: print(v3.text)
                    filecontent +=  v3.text +""",-1,
"""
        filecontent+="""]
}
}

"""
    if debugActif: print(filecontent)    
    saveVRMLFile(filename_out,filecontent)
'''
    tree = ET.parse('test_couleur.amf')
    root = tree.getroot()
    print(root[0].attrib)
    print(root[0].text)
    print(root[1].attrib)
    #comment déterminer les dimensions?
    print(root[1][0].tag)
    if (root[1][0].tag=="color"):
      #print(root[1][0])
      print(root[1][0][0].text)
      print(root[1][0][1].text)
      print(root[1][0][2].text)
      print(root[1][0][3].text)
 '''
################################################################################
def saveVRMLFile(filename_out,filecontent):    
    fout = open(filename_out, "w")
    fout.write(filecontent)          
    fout.close()
################################################################################



print("amf2wrl 2022 B. Vandeportaele")
if len(sys.argv)<3:
  print("should be run: amsf2wrl filein.amf fileout.wrl")
  print("should be run in debug mode : amsf2wrl -v filein.amf fileout.wrl")
  exit(-1);

if sys.argv[1]=="-v":
    debugActif=True
    filename_in=sys.argv[2]
    filename_out=sys.argv[3]
    
else:
    filename_in=sys.argv[1]
    filename_out=sys.argv[2]


#filename_in='test_couleur.amf'
#filename_out='test_couleur_amf2wrl.wrl'

    
createVRMLFile(filename_in,filename_out)

#os.system("view3dscene "+filename_out)

