/*++

Copyright (C) 2019 3MF Consortium (Original Author)

All rights reserved.

Redistribution and use in source and binary forms, with or without modification,
are permitted provided that the following conditions are met:

1. Redistributions of source code must retain the above copyright notice, this
list of conditions and the following disclaimer.
2. Redistributions in binary form must reproduce the above copyright notice,
this list of conditions and the following disclaimer in the documentation
and/or other materials provided with the distribution.

THIS SOFTWARE IS PROVIDED BY THE COPYRIGHT HOLDERS AND CONTRIBUTORS "AS IS" AND
ANY EXPRESS OR IMPLIED WARRANTIES, INCLUDING, BUT NOT LIMITED TO, THE IMPLIED
WARRANTIES OF MERCHANTABILITY AND FITNESS FOR A PARTICULAR PURPOSE ARE
DISCLAIMED. IN NO EVENT SHALL THE COPYRIGHT HOLDER OR CONTRIBUTORS BE LIABLE FOR
ANY DIRECT, INDIRECT, INCIDENTAL, SPECIAL, EXEMPLARY, OR CONSEQUENTIAL DAMAGES
(INCLUDING, BUT NOT LIMITED TO, PROCUREMENT OF SUBSTITUTE GOODS OR SERVICES;
LOSS OF USE, DATA, OR PROFITS; OR BUSINESS INTERRUPTION) HOWEVER CAUSED AND
ON ANY THEORY OF LIABILITY, WHETHER IN CONTRACT, STRICT LIABILITY, OR TORT
(INCLUDING NEGLIGENCE OR OTHERWISE) ARISING IN ANY WAY OUT OF THE USE OF THIS
SOFTWARE, EVEN IF ADVISED OF THE POSSIBILITY OF SUCH DAMAGE.

This file has been generated by the Automatic Component Toolkit (ACT) version 1.6.0-develop.

Abstract: This is an autogenerated C application that demonstrates the
 usage of the C bindings of the 3MF Library

Interface version: 2.1.1

*/

#include <stdlib.h>
#include <stdio.h>
#include "lib3mf_dynamic.h"


void releaseWrapper(sLib3MFDynamicWrapperTable* pWrapperTable) {
	Lib3MFResult eResult = ReleaseLib3MFWrapperTable(pWrapperTable);
	if (LIB3MF_SUCCESS != eResult) {
		printf_s("Failed releasing wrapper table\n");
	}
}

int main()
{
	// TODO: put the path and ending of the Lib3MF library file here:
	const char* libpath = "lib3mf.dll";
	sLib3MFDynamicWrapperTable sWrapperTable;
	Lib3MFResult eResult = LIB3MF_SUCCESS;
	
	eResult = InitLib3MFWrapperTable(&sWrapperTable);
	if (LIB3MF_SUCCESS != eResult) {
		printf_s("Failed to initialize wrapper table\n");
		return eResult;
	}
	
	eResult = LoadLib3MFWrapperTable(&sWrapperTable, libpath);
	if (LIB3MF_SUCCESS != eResult) {
		printf_s("Failed to load lib3mf-binary\n");
		return eResult;
	}
	Lib3MF_uint32 nMajor, nMinor, nMicro;
	eResult = sWrapperTable.m_GetLibraryVersion(&nMajor, &nMinor, &nMicro);
	if (LIB3MF_SUCCESS != eResult) {
		printf_s("Failed to get version\n");
		releaseWrapper(&sWrapperTable);
		return eResult;
	}
	printf_s("Lib3MF.Version = %d.%d.%d", nMajor, nMinor, nMicro);
	
	Lib3MF_uint32 nBufferRequired = 0;
	Lib3MF_uint8* theString = NULL;
	bool bHasInfo = false;
	eResult = sWrapperTable.m_GetPrereleaseInformation(&bHasInfo, 0, &nBufferRequired, theString);
	if (LIB3MF_SUCCESS != eResult) {
	   releaseWrapper(&sWrapperTable);
		return eResult;
	}
	if (bHasInfo && (nBufferRequired > 0)) {
		theString = malloc(sizeof(Lib3MF_uint8)*(nBufferRequired));
		eResult = sWrapperTable.m_GetPrereleaseInformation(&bHasInfo, nBufferRequired, &nBufferRequired, theString);
		if (LIB3MF_SUCCESS != eResult) {
			printf_s("Failed to get prerelease information\n");
			releaseWrapper(&sWrapperTable);
			free(theString);
			return eResult;
		}
		printf_s("-%s", theString);
		free(theString);
		theString = NULL;
	}
	
	eResult = sWrapperTable.m_GetBuildInformation(&bHasInfo, 0, &nBufferRequired, theString);
	if (LIB3MF_SUCCESS != eResult) {
	   releaseWrapper(&sWrapperTable);
		return eResult;
	}
	if (bHasInfo && (nBufferRequired > 0)) {
		theString = malloc(sizeof(Lib3MF_uint8)*(nBufferRequired));
		theString[nBufferRequired] = 0;
		eResult = sWrapperTable.m_GetBuildInformation(&bHasInfo, nBufferRequired, &nBufferRequired, theString);
		if (LIB3MF_SUCCESS != eResult) {
			printf_s("Failed to get build information\n");
			releaseWrapper(&sWrapperTable);
			free(theString);
			return eResult;
		}
		printf_s("+%s", theString);
		free(theString);
		theString = NULL;
	}
	
	printf_s("\n");
	
	eResult = ReleaseLib3MFWrapperTable(&sWrapperTable);
	if (LIB3MF_SUCCESS != eResult) {
		printf_s("Failed releasing wrapper table\n");
		return eResult;
	}
	
	return 0;
} 

