/*++

Copyright (C) 2019 3MF Consortium (Original Author)

All rights reserved.

Redistribution and use in source and binary forms, with or without modification,
are permitted provided that the following conditions are met:

1. Redistributions of source code must retain the above copyright notice, this
list of conditions and the following disclaimer.
2. Redistributions in binary form must reproduce the above copyright notice,
this list of conditions and the following disclaimer in the documentation
and/or other materials provided with the distribution.

THIS SOFTWARE IS PROVIDED BY THE COPYRIGHT HOLDERS AND CONTRIBUTORS "AS IS" AND
ANY EXPRESS OR IMPLIED WARRANTIES, INCLUDING, BUT NOT LIMITED TO, THE IMPLIED
WARRANTIES OF MERCHANTABILITY AND FITNESS FOR A PARTICULAR PURPOSE ARE
DISCLAIMED. IN NO EVENT SHALL THE COPYRIGHT HOLDER OR CONTRIBUTORS BE LIABLE FOR
ANY DIRECT, INDIRECT, INCIDENTAL, SPECIAL, EXEMPLARY, OR CONSEQUENTIAL DAMAGES
(INCLUDING, BUT NOT LIMITED TO, PROCUREMENT OF SUBSTITUTE GOODS OR SERVICES;
LOSS OF USE, DATA, OR PROFITS; OR BUSINESS INTERRUPTION) HOWEVER CAUSED AND
ON ANY THEORY OF LIABILITY, WHETHER IN CONTRACT, STRICT LIABILITY, OR TORT
(INCLUDING NEGLIGENCE OR OTHERWISE) ARISING IN ANY WAY OUT OF THE USE OF THIS
SOFTWARE, EVEN IF ADVISED OF THE POSSIBILITY OF SUCH DAMAGE.

This file has been generated by the Automatic Component Toolkit (ACT) version 1.6.0.

Abstract: This is an autogenerated Go wrapper file in order to allow an easy
 use of the 3MF Library

Interface version: 2.1.1

*/


package lib3mf


/*************************************************************************************************************************
 Declaration of enums
**************************************************************************************************************************/

type ELib3MFPropertyType int
const (
		ePropertyType_NoPropertyType = 0
		ePropertyType_BaseMaterial = 1
		ePropertyType_TexCoord = 2
		ePropertyType_Colors = 3
		ePropertyType_Composite = 4
		ePropertyType_Multi = 5
)

type ELib3MFSlicesMeshResolution int
const (
		eSlicesMeshResolution_Fullres = 0
		eSlicesMeshResolution_Lowres = 1
)

type ELib3MFModelUnit int
const (
		eModelUnit_MicroMeter = 0
		eModelUnit_MilliMeter = 1
		eModelUnit_CentiMeter = 2
		eModelUnit_Inch = 3
		eModelUnit_Foot = 4
		eModelUnit_Meter = 5
)

type ELib3MFObjectType int
const (
		eObjectType_Other = 0
		eObjectType_Model = 1
		eObjectType_Support = 2
		eObjectType_SolidSupport = 3
)

type ELib3MFTextureType int
const (
		eTextureType_Unknown = 0
		eTextureType_PNG = 1
		eTextureType_JPEG = 2
)

type ELib3MFTextureTileStyle int
const (
		eTextureTileStyle_Wrap = 0
		eTextureTileStyle_Mirror = 1
		eTextureTileStyle_Clamp = 2
		eTextureTileStyle_NoTileStyle = 3
)

type ELib3MFTextureFilter int
const (
		eTextureFilter_Auto = 0
		eTextureFilter_Linear = 1
		eTextureFilter_Nearest = 2
)

type ELib3MFBeamLatticeCapMode int
const (
		eBeamLatticeCapMode_Sphere = 0
		eBeamLatticeCapMode_HemiSphere = 1
		eBeamLatticeCapMode_Butt = 2
)

type ELib3MFBeamLatticeClipMode int
const (
		eBeamLatticeClipMode_NoClipMode = 0
		eBeamLatticeClipMode_Inside = 1
		eBeamLatticeClipMode_Outside = 2
)

type ELib3MFBeamLatticeBallMode int
const (
		eBeamLatticeBallMode_None = 0
		eBeamLatticeBallMode_Mixed = 1
		eBeamLatticeBallMode_All = 2
)

type ELib3MFProgressIdentifier int
const (
		eProgressIdentifier_QUERYCANCELED = 0
		eProgressIdentifier_DONE = 1
		eProgressIdentifier_CLEANUP = 2
		eProgressIdentifier_READSTREAM = 3
		eProgressIdentifier_EXTRACTOPCPACKAGE = 4
		eProgressIdentifier_READNONROOTMODELS = 5
		eProgressIdentifier_READROOTMODEL = 6
		eProgressIdentifier_READRESOURCES = 7
		eProgressIdentifier_READMESH = 8
		eProgressIdentifier_READSLICES = 9
		eProgressIdentifier_READBUILD = 10
		eProgressIdentifier_READCUSTOMATTACHMENT = 11
		eProgressIdentifier_READTEXTURETACHMENTS = 12
		eProgressIdentifier_CREATEOPCPACKAGE = 13
		eProgressIdentifier_WRITEMODELSTOSTREAM = 14
		eProgressIdentifier_WRITEROOTMODEL = 15
		eProgressIdentifier_WRITENONROOTMODELS = 16
		eProgressIdentifier_WRITEATTACHMENTS = 17
		eProgressIdentifier_WRITECONTENTTYPES = 18
		eProgressIdentifier_WRITENOBJECTS = 19
		eProgressIdentifier_WRITENODES = 20
		eProgressIdentifier_WRITETRIANGLES = 21
		eProgressIdentifier_WRITESLICES = 22
		eProgressIdentifier_WRITEKEYSTORE = 23
)

type ELib3MFBlendMethod int
const (
		eBlendMethod_NoBlendMethod = 0
		eBlendMethod_Mix = 1
		eBlendMethod_Multiply = 2
)

type ELib3MFEncryptionAlgorithm int
const (
		eEncryptionAlgorithm_AES256_GCM = 1
)

type ELib3MFWrappingAlgorithm int
const (
		eWrappingAlgorithm_RSA_OAEP = 0
)

type ELib3MFMgfAlgorithm int
const (
		eMgfAlgorithm_MGF1_SHA1 = 160
		eMgfAlgorithm_MGF1_SHA224 = 224
		eMgfAlgorithm_MGF1_SHA256 = 256
		eMgfAlgorithm_MGF1_SHA384 = 384
		eMgfAlgorithm_MGF1_SHA512 = 512
)

type ELib3MFDigestMethod int
const (
		eDigestMethod_SHA1 = 160
		eDigestMethod_SHA256 = 256
)

type ELib3MFCompression int
const (
		eCompression_NoCompression = 0
		eCompression_Deflate = 1
)


/*************************************************************************************************************************
 Declaration of structs
**************************************************************************************************************************/

type sLib3MFTriangle struct {
		Indices[3] uint32;
}

type sLib3MFTriangleProperties struct {
		ResourceID uint32;
		PropertyIDs[3] uint32;
}

type sLib3MFPosition struct {
		Coordinates[3] float32;
}

type sLib3MFPosition2D struct {
		Coordinates[2] float32;
}

type sLib3MFCompositeConstituent struct {
		PropertyID uint32;
		MixingRatio float64;
}

type sLib3MFMultiPropertyLayer struct {
		ResourceID uint32;
		TheBlendMethod ELib3MFBlendMethod;
}

type sLib3MFTex2Coord struct {
		U float64;
		V float64;
}

type sLib3MFTransform struct {
		Fields[4][3] float32;
}

type sLib3MFBox struct {
		MinCoordinate[3] float32;
		MaxCoordinate[3] float32;
}

type sLib3MFColor struct {
		Red uint8;
		Green uint8;
		Blue uint8;
		Alpha uint8;
}

type sLib3MFBeam struct {
		Indices[2] uint32;
		Radii[2] float64;
		CapModes[2] ELib3MFBeamLatticeCapMode;
}

type sLib3MFBall struct {
		Index uint32;
		Radius float64;
}


/*************************************************************************************************************************
 Declaration of interfaces
**************************************************************************************************************************/

type Lib3MFHandle interface {
		Close() error
		IsValid() bool
}

type Lib3MFGoInterface interface {

	/**
	* Writes out the model as file. The file type is specified by the Model Writer class.
	*
	* @param[in] Writer - Writer instance.
	* @param[in] sFilename - Filename to write into
	*/
	Writer_WriteToFile(Writer Lib3MFHandle, sFilename string) (error)


	/**
	* Retrieves the size of the full 3MF file stream.
	*
	* @param[in] Writer - Writer instance.
	* @return the stream size
	*/
	Writer_GetStreamSize(Writer Lib3MFHandle) (uint64, error)


	/**
	* Writes out the 3MF file into a memory buffer
	*
	* @param[in] Writer - Writer instance.
	* @return buffer to write into
	*/
	Writer_WriteToBuffer(Writer Lib3MFHandle) ([]uint8, error)


	/**
	* Writes out the model and passes the data to a provided callback function. The file type is specified by the Model Writer class.
	*
	* @param[in] Writer - Writer instance.
	* @param[in] pTheWriteCallback - Callback to call for writing a data chunk
	* @param[in] pTheSeekCallback - Callback to call for seeking in the stream
	* @param[in] nUserData - Userdata that is passed to the callback function
	*/
	Writer_WriteToCallback(Writer Lib3MFHandle, pTheWriteCallback int64, pTheSeekCallback int64, nUserData uint64) (error)


	/**
	* Set the progress callback for calls to this writer
	*
	* @param[in] Writer - Writer instance.
	* @param[in] pProgressCallback - pointer to the callback function.
	* @param[in] nUserData - pointer to arbitrary user data that is passed without modification to the callback.
	*/
	Writer_SetProgressCallback(Writer Lib3MFHandle, pProgressCallback int64, nUserData uint64) (error)


	/**
	* Returns the number of digits after the decimal point to be written in each vertex coordinate-value.
	*
	* @param[in] Writer - Writer instance.
	* @return The number of digits to be written in each vertex coordinate-value after the decimal point.
	*/
	Writer_GetDecimalPrecision(Writer Lib3MFHandle) (uint32, error)


	/**
	* Sets the number of digits after the decimal point to be written in each vertex coordinate-value.
	*
	* @param[in] Writer - Writer instance.
	* @param[in] nDecimalPrecision - The number of digits to be written in each vertex coordinate-value after the decimal point.
	*/
	Writer_SetDecimalPrecision(Writer Lib3MFHandle, nDecimalPrecision uint32) (error)


	/**
	* Activates (deactivates) the strict mode of the reader.
	*
	* @param[in] Writer - Writer instance.
	* @param[in] bStrictModeActive - flag whether strict mode is active or not.
	*/
	Writer_SetStrictModeActive(Writer Lib3MFHandle, bStrictModeActive bool) (error)


	/**
	* Queries whether the strict mode of the reader is active or not
	*
	* @param[in] Writer - Writer instance.
	* @return returns flag whether strict mode is active or not.
	*/
	Writer_GetStrictModeActive(Writer Lib3MFHandle) (bool, error)


	/**
	* Returns Warning and Error Information of the read process
	*
	* @param[in] Writer - Writer instance.
	* @param[in] nIndex - Index of the Warning. Valid values are 0 to WarningCount - 1
	* @return filled with the error code of the warning
	* @return the message of the warning
	*/
	Writer_GetWarning(Writer Lib3MFHandle, nIndex uint32) (uint32, string, error)


	/**
	* Returns Warning and Error Count of the read process
	*
	* @param[in] Writer - Writer instance.
	* @return filled with the count of the occurred warnings.
	*/
	Writer_GetWarningCount(Writer Lib3MFHandle) (uint32, error)


	/**
	* Registers a callback to deal with data key encryption/decryption from keystore
	*
	* @param[in] Writer - Writer instance.
	* @param[in] sConsumerID - The ConsumerID to register for
	* @param[in] pTheCallback - The callback to be callede for wrapping and encryption key
	* @param[in] nUserData - Userdata that is passed to the callback function
	*/
	Writer_AddKeyWrappingCallback(Writer Lib3MFHandle, sConsumerID string, pTheCallback int64, nUserData uint64) (error)


	/**
	* Registers a callback to deal with encryption of content
	*
	* @param[in] Writer - Writer instance.
	* @param[in] pTheCallback - The callback used to encrypt content
	* @param[in] nUserData - Userdata that is passed to the callback function
	*/
	Writer_SetContentEncryptionCallback(Writer Lib3MFHandle, pTheCallback int64, nUserData uint64) (error)


	/**
	* Reads a model from a file. The file type is specified by the Model Reader class
	*
	* @param[in] Reader - Reader instance.
	* @param[in] sFilename - Filename to read from
	*/
	Reader_ReadFromFile(Reader Lib3MFHandle, sFilename string) (error)


	/**
	* Reads a model from a memory buffer.
	*
	* @param[in] Reader - Reader instance.
	* @param[in] Buffer - Buffer to read from
	*/
	Reader_ReadFromBuffer(Reader Lib3MFHandle, Buffer []uint8) (error)


	/**
	* Reads a model and from the data provided by a callback function
	*
	* @param[in] Reader - Reader instance.
	* @param[in] pTheReadCallback - Callback to call for reading a data chunk
	* @param[in] nStreamSize - number of bytes the callback returns
	* @param[in] pTheSeekCallback - Callback to call for seeking in the stream.
	* @param[in] nUserData - Userdata that is passed to the callback function
	*/
	Reader_ReadFromCallback(Reader Lib3MFHandle, pTheReadCallback int64, nStreamSize uint64, pTheSeekCallback int64, nUserData uint64) (error)


	/**
	* Set the progress callback for calls to this writer
	*
	* @param[in] Reader - Reader instance.
	* @param[in] pProgressCallback - pointer to the callback function.
	* @param[in] nUserData - pointer to arbitrary user data that is passed without modification to the callback.
	*/
	Reader_SetProgressCallback(Reader Lib3MFHandle, pProgressCallback int64, nUserData uint64) (error)


	/**
	* Adds a relationship type which shall be read as attachment in memory while loading
	*
	* @param[in] Reader - Reader instance.
	* @param[in] sRelationShipType - String of the relationship type
	*/
	Reader_AddRelationToRead(Reader Lib3MFHandle, sRelationShipType string) (error)


	/**
	* Removes a relationship type which shall be read as attachment in memory while loading
	*
	* @param[in] Reader - Reader instance.
	* @param[in] sRelationShipType - String of the relationship type
	*/
	Reader_RemoveRelationToRead(Reader Lib3MFHandle, sRelationShipType string) (error)


	/**
	* Activates (deactivates) the strict mode of the reader.
	*
	* @param[in] Reader - Reader instance.
	* @param[in] bStrictModeActive - flag whether strict mode is active or not.
	*/
	Reader_SetStrictModeActive(Reader Lib3MFHandle, bStrictModeActive bool) (error)


	/**
	* Queries whether the strict mode of the reader is active or not
	*
	* @param[in] Reader - Reader instance.
	* @return returns flag whether strict mode is active or not.
	*/
	Reader_GetStrictModeActive(Reader Lib3MFHandle) (bool, error)


	/**
	* Returns Warning and Error Information of the read process
	*
	* @param[in] Reader - Reader instance.
	* @param[in] nIndex - Index of the Warning. Valid values are 0 to WarningCount - 1
	* @return filled with the error code of the warning
	* @return the message of the warning
	*/
	Reader_GetWarning(Reader Lib3MFHandle, nIndex uint32) (uint32, string, error)


	/**
	* Returns Warning and Error Count of the read process
	*
	* @param[in] Reader - Reader instance.
	* @return filled with the count of the occurred warnings.
	*/
	Reader_GetWarningCount(Reader Lib3MFHandle) (uint32, error)


	/**
	* Registers a callback to deal with key wrapping mechanism from keystore
	*
	* @param[in] Reader - Reader instance.
	* @param[in] sConsumerID - The ConsumerID to register for
	* @param[in] pTheCallback - The callback used to decrypt data key
	* @param[in] nUserData - Userdata that is passed to the callback function
	*/
	Reader_AddKeyWrappingCallback(Reader Lib3MFHandle, sConsumerID string, pTheCallback int64, nUserData uint64) (error)


	/**
	* Registers a callback to deal with encryption of content
	*
	* @param[in] Reader - Reader instance.
	* @param[in] pTheCallback - The callback used to encrypt content
	* @param[in] nUserData - Userdata that is passed to the callback function
	*/
	Reader_SetContentEncryptionCallback(Reader Lib3MFHandle, pTheCallback int64, nUserData uint64) (error)


	/**
	* Returns the absolute path of this PackagePart.
	*
	* @param[in] PackagePart - PackagePart instance.
	* @return Returns the absolute path of this PackagePart
	*/
	PackagePart_GetPath(PackagePart Lib3MFHandle) (string, error)


	/**
	* Sets the absolute path of this PackagePart.
	*
	* @param[in] PackagePart - PackagePart instance.
	* @param[in] sPath - Sets the absolute path of this PackagePart.
	*/
	PackagePart_SetPath(PackagePart Lib3MFHandle, sPath string) (error)


	/**
	* Retrieves the unique id of this resource within a package. This function will be removed in a later release in favor of GetUniqueResourceID
	*
	* @param[in] Resource - Resource instance.
	* @return Retrieves the unique id of this resource within a package.
	*/
	Resource_GetResourceID(Resource Lib3MFHandle) (uint32, error)


	/**
	* Retrieves the unique id of this resource within a package.
	*
	* @param[in] Resource - Resource instance.
	* @return Retrieves the unique id of this resource within a package.
	*/
	Resource_GetUniqueResourceID(Resource Lib3MFHandle) (uint32, error)


	/**
	* Returns the PackagePart within which this resource resides
	*
	* @param[in] Resource - Resource instance.
	* @return the PackagePart within which this resource resides.
	*/
	Resource_PackagePart(Resource Lib3MFHandle) (Lib3MFHandle, error)


	/**
	* Sets the new PackagePart within which this resource resides
	*
	* @param[in] Resource - Resource instance.
	* @param[in] PackagePart - the new PackagePart within which this resource resides.
	*/
	Resource_SetPackagePart(Resource Lib3MFHandle, PackagePart Lib3MFHandle) (error)


	/**
	* Retrieves the id of this resource within a model.
	*
	* @param[in] Resource - Resource instance.
	* @return Retrieves the id of this resource within a model.
	*/
	Resource_GetModelResourceID(Resource Lib3MFHandle) (uint32, error)


	/**
	* Iterates to the next resource in the list.
	*
	* @param[in] ResourceIterator - ResourceIterator instance.
	* @return Iterates to the next resource in the list.
	*/
	ResourceIterator_MoveNext(ResourceIterator Lib3MFHandle) (bool, error)


	/**
	* Iterates to the previous resource in the list.
	*
	* @param[in] ResourceIterator - ResourceIterator instance.
	* @return Iterates to the previous resource in the list.
	*/
	ResourceIterator_MovePrevious(ResourceIterator Lib3MFHandle) (bool, error)


	/**
	* Returns the resource the iterator points at.
	*
	* @param[in] ResourceIterator - ResourceIterator instance.
	* @return returns the resource instance.
	*/
	ResourceIterator_GetCurrent(ResourceIterator Lib3MFHandle) (Lib3MFHandle, error)


	/**
	* Creates a new resource iterator with the same resource list.
	*
	* @param[in] ResourceIterator - ResourceIterator instance.
	* @return returns the cloned Iterator instance
	*/
	ResourceIterator_Clone(ResourceIterator Lib3MFHandle) (Lib3MFHandle, error)


	/**
	* Returns the number of resoucres the iterator captures.
	*
	* @param[in] ResourceIterator - ResourceIterator instance.
	* @return returns the number of resoucres the iterator captures.
	*/
	ResourceIterator_Count(ResourceIterator Lib3MFHandle) (uint64, error)


	/**
	* Returns the SliceStack the iterator points at.
	*
	* @param[in] SliceStackIterator - SliceStackIterator instance.
	* @return returns the SliceStack instance.
	*/
	SliceStackIterator_GetCurrentSliceStack(SliceStackIterator Lib3MFHandle) (Lib3MFHandle, error)


	/**
	* Returns the Object the iterator points at.
	*
	* @param[in] ObjectIterator - ObjectIterator instance.
	* @return returns the Object instance.
	*/
	ObjectIterator_GetCurrentObject(ObjectIterator Lib3MFHandle) (Lib3MFHandle, error)


	/**
	* Returns the MeshObject the iterator points at.
	*
	* @param[in] MeshObjectIterator - MeshObjectIterator instance.
	* @return returns the MeshObject instance.
	*/
	MeshObjectIterator_GetCurrentMeshObject(MeshObjectIterator Lib3MFHandle) (Lib3MFHandle, error)


	/**
	* Returns the ComponentsObject the iterator points at.
	*
	* @param[in] ComponentsObjectIterator - ComponentsObjectIterator instance.
	* @return returns the ComponentsObject instance.
	*/
	ComponentsObjectIterator_GetCurrentComponentsObject(ComponentsObjectIterator Lib3MFHandle) (Lib3MFHandle, error)


	/**
	* Returns the Texture2D the iterator points at.
	*
	* @param[in] Texture2DIterator - Texture2DIterator instance.
	* @return returns the Texture2D instance.
	*/
	Texture2DIterator_GetCurrentTexture2D(Texture2DIterator Lib3MFHandle) (Lib3MFHandle, error)


	/**
	* Returns the MaterialGroup the iterator points at.
	*
	* @param[in] BaseMaterialGroupIterator - BaseMaterialGroupIterator instance.
	* @return returns the BaseMaterialGroup instance.
	*/
	BaseMaterialGroupIterator_GetCurrentBaseMaterialGroup(BaseMaterialGroupIterator Lib3MFHandle) (Lib3MFHandle, error)


	/**
	* Returns the ColorGroup the iterator points at.
	*
	* @param[in] ColorGroupIterator - ColorGroupIterator instance.
	* @return returns the ColorGroup instance.
	*/
	ColorGroupIterator_GetCurrentColorGroup(ColorGroupIterator Lib3MFHandle) (Lib3MFHandle, error)


	/**
	* Returns the Texture2DGroup the iterator points at.
	*
	* @param[in] Texture2DGroupIterator - Texture2DGroupIterator instance.
	* @return returns the Texture2DGroup instance.
	*/
	Texture2DGroupIterator_GetCurrentTexture2DGroup(Texture2DGroupIterator Lib3MFHandle) (Lib3MFHandle, error)


	/**
	* Returns the CompositeMaterials the iterator points at.
	*
	* @param[in] CompositeMaterialsIterator - CompositeMaterialsIterator instance.
	* @return returns the CompositeMaterials instance.
	*/
	CompositeMaterialsIterator_GetCurrentCompositeMaterials(CompositeMaterialsIterator Lib3MFHandle) (Lib3MFHandle, error)


	/**
	* Returns the MultiPropertyGroup the iterator points at.
	*
	* @param[in] MultiPropertyGroupIterator - MultiPropertyGroupIterator instance.
	* @return returns the MultiPropertyGroup instance.
	*/
	MultiPropertyGroupIterator_GetCurrentMultiPropertyGroup(MultiPropertyGroupIterator Lib3MFHandle) (Lib3MFHandle, error)


	/**
	* returns the namespace URL of the metadata
	*
	* @param[in] MetaData - MetaData instance.
	* @return the namespace URL of the metadata
	*/
	MetaData_GetNameSpace(MetaData Lib3MFHandle) (string, error)


	/**
	* sets a new namespace URL of the metadata
	*
	* @param[in] MetaData - MetaData instance.
	* @param[in] sNameSpace - the new namespace URL of the metadata
	*/
	MetaData_SetNameSpace(MetaData Lib3MFHandle, sNameSpace string) (error)


	/**
	* returns the name of a metadata
	*
	* @param[in] MetaData - MetaData instance.
	* @return the name of the metadata
	*/
	MetaData_GetName(MetaData Lib3MFHandle) (string, error)


	/**
	* sets a new name of a metadata
	*
	* @param[in] MetaData - MetaData instance.
	* @param[in] sName - the new name of the metadata
	*/
	MetaData_SetName(MetaData Lib3MFHandle, sName string) (error)


	/**
	* returns the (namespace+name) of a metadata
	*
	* @param[in] MetaData - MetaData instance.
	* @return the key (namespace+name) of the metadata
	*/
	MetaData_GetKey(MetaData Lib3MFHandle) (string, error)


	/**
	* returns, whether a metadata must be preserved
	*
	* @param[in] MetaData - MetaData instance.
	* @return returns, whether a metadata must be preserved
	*/
	MetaData_GetMustPreserve(MetaData Lib3MFHandle) (bool, error)


	/**
	* sets whether a metadata must be preserved
	*
	* @param[in] MetaData - MetaData instance.
	* @param[in] bMustPreserve - a new value whether a metadata must be preserved
	*/
	MetaData_SetMustPreserve(MetaData Lib3MFHandle, bMustPreserve bool) (error)


	/**
	* returns the type of a metadata
	*
	* @param[in] MetaData - MetaData instance.
	* @return the type of the metadata
	*/
	MetaData_GetType(MetaData Lib3MFHandle) (string, error)


	/**
	* sets a new type of a metadata. This must be a simple XML type
	*
	* @param[in] MetaData - MetaData instance.
	* @param[in] sType - a new type of the metadata
	*/
	MetaData_SetType(MetaData Lib3MFHandle, sType string) (error)


	/**
	* returns the value of the metadata
	*
	* @param[in] MetaData - MetaData instance.
	* @return the value of the metadata
	*/
	MetaData_GetValue(MetaData Lib3MFHandle) (string, error)


	/**
	* sets a new value of the metadata
	*
	* @param[in] MetaData - MetaData instance.
	* @param[in] sValue - a new value of the metadata
	*/
	MetaData_SetValue(MetaData Lib3MFHandle, sValue string) (error)


	/**
	* returns the number of metadata in this metadatagroup
	*
	* @param[in] MetaDataGroup - MetaDataGroup instance.
	* @return returns the number metadata
	*/
	MetaDataGroup_GetMetaDataCount(MetaDataGroup Lib3MFHandle) (uint32, error)


	/**
	* returns a metadata value within this metadatagroup
	*
	* @param[in] MetaDataGroup - MetaDataGroup instance.
	* @param[in] nIndex - Index of the Metadata.
	* @return an instance of the metadata
	*/
	MetaDataGroup_GetMetaData(MetaDataGroup Lib3MFHandle, nIndex uint32) (Lib3MFHandle, error)


	/**
	* returns a metadata value within this metadatagroup
	*
	* @param[in] MetaDataGroup - MetaDataGroup instance.
	* @param[in] sNameSpace - the namespace of the metadata
	* @param[in] sName - the name of the Metadata
	* @return an instance of the metadata
	*/
	MetaDataGroup_GetMetaDataByKey(MetaDataGroup Lib3MFHandle, sNameSpace string, sName string) (Lib3MFHandle, error)


	/**
	* removes metadata by index from the model.
	*
	* @param[in] MetaDataGroup - MetaDataGroup instance.
	* @param[in] nIndex -  Index of the metadata to remove
	*/
	MetaDataGroup_RemoveMetaDataByIndex(MetaDataGroup Lib3MFHandle, nIndex uint32) (error)


	/**
	* removes metadata from the model.
	*
	* @param[in] MetaDataGroup - MetaDataGroup instance.
	* @param[in] TheMetaData - The metadata to remove
	*/
	MetaDataGroup_RemoveMetaData(MetaDataGroup Lib3MFHandle, TheMetaData Lib3MFHandle) (error)


	/**
	* adds a new metadata to this metadatagroup
	*
	* @param[in] MetaDataGroup - MetaDataGroup instance.
	* @param[in] sNameSpace - the namespace of the metadata
	* @param[in] sName - the name of the metadata
	* @param[in] sValue - the value of the metadata
	* @param[in] sType - the type of the metadata
	* @param[in] bMustPreserve - shuold the metadata be preserved
	* @return a new instance of the metadata
	*/
	MetaDataGroup_AddMetaData(MetaDataGroup Lib3MFHandle, sNameSpace string, sName string, sValue string, sType string, bMustPreserve bool) (Lib3MFHandle, error)


	/**
	* Retrieves an object's type
	*
	* @param[in] Object - Object instance.
	* @return returns object type enum.
	*/
	Object_GetType(Object Lib3MFHandle) (ELib3MFObjectType, error)


	/**
	* Sets an object's type
	*
	* @param[in] Object - Object instance.
	* @param[in] eObjectType - object type enum.
	*/
	Object_SetType(Object Lib3MFHandle, eObjectType ELib3MFObjectType) (error)


	/**
	* Retrieves an object's name
	*
	* @param[in] Object - Object instance.
	* @return returns object name.
	*/
	Object_GetName(Object Lib3MFHandle) (string, error)


	/**
	* Sets an object's name string
	*
	* @param[in] Object - Object instance.
	* @param[in] sName - new object name.
	*/
	Object_SetName(Object Lib3MFHandle, sName string) (error)


	/**
	* Retrieves an object's part number
	*
	* @param[in] Object - Object instance.
	* @return returns object part number.
	*/
	Object_GetPartNumber(Object Lib3MFHandle) (string, error)


	/**
	* Sets an objects partnumber string
	*
	* @param[in] Object - Object instance.
	* @param[in] sPartNumber - new object part number.
	*/
	Object_SetPartNumber(Object Lib3MFHandle, sPartNumber string) (error)


	/**
	* Retrieves, if an object is a mesh object
	*
	* @param[in] Object - Object instance.
	* @return returns, whether the object is a mesh object
	*/
	Object_IsMeshObject(Object Lib3MFHandle) (bool, error)


	/**
	* Retrieves, if an object is a components object
	*
	* @param[in] Object - Object instance.
	* @return returns, whether the object is a components object
	*/
	Object_IsComponentsObject(Object Lib3MFHandle) (bool, error)


	/**
	* Retrieves, if the object is valid according to the core spec. For mesh objects, we distinguish between the type attribute of the object:In case of object type other, this always means false.In case of object type model or solidsupport, this means, if the mesh suffices all requirements of the core spec chapter 4.1.In case of object type support or surface, this always means true.A component objects is valid if and only if it contains at least one component and all child components are valid objects.
	*
	* @param[in] Object - Object instance.
	* @return returns whether the object is a valid object description
	*/
	Object_IsValid(Object Lib3MFHandle) (bool, error)


	/**
	* Use an existing attachment as thumbnail for this object
	*
	* @param[in] Object - Object instance.
	* @param[in] Attachment - Instance of a new or the existing thumbnailattachment object.
	*/
	Object_SetAttachmentAsThumbnail(Object Lib3MFHandle, Attachment Lib3MFHandle) (error)


	/**
	* Get the attachment containing the object thumbnail.
	*
	* @param[in] Object - Object instance.
	* @return Instance of the thumbnailattachment object or NULL.
	*/
	Object_GetThumbnailAttachment(Object Lib3MFHandle) (Lib3MFHandle, error)


	/**
	* Clears the attachment. The attachment instance is not removed from the package.
	*
	* @param[in] Object - Object instance.
	*/
	Object_ClearThumbnailAttachment(Object Lib3MFHandle) (error)


	/**
	* Returns the outbox of a build item
	*
	* @param[in] Object - Object instance.
	* @return Outbox of this build item
	*/
	Object_GetOutbox(Object Lib3MFHandle) (sLib3MFBox, error)


	/**
	* Retrieves an object's uuid string (see production extension specification)
	*
	* @param[in] Object - Object instance.
	* @return flag whether the build item has a UUID
	* @return returns object uuid.
	*/
	Object_GetUUID(Object Lib3MFHandle) (bool, string, error)


	/**
	* Sets a build object's uuid string (see production extension specification)
	*
	* @param[in] Object - Object instance.
	* @param[in] sUUID - new object uuid string.
	*/
	Object_SetUUID(Object Lib3MFHandle, sUUID string) (error)


	/**
	* Returns the metadatagroup of this object
	*
	* @param[in] Object - Object instance.
	* @return returns an Instance of the metadatagroup of this object
	*/
	Object_GetMetaDataGroup(Object Lib3MFHandle) (Lib3MFHandle, error)


	/**
	* set the meshresolution of the mesh object
	*
	* @param[in] Object - Object instance.
	* @param[in] eMeshResolution - meshresolution of this object
	*/
	Object_SetSlicesMeshResolution(Object Lib3MFHandle, eMeshResolution ELib3MFSlicesMeshResolution) (error)


	/**
	* get the meshresolution of the mesh object
	*
	* @param[in] Object - Object instance.
	* @return meshresolution of this object
	*/
	Object_GetSlicesMeshResolution(Object Lib3MFHandle) (ELib3MFSlicesMeshResolution, error)


	/**
	* returns whether the Object has a slice stack. If Recursive is true, also checks whether any references object has a slice stack
	*
	* @param[in] Object - Object instance.
	* @param[in] bRecursive - check also all referenced objects?
	* @return does the object have a slice stack?
	*/
	Object_HasSlices(Object Lib3MFHandle, bRecursive bool) (bool, error)


	/**
	* unlinks the attached slicestack from this object. If no slice stack is attached, do noting.
	*
	* @param[in] Object - Object instance.
	*/
	Object_ClearSliceStack(Object Lib3MFHandle) (error)


	/**
	* get the Slicestack attached to the object
	*
	* @param[in] Object - Object instance.
	* @return returns the slicestack instance
	*/
	Object_GetSliceStack(Object Lib3MFHandle) (Lib3MFHandle, error)


	/**
	* assigns a slicestack to the object
	*
	* @param[in] Object - Object instance.
	* @param[in] SliceStackInstance - the new slice stack of this Object
	*/
	Object_AssignSliceStack(Object Lib3MFHandle, SliceStackInstance Lib3MFHandle) (error)


	/**
	* Returns the vertex count of a mesh object.
	*
	* @param[in] MeshObject - MeshObject instance.
	* @return filled with the vertex count.
	*/
	MeshObject_GetVertexCount(MeshObject Lib3MFHandle) (uint32, error)


	/**
	* Returns the triangle count of a mesh object.
	*
	* @param[in] MeshObject - MeshObject instance.
	* @return filled with the triangle count.
	*/
	MeshObject_GetTriangleCount(MeshObject Lib3MFHandle) (uint32, error)


	/**
	* Returns the vertex count of a mesh object.
	*
	* @param[in] MeshObject - MeshObject instance.
	* @param[in] nIndex - Index of the vertex (0 to vertexcount - 1)
	* @return filled with the vertex coordinates.
	*/
	MeshObject_GetVertex(MeshObject Lib3MFHandle, nIndex uint32) (sLib3MFPosition, error)


	/**
	* Sets the coordinates of a single vertex of a mesh object
	*
	* @param[in] MeshObject - MeshObject instance.
	* @param[in] nIndex - Index of the vertex (0 to vertexcount - 1)
	* @param[in] sCoordinates - contains the vertex coordinates.
	*/
	MeshObject_SetVertex(MeshObject Lib3MFHandle, nIndex uint32, sCoordinates sLib3MFPosition) (error)


	/**
	* Adds a single vertex to a mesh object
	*
	* @param[in] MeshObject - MeshObject instance.
	* @param[in] sCoordinates - contains the vertex coordinates.
	* @return Index of the new vertex
	*/
	MeshObject_AddVertex(MeshObject Lib3MFHandle, sCoordinates sLib3MFPosition) (uint32, error)


	/**
	* Obtains all vertex positions of a mesh object
	*
	* @param[in] MeshObject - MeshObject instance.
	* @return contains the vertex coordinates.
	*/
	MeshObject_GetVertices(MeshObject Lib3MFHandle) ([]sLib3MFPosition, error)


	/**
	* Returns indices of a single triangle of a mesh object.
	*
	* @param[in] MeshObject - MeshObject instance.
	* @param[in] nIndex - Index of the triangle (0 to trianglecount - 1)
	* @return filled with the triangle indices.
	*/
	MeshObject_GetTriangle(MeshObject Lib3MFHandle, nIndex uint32) (sLib3MFTriangle, error)


	/**
	* Sets the indices of a single triangle of a mesh object.
	*
	* @param[in] MeshObject - MeshObject instance.
	* @param[in] nIndex - Index of the triangle (0 to trianglecount - 1)
	* @param[in] sIndices - contains the triangle indices.
	*/
	MeshObject_SetTriangle(MeshObject Lib3MFHandle, nIndex uint32, sIndices sLib3MFTriangle) (error)


	/**
	* Adds a single triangle to a mesh object
	*
	* @param[in] MeshObject - MeshObject instance.
	* @param[in] sIndices - contains the triangle indices.
	* @return Index of the new triangle
	*/
	MeshObject_AddTriangle(MeshObject Lib3MFHandle, sIndices sLib3MFTriangle) (uint32, error)


	/**
	* Get all triangles of a mesh object
	*
	* @param[in] MeshObject - MeshObject instance.
	* @return contains the triangle indices.
	*/
	MeshObject_GetTriangleIndices(MeshObject Lib3MFHandle) ([]sLib3MFTriangle, error)


	/**
	* Sets the property at the object-level of the mesh object.
	*
	* @param[in] MeshObject - MeshObject instance.
	* @param[in] nUniqueResourceID - the object-level Property UniqueResourceID.
	* @param[in] nPropertyID - the object-level PropertyID.
	*/
	MeshObject_SetObjectLevelProperty(MeshObject Lib3MFHandle, nUniqueResourceID uint32, nPropertyID uint32) (error)


	/**
	* Gets the property at the object-level of the mesh object.
	*
	* @param[in] MeshObject - MeshObject instance.
	* @return the object-level Property UniqueResourceID.
	* @return the object-level PropertyID.
	* @return Has an object-level property been specified?
	*/
	MeshObject_GetObjectLevelProperty(MeshObject Lib3MFHandle) (uint32, uint32, bool, error)


	/**
	* Sets the properties of a single triangle of a mesh object.
	*
	* @param[in] MeshObject - MeshObject instance.
	* @param[in] nIndex - Index of the triangle (0 to trianglecount - 1)
	* @param[in] sProperties - contains the triangle properties.
	*/
	MeshObject_SetTriangleProperties(MeshObject Lib3MFHandle, nIndex uint32, sProperties sLib3MFTriangleProperties) (error)


	/**
	* Gets the properties of a single triangle of a mesh object.
	*
	* @param[in] MeshObject - MeshObject instance.
	* @param[in] nIndex - Index of the triangle (0 to trianglecount - 1)
	* @return returns the triangle properties.
	*/
	MeshObject_GetTriangleProperties(MeshObject Lib3MFHandle, nIndex uint32) (sLib3MFTriangleProperties, error)


	/**
	* Sets the properties of all triangles of a mesh object. Sets the object level property to the first entry of the passed triangle properties, if not yet specified.
	*
	* @param[in] MeshObject - MeshObject instance.
	* @param[in] PropertiesArray - contains the triangle properties array. Must have trianglecount elements.
	*/
	MeshObject_SetAllTriangleProperties(MeshObject Lib3MFHandle, PropertiesArray []sLib3MFTriangleProperties) (error)


	/**
	* Gets the properties of all triangles of a mesh object.
	*
	* @param[in] MeshObject - MeshObject instance.
	* @return returns the triangle properties array. Must have trianglecount elements.
	*/
	MeshObject_GetAllTriangleProperties(MeshObject Lib3MFHandle) ([]sLib3MFTriangleProperties, error)


	/**
	* Clears all properties of this mesh object (triangle and object-level).
	*
	* @param[in] MeshObject - MeshObject instance.
	*/
	MeshObject_ClearAllProperties(MeshObject Lib3MFHandle) (error)


	/**
	* Set all triangles of a mesh object
	*
	* @param[in] MeshObject - MeshObject instance.
	* @param[in] Vertices - contains the positions.
	* @param[in] Indices - contains the triangle indices.
	*/
	MeshObject_SetGeometry(MeshObject Lib3MFHandle, Vertices []sLib3MFPosition, Indices []sLib3MFTriangle) (error)


	/**
	* Retrieves, if an object describes a topologically oriented and manifold mesh, according to the core spec.
	*
	* @param[in] MeshObject - MeshObject instance.
	* @return returns, if the object is oriented and manifold.
	*/
	MeshObject_IsManifoldAndOriented(MeshObject Lib3MFHandle) (bool, error)


	/**
	* Retrieves the BeamLattice within this MeshObject.
	*
	* @param[in] MeshObject - MeshObject instance.
	* @return the BeamLattice within this MeshObject
	*/
	MeshObject_BeamLattice(MeshObject Lib3MFHandle) (Lib3MFHandle, error)


	/**
	* Returns the minimal length of beams for the beamlattice.
	*
	* @param[in] BeamLattice - BeamLattice instance.
	* @return minimal length of beams for the beamlattice
	*/
	BeamLattice_GetMinLength(BeamLattice Lib3MFHandle) (float64, error)


	/**
	* Sets the minimal length of beams for the beamlattice.
	*
	* @param[in] BeamLattice - BeamLattice instance.
	* @param[in] dMinLength - minimal length of beams for the beamlattice
	*/
	BeamLattice_SetMinLength(BeamLattice Lib3MFHandle, dMinLength float64) (error)


	/**
	* Returns the clipping mode and the clipping-mesh for the beamlattice of this mesh.
	*
	* @param[in] BeamLattice - BeamLattice instance.
	* @return contains the clip mode of this mesh
	* @return filled with the UniqueResourceID of the clipping mesh-object or an undefined value if pClipMode is MODELBEAMLATTICECLIPMODE_NONE
	*/
	BeamLattice_GetClipping(BeamLattice Lib3MFHandle) (ELib3MFBeamLatticeClipMode, uint32, error)


	/**
	* Sets the clipping mode and the clipping-mesh for the beamlattice of this mesh.
	*
	* @param[in] BeamLattice - BeamLattice instance.
	* @param[in] eClipMode - contains the clip mode of this mesh
	* @param[in] nUniqueResourceID - the UniqueResourceID of the clipping mesh-object. This mesh-object has to be defined before setting the Clipping.
	*/
	BeamLattice_SetClipping(BeamLattice Lib3MFHandle, eClipMode ELib3MFBeamLatticeClipMode, nUniqueResourceID uint32) (error)


	/**
	* Returns the representation-mesh for the beamlattice of this mesh.
	*
	* @param[in] BeamLattice - BeamLattice instance.
	* @return flag whether the beamlattice has a representation mesh.
	* @return filled with the UniqueResourceID of the clipping mesh-object.
	*/
	BeamLattice_GetRepresentation(BeamLattice Lib3MFHandle) (bool, uint32, error)


	/**
	* Sets the representation-mesh for the beamlattice of this mesh.
	*
	* @param[in] BeamLattice - BeamLattice instance.
	* @param[in] nUniqueResourceID - the UniqueResourceID of the representation mesh-object. This mesh-object has to be defined before setting the representation.
	*/
	BeamLattice_SetRepresentation(BeamLattice Lib3MFHandle, nUniqueResourceID uint32) (error)


	/**
	* Returns the ball mode and the default ball radius for the beamlattice of this mesh.
	*
	* @param[in] BeamLattice - BeamLattice instance.
	* @return contains the ball mode of this mesh
	* @return default ball radius of balls for the beamlattice
	*/
	BeamLattice_GetBallOptions(BeamLattice Lib3MFHandle) (ELib3MFBeamLatticeBallMode, float64, error)


	/**
	* Sets the ball mode and thedefault ball radius for the beamlattice.
	*
	* @param[in] BeamLattice - BeamLattice instance.
	* @param[in] eBallMode - contains the ball mode of this mesh
	* @param[in] dBallRadius - default ball radius of balls for the beamlattice
	*/
	BeamLattice_SetBallOptions(BeamLattice Lib3MFHandle, eBallMode ELib3MFBeamLatticeBallMode, dBallRadius float64) (error)


	/**
	* Returns the beam count of a mesh object.
	*
	* @param[in] BeamLattice - BeamLattice instance.
	* @return filled with the beam count.
	*/
	BeamLattice_GetBeamCount(BeamLattice Lib3MFHandle) (uint32, error)


	/**
	* Returns indices, radii and capmodes of a single beam of a mesh object.
	*
	* @param[in] BeamLattice - BeamLattice instance.
	* @param[in] nIndex - Index of the beam (0 to beamcount - 1).
	* @return filled with the beam indices, radii and capmodes.
	*/
	BeamLattice_GetBeam(BeamLattice Lib3MFHandle, nIndex uint32) (sLib3MFBeam, error)


	/**
	* Adds a single beam to a mesh object.
	*
	* @param[in] BeamLattice - BeamLattice instance.
	* @param[in] sBeamInfo - contains the node indices, radii and capmodes.
	* @return filled with the new Index of the beam.
	*/
	BeamLattice_AddBeam(BeamLattice Lib3MFHandle, sBeamInfo sLib3MFBeam) (uint32, error)


	/**
	* Sets the indices, radii and capmodes of a single beam of a mesh object.
	*
	* @param[in] BeamLattice - BeamLattice instance.
	* @param[in] nIndex - Index of the beam (0 to beamcount - 1).
	* @param[in] sBeamInfo - filled with the beam indices, radii and capmodes.
	*/
	BeamLattice_SetBeam(BeamLattice Lib3MFHandle, nIndex uint32, sBeamInfo sLib3MFBeam) (error)


	/**
	* Sets all beam indices, radii and capmodes of a mesh object.
	*
	* @param[in] BeamLattice - BeamLattice instance.
	* @param[in] BeamInfo - contains information of a number of  beams
	*/
	BeamLattice_SetBeams(BeamLattice Lib3MFHandle, BeamInfo []sLib3MFBeam) (error)


	/**
	* obtains all beam indices, radii and capmodes of a mesh object.
	*
	* @param[in] BeamLattice - BeamLattice instance.
	* @return contains information of all beams
	*/
	BeamLattice_GetBeams(BeamLattice Lib3MFHandle) ([]sLib3MFBeam, error)


	/**
	* Returns the ball count of a mesh object.
	*
	* @param[in] BeamLattice - BeamLattice instance.
	* @return filled with the ball count.
	*/
	BeamLattice_GetBallCount(BeamLattice Lib3MFHandle) (uint32, error)


	/**
	* Returns index and radius of a single ball of a mesh object.
	*
	* @param[in] BeamLattice - BeamLattice instance.
	* @param[in] nIndex - Index of the ball (0 to ballcount - 1).
	* @return filled with the ball node index and radius.
	*/
	BeamLattice_GetBall(BeamLattice Lib3MFHandle, nIndex uint32) (sLib3MFBall, error)


	/**
	* Adds a single ball to a mesh object.
	*
	* @param[in] BeamLattice - BeamLattice instance.
	* @param[in] sBallInfo - contains the node index and radius.
	* @return filled with the new Index of the ball.
	*/
	BeamLattice_AddBall(BeamLattice Lib3MFHandle, sBallInfo sLib3MFBall) (uint32, error)


	/**
	* Sets the index and radius of a single ball of a mesh object.
	*
	* @param[in] BeamLattice - BeamLattice instance.
	* @param[in] nIndex - Index of the ball (0 to ballcount - 1).
	* @param[in] sBallInfo - filled with the ball node index and radius.
	*/
	BeamLattice_SetBall(BeamLattice Lib3MFHandle, nIndex uint32, sBallInfo sLib3MFBall) (error)


	/**
	* Sets all ball indices and radii of a mesh object.
	*
	* @param[in] BeamLattice - BeamLattice instance.
	* @param[in] BallInfo - contains information of a number of  balls
	*/
	BeamLattice_SetBalls(BeamLattice Lib3MFHandle, BallInfo []sLib3MFBall) (error)


	/**
	* obtains all ball indices and radii of a mesh object.
	*
	* @param[in] BeamLattice - BeamLattice instance.
	* @return contains information of all balls
	*/
	BeamLattice_GetBalls(BeamLattice Lib3MFHandle) ([]sLib3MFBall, error)


	/**
	* Returns the number of beamsets of a mesh object.
	*
	* @param[in] BeamLattice - BeamLattice instance.
	* @return filled with the beamset count.
	*/
	BeamLattice_GetBeamSetCount(BeamLattice Lib3MFHandle) (uint32, error)


	/**
	* Adds an empty beamset to a mesh object
	*
	* @param[in] BeamLattice - BeamLattice instance.
	* @return the new beamset
	*/
	BeamLattice_AddBeamSet(BeamLattice Lib3MFHandle) (Lib3MFHandle, error)


	/**
	* Returns a beamset of a mesh object
	*
	* @param[in] BeamLattice - BeamLattice instance.
	* @param[in] nIndex - index of the requested beamset (0 ... beamsetcount-1).
	* @return the requested beamset
	*/
	BeamLattice_GetBeamSet(BeamLattice Lib3MFHandle, nIndex uint32) (Lib3MFHandle, error)


	/**
	* Returns the Resource Instance of the component.
	*
	* @param[in] Component - Component instance.
	* @return filled with the Resource Instance.
	*/
	Component_GetObjectResource(Component Lib3MFHandle) (Lib3MFHandle, error)


	/**
	* Returns the UniqueResourceID of the component.
	*
	* @param[in] Component - Component instance.
	* @return returns the UniqueResourceID.
	*/
	Component_GetObjectResourceID(Component Lib3MFHandle) (uint32, error)


	/**
	* returns, whether a component has a UUID and, if true, the component's UUID
	*
	* @param[in] Component - Component instance.
	* @return flag whether the component has a UUID
	* @return the UUID as string of the form 'xxxxxxxx-xxxx-xxxx-xxxxxxxxxxxxxxxx'
	*/
	Component_GetUUID(Component Lib3MFHandle) (bool, string, error)


	/**
	* sets the component's UUID
	*
	* @param[in] Component - Component instance.
	* @param[in] sUUID - the UUID as string of the form 'xxxxxxxx-xxxx-xxxx-xxxxxxxxxxxxxxxx'
	*/
	Component_SetUUID(Component Lib3MFHandle, sUUID string) (error)


	/**
	* Returns, if the component has a different transformation than the identity matrix
	*
	* @param[in] Component - Component instance.
	* @return if true is returned, the transformation is not equal than the identity
	*/
	Component_HasTransform(Component Lib3MFHandle) (bool, error)


	/**
	* Returns the transformation matrix of the component.
	*
	* @param[in] Component - Component instance.
	* @return filled with the component transformation matrix
	*/
	Component_GetTransform(Component Lib3MFHandle) (sLib3MFTransform, error)


	/**
	* Sets the transformation matrix of the component.
	*
	* @param[in] Component - Component instance.
	* @param[in] sTransform - new transformation matrix
	*/
	Component_SetTransform(Component Lib3MFHandle, sTransform sLib3MFTransform) (error)


	/**
	* Adds a new component to a components object.
	*
	* @param[in] ComponentsObject - ComponentsObject instance.
	* @param[in] ObjectResource - object to add as component. Must not lead to circular references!
	* @param[in] sTransform - optional transform matrix for the component.
	* @return new component instance
	*/
	ComponentsObject_AddComponent(ComponentsObject Lib3MFHandle, ObjectResource Lib3MFHandle, sTransform sLib3MFTransform) (Lib3MFHandle, error)


	/**
	* Retrieves a component from a component object.
	*
	* @param[in] ComponentsObject - ComponentsObject instance.
	* @param[in] nIndex - index of the component to retrieve (0 to componentcount - 1)
	* @return component instance
	*/
	ComponentsObject_GetComponent(ComponentsObject Lib3MFHandle, nIndex uint32) (Lib3MFHandle, error)


	/**
	* Retrieves a component count of a component object.
	*
	* @param[in] ComponentsObject - ComponentsObject instance.
	* @return returns the component count
	*/
	ComponentsObject_GetComponentCount(ComponentsObject Lib3MFHandle) (uint32, error)


	/**
	* Sets a beamset's name string
	*
	* @param[in] BeamSet - BeamSet instance.
	* @param[in] sName - new name of the beamset.
	*/
	BeamSet_SetName(BeamSet Lib3MFHandle, sName string) (error)


	/**
	* Retrieves a beamset's name string
	*
	* @param[in] BeamSet - BeamSet instance.
	* @return returns the name of the beamset.
	*/
	BeamSet_GetName(BeamSet Lib3MFHandle) (string, error)


	/**
	* Sets a beamset's identifier string
	*
	* @param[in] BeamSet - BeamSet instance.
	* @param[in] sIdentifier - new name of the beamset.
	*/
	BeamSet_SetIdentifier(BeamSet Lib3MFHandle, sIdentifier string) (error)


	/**
	* Retrieves a beamset's identifier string
	*
	* @param[in] BeamSet - BeamSet instance.
	* @return returns the identifier of the beamset.
	*/
	BeamSet_GetIdentifier(BeamSet Lib3MFHandle) (string, error)


	/**
	* Retrieves the reference count of a beamset
	*
	* @param[in] BeamSet - BeamSet instance.
	* @return returns the reference count
	*/
	BeamSet_GetReferenceCount(BeamSet Lib3MFHandle) (uint32, error)


	/**
	* Sets the references of a beamset
	*
	* @param[in] BeamSet - BeamSet instance.
	* @param[in] References - the new indices of all beams in this beamset
	*/
	BeamSet_SetReferences(BeamSet Lib3MFHandle, References []uint32) (error)


	/**
	* Retrieves the references of a beamset
	*
	* @param[in] BeamSet - BeamSet instance.
	* @return retrieves the indices of all beams in this beamset
	*/
	BeamSet_GetReferences(BeamSet Lib3MFHandle) ([]uint32, error)


	/**
	* Retrieves the ball reference count of a beamset
	*
	* @param[in] BeamSet - BeamSet instance.
	* @return returns the ball reference count
	*/
	BeamSet_GetBallReferenceCount(BeamSet Lib3MFHandle) (uint32, error)


	/**
	* Sets the ball references of a beamset
	*
	* @param[in] BeamSet - BeamSet instance.
	* @param[in] BallReferences - the new indices of all balls in this beamset
	*/
	BeamSet_SetBallReferences(BeamSet Lib3MFHandle, BallReferences []uint32) (error)


	/**
	* Retrieves the ball references of a beamset
	*
	* @param[in] BeamSet - BeamSet instance.
	* @return retrieves the indices of all balls in this beamset
	*/
	BeamSet_GetBallReferences(BeamSet Lib3MFHandle) ([]uint32, error)


	/**
	* Retrieves the count of base materials in the material group.
	*
	* @param[in] BaseMaterialGroup - BaseMaterialGroup instance.
	* @return returns the count of base materials.
	*/
	BaseMaterialGroup_GetCount(BaseMaterialGroup Lib3MFHandle) (uint32, error)


	/**
	* returns all the PropertyIDs of all materials in this group
	*
	* @param[in] BaseMaterialGroup - BaseMaterialGroup instance.
	* @return PropertyID of the material in the material group.
	*/
	BaseMaterialGroup_GetAllPropertyIDs(BaseMaterialGroup Lib3MFHandle) ([]uint32, error)


	/**
	* Adds a new material to the material group
	*
	* @param[in] BaseMaterialGroup - BaseMaterialGroup instance.
	* @param[in] sName - new name of the base material.
	* @param[in] sDisplayColor - Display color of the material
	* @return returns new PropertyID of the new material in the material group.
	*/
	BaseMaterialGroup_AddMaterial(BaseMaterialGroup Lib3MFHandle, sName string, sDisplayColor sLib3MFColor) (uint32, error)


	/**
	* Removes a material from the material group.
	*
	* @param[in] BaseMaterialGroup - BaseMaterialGroup instance.
	* @param[in] nPropertyID - PropertyID of the material in the material group.
	*/
	BaseMaterialGroup_RemoveMaterial(BaseMaterialGroup Lib3MFHandle, nPropertyID uint32) (error)


	/**
	* Returns the base material's name
	*
	* @param[in] BaseMaterialGroup - BaseMaterialGroup instance.
	* @param[in] nPropertyID - PropertyID of the material in the material group.
	* @return returns the name of the base material.
	*/
	BaseMaterialGroup_GetName(BaseMaterialGroup Lib3MFHandle, nPropertyID uint32) (string, error)


	/**
	* Sets a base material's name
	*
	* @param[in] BaseMaterialGroup - BaseMaterialGroup instance.
	* @param[in] nPropertyID - PropertyID of the material in the material group.
	* @param[in] sName - new name of the base material.
	*/
	BaseMaterialGroup_SetName(BaseMaterialGroup Lib3MFHandle, nPropertyID uint32, sName string) (error)


	/**
	* Sets a base material's display color.
	*
	* @param[in] BaseMaterialGroup - BaseMaterialGroup instance.
	* @param[in] nPropertyID - PropertyID of the material in the material group.
	* @param[in] sTheColor - The base material's display color
	*/
	BaseMaterialGroup_SetDisplayColor(BaseMaterialGroup Lib3MFHandle, nPropertyID uint32, sTheColor sLib3MFColor) (error)


	/**
	* Returns a base material's display color.
	*
	* @param[in] BaseMaterialGroup - BaseMaterialGroup instance.
	* @param[in] nPropertyID - PropertyID of the material in the material group.
	* @return The base material's display color
	*/
	BaseMaterialGroup_GetDisplayColor(BaseMaterialGroup Lib3MFHandle, nPropertyID uint32) (sLib3MFColor, error)


	/**
	* Retrieves the count of base materials in this Color Group.
	*
	* @param[in] ColorGroup - ColorGroup instance.
	* @return returns the count of colors within this color group.
	*/
	ColorGroup_GetCount(ColorGroup Lib3MFHandle) (uint32, error)


	/**
	* returns all the PropertyIDs of all colors within this group
	*
	* @param[in] ColorGroup - ColorGroup instance.
	* @return PropertyID of the color in the color group.
	*/
	ColorGroup_GetAllPropertyIDs(ColorGroup Lib3MFHandle) ([]uint32, error)


	/**
	* Adds a new value.
	*
	* @param[in] ColorGroup - ColorGroup instance.
	* @param[in] sTheColor - The new color
	* @return PropertyID of the new color within this color group.
	*/
	ColorGroup_AddColor(ColorGroup Lib3MFHandle, sTheColor sLib3MFColor) (uint32, error)


	/**
	* Removes a color from the color group.
	*
	* @param[in] ColorGroup - ColorGroup instance.
	* @param[in] nPropertyID - PropertyID of the color to be removed from the color group.
	*/
	ColorGroup_RemoveColor(ColorGroup Lib3MFHandle, nPropertyID uint32) (error)


	/**
	* Sets a color value.
	*
	* @param[in] ColorGroup - ColorGroup instance.
	* @param[in] nPropertyID - PropertyID of a color within this color group.
	* @param[in] sTheColor - The color
	*/
	ColorGroup_SetColor(ColorGroup Lib3MFHandle, nPropertyID uint32, sTheColor sLib3MFColor) (error)


	/**
	* Sets a color value.
	*
	* @param[in] ColorGroup - ColorGroup instance.
	* @param[in] nPropertyID - PropertyID of a color within this color group.
	* @return The color
	*/
	ColorGroup_GetColor(ColorGroup Lib3MFHandle, nPropertyID uint32) (sLib3MFColor, error)


	/**
	* Retrieves the count of tex2coords in the Texture2DGroup.
	*
	* @param[in] Texture2DGroup - Texture2DGroup instance.
	* @return returns the count of tex2coords.
	*/
	Texture2DGroup_GetCount(Texture2DGroup Lib3MFHandle) (uint32, error)


	/**
	* returns all the PropertyIDs of all tex2coords in this Texture2DGroup
	*
	* @param[in] Texture2DGroup - Texture2DGroup instance.
	* @return PropertyID of the tex2coords in the Texture2DGroup.
	*/
	Texture2DGroup_GetAllPropertyIDs(Texture2DGroup Lib3MFHandle) ([]uint32, error)


	/**
	* Adds a new tex2coord to the Texture2DGroup
	*
	* @param[in] Texture2DGroup - Texture2DGroup instance.
	* @param[in] sUVCoordinate - The u/v-coordinate within the texture, horizontally right/vertically up from the origin in the lower left of the texture.
	* @return returns new PropertyID of the new tex2coord in the Texture2DGroup.
	*/
	Texture2DGroup_AddTex2Coord(Texture2DGroup Lib3MFHandle, sUVCoordinate sLib3MFTex2Coord) (uint32, error)


	/**
	* Obtains a tex2coord to the Texture2DGroup
	*
	* @param[in] Texture2DGroup - Texture2DGroup instance.
	* @param[in] nPropertyID - the PropertyID of the tex2coord in the Texture2DGroup.
	* @return The u/v-coordinate within the texture, horizontally right/vertically up from the origin in the lower left of the texture.
	*/
	Texture2DGroup_GetTex2Coord(Texture2DGroup Lib3MFHandle, nPropertyID uint32) (sLib3MFTex2Coord, error)


	/**
	* Removes a tex2coords from the Texture2DGroup.
	*
	* @param[in] Texture2DGroup - Texture2DGroup instance.
	* @param[in] nPropertyID - PropertyID of the tex2coords in the Texture2DGroup.
	*/
	Texture2DGroup_RemoveTex2Coord(Texture2DGroup Lib3MFHandle, nPropertyID uint32) (error)


	/**
	* Obtains the texture2D instance of this group.
	*
	* @param[in] Texture2DGroup - Texture2DGroup instance.
	* @return the texture2D instance of this group.
	*/
	Texture2DGroup_GetTexture2D(Texture2DGroup Lib3MFHandle) (Lib3MFHandle, error)


	/**
	* Retrieves the count of Composite-s in the CompositeMaterials.
	*
	* @param[in] CompositeMaterials - CompositeMaterials instance.
	* @return returns the count of Composite-s
	*/
	CompositeMaterials_GetCount(CompositeMaterials Lib3MFHandle) (uint32, error)


	/**
	* returns all the PropertyIDs of all Composite-Mixing Values in this CompositeMaterials
	*
	* @param[in] CompositeMaterials - CompositeMaterials instance.
	* @return PropertyID of the Composite-Mixing Values in the CompositeMaterials.
	*/
	CompositeMaterials_GetAllPropertyIDs(CompositeMaterials Lib3MFHandle) ([]uint32, error)


	/**
	* Obtains the BaseMaterialGroup instance of this CompositeMaterials.
	*
	* @param[in] CompositeMaterials - CompositeMaterials instance.
	* @return returns the BaseMaterialGroup instance of this CompositeMaterials
	*/
	CompositeMaterials_GetBaseMaterialGroup(CompositeMaterials Lib3MFHandle) (Lib3MFHandle, error)


	/**
	* Adds a new Composite-Mixing Values to the CompositeMaterials.
	*
	* @param[in] CompositeMaterials - CompositeMaterials instance.
	* @param[in] Composite - The Composite Constituents to be added as composite
	* @return returns new PropertyID of the new Composite in the CompositeMaterials.
	*/
	CompositeMaterials_AddComposite(CompositeMaterials Lib3MFHandle, Composite []sLib3MFCompositeConstituent) (uint32, error)


	/**
	* Removes a Composite-Maxing Ratio from the CompositeMaterials.
	*
	* @param[in] CompositeMaterials - CompositeMaterials instance.
	* @param[in] nPropertyID - PropertyID of the  Composite-Mixing Values in the CompositeMaterials to be removed.
	*/
	CompositeMaterials_RemoveComposite(CompositeMaterials Lib3MFHandle, nPropertyID uint32) (error)


	/**
	* Obtains a Composite-Maxing Ratio of this CompositeMaterials.
	*
	* @param[in] CompositeMaterials - CompositeMaterials instance.
	* @param[in] nPropertyID - the PropertyID of the Composite-Maxing Ratio in the CompositeMaterials.
	* @return The Composite-Mixing Values with the given PropertyID
	*/
	CompositeMaterials_GetComposite(CompositeMaterials Lib3MFHandle, nPropertyID uint32) ([]sLib3MFCompositeConstituent, error)


	/**
	* Retrieves the count of MultiProperty-s in the MultiPropertyGroup.
	*
	* @param[in] MultiPropertyGroup - MultiPropertyGroup instance.
	* @return returns the count of MultiProperty-s
	*/
	MultiPropertyGroup_GetCount(MultiPropertyGroup Lib3MFHandle) (uint32, error)


	/**
	* returns all the PropertyIDs of all MultiProperty-s in this MultiPropertyGroup
	*
	* @param[in] MultiPropertyGroup - MultiPropertyGroup instance.
	* @return PropertyID of the MultiProperty-s in the MultiPropertyGroup.
	*/
	MultiPropertyGroup_GetAllPropertyIDs(MultiPropertyGroup Lib3MFHandle) ([]uint32, error)


	/**
	* Adds a new MultiProperty to the MultiPropertyGroup.
	*
	* @param[in] MultiPropertyGroup - MultiPropertyGroup instance.
	* @param[in] PropertyIDs - The PropertyIDs of the new MultiProperty.
	* @return returns the PropertyID of the new MultiProperty in the MultiPropertyGroup.
	*/
	MultiPropertyGroup_AddMultiProperty(MultiPropertyGroup Lib3MFHandle, PropertyIDs []uint32) (uint32, error)


	/**
	* Sets the PropertyIDs of a MultiProperty.
	*
	* @param[in] MultiPropertyGroup - MultiPropertyGroup instance.
	* @param[in] nPropertyID - the PropertyID of the MultiProperty to be changed.
	* @param[in] PropertyIDs - The new PropertyIDs of the MultiProperty
	*/
	MultiPropertyGroup_SetMultiProperty(MultiPropertyGroup Lib3MFHandle, nPropertyID uint32, PropertyIDs []uint32) (error)


	/**
	* Obtains the PropertyIDs of a MultiProperty.
	*
	* @param[in] MultiPropertyGroup - MultiPropertyGroup instance.
	* @param[in] nPropertyID - the PropertyID of the MultiProperty to be queried.
	* @return The PropertyIDs of the MultiProperty
	*/
	MultiPropertyGroup_GetMultiProperty(MultiPropertyGroup Lib3MFHandle, nPropertyID uint32) ([]uint32, error)


	/**
	* Removes a MultiProperty from this MultiPropertyGroup.
	*
	* @param[in] MultiPropertyGroup - MultiPropertyGroup instance.
	* @param[in] nPropertyID - the PropertyID of the MultiProperty to be removed.
	*/
	MultiPropertyGroup_RemoveMultiProperty(MultiPropertyGroup Lib3MFHandle, nPropertyID uint32) (error)


	/**
	* Retrieves the number of layers of this MultiPropertyGroup.
	*
	* @param[in] MultiPropertyGroup - MultiPropertyGroup instance.
	* @return returns the number of layers
	*/
	MultiPropertyGroup_GetLayerCount(MultiPropertyGroup Lib3MFHandle) (uint32, error)


	/**
	* Adds a MultiPropertyLayer to this MultiPropertyGroup.
	*
	* @param[in] MultiPropertyGroup - MultiPropertyGroup instance.
	* @param[in] sTheLayer - The MultiPropertyLayer to add to this MultiPropertyGroup
	* @return returns the index of this MultiPropertyLayer
	*/
	MultiPropertyGroup_AddLayer(MultiPropertyGroup Lib3MFHandle, sTheLayer sLib3MFMultiPropertyLayer) (uint32, error)


	/**
	* Obtains a MultiPropertyLayer of this MultiPropertyGroup.
	*
	* @param[in] MultiPropertyGroup - MultiPropertyGroup instance.
	* @param[in] nLayerIndex - The Index of the MultiPropertyLayer queried
	* @return The MultiPropertyLayer with index LayerIndex within MultiPropertyGroup
	*/
	MultiPropertyGroup_GetLayer(MultiPropertyGroup Lib3MFHandle, nLayerIndex uint32) (sLib3MFMultiPropertyLayer, error)


	/**
	* Removes a MultiPropertyLayer from this MultiPropertyGroup.
	*
	* @param[in] MultiPropertyGroup - MultiPropertyGroup instance.
	* @param[in] nLayerIndex - The Index of the MultiPropertyLayer to be removed
	*/
	MultiPropertyGroup_RemoveLayer(MultiPropertyGroup Lib3MFHandle, nLayerIndex uint32) (error)


	/**
	* Retrieves an attachment's package path. This function will be removed in a later release.
	*
	* @param[in] Attachment - Attachment instance.
	* @return returns the attachment's package path string
	*/
	Attachment_GetPath(Attachment Lib3MFHandle) (string, error)


	/**
	* Sets an attachment's package path. This function will be removed in a later release.
	*
	* @param[in] Attachment - Attachment instance.
	* @param[in] sPath - new path of the attachment.
	*/
	Attachment_SetPath(Attachment Lib3MFHandle, sPath string) (error)


	/**
	* Returns the PackagePart that is this attachment.
	*
	* @param[in] Attachment - Attachment instance.
	* @return The PackagePart of this attachment.
	*/
	Attachment_PackagePart(Attachment Lib3MFHandle) (Lib3MFHandle, error)


	/**
	* Retrieves an attachment's relationship type
	*
	* @param[in] Attachment - Attachment instance.
	* @return returns the attachment's package relationship type string
	*/
	Attachment_GetRelationShipType(Attachment Lib3MFHandle) (string, error)


	/**
	* Sets an attachment's relationship type.
	*
	* @param[in] Attachment - Attachment instance.
	* @param[in] sPath - new relationship type string.
	*/
	Attachment_SetRelationShipType(Attachment Lib3MFHandle, sPath string) (error)


	/**
	* Writes out the attachment as file.
	*
	* @param[in] Attachment - Attachment instance.
	* @param[in] sFileName - file to write into.
	*/
	Attachment_WriteToFile(Attachment Lib3MFHandle, sFileName string) (error)


	/**
	* Reads an attachment from a file.
	*
	* @param[in] Attachment - Attachment instance.
	* @param[in] sFileName - file to read from.
	*/
	Attachment_ReadFromFile(Attachment Lib3MFHandle, sFileName string) (error)


	/**
	* Retrieves the size of the attachment stream
	*
	* @param[in] Attachment - Attachment instance.
	* @return the stream size
	*/
	Attachment_GetStreamSize(Attachment Lib3MFHandle) (uint64, error)


	/**
	* Writes out the attachment into a buffer
	*
	* @param[in] Attachment - Attachment instance.
	* @return Buffer to write into
	*/
	Attachment_WriteToBuffer(Attachment Lib3MFHandle) ([]uint8, error)


	/**
	* Reads an attachment from a memory buffer
	*
	* @param[in] Attachment - Attachment instance.
	* @param[in] Buffer - Buffer to read from
	*/
	Attachment_ReadFromBuffer(Attachment Lib3MFHandle, Buffer []uint8) (error)


	/**
	* Retrieves the attachment located at the path of the texture.
	*
	* @param[in] Texture2D - Texture2D instance.
	* @return attachment that holds the texture's image information.
	*/
	Texture2D_GetAttachment(Texture2D Lib3MFHandle) (Lib3MFHandle, error)


	/**
	* Sets the texture's package path to the path of the attachment.
	*
	* @param[in] Texture2D - Texture2D instance.
	* @param[in] Attachment - attachment that holds the texture's image information.
	*/
	Texture2D_SetAttachment(Texture2D Lib3MFHandle, Attachment Lib3MFHandle) (error)


	/**
	* Retrieves a texture's content type.
	*
	* @param[in] Texture2D - Texture2D instance.
	* @return returns content type enum.
	*/
	Texture2D_GetContentType(Texture2D Lib3MFHandle) (ELib3MFTextureType, error)


	/**
	* Retrieves a texture's content type.
	*
	* @param[in] Texture2D - Texture2D instance.
	* @param[in] eContentType - new Content Type
	*/
	Texture2D_SetContentType(Texture2D Lib3MFHandle, eContentType ELib3MFTextureType) (error)


	/**
	* Retrieves a texture's tilestyle type.
	*
	* @param[in] Texture2D - Texture2D instance.
	* @return returns tilestyle type enum.
	* @return returns tilestyle type enum.
	*/
	Texture2D_GetTileStyleUV(Texture2D Lib3MFHandle) (ELib3MFTextureTileStyle, ELib3MFTextureTileStyle, error)


	/**
	* Sets a texture's tilestyle type.
	*
	* @param[in] Texture2D - Texture2D instance.
	* @param[in] eTileStyleU - new tilestyle type enum.
	* @param[in] eTileStyleV - new tilestyle type enum.
	*/
	Texture2D_SetTileStyleUV(Texture2D Lib3MFHandle, eTileStyleU ELib3MFTextureTileStyle, eTileStyleV ELib3MFTextureTileStyle) (error)


	/**
	* Retrieves a texture's filter type.
	*
	* @param[in] Texture2D - Texture2D instance.
	* @return returns filter type enum.
	*/
	Texture2D_GetFilter(Texture2D Lib3MFHandle) (ELib3MFTextureFilter, error)


	/**
	* Sets a texture's filter type.
	*
	* @param[in] Texture2D - Texture2D instance.
	* @param[in] eFilter - sets new filter type enum.
	*/
	Texture2D_SetFilter(Texture2D Lib3MFHandle, eFilter ELib3MFTextureFilter) (error)


	/**
	* Retrieves the object resource associated to a build item
	*
	* @param[in] BuildItem - BuildItem instance.
	* @return returns the associated resource instance
	*/
	BuildItem_GetObjectResource(BuildItem Lib3MFHandle) (Lib3MFHandle, error)


	/**
	* returns, whether a build item has a UUID and, if true, the build item's UUID
	*
	* @param[in] BuildItem - BuildItem instance.
	* @return flag whether the build item has a UUID
	* @return the UUID as string of the form 'xxxxxxxx-xxxx-xxxx-xxxxxxxxxxxxxxxx'
	*/
	BuildItem_GetUUID(BuildItem Lib3MFHandle) (bool, string, error)


	/**
	* sets the build item's UUID
	*
	* @param[in] BuildItem - BuildItem instance.
	* @param[in] sUUID - the UUID as string of the form 'xxxxxxxx-xxxx-xxxx-xxxxxxxxxxxxxxxx'
	*/
	BuildItem_SetUUID(BuildItem Lib3MFHandle, sUUID string) (error)


	/**
	* Retrieves the object UniqueResourceID associated to a build item
	*
	* @param[in] BuildItem - BuildItem instance.
	* @return returns the UniqueResourceID of the object
	*/
	BuildItem_GetObjectResourceID(BuildItem Lib3MFHandle) (uint32, error)


	/**
	* Checks, if a build item has a non-identity transformation matrix
	*
	* @param[in] BuildItem - BuildItem instance.
	* @return returns true, if the transformation matrix is not the identity
	*/
	BuildItem_HasObjectTransform(BuildItem Lib3MFHandle) (bool, error)


	/**
	* Retrieves a build item's transformation matrix.
	*
	* @param[in] BuildItem - BuildItem instance.
	* @return returns the transformation matrix
	*/
	BuildItem_GetObjectTransform(BuildItem Lib3MFHandle) (sLib3MFTransform, error)


	/**
	* Sets a build item's transformation matrix.
	*
	* @param[in] BuildItem - BuildItem instance.
	* @param[in] sTransform - new transformation matrix
	*/
	BuildItem_SetObjectTransform(BuildItem Lib3MFHandle, sTransform sLib3MFTransform) (error)


	/**
	* Retrieves a build item's part number string
	*
	* @param[in] BuildItem - BuildItem instance.
	* @return Returns a build item's part number string
	*/
	BuildItem_GetPartNumber(BuildItem Lib3MFHandle) (string, error)


	/**
	* Sets a build item's part number string
	*
	* @param[in] BuildItem - BuildItem instance.
	* @param[in] sSetPartnumber - new part number string for referencing parts from the outside world
	*/
	BuildItem_SetPartNumber(BuildItem Lib3MFHandle, sSetPartnumber string) (error)


	/**
	* Returns the metadatagroup of this build item
	*
	* @param[in] BuildItem - BuildItem instance.
	* @return returns an Instance of the metadatagroup of this build item
	*/
	BuildItem_GetMetaDataGroup(BuildItem Lib3MFHandle) (Lib3MFHandle, error)


	/**
	* Returns the outbox of a build item
	*
	* @param[in] BuildItem - BuildItem instance.
	* @return Outbox of this build item
	*/
	BuildItem_GetOutbox(BuildItem Lib3MFHandle) (sLib3MFBox, error)


	/**
	* Iterates to the next build item in the list.
	*
	* @param[in] BuildItemIterator - BuildItemIterator instance.
	* @return Iterates to the next build item in the list.
	*/
	BuildItemIterator_MoveNext(BuildItemIterator Lib3MFHandle) (bool, error)


	/**
	* Iterates to the previous build item in the list.
	*
	* @param[in] BuildItemIterator - BuildItemIterator instance.
	* @return Iterates to the previous build item in the list.
	*/
	BuildItemIterator_MovePrevious(BuildItemIterator Lib3MFHandle) (bool, error)


	/**
	* Returns the build item the iterator points at.
	*
	* @param[in] BuildItemIterator - BuildItemIterator instance.
	* @return returns the build item instance.
	*/
	BuildItemIterator_GetCurrent(BuildItemIterator Lib3MFHandle) (Lib3MFHandle, error)


	/**
	* Creates a new build item iterator with the same build item list.
	*
	* @param[in] BuildItemIterator - BuildItemIterator instance.
	* @return returns the cloned Iterator instance
	*/
	BuildItemIterator_Clone(BuildItemIterator Lib3MFHandle) (Lib3MFHandle, error)


	/**
	* Returns the number of build items the iterator captures.
	*
	* @param[in] BuildItemIterator - BuildItemIterator instance.
	* @return returns the number of build items the iterator captures.
	*/
	BuildItemIterator_Count(BuildItemIterator Lib3MFHandle) (uint64, error)


	/**
	* Set all vertices of a slice. All polygons will be cleared.
	*
	* @param[in] Slice - Slice instance.
	* @param[in] Vertices - contains the positions.
	*/
	Slice_SetVertices(Slice Lib3MFHandle, Vertices []sLib3MFPosition2D) (error)


	/**
	* Get all vertices of a slice
	*
	* @param[in] Slice - Slice instance.
	* @return contains the positions.
	*/
	Slice_GetVertices(Slice Lib3MFHandle) ([]sLib3MFPosition2D, error)


	/**
	* Get the number of vertices in a slice
	*
	* @param[in] Slice - Slice instance.
	* @return the number of vertices in the slice
	*/
	Slice_GetVertexCount(Slice Lib3MFHandle) (uint64, error)


	/**
	* Add a new polygon to this slice
	*
	* @param[in] Slice - Slice instance.
	* @param[in] Indices - the new indices of the new polygon
	* @return the index of the new polygon
	*/
	Slice_AddPolygon(Slice Lib3MFHandle, Indices []uint32) (uint64, error)


	/**
	* Get the number of polygons in the slice
	*
	* @param[in] Slice - Slice instance.
	* @return the number of polygons in the slice
	*/
	Slice_GetPolygonCount(Slice Lib3MFHandle) (uint64, error)


	/**
	* Set all indices of a polygon
	*
	* @param[in] Slice - Slice instance.
	* @param[in] nIndex - the index of the polygon to manipulate
	* @param[in] Indices - the new indices of the index-th polygon
	*/
	Slice_SetPolygonIndices(Slice Lib3MFHandle, nIndex uint64, Indices []uint32) (error)


	/**
	* Get all vertices of a slice
	*
	* @param[in] Slice - Slice instance.
	* @param[in] nIndex - the index of the polygon to manipulate
	* @return the indices of the index-th polygon 
	*/
	Slice_GetPolygonIndices(Slice Lib3MFHandle, nIndex uint64) ([]uint32, error)


	/**
	* Get the number of vertices in a slice
	*
	* @param[in] Slice - Slice instance.
	* @param[in] nIndex - the index of the polygon to manipulate
	* @return the number of indices of the index-th polygon
	*/
	Slice_GetPolygonIndexCount(Slice Lib3MFHandle, nIndex uint64) (uint64, error)


	/**
	* Get the upper Z-Coordinate of this slice.
	*
	* @param[in] Slice - Slice instance.
	* @return the upper Z-Coordinate of this slice
	*/
	Slice_GetZTop(Slice Lib3MFHandle) (float64, error)


	/**
	* Get the lower Z-Coordinate of the slice stack.
	*
	* @param[in] SliceStack - SliceStack instance.
	* @return the lower Z-Coordinate the slice stack
	*/
	SliceStack_GetBottomZ(SliceStack Lib3MFHandle) (float64, error)


	/**
	* Returns the number of slices
	*
	* @param[in] SliceStack - SliceStack instance.
	* @return the number of slices
	*/
	SliceStack_GetSliceCount(SliceStack Lib3MFHandle) (uint64, error)


	/**
	* Query a slice from the slice stack
	*
	* @param[in] SliceStack - SliceStack instance.
	* @param[in] nSliceIndex - the index of the slice
	* @return the Slice instance
	*/
	SliceStack_GetSlice(SliceStack Lib3MFHandle, nSliceIndex uint64) (Lib3MFHandle, error)


	/**
	* Returns the number of slices
	*
	* @param[in] SliceStack - SliceStack instance.
	* @param[in] dZTop - upper Z coordinate of the slice
	* @return a new Slice instance
	*/
	SliceStack_AddSlice(SliceStack Lib3MFHandle, dZTop float64) (Lib3MFHandle, error)


	/**
	* Returns the number of slice refs
	*
	* @param[in] SliceStack - SliceStack instance.
	* @return the number of slicereferences
	*/
	SliceStack_GetSliceRefCount(SliceStack Lib3MFHandle) (uint64, error)


	/**
	* Adds another existing slicestack as sliceref in this slicestack
	*
	* @param[in] SliceStack - SliceStack instance.
	* @param[in] TheSliceStack - the slicestack to use as sliceref
	*/
	SliceStack_AddSliceStackReference(SliceStack Lib3MFHandle, TheSliceStack Lib3MFHandle) (error)


	/**
	* Adds another existing slicestack as sliceref in this slicestack
	*
	* @param[in] SliceStack - SliceStack instance.
	* @param[in] nSliceRefIndex - the index of the slice ref
	* @return the slicestack that is used as sliceref
	*/
	SliceStack_GetSliceStackReference(SliceStack Lib3MFHandle, nSliceRefIndex uint64) (Lib3MFHandle, error)


	/**
	* Removes the indirection of slices via slice-refs, i.e. creates the slices of all slice refs of this SliceStack as actual slices of this SliceStack. All previously existing slices or slicerefs will be removed.
	*
	* @param[in] SliceStack - SliceStack instance.
	*/
	SliceStack_CollapseSliceReferences(SliceStack Lib3MFHandle) (error)


	/**
	* Sets the package path where this Slice should be stored. Input an empty string to reset the path
	*
	* @param[in] SliceStack - SliceStack instance.
	* @param[in] sPath - the package path where this Slice should be stored
	*/
	SliceStack_SetOwnPath(SliceStack Lib3MFHandle, sPath string) (error)


	/**
	* Obtains the package path where this Slice should be stored. Returns an empty string if the slicestack is stored within the root model.
	*
	* @param[in] SliceStack - SliceStack instance.
	* @return the package path where this Slice will be stored
	*/
	SliceStack_GetOwnPath(SliceStack Lib3MFHandle) (string, error)


	/**
	* Gets the consumerid
	*
	* @param[in] Consumer - Consumer instance.
	* @return A unique identifier for the consumers
	*/
	Consumer_GetConsumerID(Consumer Lib3MFHandle) (string, error)


	/**
	* Getts the keyid
	*
	* @param[in] Consumer - Consumer instance.
	* @return The identifier for the key of this consumer
	*/
	Consumer_GetKeyID(Consumer Lib3MFHandle) (string, error)


	/**
	* Gets the keyvalue associated with this consumer
	*
	* @param[in] Consumer - Consumer instance.
	* @return The public key, when available, of this consumer
	*/
	Consumer_GetKeyValue(Consumer Lib3MFHandle) (string, error)


	/**
	* Gets the consumer associated with this access right
	*
	* @param[in] AccessRight - AccessRight instance.
	* @return The consumer instance
	*/
	AccessRight_GetConsumer(AccessRight Lib3MFHandle) (Lib3MFHandle, error)


	/**
	* Gets the associated encryption algorithm
	*
	* @param[in] AccessRight - AccessRight instance.
	* @return The algorithm used for the key in this accessright
	*/
	AccessRight_GetWrappingAlgorithm(AccessRight Lib3MFHandle) (ELib3MFWrappingAlgorithm, error)


	/**
	* Gets the associated mask generation function algorithm
	*
	* @param[in] AccessRight - AccessRight instance.
	* @return The MFG1 algorithm
	*/
	AccessRight_GetMgfAlgorithm(AccessRight Lib3MFHandle) (ELib3MFMgfAlgorithm, error)


	/**
	* Gets the digest method assoicated
	*
	* @param[in] AccessRight - AccessRight instance.
	* @return The digest method for this accessright
	*/
	AccessRight_GetDigestMethod(AccessRight Lib3MFHandle) (ELib3MFDigestMethod, error)


	/**
	* Returns the encryption method to be used in this encryption process
	*
	* @param[in] ContentEncryptionParams - ContentEncryptionParams instance.
	* @return 
	*/
	ContentEncryptionParams_GetEncryptionAlgorithm(ContentEncryptionParams Lib3MFHandle) (ELib3MFEncryptionAlgorithm, error)


	/**
	* Gets the key for the resource associated
	*
	* @param[in] ContentEncryptionParams - ContentEncryptionParams instance.
	* @return Pointer to a buffer where to place the key.
	*/
	ContentEncryptionParams_GetKey(ContentEncryptionParams Lib3MFHandle) ([]uint8, error)


	/**
	* Gets the IV data
	*
	* @param[in] ContentEncryptionParams - ContentEncryptionParams instance.
	* @return Pointer to a buffer where to place the data.
	*/
	ContentEncryptionParams_GetInitializationVector(ContentEncryptionParams Lib3MFHandle) ([]uint8, error)


	/**
	* A handler descriptor that uniquely identifies the context of the resource. Each resource will be assigned a different value
	*
	* @param[in] ContentEncryptionParams - ContentEncryptionParams instance.
	* @return Pointer to a buffer where to place the data.
	*/
	ContentEncryptionParams_GetAuthenticationTag(ContentEncryptionParams Lib3MFHandle) ([]uint8, error)


	/**
	* Sets the authentication tag
	*
	* @param[in] ContentEncryptionParams - ContentEncryptionParams instance.
	* @param[in] ByteData - The authentication tag size
	*/
	ContentEncryptionParams_SetAuthenticationTag(ContentEncryptionParams Lib3MFHandle, ByteData []uint8) (error)


	/**
	* A handler descriptor that uniquely identifies the context of the resource. Each resource will be assigned a different value
	*
	* @param[in] ContentEncryptionParams - ContentEncryptionParams instance.
	* @return Buffer where the data will be placed
	*/
	ContentEncryptionParams_GetAdditionalAuthenticationData(ContentEncryptionParams Lib3MFHandle) ([]uint8, error)


	/**
	* A handler descriptor that uniquely identifies the context of the resource. Each resource will be assigned a different value
	*
	* @param[in] ContentEncryptionParams - ContentEncryptionParams instance.
	* @return 
	*/
	ContentEncryptionParams_GetDescriptor(ContentEncryptionParams Lib3MFHandle) (uint64, error)


	/**
	* Gets the resourcedatagroup keyuuid
	*
	* @param[in] ContentEncryptionParams - ContentEncryptionParams instance.
	* @return The resourcedatagroup keyuuid that may be use to reference an external key
	*/
	ContentEncryptionParams_GetKeyUUID(ContentEncryptionParams Lib3MFHandle) (string, error)


	/**
	* Gets the encrypted part path
	*
	* @param[in] ResourceData - ResourceData instance.
	* @return The part path
	*/
	ResourceData_GetPath(ResourceData Lib3MFHandle) (Lib3MFHandle, error)


	/**
	* Gets the encryption algorithm used to encrypt this ResourceData
	*
	* @param[in] ResourceData - ResourceData instance.
	* @return The encryption algorithm
	*/
	ResourceData_GetEncryptionAlgorithm(ResourceData Lib3MFHandle) (ELib3MFEncryptionAlgorithm, error)


	/**
	* Tells whether this ResourceData is compressed or not
	*
	* @param[in] ResourceData - ResourceData instance.
	* @return The compression method
	*/
	ResourceData_GetCompression(ResourceData Lib3MFHandle) (ELib3MFCompression, error)


	/**
	* Tells whether this ResourceData is compressed or not
	*
	* @param[in] ResourceData - ResourceData instance.
	* @return The compression method
	*/
	ResourceData_GetAdditionalAuthenticationData(ResourceData Lib3MFHandle) ([]uint8, error)


	/**
	* Sets the resourcedatagroup keyuuid
	*
	* @param[in] ResourceDataGroup - ResourceDataGroup instance.
	* @return The new resourcedatagroup keyuuid.
	*/
	ResourceDataGroup_GetKeyUUID(ResourceDataGroup Lib3MFHandle) (string, error)


	/**
	* Add accessright to resourcedatagroup element
	*
	* @param[in] ResourceDataGroup - ResourceDataGroup instance.
	* @param[in] Consumer - The Consumer reference
	* @param[in] eWrappingAlgorithm - The key wrapping algorithm to be used
	* @param[in] eMgfAlgorithm - The mask generation function to be used
	* @param[in] eDigestMethod - The digest mechanism to be used
	* @return The acess right instance
	*/
	ResourceDataGroup_AddAccessRight(ResourceDataGroup Lib3MFHandle, Consumer Lib3MFHandle, eWrappingAlgorithm ELib3MFWrappingAlgorithm, eMgfAlgorithm ELib3MFMgfAlgorithm, eDigestMethod ELib3MFDigestMethod) (Lib3MFHandle, error)


	/**
	* Finds the AccessRight associated with a Consumer
	*
	* @param[in] ResourceDataGroup - ResourceDataGroup instance.
	* @param[in] Consumer - The Consumer instance
	* @return The AcessRight instance
	*/
	ResourceDataGroup_FindAccessRightByConsumer(ResourceDataGroup Lib3MFHandle, Consumer Lib3MFHandle) (Lib3MFHandle, error)


	/**
	* Removes access from a Consumer on this resource data group
	*
	* @param[in] ResourceDataGroup - ResourceDataGroup instance.
	* @param[in] Consumer - The Consumer instance
	*/
	ResourceDataGroup_RemoveAccessRight(ResourceDataGroup Lib3MFHandle, Consumer Lib3MFHandle) (error)


	/**
	* Adds a consumer to the keystore
	*
	* @param[in] KeyStore - KeyStore instance.
	* @param[in] sConsumerID - A unique identifier for the consumer
	* @param[in] sKeyID - The id of the key of the consumer
	* @param[in] sKeyValue - The public key for this consumer in PEM format
	* @return The consumer instance
	*/
	KeyStore_AddConsumer(KeyStore Lib3MFHandle, sConsumerID string, sKeyID string, sKeyValue string) (Lib3MFHandle, error)


	/**
	* Gets the number of consumers in the keystore
	*
	* @param[in] KeyStore - KeyStore instance.
	* @return The consumer count
	*/
	KeyStore_GetConsumerCount(KeyStore Lib3MFHandle) (uint64, error)


	/**
	* Get a consumer from the keystore
	*
	* @param[in] KeyStore - KeyStore instance.
	* @param[in] nConsumerIndex - The index of the consumer
	* @return The consumer instance
	*/
	KeyStore_GetConsumer(KeyStore Lib3MFHandle, nConsumerIndex uint64) (Lib3MFHandle, error)


	/**
	* Removes a consumer from the keystore
	*
	* @param[in] KeyStore - KeyStore instance.
	* @param[in] Consumer - The consumer instance to remove
	*/
	KeyStore_RemoveConsumer(KeyStore Lib3MFHandle, Consumer Lib3MFHandle) (error)


	/**
	* Finds a consumer by ID
	*
	* @param[in] KeyStore - KeyStore instance.
	* @param[in] sConsumerID - The ID of the consumer
	* @return The consumer instance
	*/
	KeyStore_FindConsumer(KeyStore Lib3MFHandle, sConsumerID string) (Lib3MFHandle, error)


	/**
	* Gets the number of resource data group in the keysore
	*
	* @param[in] KeyStore - KeyStore instance.
	* @return The number of resource data available
	*/
	KeyStore_GetResourceDataGroupCount(KeyStore Lib3MFHandle) (uint64, error)


	/**
	* Adds a resource data group into the keystore.
	*
	* @param[in] KeyStore - KeyStore instance.
	* @return The resource data group instance
	*/
	KeyStore_AddResourceDataGroup(KeyStore Lib3MFHandle) (Lib3MFHandle, error)


	/**
	* Gets a resource data group
	*
	* @param[in] KeyStore - KeyStore instance.
	* @param[in] nResourceDataIndex - The index of the resource data
	* @return The resource data group instance
	*/
	KeyStore_GetResourceDataGroup(KeyStore Lib3MFHandle, nResourceDataIndex uint64) (Lib3MFHandle, error)


	/**
	* Removes a resource data group
	*
	* @param[in] KeyStore - KeyStore instance.
	* @param[in] ResourceDataGroup - The resource data group instance
	*/
	KeyStore_RemoveResourceDataGroup(KeyStore Lib3MFHandle, ResourceDataGroup Lib3MFHandle) (error)


	/**
	* Finds a resource data group that contains a particular resourcedata
	*
	* @param[in] KeyStore - KeyStore instance.
	* @param[in] PartPath - The target path for the resourcedata hold by the resource data group
	* @return The data resource instance
	*/
	KeyStore_FindResourceDataGroup(KeyStore Lib3MFHandle, PartPath Lib3MFHandle) (Lib3MFHandle, error)


	/**
	* Add resourcedata to resourcedatagroup element
	*
	* @param[in] KeyStore - KeyStore instance.
	* @param[in] ResourceDataGroup - The resource data group where to add this resource data
	* @param[in] PartPath - The path of the part to be encrypted
	* @param[in] eAlgorithm - The encryption algorithm to be used to encrypt this resource
	* @param[in] eCompression - Whether compression should be used prior to encryption
	* @param[in] AdditionalAuthenticationData - Additional data to be encrypted along the contents for better security
	* @return The data resource instance
	*/
	KeyStore_AddResourceData(KeyStore Lib3MFHandle, ResourceDataGroup Lib3MFHandle, PartPath Lib3MFHandle, eAlgorithm ELib3MFEncryptionAlgorithm, eCompression ELib3MFCompression, AdditionalAuthenticationData []uint8) (Lib3MFHandle, error)


	/**
	* Removes a resource data
	*
	* @param[in] KeyStore - KeyStore instance.
	* @param[in] ResourceData - The resource data to be removed
	*/
	KeyStore_RemoveResourceData(KeyStore Lib3MFHandle, ResourceData Lib3MFHandle) (error)


	/**
	* Finds a resource data on this resource group
	*
	* @param[in] KeyStore - KeyStore instance.
	* @param[in] ResourcePath - The target path for the resourcedata
	* @return The resource data instance
	*/
	KeyStore_FindResourceData(KeyStore Lib3MFHandle, ResourcePath Lib3MFHandle) (Lib3MFHandle, error)


	/**
	* Gets the number of resource data in the keysore
	*
	* @param[in] KeyStore - KeyStore instance.
	* @return The number of resource data available
	*/
	KeyStore_GetResourceDataCount(KeyStore Lib3MFHandle) (uint64, error)


	/**
	* Gets a resource data
	*
	* @param[in] KeyStore - KeyStore instance.
	* @param[in] nResourceDataIndex - The index of the resource data
	* @return The data resource instance
	*/
	KeyStore_GetResourceData(KeyStore Lib3MFHandle, nResourceDataIndex uint64) (Lib3MFHandle, error)


	/**
	* Gets the keystore UUID
	*
	* @param[in] KeyStore - KeyStore instance.
	* @return flag whether the keystore has a UUID
	* @return returns the keystore uuid.
	*/
	KeyStore_GetUUID(KeyStore Lib3MFHandle) (bool, string, error)


	/**
	* Sets the keystore UUID
	*
	* @param[in] KeyStore - KeyStore instance.
	* @param[in] sUUID - The new keystore uuid.
	*/
	KeyStore_SetUUID(KeyStore Lib3MFHandle, sUUID string) (error)


	/**
	* Returns the PackagePart within the OPC package that holds the root model.
	*
	* @param[in] Model - Model instance.
	* @return the PackagePart within the OPC package that holds the model-file
	*/
	Model_RootModelPart(Model Lib3MFHandle) (Lib3MFHandle, error)


	/**
	* Returns a new PackagePart for use within the OPC package.
	*
	* @param[in] Model - Model instance.
	* @param[in] sAbsolutePath - the absolute Path (physical location) within the OPC package
	* @return the new PackagePart within the OPC package
	*/
	Model_FindOrCreatePackagePart(Model Lib3MFHandle, sAbsolutePath string) (Lib3MFHandle, error)


	/**
	* sets the units of a model.
	*
	* @param[in] Model - Model instance.
	* @param[in] eUnit - Unit enum value for the model unit
	*/
	Model_SetUnit(Model Lib3MFHandle, eUnit ELib3MFModelUnit) (error)


	/**
	* returns the units of a model.
	*
	* @param[in] Model - Model instance.
	* @return Unit enum value for the model unit
	*/
	Model_GetUnit(Model Lib3MFHandle) (ELib3MFModelUnit, error)


	/**
	* retrieves the language of a model
	*
	* @param[in] Model - Model instance.
	* @return language identifier
	*/
	Model_GetLanguage(Model Lib3MFHandle) (string, error)


	/**
	* sets the language of a model
	*
	* @param[in] Model - Model instance.
	* @param[in] sLanguage - language identifier
	*/
	Model_SetLanguage(Model Lib3MFHandle, sLanguage string) (error)


	/**
	* creates a model writer instance for a specific file type
	*
	* @param[in] Model - Model instance.
	* @param[in] sWriterClass -  string identifier for the file type
	* @return  string identifier for the file type
	*/
	Model_QueryWriter(Model Lib3MFHandle, sWriterClass string) (Lib3MFHandle, error)


	/**
	* creates a model reader instance for a specific file type
	*
	* @param[in] Model - Model instance.
	* @param[in] sReaderClass -  string identifier for the file type
	* @return  string identifier for the file type
	*/
	Model_QueryReader(Model Lib3MFHandle, sReaderClass string) (Lib3MFHandle, error)


	/**
	* finds a model texture by its UniqueResourceID
	*
	* @param[in] Model - Model instance.
	* @param[in] nUniqueResourceID - UniqueResourceID
	* @return returns the texture2d instance
	*/
	Model_GetTexture2DByID(Model Lib3MFHandle, nUniqueResourceID uint32) (Lib3MFHandle, error)


	/**
	* returns a Property's type
	*
	* @param[in] Model - Model instance.
	* @param[in] nUniqueResourceID - Resource ID of the Property to Query
	* @return returns a Property's type
	*/
	Model_GetPropertyTypeByID(Model Lib3MFHandle, nUniqueResourceID uint32) (ELib3MFPropertyType, error)


	/**
	* finds a model base material group by its UniqueResourceID
	*
	* @param[in] Model - Model instance.
	* @param[in] nUniqueResourceID - UniqueResourceID
	* @return returns the BaseMaterialGroup instance
	*/
	Model_GetBaseMaterialGroupByID(Model Lib3MFHandle, nUniqueResourceID uint32) (Lib3MFHandle, error)


	/**
	* finds a model texture2d group by its UniqueResourceID
	*
	* @param[in] Model - Model instance.
	* @param[in] nUniqueResourceID - UniqueResourceID
	* @return returns the Texture2DGroup instance
	*/
	Model_GetTexture2DGroupByID(Model Lib3MFHandle, nUniqueResourceID uint32) (Lib3MFHandle, error)


	/**
	* finds a model CompositeMaterials by its UniqueResourceID
	*
	* @param[in] Model - Model instance.
	* @param[in] nUniqueResourceID - UniqueResourceID
	* @return returns the CompositeMaterials instance
	*/
	Model_GetCompositeMaterialsByID(Model Lib3MFHandle, nUniqueResourceID uint32) (Lib3MFHandle, error)


	/**
	* finds a model MultiPropertyGroup by its UniqueResourceID
	*
	* @param[in] Model - Model instance.
	* @param[in] nUniqueResourceID - UniqueResourceID
	* @return returns the MultiPropertyGroup instance
	*/
	Model_GetMultiPropertyGroupByID(Model Lib3MFHandle, nUniqueResourceID uint32) (Lib3MFHandle, error)


	/**
	* finds a mesh object by its UniqueResourceID
	*
	* @param[in] Model - Model instance.
	* @param[in] nUniqueResourceID - UniqueResourceID
	* @return returns the mesh object instance
	*/
	Model_GetMeshObjectByID(Model Lib3MFHandle, nUniqueResourceID uint32) (Lib3MFHandle, error)


	/**
	* finds a components object by its UniqueResourceID
	*
	* @param[in] Model - Model instance.
	* @param[in] nUniqueResourceID - UniqueResourceID
	* @return returns the components object instance
	*/
	Model_GetComponentsObjectByID(Model Lib3MFHandle, nUniqueResourceID uint32) (Lib3MFHandle, error)


	/**
	* finds a model color group by its UniqueResourceID
	*
	* @param[in] Model - Model instance.
	* @param[in] nUniqueResourceID - UniqueResourceID
	* @return returns the ColorGroup instance
	*/
	Model_GetColorGroupByID(Model Lib3MFHandle, nUniqueResourceID uint32) (Lib3MFHandle, error)


	/**
	* finds a model slicestack by its UniqueResourceID
	*
	* @param[in] Model - Model instance.
	* @param[in] nUniqueResourceID - UniqueResourceID
	* @return returns the slicestack instance
	*/
	Model_GetSliceStackByID(Model Lib3MFHandle, nUniqueResourceID uint32) (Lib3MFHandle, error)


	/**
	* returns, whether a build has a UUID and, if true, the build's UUID
	*
	* @param[in] Model - Model instance.
	* @return flag whether the build has a UUID
	* @return the UUID as string of the form 'xxxxxxxx-xxxx-xxxx-xxxxxxxxxxxxxxxx'
	*/
	Model_GetBuildUUID(Model Lib3MFHandle) (bool, string, error)


	/**
	* sets the build's UUID
	*
	* @param[in] Model - Model instance.
	* @param[in] sUUID - the UUID as string of the form 'xxxxxxxx-xxxx-xxxx-xxxxxxxxxxxxxxxx'
	*/
	Model_SetBuildUUID(Model Lib3MFHandle, sUUID string) (error)


	/**
	* creates a build item iterator instance with all build items.
	*
	* @param[in] Model - Model instance.
	* @return returns the iterator instance.
	*/
	Model_GetBuildItems(Model Lib3MFHandle) (Lib3MFHandle, error)


	/**
	* Returns the outbox of a Model
	*
	* @param[in] Model - Model instance.
	* @return Outbox of this Model
	*/
	Model_GetOutbox(Model Lib3MFHandle) (sLib3MFBox, error)


	/**
	* creates a resource iterator instance with all resources.
	*
	* @param[in] Model - Model instance.
	* @return returns the iterator instance.
	*/
	Model_GetResources(Model Lib3MFHandle) (Lib3MFHandle, error)


	/**
	* creates a resource iterator instance with all object resources.
	*
	* @param[in] Model - Model instance.
	* @return returns the iterator instance.
	*/
	Model_GetObjects(Model Lib3MFHandle) (Lib3MFHandle, error)


	/**
	* creates a resource iterator instance with all mesh object resources.
	*
	* @param[in] Model - Model instance.
	* @return returns the iterator instance.
	*/
	Model_GetMeshObjects(Model Lib3MFHandle) (Lib3MFHandle, error)


	/**
	* creates a resource iterator instance with all components object resources.
	*
	* @param[in] Model - Model instance.
	* @return returns the iterator instance.
	*/
	Model_GetComponentsObjects(Model Lib3MFHandle) (Lib3MFHandle, error)


	/**
	* creates a Texture2DIterator instance with all texture2d resources.
	*
	* @param[in] Model - Model instance.
	* @return returns the iterator instance.
	*/
	Model_GetTexture2Ds(Model Lib3MFHandle) (Lib3MFHandle, error)


	/**
	* creates a BaseMaterialGroupIterator instance with all base material resources.
	*
	* @param[in] Model - Model instance.
	* @return returns the iterator instance.
	*/
	Model_GetBaseMaterialGroups(Model Lib3MFHandle) (Lib3MFHandle, error)


	/**
	* creates a ColorGroupIterator instance with all ColorGroup resources.
	*
	* @param[in] Model - Model instance.
	* @return returns the iterator instance.
	*/
	Model_GetColorGroups(Model Lib3MFHandle) (Lib3MFHandle, error)


	/**
	* creates a Texture2DGroupIterator instance with all base material resources.
	*
	* @param[in] Model - Model instance.
	* @return returns the iterator instance.
	*/
	Model_GetTexture2DGroups(Model Lib3MFHandle) (Lib3MFHandle, error)


	/**
	* creates a CompositeMaterialsIterator instance with all CompositeMaterials resources.
	*
	* @param[in] Model - Model instance.
	* @return returns the iterator instance.
	*/
	Model_GetCompositeMaterials(Model Lib3MFHandle) (Lib3MFHandle, error)


	/**
	* creates a MultiPropertyGroupsIterator instance with all MultiPropertyGroup resources.
	*
	* @param[in] Model - Model instance.
	* @return returns the iterator instance.
	*/
	Model_GetMultiPropertyGroups(Model Lib3MFHandle) (Lib3MFHandle, error)


	/**
	* creates a resource iterator instance with all slice stack resources.
	*
	* @param[in] Model - Model instance.
	* @return returns the iterator instance.
	*/
	Model_GetSliceStacks(Model Lib3MFHandle) (Lib3MFHandle, error)


	/**
	* Merges all components and objects which are referenced by a build item into a mesh. The memory is duplicated and a new model is created.
	*
	* @param[in] Model - Model instance.
	* @return returns the merged model instance
	*/
	Model_MergeToModel(Model Lib3MFHandle) (Lib3MFHandle, error)


	/**
	* adds an empty mesh object to the model.
	*
	* @param[in] Model - Model instance.
	* @return  returns the mesh object instance
	*/
	Model_AddMeshObject(Model Lib3MFHandle) (Lib3MFHandle, error)


	/**
	* adds an empty component object to the model.
	*
	* @param[in] Model - Model instance.
	* @return  returns the components object instance
	*/
	Model_AddComponentsObject(Model Lib3MFHandle) (Lib3MFHandle, error)


	/**
	* creates a new model slicestack by its id
	*
	* @param[in] Model - Model instance.
	* @param[in] dZBottom - Bottom Z value of the slicestack
	* @return returns the new slicestack instance
	*/
	Model_AddSliceStack(Model Lib3MFHandle, dZBottom float64) (Lib3MFHandle, error)


	/**
	* adds a texture2d resource to the model. Its path is given by that of an existing attachment.
	*
	* @param[in] Model - Model instance.
	* @param[in] TextureAttachment - attachment containing the image data.
	* @return returns the new texture instance.
	*/
	Model_AddTexture2DFromAttachment(Model Lib3MFHandle, TextureAttachment Lib3MFHandle) (Lib3MFHandle, error)


	/**
	* adds an empty BaseMaterialGroup resource to the model.
	*
	* @param[in] Model - Model instance.
	* @return returns the new base material instance.
	*/
	Model_AddBaseMaterialGroup(Model Lib3MFHandle) (Lib3MFHandle, error)


	/**
	* adds an empty ColorGroup resource to the model.
	*
	* @param[in] Model - Model instance.
	* @return returns the new ColorGroup instance.
	*/
	Model_AddColorGroup(Model Lib3MFHandle) (Lib3MFHandle, error)


	/**
	* adds an empty Texture2DGroup resource to the model.
	*
	* @param[in] Model - Model instance.
	* @param[in] Texture2DInstance - The texture2D instance of the created Texture2DGroup.
	* @return returns the new Texture2DGroup instance.
	*/
	Model_AddTexture2DGroup(Model Lib3MFHandle, Texture2DInstance Lib3MFHandle) (Lib3MFHandle, error)


	/**
	* adds an empty CompositeMaterials resource to the model.
	*
	* @param[in] Model - Model instance.
	* @param[in] BaseMaterialGroupInstance - The BaseMaterialGroup instance of the created CompositeMaterials.
	* @return returns the new CompositeMaterials instance.
	*/
	Model_AddCompositeMaterials(Model Lib3MFHandle, BaseMaterialGroupInstance Lib3MFHandle) (Lib3MFHandle, error)


	/**
	* adds an empty MultiPropertyGroup resource to the model.
	*
	* @param[in] Model - Model instance.
	* @return returns the new MultiPropertyGroup instance.
	*/
	Model_AddMultiPropertyGroup(Model Lib3MFHandle) (Lib3MFHandle, error)


	/**
	* adds a build item to the model.
	*
	* @param[in] Model - Model instance.
	* @param[in] Object - Object instance.
	* @param[in] sTransform - Transformation matrix.
	* @return returns the build item instance.
	*/
	Model_AddBuildItem(Model Lib3MFHandle, Object Lib3MFHandle, sTransform sLib3MFTransform) (Lib3MFHandle, error)


	/**
	* removes a build item from the model
	*
	* @param[in] Model - Model instance.
	* @param[in] BuildItemInstance - Build item to remove.
	*/
	Model_RemoveBuildItem(Model Lib3MFHandle, BuildItemInstance Lib3MFHandle) (error)


	/**
	* Returns the metadata of the model as MetaDataGroup
	*
	* @param[in] Model - Model instance.
	* @return returns an Instance of the metadatagroup of the model
	*/
	Model_GetMetaDataGroup(Model Lib3MFHandle) (Lib3MFHandle, error)


	/**
	* adds an attachment stream to the model. The OPC part will be related to the model stream with a certain relationship type.
	*
	* @param[in] Model - Model instance.
	* @param[in] sURI - Path of the attachment
	* @param[in] sRelationShipType - Relationship type of the attachment
	* @return Instance of the attachment object
	*/
	Model_AddAttachment(Model Lib3MFHandle, sURI string, sRelationShipType string) (Lib3MFHandle, error)


	/**
	* Removes attachment from the model.
	*
	* @param[in] Model - Model instance.
	* @param[in] AttachmentInstance - Attachment instance to remove
	*/
	Model_RemoveAttachment(Model Lib3MFHandle, AttachmentInstance Lib3MFHandle) (error)


	/**
	* retrieves an attachment stream object from the model..
	*
	* @param[in] Model - Model instance.
	* @param[in] nIndex - Index of the attachment stream
	* @return Instance of the attachment object
	*/
	Model_GetAttachment(Model Lib3MFHandle, nIndex uint32) (Lib3MFHandle, error)


	/**
	* retrieves an attachment stream object from the model.
	*
	* @param[in] Model - Model instance.
	* @param[in] sURI - Path URI in the package
	* @return Instance of the attachment object
	*/
	Model_FindAttachment(Model Lib3MFHandle, sURI string) (Lib3MFHandle, error)


	/**
	* retrieves the number of attachments of the model.
	*
	* @param[in] Model - Model instance.
	* @return Returns the number of attachments.
	*/
	Model_GetAttachmentCount(Model Lib3MFHandle) (uint32, error)


	/**
	* Retrieve whether the OPC package contains a package thumbnail.
	*
	* @param[in] Model - Model instance.
	* @return returns whether the OPC package contains a package thumbnail
	*/
	Model_HasPackageThumbnailAttachment(Model Lib3MFHandle) (bool, error)


	/**
	* Create a new or the existing package thumbnail for the OPC package.
	*
	* @param[in] Model - Model instance.
	* @return Instance of a new or the existing thumbnailattachment object.
	*/
	Model_CreatePackageThumbnailAttachment(Model Lib3MFHandle) (Lib3MFHandle, error)


	/**
	* Get the attachment to the OPC package containing the package thumbnail.
	*
	* @param[in] Model - Model instance.
	* @return Instance of the thumbnailattachment object or NULL.
	*/
	Model_GetPackageThumbnailAttachment(Model Lib3MFHandle) (Lib3MFHandle, error)


	/**
	* Remove the attachment to the OPC package containing the package thumbnail.
	*
	* @param[in] Model - Model instance.
	*/
	Model_RemovePackageThumbnailAttachment(Model Lib3MFHandle) (error)


	/**
	* Adds a new Content Type to the model.
	*
	* @param[in] Model - Model instance.
	* @param[in] sExtension - File Extension
	* @param[in] sContentType - Content Type Identifier
	*/
	Model_AddCustomContentType(Model Lib3MFHandle, sExtension string, sContentType string) (error)


	/**
	* Removes a custom Content Type from the model (UTF8 version).
	*
	* @param[in] Model - Model instance.
	* @param[in] sExtension - File Extension
	*/
	Model_RemoveCustomContentType(Model Lib3MFHandle, sExtension string) (error)


	/**
	* Sets the random number generator callback for use in the library
	*
	* @param[in] Model - Model instance.
	* @param[in] pTheCallback - The callback used to generate random numbers
	* @param[in] nUserData - Userdata to be passed to the callback function
	*/
	Model_SetRandomNumberCallback(Model Lib3MFHandle, pTheCallback int64, nUserData uint64) (error)


	/**
	* Gets the keystore associated with this model
	*
	* @param[in] Model - Model instance.
	* @return The package keystore
	*/
	Model_GetKeyStore(Model Lib3MFHandle) (Lib3MFHandle, error)


	/**
	* retrieves the binary version of this library.
	*
	* @param[in] Wrapper - Wrapper instance.
	* @return returns the major version of this library
	* @return returns the minor version of this library
	* @return returns the micro version of this library
	*/
	GetLibraryVersion() (uint32, uint32, uint32, error)


	/**
	* retrieves prerelease information of this library.
	*
	* @param[in] Wrapper - Wrapper instance.
	* @return Does the library provide prerelease version?
	* @return retrieves prerelease information of this library.
	*/
	GetPrereleaseInformation() (bool, string, error)


	/**
	* retrieves build information of this library.
	*
	* @param[in] Wrapper - Wrapper instance.
	* @return Does the library provide build version?
	* @return retrieves build information of this library.
	*/
	GetBuildInformation() (bool, string, error)


	/**
	* retrieves whether a specification is supported, and if so, which version.
	*
	* @param[in] Wrapper - Wrapper instance.
	* @param[in] sSpecificationURL - URL of extension to check
	* @return returns whether this specification is supported
	* @return returns the major version of the extension (if IsSupported)
	* @return returns the minor version of the extension (if IsSupported)
	* @return returns the micro version of the extension (if IsSupported)
	*/
	GetSpecificationVersion(sSpecificationURL string) (bool, uint32, uint32, uint32, error)


	/**
	* creates an empty model instance.
	*
	* @param[in] Wrapper - Wrapper instance.
	* @return returns an empty model instance
	*/
	CreateModel() (Lib3MFHandle, error)


	/**
	* releases shared ownership of an object instance
	*
	* @param[in] Wrapper - Wrapper instance.
	* @param[in] Instance - the object instance to release
	*/
	Release(Instance Lib3MFHandle) (error)


	/**
	* acquires shared ownership of an object instance
	*
	* @param[in] Wrapper - Wrapper instance.
	* @param[in] Instance - the object instance to acquire
	*/
	Acquire(Instance Lib3MFHandle) (error)


	/**
	* Sets the journal file path
	*
	* @param[in] Wrapper - Wrapper instance.
	* @param[in] sJournalPath - File name of the journal file
	*/
	SetJournal(sJournalPath string) (error)


	/**
	* Retrieves the last error string of an instance
	*
	* @param[in] Wrapper - Wrapper instance.
	* @param[in] Instance - Object where the error occured.
	* @return Last Error String
	* @return Returns if the instance has a last error.
	*/
	GetLastError(Instance Lib3MFHandle) (string, bool, error)


	/**
	* Return an English text for a progress identifier.|Note: this is the only function you can call from your callback function.
	*
	* @param[in] Wrapper - Wrapper instance.
	* @param[in] eTheProgressIdentifier - the progress identifier that is passed to the callback function
	* @return English text for the progress identifier
	*/
	RetrieveProgressMessage(eTheProgressIdentifier ELib3MFProgressIdentifier) (string, error)


	/**
	* Creates a Color from uint8 RGBA values
	*
	* @param[in] Wrapper - Wrapper instance.
	* @param[in] nRed - Red value of color (0-255)
	* @param[in] nGreen - Green value of color (0-255)
	* @param[in] nBlue - Blue value of color (0-255)
	* @param[in] nAlpha - Alpha value of color (0-255)
	* @return Assembled color
	*/
	RGBAToColor(nRed uint8, nGreen uint8, nBlue uint8, nAlpha uint8) (sLib3MFColor, error)


	/**
	* Creates a Color from uint8 RGBA values
	*
	* @param[in] Wrapper - Wrapper instance.
	* @param[in] fRed - Red value of color (0-1)
	* @param[in] fGreen - Green value of color (0-1)
	* @param[in] fBlue - Blue value of color (0-1)
	* @param[in] fAlpha - Alpha value of color (0-1)
	* @return Assembled color
	*/
	FloatRGBAToColor(fRed float32, fGreen float32, fBlue float32, fAlpha float32) (sLib3MFColor, error)


	/**
	* Calculates uint8-RGBA-values from a Color
	*
	* @param[in] Wrapper - Wrapper instance.
	* @param[in] sTheColor - Color to handle
	* @return Red value of color (0-255)
	* @return Green value of color (0-255)
	* @return Blue value of color (0-255)
	* @return Alpha value of color (0-255)
	*/
	ColorToRGBA(sTheColor sLib3MFColor) (uint8, uint8, uint8, uint8, error)


	/**
	* Calculates float-RGBA-values from a Color
	*
	* @param[in] Wrapper - Wrapper instance.
	* @param[in] sTheColor - Color to handle
	* @return Red value of color (0-1)
	* @return Green value of color (0-1)
	* @return Blue value of color (0-1)
	* @return Alpha value of color (0-1)
	*/
	ColorToFloatRGBA(sTheColor sLib3MFColor) (float32, float32, float32, float32, error)


	/**
	* Creates an identity transform
	*
	* @param[in] Wrapper - Wrapper instance.
	* @return Transformation matrix.
	*/
	GetIdentityTransform() (sLib3MFTransform, error)


	/**
	* Creates a uniform scale transform
	*
	* @param[in] Wrapper - Wrapper instance.
	* @param[in] fFactor - Factor in X, Y and Z
	* @return Transformation matrix.
	*/
	GetUniformScaleTransform(fFactor float32) (sLib3MFTransform, error)


	/**
	* Creates a scale transform
	*
	* @param[in] Wrapper - Wrapper instance.
	* @param[in] fFactorX - Factor in X
	* @param[in] fFactorY - Factor in Y
	* @param[in] fFactorZ - Factor in Z
	* @return Transformation matrix.
	*/
	GetScaleTransform(fFactorX float32, fFactorY float32, fFactorZ float32) (sLib3MFTransform, error)


	/**
	* Creates an translation transform
	*
	* @param[in] Wrapper - Wrapper instance.
	* @param[in] fVectorX - Translation in X
	* @param[in] fVectorY - Translation in Y
	* @param[in] fVectorZ - Translation in Z
	* @return Transformation matrix.
	*/
	GetTranslationTransform(fVectorX float32, fVectorY float32, fVectorZ float32) (sLib3MFTransform, error)


}


/*************************************************************************************************************************
Class definition Lib3MFBase
**************************************************************************************************************************/

type Lib3MFBase struct {
	Interface Lib3MFGoInterface
	Handle Lib3MFHandle
}

func (instance *Lib3MFBase) Close() (error) {
	return instance.Handle.Close()
}


/*************************************************************************************************************************
Class definition Lib3MFWriter
**************************************************************************************************************************/

type Lib3MFWriter struct {
	Lib3MFBase
}

func (instance *Lib3MFWriter) Close() (error) {
	return instance.Handle.Close()
}

func (instance *Lib3MFWriter) WriteToFile(sFilename string) (error) {
	error := instance.Interface.Writer_WriteToFile(instance.Handle, sFilename)
	return error
}

func (instance *Lib3MFWriter) GetStreamSize() (uint64, error) {
	nStreamSize, error := instance.Interface.Writer_GetStreamSize(instance.Handle)
	return nStreamSize, error
}

func (instance *Lib3MFWriter) WriteToBuffer() ([]uint8, error) {
	bufferBuffer, error := instance.Interface.Writer_WriteToBuffer(instance.Handle)
	return bufferBuffer, error
}

func (instance *Lib3MFWriter) WriteToCallback(pTheWriteCallback int64, pTheSeekCallback int64, nUserData uint64) (error) {
	error := instance.Interface.Writer_WriteToCallback(instance.Handle, pTheWriteCallback, pTheSeekCallback, nUserData)
	return error
}

func (instance *Lib3MFWriter) SetProgressCallback(pProgressCallback int64, nUserData uint64) (error) {
	error := instance.Interface.Writer_SetProgressCallback(instance.Handle, pProgressCallback, nUserData)
	return error
}

func (instance *Lib3MFWriter) GetDecimalPrecision() (uint32, error) {
	nDecimalPrecision, error := instance.Interface.Writer_GetDecimalPrecision(instance.Handle)
	return nDecimalPrecision, error
}

func (instance *Lib3MFWriter) SetDecimalPrecision(nDecimalPrecision uint32) (error) {
	error := instance.Interface.Writer_SetDecimalPrecision(instance.Handle, nDecimalPrecision)
	return error
}

func (instance *Lib3MFWriter) SetStrictModeActive(bStrictModeActive bool) (error) {
	error := instance.Interface.Writer_SetStrictModeActive(instance.Handle, bStrictModeActive)
	return error
}

func (instance *Lib3MFWriter) GetStrictModeActive() (bool, error) {
	bStrictModeActive, error := instance.Interface.Writer_GetStrictModeActive(instance.Handle)
	return bStrictModeActive, error
}

func (instance *Lib3MFWriter) GetWarning(nIndex uint32) (uint32, string, error) {
	nErrorCode, sWarning, error := instance.Interface.Writer_GetWarning(instance.Handle, nIndex)
	return nErrorCode, sWarning, error
}

func (instance *Lib3MFWriter) GetWarningCount() (uint32, error) {
	nCount, error := instance.Interface.Writer_GetWarningCount(instance.Handle)
	return nCount, error
}

func (instance *Lib3MFWriter) AddKeyWrappingCallback(sConsumerID string, pTheCallback int64, nUserData uint64) (error) {
	error := instance.Interface.Writer_AddKeyWrappingCallback(instance.Handle, sConsumerID, pTheCallback, nUserData)
	return error
}

func (instance *Lib3MFWriter) SetContentEncryptionCallback(pTheCallback int64, nUserData uint64) (error) {
	error := instance.Interface.Writer_SetContentEncryptionCallback(instance.Handle, pTheCallback, nUserData)
	return error
}


/*************************************************************************************************************************
Class definition Lib3MFReader
**************************************************************************************************************************/

type Lib3MFReader struct {
	Lib3MFBase
}

func (instance *Lib3MFReader) Close() (error) {
	return instance.Handle.Close()
}

func (instance *Lib3MFReader) ReadFromFile(sFilename string) (error) {
	error := instance.Interface.Reader_ReadFromFile(instance.Handle, sFilename)
	return error
}

func (instance *Lib3MFReader) ReadFromBuffer(Buffer []uint8) (error) {
	error := instance.Interface.Reader_ReadFromBuffer(instance.Handle, Buffer)
	return error
}

func (instance *Lib3MFReader) ReadFromCallback(pTheReadCallback int64, nStreamSize uint64, pTheSeekCallback int64, nUserData uint64) (error) {
	error := instance.Interface.Reader_ReadFromCallback(instance.Handle, pTheReadCallback, nStreamSize, pTheSeekCallback, nUserData)
	return error
}

func (instance *Lib3MFReader) SetProgressCallback(pProgressCallback int64, nUserData uint64) (error) {
	error := instance.Interface.Reader_SetProgressCallback(instance.Handle, pProgressCallback, nUserData)
	return error
}

func (instance *Lib3MFReader) AddRelationToRead(sRelationShipType string) (error) {
	error := instance.Interface.Reader_AddRelationToRead(instance.Handle, sRelationShipType)
	return error
}

func (instance *Lib3MFReader) RemoveRelationToRead(sRelationShipType string) (error) {
	error := instance.Interface.Reader_RemoveRelationToRead(instance.Handle, sRelationShipType)
	return error
}

func (instance *Lib3MFReader) SetStrictModeActive(bStrictModeActive bool) (error) {
	error := instance.Interface.Reader_SetStrictModeActive(instance.Handle, bStrictModeActive)
	return error
}

func (instance *Lib3MFReader) GetStrictModeActive() (bool, error) {
	bStrictModeActive, error := instance.Interface.Reader_GetStrictModeActive(instance.Handle)
	return bStrictModeActive, error
}

func (instance *Lib3MFReader) GetWarning(nIndex uint32) (uint32, string, error) {
	nErrorCode, sWarning, error := instance.Interface.Reader_GetWarning(instance.Handle, nIndex)
	return nErrorCode, sWarning, error
}

func (instance *Lib3MFReader) GetWarningCount() (uint32, error) {
	nCount, error := instance.Interface.Reader_GetWarningCount(instance.Handle)
	return nCount, error
}

func (instance *Lib3MFReader) AddKeyWrappingCallback(sConsumerID string, pTheCallback int64, nUserData uint64) (error) {
	error := instance.Interface.Reader_AddKeyWrappingCallback(instance.Handle, sConsumerID, pTheCallback, nUserData)
	return error
}

func (instance *Lib3MFReader) SetContentEncryptionCallback(pTheCallback int64, nUserData uint64) (error) {
	error := instance.Interface.Reader_SetContentEncryptionCallback(instance.Handle, pTheCallback, nUserData)
	return error
}


/*************************************************************************************************************************
Class definition Lib3MFPackagePart
**************************************************************************************************************************/

type Lib3MFPackagePart struct {
	Lib3MFBase
}

func (instance *Lib3MFPackagePart) Close() (error) {
	return instance.Handle.Close()
}

func (instance *Lib3MFPackagePart) GetPath() (string, error) {
	sPath, error := instance.Interface.PackagePart_GetPath(instance.Handle)
	return sPath, error
}

func (instance *Lib3MFPackagePart) SetPath(sPath string) (error) {
	error := instance.Interface.PackagePart_SetPath(instance.Handle, sPath)
	return error
}


/*************************************************************************************************************************
Class definition Lib3MFResource
**************************************************************************************************************************/

type Lib3MFResource struct {
	Lib3MFBase
}

func (instance *Lib3MFResource) Close() (error) {
	return instance.Handle.Close()
}

func (instance *Lib3MFResource) GetResourceID() (uint32, error) {
	nUniqueResourceID, error := instance.Interface.Resource_GetResourceID(instance.Handle)
	return nUniqueResourceID, error
}

func (instance *Lib3MFResource) GetUniqueResourceID() (uint32, error) {
	nUniqueResourceID, error := instance.Interface.Resource_GetUniqueResourceID(instance.Handle)
	return nUniqueResourceID, error
}

func (instance *Lib3MFResource) PackagePart() (Lib3MFPackagePart, error) {
	hPackagePart, error := instance.Interface.Resource_PackagePart(instance.Handle)
	var cPackagePart Lib3MFPackagePart
	cPackagePart.Interface = instance.Interface
	cPackagePart.Handle = hPackagePart
	return cPackagePart, error
}

func (instance *Lib3MFResource) SetPackagePart(PackagePart Lib3MFHandle) (error) {
	error := instance.Interface.Resource_SetPackagePart(instance.Handle, PackagePart)
	return error
}

func (instance *Lib3MFResource) GetModelResourceID() (uint32, error) {
	nModelResourceId, error := instance.Interface.Resource_GetModelResourceID(instance.Handle)
	return nModelResourceId, error
}


/*************************************************************************************************************************
Class definition Lib3MFResourceIterator
**************************************************************************************************************************/

type Lib3MFResourceIterator struct {
	Lib3MFBase
}

func (instance *Lib3MFResourceIterator) Close() (error) {
	return instance.Handle.Close()
}

func (instance *Lib3MFResourceIterator) MoveNext() (bool, error) {
	bHasNext, error := instance.Interface.ResourceIterator_MoveNext(instance.Handle)
	return bHasNext, error
}

func (instance *Lib3MFResourceIterator) MovePrevious() (bool, error) {
	bHasPrevious, error := instance.Interface.ResourceIterator_MovePrevious(instance.Handle)
	return bHasPrevious, error
}

func (instance *Lib3MFResourceIterator) GetCurrent() (Lib3MFResource, error) {
	hResource, error := instance.Interface.ResourceIterator_GetCurrent(instance.Handle)
	var cResource Lib3MFResource
	cResource.Interface = instance.Interface
	cResource.Handle = hResource
	return cResource, error
}

func (instance *Lib3MFResourceIterator) Clone() (Lib3MFResourceIterator, error) {
	hOutResourceIterator, error := instance.Interface.ResourceIterator_Clone(instance.Handle)
	var cOutResourceIterator Lib3MFResourceIterator
	cOutResourceIterator.Interface = instance.Interface
	cOutResourceIterator.Handle = hOutResourceIterator
	return cOutResourceIterator, error
}

func (instance *Lib3MFResourceIterator) Count() (uint64, error) {
	nCount, error := instance.Interface.ResourceIterator_Count(instance.Handle)
	return nCount, error
}


/*************************************************************************************************************************
Class definition Lib3MFSliceStackIterator
**************************************************************************************************************************/

type Lib3MFSliceStackIterator struct {
	Lib3MFResourceIterator
}

func (instance *Lib3MFSliceStackIterator) Close() (error) {
	return instance.Handle.Close()
}

func (instance *Lib3MFSliceStackIterator) GetCurrentSliceStack() (Lib3MFSliceStack, error) {
	hResource, error := instance.Interface.SliceStackIterator_GetCurrentSliceStack(instance.Handle)
	var cResource Lib3MFSliceStack
	cResource.Interface = instance.Interface
	cResource.Handle = hResource
	return cResource, error
}


/*************************************************************************************************************************
Class definition Lib3MFObjectIterator
**************************************************************************************************************************/

type Lib3MFObjectIterator struct {
	Lib3MFResourceIterator
}

func (instance *Lib3MFObjectIterator) Close() (error) {
	return instance.Handle.Close()
}

func (instance *Lib3MFObjectIterator) GetCurrentObject() (Lib3MFObject, error) {
	hResource, error := instance.Interface.ObjectIterator_GetCurrentObject(instance.Handle)
	var cResource Lib3MFObject
	cResource.Interface = instance.Interface
	cResource.Handle = hResource
	return cResource, error
}


/*************************************************************************************************************************
Class definition Lib3MFMeshObjectIterator
**************************************************************************************************************************/

type Lib3MFMeshObjectIterator struct {
	Lib3MFResourceIterator
}

func (instance *Lib3MFMeshObjectIterator) Close() (error) {
	return instance.Handle.Close()
}

func (instance *Lib3MFMeshObjectIterator) GetCurrentMeshObject() (Lib3MFMeshObject, error) {
	hResource, error := instance.Interface.MeshObjectIterator_GetCurrentMeshObject(instance.Handle)
	var cResource Lib3MFMeshObject
	cResource.Interface = instance.Interface
	cResource.Handle = hResource
	return cResource, error
}


/*************************************************************************************************************************
Class definition Lib3MFComponentsObjectIterator
**************************************************************************************************************************/

type Lib3MFComponentsObjectIterator struct {
	Lib3MFResourceIterator
}

func (instance *Lib3MFComponentsObjectIterator) Close() (error) {
	return instance.Handle.Close()
}

func (instance *Lib3MFComponentsObjectIterator) GetCurrentComponentsObject() (Lib3MFComponentsObject, error) {
	hResource, error := instance.Interface.ComponentsObjectIterator_GetCurrentComponentsObject(instance.Handle)
	var cResource Lib3MFComponentsObject
	cResource.Interface = instance.Interface
	cResource.Handle = hResource
	return cResource, error
}


/*************************************************************************************************************************
Class definition Lib3MFTexture2DIterator
**************************************************************************************************************************/

type Lib3MFTexture2DIterator struct {
	Lib3MFResourceIterator
}

func (instance *Lib3MFTexture2DIterator) Close() (error) {
	return instance.Handle.Close()
}

func (instance *Lib3MFTexture2DIterator) GetCurrentTexture2D() (Lib3MFTexture2D, error) {
	hResource, error := instance.Interface.Texture2DIterator_GetCurrentTexture2D(instance.Handle)
	var cResource Lib3MFTexture2D
	cResource.Interface = instance.Interface
	cResource.Handle = hResource
	return cResource, error
}


/*************************************************************************************************************************
Class definition Lib3MFBaseMaterialGroupIterator
**************************************************************************************************************************/

type Lib3MFBaseMaterialGroupIterator struct {
	Lib3MFResourceIterator
}

func (instance *Lib3MFBaseMaterialGroupIterator) Close() (error) {
	return instance.Handle.Close()
}

func (instance *Lib3MFBaseMaterialGroupIterator) GetCurrentBaseMaterialGroup() (Lib3MFBaseMaterialGroup, error) {
	hResource, error := instance.Interface.BaseMaterialGroupIterator_GetCurrentBaseMaterialGroup(instance.Handle)
	var cResource Lib3MFBaseMaterialGroup
	cResource.Interface = instance.Interface
	cResource.Handle = hResource
	return cResource, error
}


/*************************************************************************************************************************
Class definition Lib3MFColorGroupIterator
**************************************************************************************************************************/

type Lib3MFColorGroupIterator struct {
	Lib3MFResourceIterator
}

func (instance *Lib3MFColorGroupIterator) Close() (error) {
	return instance.Handle.Close()
}

func (instance *Lib3MFColorGroupIterator) GetCurrentColorGroup() (Lib3MFColorGroup, error) {
	hResource, error := instance.Interface.ColorGroupIterator_GetCurrentColorGroup(instance.Handle)
	var cResource Lib3MFColorGroup
	cResource.Interface = instance.Interface
	cResource.Handle = hResource
	return cResource, error
}


/*************************************************************************************************************************
Class definition Lib3MFTexture2DGroupIterator
**************************************************************************************************************************/

type Lib3MFTexture2DGroupIterator struct {
	Lib3MFResourceIterator
}

func (instance *Lib3MFTexture2DGroupIterator) Close() (error) {
	return instance.Handle.Close()
}

func (instance *Lib3MFTexture2DGroupIterator) GetCurrentTexture2DGroup() (Lib3MFTexture2DGroup, error) {
	hResource, error := instance.Interface.Texture2DGroupIterator_GetCurrentTexture2DGroup(instance.Handle)
	var cResource Lib3MFTexture2DGroup
	cResource.Interface = instance.Interface
	cResource.Handle = hResource
	return cResource, error
}


/*************************************************************************************************************************
Class definition Lib3MFCompositeMaterialsIterator
**************************************************************************************************************************/

type Lib3MFCompositeMaterialsIterator struct {
	Lib3MFResourceIterator
}

func (instance *Lib3MFCompositeMaterialsIterator) Close() (error) {
	return instance.Handle.Close()
}

func (instance *Lib3MFCompositeMaterialsIterator) GetCurrentCompositeMaterials() (Lib3MFCompositeMaterials, error) {
	hResource, error := instance.Interface.CompositeMaterialsIterator_GetCurrentCompositeMaterials(instance.Handle)
	var cResource Lib3MFCompositeMaterials
	cResource.Interface = instance.Interface
	cResource.Handle = hResource
	return cResource, error
}


/*************************************************************************************************************************
Class definition Lib3MFMultiPropertyGroupIterator
**************************************************************************************************************************/

type Lib3MFMultiPropertyGroupIterator struct {
	Lib3MFResourceIterator
}

func (instance *Lib3MFMultiPropertyGroupIterator) Close() (error) {
	return instance.Handle.Close()
}

func (instance *Lib3MFMultiPropertyGroupIterator) GetCurrentMultiPropertyGroup() (Lib3MFMultiPropertyGroup, error) {
	hResource, error := instance.Interface.MultiPropertyGroupIterator_GetCurrentMultiPropertyGroup(instance.Handle)
	var cResource Lib3MFMultiPropertyGroup
	cResource.Interface = instance.Interface
	cResource.Handle = hResource
	return cResource, error
}


/*************************************************************************************************************************
Class definition Lib3MFMetaData
**************************************************************************************************************************/

type Lib3MFMetaData struct {
	Lib3MFBase
}

func (instance *Lib3MFMetaData) Close() (error) {
	return instance.Handle.Close()
}

func (instance *Lib3MFMetaData) GetNameSpace() (string, error) {
	sNameSpace, error := instance.Interface.MetaData_GetNameSpace(instance.Handle)
	return sNameSpace, error
}

func (instance *Lib3MFMetaData) SetNameSpace(sNameSpace string) (error) {
	error := instance.Interface.MetaData_SetNameSpace(instance.Handle, sNameSpace)
	return error
}

func (instance *Lib3MFMetaData) GetName() (string, error) {
	sName, error := instance.Interface.MetaData_GetName(instance.Handle)
	return sName, error
}

func (instance *Lib3MFMetaData) SetName(sName string) (error) {
	error := instance.Interface.MetaData_SetName(instance.Handle, sName)
	return error
}

func (instance *Lib3MFMetaData) GetKey() (string, error) {
	sKey, error := instance.Interface.MetaData_GetKey(instance.Handle)
	return sKey, error
}

func (instance *Lib3MFMetaData) GetMustPreserve() (bool, error) {
	bMustPreserve, error := instance.Interface.MetaData_GetMustPreserve(instance.Handle)
	return bMustPreserve, error
}

func (instance *Lib3MFMetaData) SetMustPreserve(bMustPreserve bool) (error) {
	error := instance.Interface.MetaData_SetMustPreserve(instance.Handle, bMustPreserve)
	return error
}

func (instance *Lib3MFMetaData) GetType() (string, error) {
	sType, error := instance.Interface.MetaData_GetType(instance.Handle)
	return sType, error
}

func (instance *Lib3MFMetaData) SetType(sType string) (error) {
	error := instance.Interface.MetaData_SetType(instance.Handle, sType)
	return error
}

func (instance *Lib3MFMetaData) GetValue() (string, error) {
	sValue, error := instance.Interface.MetaData_GetValue(instance.Handle)
	return sValue, error
}

func (instance *Lib3MFMetaData) SetValue(sValue string) (error) {
	error := instance.Interface.MetaData_SetValue(instance.Handle, sValue)
	return error
}


/*************************************************************************************************************************
Class definition Lib3MFMetaDataGroup
**************************************************************************************************************************/

type Lib3MFMetaDataGroup struct {
	Lib3MFBase
}

func (instance *Lib3MFMetaDataGroup) Close() (error) {
	return instance.Handle.Close()
}

func (instance *Lib3MFMetaDataGroup) GetMetaDataCount() (uint32, error) {
	nCount, error := instance.Interface.MetaDataGroup_GetMetaDataCount(instance.Handle)
	return nCount, error
}

func (instance *Lib3MFMetaDataGroup) GetMetaData(nIndex uint32) (Lib3MFMetaData, error) {
	hMetaData, error := instance.Interface.MetaDataGroup_GetMetaData(instance.Handle, nIndex)
	var cMetaData Lib3MFMetaData
	cMetaData.Interface = instance.Interface
	cMetaData.Handle = hMetaData
	return cMetaData, error
}

func (instance *Lib3MFMetaDataGroup) GetMetaDataByKey(sNameSpace string, sName string) (Lib3MFMetaData, error) {
	hMetaData, error := instance.Interface.MetaDataGroup_GetMetaDataByKey(instance.Handle, sNameSpace, sName)
	var cMetaData Lib3MFMetaData
	cMetaData.Interface = instance.Interface
	cMetaData.Handle = hMetaData
	return cMetaData, error
}

func (instance *Lib3MFMetaDataGroup) RemoveMetaDataByIndex(nIndex uint32) (error) {
	error := instance.Interface.MetaDataGroup_RemoveMetaDataByIndex(instance.Handle, nIndex)
	return error
}

func (instance *Lib3MFMetaDataGroup) RemoveMetaData(TheMetaData Lib3MFHandle) (error) {
	error := instance.Interface.MetaDataGroup_RemoveMetaData(instance.Handle, TheMetaData)
	return error
}

func (instance *Lib3MFMetaDataGroup) AddMetaData(sNameSpace string, sName string, sValue string, sType string, bMustPreserve bool) (Lib3MFMetaData, error) {
	hMetaData, error := instance.Interface.MetaDataGroup_AddMetaData(instance.Handle, sNameSpace, sName, sValue, sType, bMustPreserve)
	var cMetaData Lib3MFMetaData
	cMetaData.Interface = instance.Interface
	cMetaData.Handle = hMetaData
	return cMetaData, error
}


/*************************************************************************************************************************
Class definition Lib3MFObject
**************************************************************************************************************************/

type Lib3MFObject struct {
	Lib3MFResource
}

func (instance *Lib3MFObject) Close() (error) {
	return instance.Handle.Close()
}

func (instance *Lib3MFObject) GetType() (ELib3MFObjectType, error) {
	eObjectType, error := instance.Interface.Object_GetType(instance.Handle)
	return eObjectType, error
}

func (instance *Lib3MFObject) SetType(eObjectType ELib3MFObjectType) (error) {
	error := instance.Interface.Object_SetType(instance.Handle, eObjectType)
	return error
}

func (instance *Lib3MFObject) GetName() (string, error) {
	sName, error := instance.Interface.Object_GetName(instance.Handle)
	return sName, error
}

func (instance *Lib3MFObject) SetName(sName string) (error) {
	error := instance.Interface.Object_SetName(instance.Handle, sName)
	return error
}

func (instance *Lib3MFObject) GetPartNumber() (string, error) {
	sPartNumber, error := instance.Interface.Object_GetPartNumber(instance.Handle)
	return sPartNumber, error
}

func (instance *Lib3MFObject) SetPartNumber(sPartNumber string) (error) {
	error := instance.Interface.Object_SetPartNumber(instance.Handle, sPartNumber)
	return error
}

func (instance *Lib3MFObject) IsMeshObject() (bool, error) {
	bIsMeshObject, error := instance.Interface.Object_IsMeshObject(instance.Handle)
	return bIsMeshObject, error
}

func (instance *Lib3MFObject) IsComponentsObject() (bool, error) {
	bIsComponentsObject, error := instance.Interface.Object_IsComponentsObject(instance.Handle)
	return bIsComponentsObject, error
}

func (instance *Lib3MFObject) IsValid() (bool, error) {
	bIsValid, error := instance.Interface.Object_IsValid(instance.Handle)
	return bIsValid, error
}

func (instance *Lib3MFObject) SetAttachmentAsThumbnail(Attachment Lib3MFHandle) (error) {
	error := instance.Interface.Object_SetAttachmentAsThumbnail(instance.Handle, Attachment)
	return error
}

func (instance *Lib3MFObject) GetThumbnailAttachment() (Lib3MFAttachment, error) {
	hAttachment, error := instance.Interface.Object_GetThumbnailAttachment(instance.Handle)
	var cAttachment Lib3MFAttachment
	cAttachment.Interface = instance.Interface
	cAttachment.Handle = hAttachment
	return cAttachment, error
}

func (instance *Lib3MFObject) ClearThumbnailAttachment() (error) {
	error := instance.Interface.Object_ClearThumbnailAttachment(instance.Handle)
	return error
}

func (instance *Lib3MFObject) GetOutbox() (sLib3MFBox, error) {
	sOutbox, error := instance.Interface.Object_GetOutbox(instance.Handle)
	return sOutbox, error
}

func (instance *Lib3MFObject) GetUUID() (bool, string, error) {
	bHasUUID, sUUID, error := instance.Interface.Object_GetUUID(instance.Handle)
	return bHasUUID, sUUID, error
}

func (instance *Lib3MFObject) SetUUID(sUUID string) (error) {
	error := instance.Interface.Object_SetUUID(instance.Handle, sUUID)
	return error
}

func (instance *Lib3MFObject) GetMetaDataGroup() (Lib3MFMetaDataGroup, error) {
	hMetaDataGroup, error := instance.Interface.Object_GetMetaDataGroup(instance.Handle)
	var cMetaDataGroup Lib3MFMetaDataGroup
	cMetaDataGroup.Interface = instance.Interface
	cMetaDataGroup.Handle = hMetaDataGroup
	return cMetaDataGroup, error
}

func (instance *Lib3MFObject) SetSlicesMeshResolution(eMeshResolution ELib3MFSlicesMeshResolution) (error) {
	error := instance.Interface.Object_SetSlicesMeshResolution(instance.Handle, eMeshResolution)
	return error
}

func (instance *Lib3MFObject) GetSlicesMeshResolution() (ELib3MFSlicesMeshResolution, error) {
	eMeshResolution, error := instance.Interface.Object_GetSlicesMeshResolution(instance.Handle)
	return eMeshResolution, error
}

func (instance *Lib3MFObject) HasSlices(bRecursive bool) (bool, error) {
	bHasSlices, error := instance.Interface.Object_HasSlices(instance.Handle, bRecursive)
	return bHasSlices, error
}

func (instance *Lib3MFObject) ClearSliceStack() (error) {
	error := instance.Interface.Object_ClearSliceStack(instance.Handle)
	return error
}

func (instance *Lib3MFObject) GetSliceStack() (Lib3MFSliceStack, error) {
	hSliceStackInstance, error := instance.Interface.Object_GetSliceStack(instance.Handle)
	var cSliceStackInstance Lib3MFSliceStack
	cSliceStackInstance.Interface = instance.Interface
	cSliceStackInstance.Handle = hSliceStackInstance
	return cSliceStackInstance, error
}

func (instance *Lib3MFObject) AssignSliceStack(SliceStackInstance Lib3MFHandle) (error) {
	error := instance.Interface.Object_AssignSliceStack(instance.Handle, SliceStackInstance)
	return error
}


/*************************************************************************************************************************
Class definition Lib3MFMeshObject
**************************************************************************************************************************/

type Lib3MFMeshObject struct {
	Lib3MFObject
}

func (instance *Lib3MFMeshObject) Close() (error) {
	return instance.Handle.Close()
}

func (instance *Lib3MFMeshObject) GetVertexCount() (uint32, error) {
	nVertexCount, error := instance.Interface.MeshObject_GetVertexCount(instance.Handle)
	return nVertexCount, error
}

func (instance *Lib3MFMeshObject) GetTriangleCount() (uint32, error) {
	nVertexCount, error := instance.Interface.MeshObject_GetTriangleCount(instance.Handle)
	return nVertexCount, error
}

func (instance *Lib3MFMeshObject) GetVertex(nIndex uint32) (sLib3MFPosition, error) {
	sCoordinates, error := instance.Interface.MeshObject_GetVertex(instance.Handle, nIndex)
	return sCoordinates, error
}

func (instance *Lib3MFMeshObject) SetVertex(nIndex uint32, sCoordinates sLib3MFPosition) (error) {
	error := instance.Interface.MeshObject_SetVertex(instance.Handle, nIndex, sCoordinates)
	return error
}

func (instance *Lib3MFMeshObject) AddVertex(sCoordinates sLib3MFPosition) (uint32, error) {
	nNewIndex, error := instance.Interface.MeshObject_AddVertex(instance.Handle, sCoordinates)
	return nNewIndex, error
}

func (instance *Lib3MFMeshObject) GetVertices() ([]sLib3MFPosition, error) {
	arrayVertices, error := instance.Interface.MeshObject_GetVertices(instance.Handle)
	return arrayVertices, error
}

func (instance *Lib3MFMeshObject) GetTriangle(nIndex uint32) (sLib3MFTriangle, error) {
	sIndices, error := instance.Interface.MeshObject_GetTriangle(instance.Handle, nIndex)
	return sIndices, error
}

func (instance *Lib3MFMeshObject) SetTriangle(nIndex uint32, sIndices sLib3MFTriangle) (error) {
	error := instance.Interface.MeshObject_SetTriangle(instance.Handle, nIndex, sIndices)
	return error
}

func (instance *Lib3MFMeshObject) AddTriangle(sIndices sLib3MFTriangle) (uint32, error) {
	nNewIndex, error := instance.Interface.MeshObject_AddTriangle(instance.Handle, sIndices)
	return nNewIndex, error
}

func (instance *Lib3MFMeshObject) GetTriangleIndices() ([]sLib3MFTriangle, error) {
	arrayIndices, error := instance.Interface.MeshObject_GetTriangleIndices(instance.Handle)
	return arrayIndices, error
}

func (instance *Lib3MFMeshObject) SetObjectLevelProperty(nUniqueResourceID uint32, nPropertyID uint32) (error) {
	error := instance.Interface.MeshObject_SetObjectLevelProperty(instance.Handle, nUniqueResourceID, nPropertyID)
	return error
}

func (instance *Lib3MFMeshObject) GetObjectLevelProperty() (uint32, uint32, bool, error) {
	nUniqueResourceID, nPropertyID, bHasObjectLevelProperty, error := instance.Interface.MeshObject_GetObjectLevelProperty(instance.Handle)
	return nUniqueResourceID, nPropertyID, bHasObjectLevelProperty, error
}

func (instance *Lib3MFMeshObject) SetTriangleProperties(nIndex uint32, sProperties sLib3MFTriangleProperties) (error) {
	error := instance.Interface.MeshObject_SetTriangleProperties(instance.Handle, nIndex, sProperties)
	return error
}

func (instance *Lib3MFMeshObject) GetTriangleProperties(nIndex uint32) (sLib3MFTriangleProperties, error) {
	sProperty, error := instance.Interface.MeshObject_GetTriangleProperties(instance.Handle, nIndex)
	return sProperty, error
}

func (instance *Lib3MFMeshObject) SetAllTriangleProperties(PropertiesArray []sLib3MFTriangleProperties) (error) {
	error := instance.Interface.MeshObject_SetAllTriangleProperties(instance.Handle, PropertiesArray)
	return error
}

func (instance *Lib3MFMeshObject) GetAllTriangleProperties() ([]sLib3MFTriangleProperties, error) {
	arrayPropertiesArray, error := instance.Interface.MeshObject_GetAllTriangleProperties(instance.Handle)
	return arrayPropertiesArray, error
}

func (instance *Lib3MFMeshObject) ClearAllProperties() (error) {
	error := instance.Interface.MeshObject_ClearAllProperties(instance.Handle)
	return error
}

func (instance *Lib3MFMeshObject) SetGeometry(Vertices []sLib3MFPosition, Indices []sLib3MFTriangle) (error) {
	error := instance.Interface.MeshObject_SetGeometry(instance.Handle, Vertices, Indices)
	return error
}

func (instance *Lib3MFMeshObject) IsManifoldAndOriented() (bool, error) {
	bIsManifoldAndOriented, error := instance.Interface.MeshObject_IsManifoldAndOriented(instance.Handle)
	return bIsManifoldAndOriented, error
}

func (instance *Lib3MFMeshObject) BeamLattice() (Lib3MFBeamLattice, error) {
	hTheBeamLattice, error := instance.Interface.MeshObject_BeamLattice(instance.Handle)
	var cTheBeamLattice Lib3MFBeamLattice
	cTheBeamLattice.Interface = instance.Interface
	cTheBeamLattice.Handle = hTheBeamLattice
	return cTheBeamLattice, error
}


/*************************************************************************************************************************
Class definition Lib3MFBeamLattice
**************************************************************************************************************************/

type Lib3MFBeamLattice struct {
	Lib3MFBase
}

func (instance *Lib3MFBeamLattice) Close() (error) {
	return instance.Handle.Close()
}

func (instance *Lib3MFBeamLattice) GetMinLength() (float64, error) {
	dMinLength, error := instance.Interface.BeamLattice_GetMinLength(instance.Handle)
	return dMinLength, error
}

func (instance *Lib3MFBeamLattice) SetMinLength(dMinLength float64) (error) {
	error := instance.Interface.BeamLattice_SetMinLength(instance.Handle, dMinLength)
	return error
}

func (instance *Lib3MFBeamLattice) GetClipping() (ELib3MFBeamLatticeClipMode, uint32, error) {
	eClipMode, nUniqueResourceID, error := instance.Interface.BeamLattice_GetClipping(instance.Handle)
	return eClipMode, nUniqueResourceID, error
}

func (instance *Lib3MFBeamLattice) SetClipping(eClipMode ELib3MFBeamLatticeClipMode, nUniqueResourceID uint32) (error) {
	error := instance.Interface.BeamLattice_SetClipping(instance.Handle, eClipMode, nUniqueResourceID)
	return error
}

func (instance *Lib3MFBeamLattice) GetRepresentation() (bool, uint32, error) {
	bHasRepresentation, nUniqueResourceID, error := instance.Interface.BeamLattice_GetRepresentation(instance.Handle)
	return bHasRepresentation, nUniqueResourceID, error
}

func (instance *Lib3MFBeamLattice) SetRepresentation(nUniqueResourceID uint32) (error) {
	error := instance.Interface.BeamLattice_SetRepresentation(instance.Handle, nUniqueResourceID)
	return error
}

func (instance *Lib3MFBeamLattice) GetBallOptions() (ELib3MFBeamLatticeBallMode, float64, error) {
	eBallMode, dBallRadius, error := instance.Interface.BeamLattice_GetBallOptions(instance.Handle)
	return eBallMode, dBallRadius, error
}

func (instance *Lib3MFBeamLattice) SetBallOptions(eBallMode ELib3MFBeamLatticeBallMode, dBallRadius float64) (error) {
	error := instance.Interface.BeamLattice_SetBallOptions(instance.Handle, eBallMode, dBallRadius)
	return error
}

func (instance *Lib3MFBeamLattice) GetBeamCount() (uint32, error) {
	nCount, error := instance.Interface.BeamLattice_GetBeamCount(instance.Handle)
	return nCount, error
}

func (instance *Lib3MFBeamLattice) GetBeam(nIndex uint32) (sLib3MFBeam, error) {
	sBeamInfo, error := instance.Interface.BeamLattice_GetBeam(instance.Handle, nIndex)
	return sBeamInfo, error
}

func (instance *Lib3MFBeamLattice) AddBeam(sBeamInfo sLib3MFBeam) (uint32, error) {
	nIndex, error := instance.Interface.BeamLattice_AddBeam(instance.Handle, sBeamInfo)
	return nIndex, error
}

func (instance *Lib3MFBeamLattice) SetBeam(nIndex uint32, sBeamInfo sLib3MFBeam) (error) {
	error := instance.Interface.BeamLattice_SetBeam(instance.Handle, nIndex, sBeamInfo)
	return error
}

func (instance *Lib3MFBeamLattice) SetBeams(BeamInfo []sLib3MFBeam) (error) {
	error := instance.Interface.BeamLattice_SetBeams(instance.Handle, BeamInfo)
	return error
}

func (instance *Lib3MFBeamLattice) GetBeams() ([]sLib3MFBeam, error) {
	arrayBeamInfo, error := instance.Interface.BeamLattice_GetBeams(instance.Handle)
	return arrayBeamInfo, error
}

func (instance *Lib3MFBeamLattice) GetBallCount() (uint32, error) {
	nCount, error := instance.Interface.BeamLattice_GetBallCount(instance.Handle)
	return nCount, error
}

func (instance *Lib3MFBeamLattice) GetBall(nIndex uint32) (sLib3MFBall, error) {
	sBallInfo, error := instance.Interface.BeamLattice_GetBall(instance.Handle, nIndex)
	return sBallInfo, error
}

func (instance *Lib3MFBeamLattice) AddBall(sBallInfo sLib3MFBall) (uint32, error) {
	nIndex, error := instance.Interface.BeamLattice_AddBall(instance.Handle, sBallInfo)
	return nIndex, error
}

func (instance *Lib3MFBeamLattice) SetBall(nIndex uint32, sBallInfo sLib3MFBall) (error) {
	error := instance.Interface.BeamLattice_SetBall(instance.Handle, nIndex, sBallInfo)
	return error
}

func (instance *Lib3MFBeamLattice) SetBalls(BallInfo []sLib3MFBall) (error) {
	error := instance.Interface.BeamLattice_SetBalls(instance.Handle, BallInfo)
	return error
}

func (instance *Lib3MFBeamLattice) GetBalls() ([]sLib3MFBall, error) {
	arrayBallInfo, error := instance.Interface.BeamLattice_GetBalls(instance.Handle)
	return arrayBallInfo, error
}

func (instance *Lib3MFBeamLattice) GetBeamSetCount() (uint32, error) {
	nCount, error := instance.Interface.BeamLattice_GetBeamSetCount(instance.Handle)
	return nCount, error
}

func (instance *Lib3MFBeamLattice) AddBeamSet() (Lib3MFBeamSet, error) {
	hBeamSet, error := instance.Interface.BeamLattice_AddBeamSet(instance.Handle)
	var cBeamSet Lib3MFBeamSet
	cBeamSet.Interface = instance.Interface
	cBeamSet.Handle = hBeamSet
	return cBeamSet, error
}

func (instance *Lib3MFBeamLattice) GetBeamSet(nIndex uint32) (Lib3MFBeamSet, error) {
	hBeamSet, error := instance.Interface.BeamLattice_GetBeamSet(instance.Handle, nIndex)
	var cBeamSet Lib3MFBeamSet
	cBeamSet.Interface = instance.Interface
	cBeamSet.Handle = hBeamSet
	return cBeamSet, error
}


/*************************************************************************************************************************
Class definition Lib3MFComponent
**************************************************************************************************************************/

type Lib3MFComponent struct {
	Lib3MFBase
}

func (instance *Lib3MFComponent) Close() (error) {
	return instance.Handle.Close()
}

func (instance *Lib3MFComponent) GetObjectResource() (Lib3MFObject, error) {
	hObjectResource, error := instance.Interface.Component_GetObjectResource(instance.Handle)
	var cObjectResource Lib3MFObject
	cObjectResource.Interface = instance.Interface
	cObjectResource.Handle = hObjectResource
	return cObjectResource, error
}

func (instance *Lib3MFComponent) GetObjectResourceID() (uint32, error) {
	nUniqueResourceID, error := instance.Interface.Component_GetObjectResourceID(instance.Handle)
	return nUniqueResourceID, error
}

func (instance *Lib3MFComponent) GetUUID() (bool, string, error) {
	bHasUUID, sUUID, error := instance.Interface.Component_GetUUID(instance.Handle)
	return bHasUUID, sUUID, error
}

func (instance *Lib3MFComponent) SetUUID(sUUID string) (error) {
	error := instance.Interface.Component_SetUUID(instance.Handle, sUUID)
	return error
}

func (instance *Lib3MFComponent) HasTransform() (bool, error) {
	bHasTransform, error := instance.Interface.Component_HasTransform(instance.Handle)
	return bHasTransform, error
}

func (instance *Lib3MFComponent) GetTransform() (sLib3MFTransform, error) {
	sTransform, error := instance.Interface.Component_GetTransform(instance.Handle)
	return sTransform, error
}

func (instance *Lib3MFComponent) SetTransform(sTransform sLib3MFTransform) (error) {
	error := instance.Interface.Component_SetTransform(instance.Handle, sTransform)
	return error
}


/*************************************************************************************************************************
Class definition Lib3MFComponentsObject
**************************************************************************************************************************/

type Lib3MFComponentsObject struct {
	Lib3MFObject
}

func (instance *Lib3MFComponentsObject) Close() (error) {
	return instance.Handle.Close()
}

func (instance *Lib3MFComponentsObject) AddComponent(ObjectResource Lib3MFHandle, sTransform sLib3MFTransform) (Lib3MFComponent, error) {
	hComponentInstance, error := instance.Interface.ComponentsObject_AddComponent(instance.Handle, ObjectResource, sTransform)
	var cComponentInstance Lib3MFComponent
	cComponentInstance.Interface = instance.Interface
	cComponentInstance.Handle = hComponentInstance
	return cComponentInstance, error
}

func (instance *Lib3MFComponentsObject) GetComponent(nIndex uint32) (Lib3MFComponent, error) {
	hComponentInstance, error := instance.Interface.ComponentsObject_GetComponent(instance.Handle, nIndex)
	var cComponentInstance Lib3MFComponent
	cComponentInstance.Interface = instance.Interface
	cComponentInstance.Handle = hComponentInstance
	return cComponentInstance, error
}

func (instance *Lib3MFComponentsObject) GetComponentCount() (uint32, error) {
	nCount, error := instance.Interface.ComponentsObject_GetComponentCount(instance.Handle)
	return nCount, error
}


/*************************************************************************************************************************
Class definition Lib3MFBeamSet
**************************************************************************************************************************/

type Lib3MFBeamSet struct {
	Lib3MFBase
}

func (instance *Lib3MFBeamSet) Close() (error) {
	return instance.Handle.Close()
}

func (instance *Lib3MFBeamSet) SetName(sName string) (error) {
	error := instance.Interface.BeamSet_SetName(instance.Handle, sName)
	return error
}

func (instance *Lib3MFBeamSet) GetName() (string, error) {
	sName, error := instance.Interface.BeamSet_GetName(instance.Handle)
	return sName, error
}

func (instance *Lib3MFBeamSet) SetIdentifier(sIdentifier string) (error) {
	error := instance.Interface.BeamSet_SetIdentifier(instance.Handle, sIdentifier)
	return error
}

func (instance *Lib3MFBeamSet) GetIdentifier() (string, error) {
	sIdentifier, error := instance.Interface.BeamSet_GetIdentifier(instance.Handle)
	return sIdentifier, error
}

func (instance *Lib3MFBeamSet) GetReferenceCount() (uint32, error) {
	nCount, error := instance.Interface.BeamSet_GetReferenceCount(instance.Handle)
	return nCount, error
}

func (instance *Lib3MFBeamSet) SetReferences(References []uint32) (error) {
	error := instance.Interface.BeamSet_SetReferences(instance.Handle, References)
	return error
}

func (instance *Lib3MFBeamSet) GetReferences() ([]uint32, error) {
	bufferReferences, error := instance.Interface.BeamSet_GetReferences(instance.Handle)
	return bufferReferences, error
}

func (instance *Lib3MFBeamSet) GetBallReferenceCount() (uint32, error) {
	nCount, error := instance.Interface.BeamSet_GetBallReferenceCount(instance.Handle)
	return nCount, error
}

func (instance *Lib3MFBeamSet) SetBallReferences(BallReferences []uint32) (error) {
	error := instance.Interface.BeamSet_SetBallReferences(instance.Handle, BallReferences)
	return error
}

func (instance *Lib3MFBeamSet) GetBallReferences() ([]uint32, error) {
	bufferBallReferences, error := instance.Interface.BeamSet_GetBallReferences(instance.Handle)
	return bufferBallReferences, error
}


/*************************************************************************************************************************
Class definition Lib3MFBaseMaterialGroup
**************************************************************************************************************************/

type Lib3MFBaseMaterialGroup struct {
	Lib3MFResource
}

func (instance *Lib3MFBaseMaterialGroup) Close() (error) {
	return instance.Handle.Close()
}

func (instance *Lib3MFBaseMaterialGroup) GetCount() (uint32, error) {
	nCount, error := instance.Interface.BaseMaterialGroup_GetCount(instance.Handle)
	return nCount, error
}

func (instance *Lib3MFBaseMaterialGroup) GetAllPropertyIDs() ([]uint32, error) {
	bufferPropertyIDs, error := instance.Interface.BaseMaterialGroup_GetAllPropertyIDs(instance.Handle)
	return bufferPropertyIDs, error
}

func (instance *Lib3MFBaseMaterialGroup) AddMaterial(sName string, sDisplayColor sLib3MFColor) (uint32, error) {
	nPropertyID, error := instance.Interface.BaseMaterialGroup_AddMaterial(instance.Handle, sName, sDisplayColor)
	return nPropertyID, error
}

func (instance *Lib3MFBaseMaterialGroup) RemoveMaterial(nPropertyID uint32) (error) {
	error := instance.Interface.BaseMaterialGroup_RemoveMaterial(instance.Handle, nPropertyID)
	return error
}

func (instance *Lib3MFBaseMaterialGroup) GetName(nPropertyID uint32) (string, error) {
	sName, error := instance.Interface.BaseMaterialGroup_GetName(instance.Handle, nPropertyID)
	return sName, error
}

func (instance *Lib3MFBaseMaterialGroup) SetName(nPropertyID uint32, sName string) (error) {
	error := instance.Interface.BaseMaterialGroup_SetName(instance.Handle, nPropertyID, sName)
	return error
}

func (instance *Lib3MFBaseMaterialGroup) SetDisplayColor(nPropertyID uint32, sTheColor sLib3MFColor) (error) {
	error := instance.Interface.BaseMaterialGroup_SetDisplayColor(instance.Handle, nPropertyID, sTheColor)
	return error
}

func (instance *Lib3MFBaseMaterialGroup) GetDisplayColor(nPropertyID uint32) (sLib3MFColor, error) {
	sTheColor, error := instance.Interface.BaseMaterialGroup_GetDisplayColor(instance.Handle, nPropertyID)
	return sTheColor, error
}


/*************************************************************************************************************************
Class definition Lib3MFColorGroup
**************************************************************************************************************************/

type Lib3MFColorGroup struct {
	Lib3MFResource
}

func (instance *Lib3MFColorGroup) Close() (error) {
	return instance.Handle.Close()
}

func (instance *Lib3MFColorGroup) GetCount() (uint32, error) {
	nCount, error := instance.Interface.ColorGroup_GetCount(instance.Handle)
	return nCount, error
}

func (instance *Lib3MFColorGroup) GetAllPropertyIDs() ([]uint32, error) {
	bufferPropertyIDs, error := instance.Interface.ColorGroup_GetAllPropertyIDs(instance.Handle)
	return bufferPropertyIDs, error
}

func (instance *Lib3MFColorGroup) AddColor(sTheColor sLib3MFColor) (uint32, error) {
	nPropertyID, error := instance.Interface.ColorGroup_AddColor(instance.Handle, sTheColor)
	return nPropertyID, error
}

func (instance *Lib3MFColorGroup) RemoveColor(nPropertyID uint32) (error) {
	error := instance.Interface.ColorGroup_RemoveColor(instance.Handle, nPropertyID)
	return error
}

func (instance *Lib3MFColorGroup) SetColor(nPropertyID uint32, sTheColor sLib3MFColor) (error) {
	error := instance.Interface.ColorGroup_SetColor(instance.Handle, nPropertyID, sTheColor)
	return error
}

func (instance *Lib3MFColorGroup) GetColor(nPropertyID uint32) (sLib3MFColor, error) {
	sTheColor, error := instance.Interface.ColorGroup_GetColor(instance.Handle, nPropertyID)
	return sTheColor, error
}


/*************************************************************************************************************************
Class definition Lib3MFTexture2DGroup
**************************************************************************************************************************/

type Lib3MFTexture2DGroup struct {
	Lib3MFResource
}

func (instance *Lib3MFTexture2DGroup) Close() (error) {
	return instance.Handle.Close()
}

func (instance *Lib3MFTexture2DGroup) GetCount() (uint32, error) {
	nCount, error := instance.Interface.Texture2DGroup_GetCount(instance.Handle)
	return nCount, error
}

func (instance *Lib3MFTexture2DGroup) GetAllPropertyIDs() ([]uint32, error) {
	bufferPropertyIDs, error := instance.Interface.Texture2DGroup_GetAllPropertyIDs(instance.Handle)
	return bufferPropertyIDs, error
}

func (instance *Lib3MFTexture2DGroup) AddTex2Coord(sUVCoordinate sLib3MFTex2Coord) (uint32, error) {
	nPropertyID, error := instance.Interface.Texture2DGroup_AddTex2Coord(instance.Handle, sUVCoordinate)
	return nPropertyID, error
}

func (instance *Lib3MFTexture2DGroup) GetTex2Coord(nPropertyID uint32) (sLib3MFTex2Coord, error) {
	sUVCoordinate, error := instance.Interface.Texture2DGroup_GetTex2Coord(instance.Handle, nPropertyID)
	return sUVCoordinate, error
}

func (instance *Lib3MFTexture2DGroup) RemoveTex2Coord(nPropertyID uint32) (error) {
	error := instance.Interface.Texture2DGroup_RemoveTex2Coord(instance.Handle, nPropertyID)
	return error
}

func (instance *Lib3MFTexture2DGroup) GetTexture2D() (Lib3MFTexture2D, error) {
	hTexture2DInstance, error := instance.Interface.Texture2DGroup_GetTexture2D(instance.Handle)
	var cTexture2DInstance Lib3MFTexture2D
	cTexture2DInstance.Interface = instance.Interface
	cTexture2DInstance.Handle = hTexture2DInstance
	return cTexture2DInstance, error
}


/*************************************************************************************************************************
Class definition Lib3MFCompositeMaterials
**************************************************************************************************************************/

type Lib3MFCompositeMaterials struct {
	Lib3MFResource
}

func (instance *Lib3MFCompositeMaterials) Close() (error) {
	return instance.Handle.Close()
}

func (instance *Lib3MFCompositeMaterials) GetCount() (uint32, error) {
	nCount, error := instance.Interface.CompositeMaterials_GetCount(instance.Handle)
	return nCount, error
}

func (instance *Lib3MFCompositeMaterials) GetAllPropertyIDs() ([]uint32, error) {
	bufferPropertyIDs, error := instance.Interface.CompositeMaterials_GetAllPropertyIDs(instance.Handle)
	return bufferPropertyIDs, error
}

func (instance *Lib3MFCompositeMaterials) GetBaseMaterialGroup() (Lib3MFBaseMaterialGroup, error) {
	hBaseMaterialGroupInstance, error := instance.Interface.CompositeMaterials_GetBaseMaterialGroup(instance.Handle)
	var cBaseMaterialGroupInstance Lib3MFBaseMaterialGroup
	cBaseMaterialGroupInstance.Interface = instance.Interface
	cBaseMaterialGroupInstance.Handle = hBaseMaterialGroupInstance
	return cBaseMaterialGroupInstance, error
}

func (instance *Lib3MFCompositeMaterials) AddComposite(Composite []sLib3MFCompositeConstituent) (uint32, error) {
	nPropertyID, error := instance.Interface.CompositeMaterials_AddComposite(instance.Handle, Composite)
	return nPropertyID, error
}

func (instance *Lib3MFCompositeMaterials) RemoveComposite(nPropertyID uint32) (error) {
	error := instance.Interface.CompositeMaterials_RemoveComposite(instance.Handle, nPropertyID)
	return error
}

func (instance *Lib3MFCompositeMaterials) GetComposite(nPropertyID uint32) ([]sLib3MFCompositeConstituent, error) {
	arrayComposite, error := instance.Interface.CompositeMaterials_GetComposite(instance.Handle, nPropertyID)
	return arrayComposite, error
}


/*************************************************************************************************************************
Class definition Lib3MFMultiPropertyGroup
**************************************************************************************************************************/

type Lib3MFMultiPropertyGroup struct {
	Lib3MFResource
}

func (instance *Lib3MFMultiPropertyGroup) Close() (error) {
	return instance.Handle.Close()
}

func (instance *Lib3MFMultiPropertyGroup) GetCount() (uint32, error) {
	nCount, error := instance.Interface.MultiPropertyGroup_GetCount(instance.Handle)
	return nCount, error
}

func (instance *Lib3MFMultiPropertyGroup) GetAllPropertyIDs() ([]uint32, error) {
	bufferPropertyIDs, error := instance.Interface.MultiPropertyGroup_GetAllPropertyIDs(instance.Handle)
	return bufferPropertyIDs, error
}

func (instance *Lib3MFMultiPropertyGroup) AddMultiProperty(PropertyIDs []uint32) (uint32, error) {
	nPropertyID, error := instance.Interface.MultiPropertyGroup_AddMultiProperty(instance.Handle, PropertyIDs)
	return nPropertyID, error
}

func (instance *Lib3MFMultiPropertyGroup) SetMultiProperty(nPropertyID uint32, PropertyIDs []uint32) (error) {
	error := instance.Interface.MultiPropertyGroup_SetMultiProperty(instance.Handle, nPropertyID, PropertyIDs)
	return error
}

func (instance *Lib3MFMultiPropertyGroup) GetMultiProperty(nPropertyID uint32) ([]uint32, error) {
	bufferPropertyIDs, error := instance.Interface.MultiPropertyGroup_GetMultiProperty(instance.Handle, nPropertyID)
	return bufferPropertyIDs, error
}

func (instance *Lib3MFMultiPropertyGroup) RemoveMultiProperty(nPropertyID uint32) (error) {
	error := instance.Interface.MultiPropertyGroup_RemoveMultiProperty(instance.Handle, nPropertyID)
	return error
}

func (instance *Lib3MFMultiPropertyGroup) GetLayerCount() (uint32, error) {
	nCount, error := instance.Interface.MultiPropertyGroup_GetLayerCount(instance.Handle)
	return nCount, error
}

func (instance *Lib3MFMultiPropertyGroup) AddLayer(sTheLayer sLib3MFMultiPropertyLayer) (uint32, error) {
	nLayerIndex, error := instance.Interface.MultiPropertyGroup_AddLayer(instance.Handle, sTheLayer)
	return nLayerIndex, error
}

func (instance *Lib3MFMultiPropertyGroup) GetLayer(nLayerIndex uint32) (sLib3MFMultiPropertyLayer, error) {
	sTheLayer, error := instance.Interface.MultiPropertyGroup_GetLayer(instance.Handle, nLayerIndex)
	return sTheLayer, error
}

func (instance *Lib3MFMultiPropertyGroup) RemoveLayer(nLayerIndex uint32) (error) {
	error := instance.Interface.MultiPropertyGroup_RemoveLayer(instance.Handle, nLayerIndex)
	return error
}


/*************************************************************************************************************************
Class definition Lib3MFAttachment
**************************************************************************************************************************/

type Lib3MFAttachment struct {
	Lib3MFBase
}

func (instance *Lib3MFAttachment) Close() (error) {
	return instance.Handle.Close()
}

func (instance *Lib3MFAttachment) GetPath() (string, error) {
	sPath, error := instance.Interface.Attachment_GetPath(instance.Handle)
	return sPath, error
}

func (instance *Lib3MFAttachment) SetPath(sPath string) (error) {
	error := instance.Interface.Attachment_SetPath(instance.Handle, sPath)
	return error
}

func (instance *Lib3MFAttachment) PackagePart() (Lib3MFPackagePart, error) {
	hPackagePart, error := instance.Interface.Attachment_PackagePart(instance.Handle)
	var cPackagePart Lib3MFPackagePart
	cPackagePart.Interface = instance.Interface
	cPackagePart.Handle = hPackagePart
	return cPackagePart, error
}

func (instance *Lib3MFAttachment) GetRelationShipType() (string, error) {
	sPath, error := instance.Interface.Attachment_GetRelationShipType(instance.Handle)
	return sPath, error
}

func (instance *Lib3MFAttachment) SetRelationShipType(sPath string) (error) {
	error := instance.Interface.Attachment_SetRelationShipType(instance.Handle, sPath)
	return error
}

func (instance *Lib3MFAttachment) WriteToFile(sFileName string) (error) {
	error := instance.Interface.Attachment_WriteToFile(instance.Handle, sFileName)
	return error
}

func (instance *Lib3MFAttachment) ReadFromFile(sFileName string) (error) {
	error := instance.Interface.Attachment_ReadFromFile(instance.Handle, sFileName)
	return error
}

func (instance *Lib3MFAttachment) GetStreamSize() (uint64, error) {
	nStreamSize, error := instance.Interface.Attachment_GetStreamSize(instance.Handle)
	return nStreamSize, error
}

func (instance *Lib3MFAttachment) WriteToBuffer() ([]uint8, error) {
	bufferBuffer, error := instance.Interface.Attachment_WriteToBuffer(instance.Handle)
	return bufferBuffer, error
}

func (instance *Lib3MFAttachment) ReadFromBuffer(Buffer []uint8) (error) {
	error := instance.Interface.Attachment_ReadFromBuffer(instance.Handle, Buffer)
	return error
}


/*************************************************************************************************************************
Class definition Lib3MFTexture2D
**************************************************************************************************************************/

type Lib3MFTexture2D struct {
	Lib3MFResource
}

func (instance *Lib3MFTexture2D) Close() (error) {
	return instance.Handle.Close()
}

func (instance *Lib3MFTexture2D) GetAttachment() (Lib3MFAttachment, error) {
	hAttachment, error := instance.Interface.Texture2D_GetAttachment(instance.Handle)
	var cAttachment Lib3MFAttachment
	cAttachment.Interface = instance.Interface
	cAttachment.Handle = hAttachment
	return cAttachment, error
}

func (instance *Lib3MFTexture2D) SetAttachment(Attachment Lib3MFHandle) (error) {
	error := instance.Interface.Texture2D_SetAttachment(instance.Handle, Attachment)
	return error
}

func (instance *Lib3MFTexture2D) GetContentType() (ELib3MFTextureType, error) {
	eContentType, error := instance.Interface.Texture2D_GetContentType(instance.Handle)
	return eContentType, error
}

func (instance *Lib3MFTexture2D) SetContentType(eContentType ELib3MFTextureType) (error) {
	error := instance.Interface.Texture2D_SetContentType(instance.Handle, eContentType)
	return error
}

func (instance *Lib3MFTexture2D) GetTileStyleUV() (ELib3MFTextureTileStyle, ELib3MFTextureTileStyle, error) {
	eTileStyleU, eTileStyleV, error := instance.Interface.Texture2D_GetTileStyleUV(instance.Handle)
	return eTileStyleU, eTileStyleV, error
}

func (instance *Lib3MFTexture2D) SetTileStyleUV(eTileStyleU ELib3MFTextureTileStyle, eTileStyleV ELib3MFTextureTileStyle) (error) {
	error := instance.Interface.Texture2D_SetTileStyleUV(instance.Handle, eTileStyleU, eTileStyleV)
	return error
}

func (instance *Lib3MFTexture2D) GetFilter() (ELib3MFTextureFilter, error) {
	eFilter, error := instance.Interface.Texture2D_GetFilter(instance.Handle)
	return eFilter, error
}

func (instance *Lib3MFTexture2D) SetFilter(eFilter ELib3MFTextureFilter) (error) {
	error := instance.Interface.Texture2D_SetFilter(instance.Handle, eFilter)
	return error
}


/*************************************************************************************************************************
Class definition Lib3MFBuildItem
**************************************************************************************************************************/

type Lib3MFBuildItem struct {
	Lib3MFBase
}

func (instance *Lib3MFBuildItem) Close() (error) {
	return instance.Handle.Close()
}

func (instance *Lib3MFBuildItem) GetObjectResource() (Lib3MFObject, error) {
	hObjectResource, error := instance.Interface.BuildItem_GetObjectResource(instance.Handle)
	var cObjectResource Lib3MFObject
	cObjectResource.Interface = instance.Interface
	cObjectResource.Handle = hObjectResource
	return cObjectResource, error
}

func (instance *Lib3MFBuildItem) GetUUID() (bool, string, error) {
	bHasUUID, sUUID, error := instance.Interface.BuildItem_GetUUID(instance.Handle)
	return bHasUUID, sUUID, error
}

func (instance *Lib3MFBuildItem) SetUUID(sUUID string) (error) {
	error := instance.Interface.BuildItem_SetUUID(instance.Handle, sUUID)
	return error
}

func (instance *Lib3MFBuildItem) GetObjectResourceID() (uint32, error) {
	nUniqueResourceID, error := instance.Interface.BuildItem_GetObjectResourceID(instance.Handle)
	return nUniqueResourceID, error
}

func (instance *Lib3MFBuildItem) HasObjectTransform() (bool, error) {
	bHasTransform, error := instance.Interface.BuildItem_HasObjectTransform(instance.Handle)
	return bHasTransform, error
}

func (instance *Lib3MFBuildItem) GetObjectTransform() (sLib3MFTransform, error) {
	sTransform, error := instance.Interface.BuildItem_GetObjectTransform(instance.Handle)
	return sTransform, error
}

func (instance *Lib3MFBuildItem) SetObjectTransform(sTransform sLib3MFTransform) (error) {
	error := instance.Interface.BuildItem_SetObjectTransform(instance.Handle, sTransform)
	return error
}

func (instance *Lib3MFBuildItem) GetPartNumber() (string, error) {
	sPartNumber, error := instance.Interface.BuildItem_GetPartNumber(instance.Handle)
	return sPartNumber, error
}

func (instance *Lib3MFBuildItem) SetPartNumber(sSetPartnumber string) (error) {
	error := instance.Interface.BuildItem_SetPartNumber(instance.Handle, sSetPartnumber)
	return error
}

func (instance *Lib3MFBuildItem) GetMetaDataGroup() (Lib3MFMetaDataGroup, error) {
	hMetaDataGroup, error := instance.Interface.BuildItem_GetMetaDataGroup(instance.Handle)
	var cMetaDataGroup Lib3MFMetaDataGroup
	cMetaDataGroup.Interface = instance.Interface
	cMetaDataGroup.Handle = hMetaDataGroup
	return cMetaDataGroup, error
}

func (instance *Lib3MFBuildItem) GetOutbox() (sLib3MFBox, error) {
	sOutbox, error := instance.Interface.BuildItem_GetOutbox(instance.Handle)
	return sOutbox, error
}


/*************************************************************************************************************************
Class definition Lib3MFBuildItemIterator
**************************************************************************************************************************/

type Lib3MFBuildItemIterator struct {
	Lib3MFBase
}

func (instance *Lib3MFBuildItemIterator) Close() (error) {
	return instance.Handle.Close()
}

func (instance *Lib3MFBuildItemIterator) MoveNext() (bool, error) {
	bHasNext, error := instance.Interface.BuildItemIterator_MoveNext(instance.Handle)
	return bHasNext, error
}

func (instance *Lib3MFBuildItemIterator) MovePrevious() (bool, error) {
	bHasPrevious, error := instance.Interface.BuildItemIterator_MovePrevious(instance.Handle)
	return bHasPrevious, error
}

func (instance *Lib3MFBuildItemIterator) GetCurrent() (Lib3MFBuildItem, error) {
	hBuildItem, error := instance.Interface.BuildItemIterator_GetCurrent(instance.Handle)
	var cBuildItem Lib3MFBuildItem
	cBuildItem.Interface = instance.Interface
	cBuildItem.Handle = hBuildItem
	return cBuildItem, error
}

func (instance *Lib3MFBuildItemIterator) Clone() (Lib3MFBuildItemIterator, error) {
	hOutBuildItemIterator, error := instance.Interface.BuildItemIterator_Clone(instance.Handle)
	var cOutBuildItemIterator Lib3MFBuildItemIterator
	cOutBuildItemIterator.Interface = instance.Interface
	cOutBuildItemIterator.Handle = hOutBuildItemIterator
	return cOutBuildItemIterator, error
}

func (instance *Lib3MFBuildItemIterator) Count() (uint64, error) {
	nCount, error := instance.Interface.BuildItemIterator_Count(instance.Handle)
	return nCount, error
}


/*************************************************************************************************************************
Class definition Lib3MFSlice
**************************************************************************************************************************/

type Lib3MFSlice struct {
	Lib3MFBase
}

func (instance *Lib3MFSlice) Close() (error) {
	return instance.Handle.Close()
}

func (instance *Lib3MFSlice) SetVertices(Vertices []sLib3MFPosition2D) (error) {
	error := instance.Interface.Slice_SetVertices(instance.Handle, Vertices)
	return error
}

func (instance *Lib3MFSlice) GetVertices() ([]sLib3MFPosition2D, error) {
	arrayVertices, error := instance.Interface.Slice_GetVertices(instance.Handle)
	return arrayVertices, error
}

func (instance *Lib3MFSlice) GetVertexCount() (uint64, error) {
	nCount, error := instance.Interface.Slice_GetVertexCount(instance.Handle)
	return nCount, error
}

func (instance *Lib3MFSlice) AddPolygon(Indices []uint32) (uint64, error) {
	nIndex, error := instance.Interface.Slice_AddPolygon(instance.Handle, Indices)
	return nIndex, error
}

func (instance *Lib3MFSlice) GetPolygonCount() (uint64, error) {
	nCount, error := instance.Interface.Slice_GetPolygonCount(instance.Handle)
	return nCount, error
}

func (instance *Lib3MFSlice) SetPolygonIndices(nIndex uint64, Indices []uint32) (error) {
	error := instance.Interface.Slice_SetPolygonIndices(instance.Handle, nIndex, Indices)
	return error
}

func (instance *Lib3MFSlice) GetPolygonIndices(nIndex uint64) ([]uint32, error) {
	bufferIndices, error := instance.Interface.Slice_GetPolygonIndices(instance.Handle, nIndex)
	return bufferIndices, error
}

func (instance *Lib3MFSlice) GetPolygonIndexCount(nIndex uint64) (uint64, error) {
	nCount, error := instance.Interface.Slice_GetPolygonIndexCount(instance.Handle, nIndex)
	return nCount, error
}

func (instance *Lib3MFSlice) GetZTop() (float64, error) {
	dZTop, error := instance.Interface.Slice_GetZTop(instance.Handle)
	return dZTop, error
}


/*************************************************************************************************************************
Class definition Lib3MFSliceStack
**************************************************************************************************************************/

type Lib3MFSliceStack struct {
	Lib3MFResource
}

func (instance *Lib3MFSliceStack) Close() (error) {
	return instance.Handle.Close()
}

func (instance *Lib3MFSliceStack) GetBottomZ() (float64, error) {
	dZBottom, error := instance.Interface.SliceStack_GetBottomZ(instance.Handle)
	return dZBottom, error
}

func (instance *Lib3MFSliceStack) GetSliceCount() (uint64, error) {
	nCount, error := instance.Interface.SliceStack_GetSliceCount(instance.Handle)
	return nCount, error
}

func (instance *Lib3MFSliceStack) GetSlice(nSliceIndex uint64) (Lib3MFSlice, error) {
	hTheSlice, error := instance.Interface.SliceStack_GetSlice(instance.Handle, nSliceIndex)
	var cTheSlice Lib3MFSlice
	cTheSlice.Interface = instance.Interface
	cTheSlice.Handle = hTheSlice
	return cTheSlice, error
}

func (instance *Lib3MFSliceStack) AddSlice(dZTop float64) (Lib3MFSlice, error) {
	hTheSlice, error := instance.Interface.SliceStack_AddSlice(instance.Handle, dZTop)
	var cTheSlice Lib3MFSlice
	cTheSlice.Interface = instance.Interface
	cTheSlice.Handle = hTheSlice
	return cTheSlice, error
}

func (instance *Lib3MFSliceStack) GetSliceRefCount() (uint64, error) {
	nCount, error := instance.Interface.SliceStack_GetSliceRefCount(instance.Handle)
	return nCount, error
}

func (instance *Lib3MFSliceStack) AddSliceStackReference(TheSliceStack Lib3MFHandle) (error) {
	error := instance.Interface.SliceStack_AddSliceStackReference(instance.Handle, TheSliceStack)
	return error
}

func (instance *Lib3MFSliceStack) GetSliceStackReference(nSliceRefIndex uint64) (Lib3MFSliceStack, error) {
	hTheSliceStack, error := instance.Interface.SliceStack_GetSliceStackReference(instance.Handle, nSliceRefIndex)
	var cTheSliceStack Lib3MFSliceStack
	cTheSliceStack.Interface = instance.Interface
	cTheSliceStack.Handle = hTheSliceStack
	return cTheSliceStack, error
}

func (instance *Lib3MFSliceStack) CollapseSliceReferences() (error) {
	error := instance.Interface.SliceStack_CollapseSliceReferences(instance.Handle)
	return error
}

func (instance *Lib3MFSliceStack) SetOwnPath(sPath string) (error) {
	error := instance.Interface.SliceStack_SetOwnPath(instance.Handle, sPath)
	return error
}

func (instance *Lib3MFSliceStack) GetOwnPath() (string, error) {
	sPath, error := instance.Interface.SliceStack_GetOwnPath(instance.Handle)
	return sPath, error
}


/*************************************************************************************************************************
Class definition Lib3MFConsumer
**************************************************************************************************************************/

type Lib3MFConsumer struct {
	Lib3MFBase
}

func (instance *Lib3MFConsumer) Close() (error) {
	return instance.Handle.Close()
}

func (instance *Lib3MFConsumer) GetConsumerID() (string, error) {
	sConsumerID, error := instance.Interface.Consumer_GetConsumerID(instance.Handle)
	return sConsumerID, error
}

func (instance *Lib3MFConsumer) GetKeyID() (string, error) {
	sKeyID, error := instance.Interface.Consumer_GetKeyID(instance.Handle)
	return sKeyID, error
}

func (instance *Lib3MFConsumer) GetKeyValue() (string, error) {
	sKeyValue, error := instance.Interface.Consumer_GetKeyValue(instance.Handle)
	return sKeyValue, error
}


/*************************************************************************************************************************
Class definition Lib3MFAccessRight
**************************************************************************************************************************/

type Lib3MFAccessRight struct {
	Lib3MFBase
}

func (instance *Lib3MFAccessRight) Close() (error) {
	return instance.Handle.Close()
}

func (instance *Lib3MFAccessRight) GetConsumer() (Lib3MFConsumer, error) {
	hConsumer, error := instance.Interface.AccessRight_GetConsumer(instance.Handle)
	var cConsumer Lib3MFConsumer
	cConsumer.Interface = instance.Interface
	cConsumer.Handle = hConsumer
	return cConsumer, error
}

func (instance *Lib3MFAccessRight) GetWrappingAlgorithm() (ELib3MFWrappingAlgorithm, error) {
	eAlgorithm, error := instance.Interface.AccessRight_GetWrappingAlgorithm(instance.Handle)
	return eAlgorithm, error
}

func (instance *Lib3MFAccessRight) GetMgfAlgorithm() (ELib3MFMgfAlgorithm, error) {
	eAlgorithm, error := instance.Interface.AccessRight_GetMgfAlgorithm(instance.Handle)
	return eAlgorithm, error
}

func (instance *Lib3MFAccessRight) GetDigestMethod() (ELib3MFDigestMethod, error) {
	eAlgorithm, error := instance.Interface.AccessRight_GetDigestMethod(instance.Handle)
	return eAlgorithm, error
}


/*************************************************************************************************************************
Class definition Lib3MFContentEncryptionParams
**************************************************************************************************************************/

type Lib3MFContentEncryptionParams struct {
	Lib3MFBase
}

func (instance *Lib3MFContentEncryptionParams) Close() (error) {
	return instance.Handle.Close()
}

func (instance *Lib3MFContentEncryptionParams) GetEncryptionAlgorithm() (ELib3MFEncryptionAlgorithm, error) {
	eAlgorithm, error := instance.Interface.ContentEncryptionParams_GetEncryptionAlgorithm(instance.Handle)
	return eAlgorithm, error
}

func (instance *Lib3MFContentEncryptionParams) GetKey() ([]uint8, error) {
	bufferByteData, error := instance.Interface.ContentEncryptionParams_GetKey(instance.Handle)
	return bufferByteData, error
}

func (instance *Lib3MFContentEncryptionParams) GetInitializationVector() ([]uint8, error) {
	bufferByteData, error := instance.Interface.ContentEncryptionParams_GetInitializationVector(instance.Handle)
	return bufferByteData, error
}

func (instance *Lib3MFContentEncryptionParams) GetAuthenticationTag() ([]uint8, error) {
	bufferByteData, error := instance.Interface.ContentEncryptionParams_GetAuthenticationTag(instance.Handle)
	return bufferByteData, error
}

func (instance *Lib3MFContentEncryptionParams) SetAuthenticationTag(ByteData []uint8) (error) {
	error := instance.Interface.ContentEncryptionParams_SetAuthenticationTag(instance.Handle, ByteData)
	return error
}

func (instance *Lib3MFContentEncryptionParams) GetAdditionalAuthenticationData() ([]uint8, error) {
	bufferByteData, error := instance.Interface.ContentEncryptionParams_GetAdditionalAuthenticationData(instance.Handle)
	return bufferByteData, error
}

func (instance *Lib3MFContentEncryptionParams) GetDescriptor() (uint64, error) {
	nDescriptor, error := instance.Interface.ContentEncryptionParams_GetDescriptor(instance.Handle)
	return nDescriptor, error
}

func (instance *Lib3MFContentEncryptionParams) GetKeyUUID() (string, error) {
	sUUID, error := instance.Interface.ContentEncryptionParams_GetKeyUUID(instance.Handle)
	return sUUID, error
}


/*************************************************************************************************************************
Class definition Lib3MFResourceData
**************************************************************************************************************************/

type Lib3MFResourceData struct {
	Lib3MFBase
}

func (instance *Lib3MFResourceData) Close() (error) {
	return instance.Handle.Close()
}

func (instance *Lib3MFResourceData) GetPath() (Lib3MFPackagePart, error) {
	hPath, error := instance.Interface.ResourceData_GetPath(instance.Handle)
	var cPath Lib3MFPackagePart
	cPath.Interface = instance.Interface
	cPath.Handle = hPath
	return cPath, error
}

func (instance *Lib3MFResourceData) GetEncryptionAlgorithm() (ELib3MFEncryptionAlgorithm, error) {
	eEncryptionAlgorithm, error := instance.Interface.ResourceData_GetEncryptionAlgorithm(instance.Handle)
	return eEncryptionAlgorithm, error
}

func (instance *Lib3MFResourceData) GetCompression() (ELib3MFCompression, error) {
	eCompression, error := instance.Interface.ResourceData_GetCompression(instance.Handle)
	return eCompression, error
}

func (instance *Lib3MFResourceData) GetAdditionalAuthenticationData() ([]uint8, error) {
	bufferByteData, error := instance.Interface.ResourceData_GetAdditionalAuthenticationData(instance.Handle)
	return bufferByteData, error
}


/*************************************************************************************************************************
Class definition Lib3MFResourceDataGroup
**************************************************************************************************************************/

type Lib3MFResourceDataGroup struct {
	Lib3MFBase
}

func (instance *Lib3MFResourceDataGroup) Close() (error) {
	return instance.Handle.Close()
}

func (instance *Lib3MFResourceDataGroup) GetKeyUUID() (string, error) {
	sUUID, error := instance.Interface.ResourceDataGroup_GetKeyUUID(instance.Handle)
	return sUUID, error
}

func (instance *Lib3MFResourceDataGroup) AddAccessRight(Consumer Lib3MFHandle, eWrappingAlgorithm ELib3MFWrappingAlgorithm, eMgfAlgorithm ELib3MFMgfAlgorithm, eDigestMethod ELib3MFDigestMethod) (Lib3MFAccessRight, error) {
	hTheAccessRight, error := instance.Interface.ResourceDataGroup_AddAccessRight(instance.Handle, Consumer, eWrappingAlgorithm, eMgfAlgorithm, eDigestMethod)
	var cTheAccessRight Lib3MFAccessRight
	cTheAccessRight.Interface = instance.Interface
	cTheAccessRight.Handle = hTheAccessRight
	return cTheAccessRight, error
}

func (instance *Lib3MFResourceDataGroup) FindAccessRightByConsumer(Consumer Lib3MFHandle) (Lib3MFAccessRight, error) {
	hTheAccessRight, error := instance.Interface.ResourceDataGroup_FindAccessRightByConsumer(instance.Handle, Consumer)
	var cTheAccessRight Lib3MFAccessRight
	cTheAccessRight.Interface = instance.Interface
	cTheAccessRight.Handle = hTheAccessRight
	return cTheAccessRight, error
}

func (instance *Lib3MFResourceDataGroup) RemoveAccessRight(Consumer Lib3MFHandle) (error) {
	error := instance.Interface.ResourceDataGroup_RemoveAccessRight(instance.Handle, Consumer)
	return error
}


/*************************************************************************************************************************
Class definition Lib3MFKeyStore
**************************************************************************************************************************/

type Lib3MFKeyStore struct {
	Lib3MFBase
}

func (instance *Lib3MFKeyStore) Close() (error) {
	return instance.Handle.Close()
}

func (instance *Lib3MFKeyStore) AddConsumer(sConsumerID string, sKeyID string, sKeyValue string) (Lib3MFConsumer, error) {
	hConsumer, error := instance.Interface.KeyStore_AddConsumer(instance.Handle, sConsumerID, sKeyID, sKeyValue)
	var cConsumer Lib3MFConsumer
	cConsumer.Interface = instance.Interface
	cConsumer.Handle = hConsumer
	return cConsumer, error
}

func (instance *Lib3MFKeyStore) GetConsumerCount() (uint64, error) {
	nCount, error := instance.Interface.KeyStore_GetConsumerCount(instance.Handle)
	return nCount, error
}

func (instance *Lib3MFKeyStore) GetConsumer(nConsumerIndex uint64) (Lib3MFConsumer, error) {
	hConsumer, error := instance.Interface.KeyStore_GetConsumer(instance.Handle, nConsumerIndex)
	var cConsumer Lib3MFConsumer
	cConsumer.Interface = instance.Interface
	cConsumer.Handle = hConsumer
	return cConsumer, error
}

func (instance *Lib3MFKeyStore) RemoveConsumer(Consumer Lib3MFHandle) (error) {
	error := instance.Interface.KeyStore_RemoveConsumer(instance.Handle, Consumer)
	return error
}

func (instance *Lib3MFKeyStore) FindConsumer(sConsumerID string) (Lib3MFConsumer, error) {
	hConsumer, error := instance.Interface.KeyStore_FindConsumer(instance.Handle, sConsumerID)
	var cConsumer Lib3MFConsumer
	cConsumer.Interface = instance.Interface
	cConsumer.Handle = hConsumer
	return cConsumer, error
}

func (instance *Lib3MFKeyStore) GetResourceDataGroupCount() (uint64, error) {
	nCount, error := instance.Interface.KeyStore_GetResourceDataGroupCount(instance.Handle)
	return nCount, error
}

func (instance *Lib3MFKeyStore) AddResourceDataGroup() (Lib3MFResourceDataGroup, error) {
	hResourceDataGroup, error := instance.Interface.KeyStore_AddResourceDataGroup(instance.Handle)
	var cResourceDataGroup Lib3MFResourceDataGroup
	cResourceDataGroup.Interface = instance.Interface
	cResourceDataGroup.Handle = hResourceDataGroup
	return cResourceDataGroup, error
}

func (instance *Lib3MFKeyStore) GetResourceDataGroup(nResourceDataIndex uint64) (Lib3MFResourceDataGroup, error) {
	hResourceDataGroup, error := instance.Interface.KeyStore_GetResourceDataGroup(instance.Handle, nResourceDataIndex)
	var cResourceDataGroup Lib3MFResourceDataGroup
	cResourceDataGroup.Interface = instance.Interface
	cResourceDataGroup.Handle = hResourceDataGroup
	return cResourceDataGroup, error
}

func (instance *Lib3MFKeyStore) RemoveResourceDataGroup(ResourceDataGroup Lib3MFHandle) (error) {
	error := instance.Interface.KeyStore_RemoveResourceDataGroup(instance.Handle, ResourceDataGroup)
	return error
}

func (instance *Lib3MFKeyStore) FindResourceDataGroup(PartPath Lib3MFHandle) (Lib3MFResourceDataGroup, error) {
	hResourceDataGroup, error := instance.Interface.KeyStore_FindResourceDataGroup(instance.Handle, PartPath)
	var cResourceDataGroup Lib3MFResourceDataGroup
	cResourceDataGroup.Interface = instance.Interface
	cResourceDataGroup.Handle = hResourceDataGroup
	return cResourceDataGroup, error
}

func (instance *Lib3MFKeyStore) AddResourceData(ResourceDataGroup Lib3MFHandle, PartPath Lib3MFHandle, eAlgorithm ELib3MFEncryptionAlgorithm, eCompression ELib3MFCompression, AdditionalAuthenticationData []uint8) (Lib3MFResourceData, error) {
	hResourceData, error := instance.Interface.KeyStore_AddResourceData(instance.Handle, ResourceDataGroup, PartPath, eAlgorithm, eCompression, AdditionalAuthenticationData)
	var cResourceData Lib3MFResourceData
	cResourceData.Interface = instance.Interface
	cResourceData.Handle = hResourceData
	return cResourceData, error
}

func (instance *Lib3MFKeyStore) RemoveResourceData(ResourceData Lib3MFHandle) (error) {
	error := instance.Interface.KeyStore_RemoveResourceData(instance.Handle, ResourceData)
	return error
}

func (instance *Lib3MFKeyStore) FindResourceData(ResourcePath Lib3MFHandle) (Lib3MFResourceData, error) {
	hResourceData, error := instance.Interface.KeyStore_FindResourceData(instance.Handle, ResourcePath)
	var cResourceData Lib3MFResourceData
	cResourceData.Interface = instance.Interface
	cResourceData.Handle = hResourceData
	return cResourceData, error
}

func (instance *Lib3MFKeyStore) GetResourceDataCount() (uint64, error) {
	nCount, error := instance.Interface.KeyStore_GetResourceDataCount(instance.Handle)
	return nCount, error
}

func (instance *Lib3MFKeyStore) GetResourceData(nResourceDataIndex uint64) (Lib3MFResourceData, error) {
	hResourceData, error := instance.Interface.KeyStore_GetResourceData(instance.Handle, nResourceDataIndex)
	var cResourceData Lib3MFResourceData
	cResourceData.Interface = instance.Interface
	cResourceData.Handle = hResourceData
	return cResourceData, error
}

func (instance *Lib3MFKeyStore) GetUUID() (bool, string, error) {
	bHasUUID, sUUID, error := instance.Interface.KeyStore_GetUUID(instance.Handle)
	return bHasUUID, sUUID, error
}

func (instance *Lib3MFKeyStore) SetUUID(sUUID string) (error) {
	error := instance.Interface.KeyStore_SetUUID(instance.Handle, sUUID)
	return error
}


/*************************************************************************************************************************
Class definition Lib3MFModel
**************************************************************************************************************************/

type Lib3MFModel struct {
	Lib3MFBase
}

func (instance *Lib3MFModel) Close() (error) {
	return instance.Handle.Close()
}

func (instance *Lib3MFModel) RootModelPart() (Lib3MFPackagePart, error) {
	hRootModelPart, error := instance.Interface.Model_RootModelPart(instance.Handle)
	var cRootModelPart Lib3MFPackagePart
	cRootModelPart.Interface = instance.Interface
	cRootModelPart.Handle = hRootModelPart
	return cRootModelPart, error
}

func (instance *Lib3MFModel) FindOrCreatePackagePart(sAbsolutePath string) (Lib3MFPackagePart, error) {
	hModelPart, error := instance.Interface.Model_FindOrCreatePackagePart(instance.Handle, sAbsolutePath)
	var cModelPart Lib3MFPackagePart
	cModelPart.Interface = instance.Interface
	cModelPart.Handle = hModelPart
	return cModelPart, error
}

func (instance *Lib3MFModel) SetUnit(eUnit ELib3MFModelUnit) (error) {
	error := instance.Interface.Model_SetUnit(instance.Handle, eUnit)
	return error
}

func (instance *Lib3MFModel) GetUnit() (ELib3MFModelUnit, error) {
	eUnit, error := instance.Interface.Model_GetUnit(instance.Handle)
	return eUnit, error
}

func (instance *Lib3MFModel) GetLanguage() (string, error) {
	sLanguage, error := instance.Interface.Model_GetLanguage(instance.Handle)
	return sLanguage, error
}

func (instance *Lib3MFModel) SetLanguage(sLanguage string) (error) {
	error := instance.Interface.Model_SetLanguage(instance.Handle, sLanguage)
	return error
}

func (instance *Lib3MFModel) QueryWriter(sWriterClass string) (Lib3MFWriter, error) {
	hWriterInstance, error := instance.Interface.Model_QueryWriter(instance.Handle, sWriterClass)
	var cWriterInstance Lib3MFWriter
	cWriterInstance.Interface = instance.Interface
	cWriterInstance.Handle = hWriterInstance
	return cWriterInstance, error
}

func (instance *Lib3MFModel) QueryReader(sReaderClass string) (Lib3MFReader, error) {
	hReaderInstance, error := instance.Interface.Model_QueryReader(instance.Handle, sReaderClass)
	var cReaderInstance Lib3MFReader
	cReaderInstance.Interface = instance.Interface
	cReaderInstance.Handle = hReaderInstance
	return cReaderInstance, error
}

func (instance *Lib3MFModel) GetTexture2DByID(nUniqueResourceID uint32) (Lib3MFTexture2D, error) {
	hTextureInstance, error := instance.Interface.Model_GetTexture2DByID(instance.Handle, nUniqueResourceID)
	var cTextureInstance Lib3MFTexture2D
	cTextureInstance.Interface = instance.Interface
	cTextureInstance.Handle = hTextureInstance
	return cTextureInstance, error
}

func (instance *Lib3MFModel) GetPropertyTypeByID(nUniqueResourceID uint32) (ELib3MFPropertyType, error) {
	eThePropertyType, error := instance.Interface.Model_GetPropertyTypeByID(instance.Handle, nUniqueResourceID)
	return eThePropertyType, error
}

func (instance *Lib3MFModel) GetBaseMaterialGroupByID(nUniqueResourceID uint32) (Lib3MFBaseMaterialGroup, error) {
	hBaseMaterialGroupInstance, error := instance.Interface.Model_GetBaseMaterialGroupByID(instance.Handle, nUniqueResourceID)
	var cBaseMaterialGroupInstance Lib3MFBaseMaterialGroup
	cBaseMaterialGroupInstance.Interface = instance.Interface
	cBaseMaterialGroupInstance.Handle = hBaseMaterialGroupInstance
	return cBaseMaterialGroupInstance, error
}

func (instance *Lib3MFModel) GetTexture2DGroupByID(nUniqueResourceID uint32) (Lib3MFTexture2DGroup, error) {
	hTexture2DGroupInstance, error := instance.Interface.Model_GetTexture2DGroupByID(instance.Handle, nUniqueResourceID)
	var cTexture2DGroupInstance Lib3MFTexture2DGroup
	cTexture2DGroupInstance.Interface = instance.Interface
	cTexture2DGroupInstance.Handle = hTexture2DGroupInstance
	return cTexture2DGroupInstance, error
}

func (instance *Lib3MFModel) GetCompositeMaterialsByID(nUniqueResourceID uint32) (Lib3MFCompositeMaterials, error) {
	hCompositeMaterialsInstance, error := instance.Interface.Model_GetCompositeMaterialsByID(instance.Handle, nUniqueResourceID)
	var cCompositeMaterialsInstance Lib3MFCompositeMaterials
	cCompositeMaterialsInstance.Interface = instance.Interface
	cCompositeMaterialsInstance.Handle = hCompositeMaterialsInstance
	return cCompositeMaterialsInstance, error
}

func (instance *Lib3MFModel) GetMultiPropertyGroupByID(nUniqueResourceID uint32) (Lib3MFMultiPropertyGroup, error) {
	hMultiPropertyGroupInstance, error := instance.Interface.Model_GetMultiPropertyGroupByID(instance.Handle, nUniqueResourceID)
	var cMultiPropertyGroupInstance Lib3MFMultiPropertyGroup
	cMultiPropertyGroupInstance.Interface = instance.Interface
	cMultiPropertyGroupInstance.Handle = hMultiPropertyGroupInstance
	return cMultiPropertyGroupInstance, error
}

func (instance *Lib3MFModel) GetMeshObjectByID(nUniqueResourceID uint32) (Lib3MFMeshObject, error) {
	hMeshObjectInstance, error := instance.Interface.Model_GetMeshObjectByID(instance.Handle, nUniqueResourceID)
	var cMeshObjectInstance Lib3MFMeshObject
	cMeshObjectInstance.Interface = instance.Interface
	cMeshObjectInstance.Handle = hMeshObjectInstance
	return cMeshObjectInstance, error
}

func (instance *Lib3MFModel) GetComponentsObjectByID(nUniqueResourceID uint32) (Lib3MFComponentsObject, error) {
	hComponentsObjectInstance, error := instance.Interface.Model_GetComponentsObjectByID(instance.Handle, nUniqueResourceID)
	var cComponentsObjectInstance Lib3MFComponentsObject
	cComponentsObjectInstance.Interface = instance.Interface
	cComponentsObjectInstance.Handle = hComponentsObjectInstance
	return cComponentsObjectInstance, error
}

func (instance *Lib3MFModel) GetColorGroupByID(nUniqueResourceID uint32) (Lib3MFColorGroup, error) {
	hColorGroupInstance, error := instance.Interface.Model_GetColorGroupByID(instance.Handle, nUniqueResourceID)
	var cColorGroupInstance Lib3MFColorGroup
	cColorGroupInstance.Interface = instance.Interface
	cColorGroupInstance.Handle = hColorGroupInstance
	return cColorGroupInstance, error
}

func (instance *Lib3MFModel) GetSliceStackByID(nUniqueResourceID uint32) (Lib3MFSliceStack, error) {
	hSliceStacInstance, error := instance.Interface.Model_GetSliceStackByID(instance.Handle, nUniqueResourceID)
	var cSliceStacInstance Lib3MFSliceStack
	cSliceStacInstance.Interface = instance.Interface
	cSliceStacInstance.Handle = hSliceStacInstance
	return cSliceStacInstance, error
}

func (instance *Lib3MFModel) GetBuildUUID() (bool, string, error) {
	bHasUUID, sUUID, error := instance.Interface.Model_GetBuildUUID(instance.Handle)
	return bHasUUID, sUUID, error
}

func (instance *Lib3MFModel) SetBuildUUID(sUUID string) (error) {
	error := instance.Interface.Model_SetBuildUUID(instance.Handle, sUUID)
	return error
}

func (instance *Lib3MFModel) GetBuildItems() (Lib3MFBuildItemIterator, error) {
	hBuildItemIterator, error := instance.Interface.Model_GetBuildItems(instance.Handle)
	var cBuildItemIterator Lib3MFBuildItemIterator
	cBuildItemIterator.Interface = instance.Interface
	cBuildItemIterator.Handle = hBuildItemIterator
	return cBuildItemIterator, error
}

func (instance *Lib3MFModel) GetOutbox() (sLib3MFBox, error) {
	sOutbox, error := instance.Interface.Model_GetOutbox(instance.Handle)
	return sOutbox, error
}

func (instance *Lib3MFModel) GetResources() (Lib3MFResourceIterator, error) {
	hResourceIterator, error := instance.Interface.Model_GetResources(instance.Handle)
	var cResourceIterator Lib3MFResourceIterator
	cResourceIterator.Interface = instance.Interface
	cResourceIterator.Handle = hResourceIterator
	return cResourceIterator, error
}

func (instance *Lib3MFModel) GetObjects() (Lib3MFObjectIterator, error) {
	hResourceIterator, error := instance.Interface.Model_GetObjects(instance.Handle)
	var cResourceIterator Lib3MFObjectIterator
	cResourceIterator.Interface = instance.Interface
	cResourceIterator.Handle = hResourceIterator
	return cResourceIterator, error
}

func (instance *Lib3MFModel) GetMeshObjects() (Lib3MFMeshObjectIterator, error) {
	hResourceIterator, error := instance.Interface.Model_GetMeshObjects(instance.Handle)
	var cResourceIterator Lib3MFMeshObjectIterator
	cResourceIterator.Interface = instance.Interface
	cResourceIterator.Handle = hResourceIterator
	return cResourceIterator, error
}

func (instance *Lib3MFModel) GetComponentsObjects() (Lib3MFComponentsObjectIterator, error) {
	hResourceIterator, error := instance.Interface.Model_GetComponentsObjects(instance.Handle)
	var cResourceIterator Lib3MFComponentsObjectIterator
	cResourceIterator.Interface = instance.Interface
	cResourceIterator.Handle = hResourceIterator
	return cResourceIterator, error
}

func (instance *Lib3MFModel) GetTexture2Ds() (Lib3MFTexture2DIterator, error) {
	hResourceIterator, error := instance.Interface.Model_GetTexture2Ds(instance.Handle)
	var cResourceIterator Lib3MFTexture2DIterator
	cResourceIterator.Interface = instance.Interface
	cResourceIterator.Handle = hResourceIterator
	return cResourceIterator, error
}

func (instance *Lib3MFModel) GetBaseMaterialGroups() (Lib3MFBaseMaterialGroupIterator, error) {
	hResourceIterator, error := instance.Interface.Model_GetBaseMaterialGroups(instance.Handle)
	var cResourceIterator Lib3MFBaseMaterialGroupIterator
	cResourceIterator.Interface = instance.Interface
	cResourceIterator.Handle = hResourceIterator
	return cResourceIterator, error
}

func (instance *Lib3MFModel) GetColorGroups() (Lib3MFColorGroupIterator, error) {
	hResourceIterator, error := instance.Interface.Model_GetColorGroups(instance.Handle)
	var cResourceIterator Lib3MFColorGroupIterator
	cResourceIterator.Interface = instance.Interface
	cResourceIterator.Handle = hResourceIterator
	return cResourceIterator, error
}

func (instance *Lib3MFModel) GetTexture2DGroups() (Lib3MFTexture2DGroupIterator, error) {
	hResourceIterator, error := instance.Interface.Model_GetTexture2DGroups(instance.Handle)
	var cResourceIterator Lib3MFTexture2DGroupIterator
	cResourceIterator.Interface = instance.Interface
	cResourceIterator.Handle = hResourceIterator
	return cResourceIterator, error
}

func (instance *Lib3MFModel) GetCompositeMaterials() (Lib3MFCompositeMaterialsIterator, error) {
	hResourceIterator, error := instance.Interface.Model_GetCompositeMaterials(instance.Handle)
	var cResourceIterator Lib3MFCompositeMaterialsIterator
	cResourceIterator.Interface = instance.Interface
	cResourceIterator.Handle = hResourceIterator
	return cResourceIterator, error
}

func (instance *Lib3MFModel) GetMultiPropertyGroups() (Lib3MFMultiPropertyGroupIterator, error) {
	hResourceIterator, error := instance.Interface.Model_GetMultiPropertyGroups(instance.Handle)
	var cResourceIterator Lib3MFMultiPropertyGroupIterator
	cResourceIterator.Interface = instance.Interface
	cResourceIterator.Handle = hResourceIterator
	return cResourceIterator, error
}

func (instance *Lib3MFModel) GetSliceStacks() (Lib3MFSliceStackIterator, error) {
	hResourceIterator, error := instance.Interface.Model_GetSliceStacks(instance.Handle)
	var cResourceIterator Lib3MFSliceStackIterator
	cResourceIterator.Interface = instance.Interface
	cResourceIterator.Handle = hResourceIterator
	return cResourceIterator, error
}

func (instance *Lib3MFModel) MergeToModel() (Lib3MFModel, error) {
	hMergedModelInstance, error := instance.Interface.Model_MergeToModel(instance.Handle)
	var cMergedModelInstance Lib3MFModel
	cMergedModelInstance.Interface = instance.Interface
	cMergedModelInstance.Handle = hMergedModelInstance
	return cMergedModelInstance, error
}

func (instance *Lib3MFModel) AddMeshObject() (Lib3MFMeshObject, error) {
	hMeshObjectInstance, error := instance.Interface.Model_AddMeshObject(instance.Handle)
	var cMeshObjectInstance Lib3MFMeshObject
	cMeshObjectInstance.Interface = instance.Interface
	cMeshObjectInstance.Handle = hMeshObjectInstance
	return cMeshObjectInstance, error
}

func (instance *Lib3MFModel) AddComponentsObject() (Lib3MFComponentsObject, error) {
	hComponentsObjectInstance, error := instance.Interface.Model_AddComponentsObject(instance.Handle)
	var cComponentsObjectInstance Lib3MFComponentsObject
	cComponentsObjectInstance.Interface = instance.Interface
	cComponentsObjectInstance.Handle = hComponentsObjectInstance
	return cComponentsObjectInstance, error
}

func (instance *Lib3MFModel) AddSliceStack(dZBottom float64) (Lib3MFSliceStack, error) {
	hSliceStackInstance, error := instance.Interface.Model_AddSliceStack(instance.Handle, dZBottom)
	var cSliceStackInstance Lib3MFSliceStack
	cSliceStackInstance.Interface = instance.Interface
	cSliceStackInstance.Handle = hSliceStackInstance
	return cSliceStackInstance, error
}

func (instance *Lib3MFModel) AddTexture2DFromAttachment(TextureAttachment Lib3MFHandle) (Lib3MFTexture2D, error) {
	hTexture2DInstance, error := instance.Interface.Model_AddTexture2DFromAttachment(instance.Handle, TextureAttachment)
	var cTexture2DInstance Lib3MFTexture2D
	cTexture2DInstance.Interface = instance.Interface
	cTexture2DInstance.Handle = hTexture2DInstance
	return cTexture2DInstance, error
}

func (instance *Lib3MFModel) AddBaseMaterialGroup() (Lib3MFBaseMaterialGroup, error) {
	hBaseMaterialGroupInstance, error := instance.Interface.Model_AddBaseMaterialGroup(instance.Handle)
	var cBaseMaterialGroupInstance Lib3MFBaseMaterialGroup
	cBaseMaterialGroupInstance.Interface = instance.Interface
	cBaseMaterialGroupInstance.Handle = hBaseMaterialGroupInstance
	return cBaseMaterialGroupInstance, error
}

func (instance *Lib3MFModel) AddColorGroup() (Lib3MFColorGroup, error) {
	hColorGroupInstance, error := instance.Interface.Model_AddColorGroup(instance.Handle)
	var cColorGroupInstance Lib3MFColorGroup
	cColorGroupInstance.Interface = instance.Interface
	cColorGroupInstance.Handle = hColorGroupInstance
	return cColorGroupInstance, error
}

func (instance *Lib3MFModel) AddTexture2DGroup(Texture2DInstance Lib3MFHandle) (Lib3MFTexture2DGroup, error) {
	hTexture2DGroupInstance, error := instance.Interface.Model_AddTexture2DGroup(instance.Handle, Texture2DInstance)
	var cTexture2DGroupInstance Lib3MFTexture2DGroup
	cTexture2DGroupInstance.Interface = instance.Interface
	cTexture2DGroupInstance.Handle = hTexture2DGroupInstance
	return cTexture2DGroupInstance, error
}

func (instance *Lib3MFModel) AddCompositeMaterials(BaseMaterialGroupInstance Lib3MFHandle) (Lib3MFCompositeMaterials, error) {
	hCompositeMaterialsInstance, error := instance.Interface.Model_AddCompositeMaterials(instance.Handle, BaseMaterialGroupInstance)
	var cCompositeMaterialsInstance Lib3MFCompositeMaterials
	cCompositeMaterialsInstance.Interface = instance.Interface
	cCompositeMaterialsInstance.Handle = hCompositeMaterialsInstance
	return cCompositeMaterialsInstance, error
}

func (instance *Lib3MFModel) AddMultiPropertyGroup() (Lib3MFMultiPropertyGroup, error) {
	hMultiPropertyGroupInstance, error := instance.Interface.Model_AddMultiPropertyGroup(instance.Handle)
	var cMultiPropertyGroupInstance Lib3MFMultiPropertyGroup
	cMultiPropertyGroupInstance.Interface = instance.Interface
	cMultiPropertyGroupInstance.Handle = hMultiPropertyGroupInstance
	return cMultiPropertyGroupInstance, error
}

func (instance *Lib3MFModel) AddBuildItem(Object Lib3MFHandle, sTransform sLib3MFTransform) (Lib3MFBuildItem, error) {
	hBuildItemInstance, error := instance.Interface.Model_AddBuildItem(instance.Handle, Object, sTransform)
	var cBuildItemInstance Lib3MFBuildItem
	cBuildItemInstance.Interface = instance.Interface
	cBuildItemInstance.Handle = hBuildItemInstance
	return cBuildItemInstance, error
}

func (instance *Lib3MFModel) RemoveBuildItem(BuildItemInstance Lib3MFHandle) (error) {
	error := instance.Interface.Model_RemoveBuildItem(instance.Handle, BuildItemInstance)
	return error
}

func (instance *Lib3MFModel) GetMetaDataGroup() (Lib3MFMetaDataGroup, error) {
	hTheMetaDataGroup, error := instance.Interface.Model_GetMetaDataGroup(instance.Handle)
	var cTheMetaDataGroup Lib3MFMetaDataGroup
	cTheMetaDataGroup.Interface = instance.Interface
	cTheMetaDataGroup.Handle = hTheMetaDataGroup
	return cTheMetaDataGroup, error
}

func (instance *Lib3MFModel) AddAttachment(sURI string, sRelationShipType string) (Lib3MFAttachment, error) {
	hAttachmentInstance, error := instance.Interface.Model_AddAttachment(instance.Handle, sURI, sRelationShipType)
	var cAttachmentInstance Lib3MFAttachment
	cAttachmentInstance.Interface = instance.Interface
	cAttachmentInstance.Handle = hAttachmentInstance
	return cAttachmentInstance, error
}

func (instance *Lib3MFModel) RemoveAttachment(AttachmentInstance Lib3MFHandle) (error) {
	error := instance.Interface.Model_RemoveAttachment(instance.Handle, AttachmentInstance)
	return error
}

func (instance *Lib3MFModel) GetAttachment(nIndex uint32) (Lib3MFAttachment, error) {
	hAttachmentInstance, error := instance.Interface.Model_GetAttachment(instance.Handle, nIndex)
	var cAttachmentInstance Lib3MFAttachment
	cAttachmentInstance.Interface = instance.Interface
	cAttachmentInstance.Handle = hAttachmentInstance
	return cAttachmentInstance, error
}

func (instance *Lib3MFModel) FindAttachment(sURI string) (Lib3MFAttachment, error) {
	hAttachmentInstance, error := instance.Interface.Model_FindAttachment(instance.Handle, sURI)
	var cAttachmentInstance Lib3MFAttachment
	cAttachmentInstance.Interface = instance.Interface
	cAttachmentInstance.Handle = hAttachmentInstance
	return cAttachmentInstance, error
}

func (instance *Lib3MFModel) GetAttachmentCount() (uint32, error) {
	nAttachmentCount, error := instance.Interface.Model_GetAttachmentCount(instance.Handle)
	return nAttachmentCount, error
}

func (instance *Lib3MFModel) HasPackageThumbnailAttachment() (bool, error) {
	bHasThumbnail, error := instance.Interface.Model_HasPackageThumbnailAttachment(instance.Handle)
	return bHasThumbnail, error
}

func (instance *Lib3MFModel) CreatePackageThumbnailAttachment() (Lib3MFAttachment, error) {
	hAttachment, error := instance.Interface.Model_CreatePackageThumbnailAttachment(instance.Handle)
	var cAttachment Lib3MFAttachment
	cAttachment.Interface = instance.Interface
	cAttachment.Handle = hAttachment
	return cAttachment, error
}

func (instance *Lib3MFModel) GetPackageThumbnailAttachment() (Lib3MFAttachment, error) {
	hAttachment, error := instance.Interface.Model_GetPackageThumbnailAttachment(instance.Handle)
	var cAttachment Lib3MFAttachment
	cAttachment.Interface = instance.Interface
	cAttachment.Handle = hAttachment
	return cAttachment, error
}

func (instance *Lib3MFModel) RemovePackageThumbnailAttachment() (error) {
	error := instance.Interface.Model_RemovePackageThumbnailAttachment(instance.Handle)
	return error
}

func (instance *Lib3MFModel) AddCustomContentType(sExtension string, sContentType string) (error) {
	error := instance.Interface.Model_AddCustomContentType(instance.Handle, sExtension, sContentType)
	return error
}

func (instance *Lib3MFModel) RemoveCustomContentType(sExtension string) (error) {
	error := instance.Interface.Model_RemoveCustomContentType(instance.Handle, sExtension)
	return error
}

func (instance *Lib3MFModel) SetRandomNumberCallback(pTheCallback int64, nUserData uint64) (error) {
	error := instance.Interface.Model_SetRandomNumberCallback(instance.Handle, pTheCallback, nUserData)
	return error
}

func (instance *Lib3MFModel) GetKeyStore() (Lib3MFKeyStore, error) {
	hKeyStore, error := instance.Interface.Model_GetKeyStore(instance.Handle)
	var cKeyStore Lib3MFKeyStore
	cKeyStore.Interface = instance.Interface
	cKeyStore.Handle = hKeyStore
	return cKeyStore, error
}

func (instance *Lib3MFWrapper) GetLibraryVersion() (uint32, uint32, uint32, error) {
	nMajor, nMinor, nMicro, error := instance.Interface.GetLibraryVersion()
	return nMajor, nMinor, nMicro, error
}

func (instance *Lib3MFWrapper) GetPrereleaseInformation() (bool, string, error) {
	bHasPrereleaseInfo, sPrereleaseInfo, error := instance.Interface.GetPrereleaseInformation()
	return bHasPrereleaseInfo, sPrereleaseInfo, error
}

func (instance *Lib3MFWrapper) GetBuildInformation() (bool, string, error) {
	bHasBuildInfo, sBuildInformation, error := instance.Interface.GetBuildInformation()
	return bHasBuildInfo, sBuildInformation, error
}

func (instance *Lib3MFWrapper) GetSpecificationVersion(sSpecificationURL string) (bool, uint32, uint32, uint32, error) {
	bIsSupported, nMajor, nMinor, nMicro, error := instance.Interface.GetSpecificationVersion(sSpecificationURL)
	return bIsSupported, nMajor, nMinor, nMicro, error
}

func (instance *Lib3MFWrapper) CreateModel() (Lib3MFModel, error) {
	hModel, error := instance.Interface.CreateModel()
	var cModel Lib3MFModel
	cModel.Interface = instance.Interface
	cModel.Handle = hModel
	return cModel, error
}

func (instance *Lib3MFWrapper) Release(Instance Lib3MFHandle) (error) {
	error := instance.Interface.Release(Instance)
	return error
}

func (instance *Lib3MFWrapper) Acquire(Instance Lib3MFHandle) (error) {
	error := instance.Interface.Acquire(Instance)
	return error
}

func (instance *Lib3MFWrapper) SetJournal(sJournalPath string) (error) {
	error := instance.Interface.SetJournal(sJournalPath)
	return error
}

func (instance *Lib3MFWrapper) GetLastError(Instance Lib3MFHandle) (string, bool, error) {
	sLastErrorString, bHasLastError, error := instance.Interface.GetLastError(Instance)
	return sLastErrorString, bHasLastError, error
}

func (instance *Lib3MFWrapper) RetrieveProgressMessage(eTheProgressIdentifier ELib3MFProgressIdentifier) (string, error) {
	sProgressMessage, error := instance.Interface.RetrieveProgressMessage(eTheProgressIdentifier)
	return sProgressMessage, error
}

func (instance *Lib3MFWrapper) RGBAToColor(nRed uint8, nGreen uint8, nBlue uint8, nAlpha uint8) (sLib3MFColor, error) {
	sTheColor, error := instance.Interface.RGBAToColor(nRed, nGreen, nBlue, nAlpha)
	return sTheColor, error
}

func (instance *Lib3MFWrapper) FloatRGBAToColor(fRed float32, fGreen float32, fBlue float32, fAlpha float32) (sLib3MFColor, error) {
	sTheColor, error := instance.Interface.FloatRGBAToColor(fRed, fGreen, fBlue, fAlpha)
	return sTheColor, error
}

func (instance *Lib3MFWrapper) ColorToRGBA(sTheColor sLib3MFColor) (uint8, uint8, uint8, uint8, error) {
	nRed, nGreen, nBlue, nAlpha, error := instance.Interface.ColorToRGBA(sTheColor)
	return nRed, nGreen, nBlue, nAlpha, error
}

func (instance *Lib3MFWrapper) ColorToFloatRGBA(sTheColor sLib3MFColor) (float32, float32, float32, float32, error) {
	fRed, fGreen, fBlue, fAlpha, error := instance.Interface.ColorToFloatRGBA(sTheColor)
	return fRed, fGreen, fBlue, fAlpha, error
}

func (instance *Lib3MFWrapper) GetIdentityTransform() (sLib3MFTransform, error) {
	sTransform, error := instance.Interface.GetIdentityTransform()
	return sTransform, error
}

func (instance *Lib3MFWrapper) GetUniformScaleTransform(fFactor float32) (sLib3MFTransform, error) {
	sTransform, error := instance.Interface.GetUniformScaleTransform(fFactor)
	return sTransform, error
}

func (instance *Lib3MFWrapper) GetScaleTransform(fFactorX float32, fFactorY float32, fFactorZ float32) (sLib3MFTransform, error) {
	sTransform, error := instance.Interface.GetScaleTransform(fFactorX, fFactorY, fFactorZ)
	return sTransform, error
}

func (instance *Lib3MFWrapper) GetTranslationTransform(fVectorX float32, fVectorY float32, fVectorZ float32) (sLib3MFTransform, error) {
	sTransform, error := instance.Interface.GetTranslationTransform(fVectorX, fVectorY, fVectorZ)
	return sTransform, error
}

