/*++

Copyright (C) 2019 3MF Consortium (Original Author)

All rights reserved.

Redistribution and use in source and binary forms, with or without modification,
are permitted provided that the following conditions are met:

1. Redistributions of source code must retain the above copyright notice, this
list of conditions and the following disclaimer.
2. Redistributions in binary form must reproduce the above copyright notice,
this list of conditions and the following disclaimer in the documentation
and/or other materials provided with the distribution.

THIS SOFTWARE IS PROVIDED BY THE COPYRIGHT HOLDERS AND CONTRIBUTORS "AS IS" AND
ANY EXPRESS OR IMPLIED WARRANTIES, INCLUDING, BUT NOT LIMITED TO, THE IMPLIED
WARRANTIES OF MERCHANTABILITY AND FITNESS FOR A PARTICULAR PURPOSE ARE
DISCLAIMED. IN NO EVENT SHALL THE COPYRIGHT HOLDER OR CONTRIBUTORS BE LIABLE FOR
ANY DIRECT, INDIRECT, INCIDENTAL, SPECIAL, EXEMPLARY, OR CONSEQUENTIAL DAMAGES
(INCLUDING, BUT NOT LIMITED TO, PROCUREMENT OF SUBSTITUTE GOODS OR SERVICES;
LOSS OF USE, DATA, OR PROFITS; OR BUSINESS INTERRUPTION) HOWEVER CAUSED AND
ON ANY THEORY OF LIABILITY, WHETHER IN CONTRACT, STRICT LIABILITY, OR TORT
(INCLUDING NEGLIGENCE OR OTHERWISE) ARISING IN ANY WAY OUT OF THE USE OF THIS
SOFTWARE, EVEN IF ADVISED OF THE POSSIBILITY OF SUCH DAMAGE.

This file has been generated by the Automatic Component Toolkit (ACT) version 1.6.0.

Abstract: This is an autogenerated plain C Header file in order to allow an easy
 use of the 3MF Library

Interface version: 2.1.1

*/

#ifndef __LIB3MF_DYNAMICHEADER
#define __LIB3MF_DYNAMICHEADER

#include "lib3mf_types.h"



/*************************************************************************************************************************
 Class definition for Base
**************************************************************************************************************************/

/*************************************************************************************************************************
 Class definition for Writer
**************************************************************************************************************************/

/**
* Writes out the model as file. The file type is specified by the Model Writer class.
*
* @param[in] pWriter - Writer instance.
* @param[in] pFilename - Filename to write into
* @return error code or 0 (success)
*/
typedef Lib3MFResult (*PLib3MFWriter_WriteToFilePtr) (Lib3MF_Writer pWriter, const char * pFilename);

/**
* Retrieves the size of the full 3MF file stream.
*
* @param[in] pWriter - Writer instance.
* @param[out] pStreamSize - the stream size
* @return error code or 0 (success)
*/
typedef Lib3MFResult (*PLib3MFWriter_GetStreamSizePtr) (Lib3MF_Writer pWriter, Lib3MF_uint64 * pStreamSize);

/**
* Writes out the 3MF file into a memory buffer
*
* @param[in] pWriter - Writer instance.
* @param[in] nBufferBufferSize - Number of elements in buffer
* @param[out] pBufferNeededCount - will be filled with the count of the written elements, or needed buffer size.
* @param[out] pBufferBuffer - uint8  buffer of buffer to write into
* @return error code or 0 (success)
*/
typedef Lib3MFResult (*PLib3MFWriter_WriteToBufferPtr) (Lib3MF_Writer pWriter, const Lib3MF_uint64 nBufferBufferSize, Lib3MF_uint64* pBufferNeededCount, Lib3MF_uint8 * pBufferBuffer);

/**
* Writes out the model and passes the data to a provided callback function. The file type is specified by the Model Writer class.
*
* @param[in] pWriter - Writer instance.
* @param[in] pTheWriteCallback - Callback to call for writing a data chunk
* @param[in] pTheSeekCallback - Callback to call for seeking in the stream
* @param[in] pUserData - Userdata that is passed to the callback function
* @return error code or 0 (success)
*/
typedef Lib3MFResult (*PLib3MFWriter_WriteToCallbackPtr) (Lib3MF_Writer pWriter, Lib3MFWriteCallback pTheWriteCallback, Lib3MFSeekCallback pTheSeekCallback, Lib3MF_pvoid pUserData);

/**
* Set the progress callback for calls to this writer
*
* @param[in] pWriter - Writer instance.
* @param[in] pProgressCallback - pointer to the callback function.
* @param[in] pUserData - pointer to arbitrary user data that is passed without modification to the callback.
* @return error code or 0 (success)
*/
typedef Lib3MFResult (*PLib3MFWriter_SetProgressCallbackPtr) (Lib3MF_Writer pWriter, Lib3MFProgressCallback pProgressCallback, Lib3MF_pvoid pUserData);

/**
* Returns the number of digits after the decimal point to be written in each vertex coordinate-value.
*
* @param[in] pWriter - Writer instance.
* @param[out] pDecimalPrecision - The number of digits to be written in each vertex coordinate-value after the decimal point.
* @return error code or 0 (success)
*/
typedef Lib3MFResult (*PLib3MFWriter_GetDecimalPrecisionPtr) (Lib3MF_Writer pWriter, Lib3MF_uint32 * pDecimalPrecision);

/**
* Sets the number of digits after the decimal point to be written in each vertex coordinate-value.
*
* @param[in] pWriter - Writer instance.
* @param[in] nDecimalPrecision - The number of digits to be written in each vertex coordinate-value after the decimal point.
* @return error code or 0 (success)
*/
typedef Lib3MFResult (*PLib3MFWriter_SetDecimalPrecisionPtr) (Lib3MF_Writer pWriter, Lib3MF_uint32 nDecimalPrecision);

/**
* Activates (deactivates) the strict mode of the reader.
*
* @param[in] pWriter - Writer instance.
* @param[in] bStrictModeActive - flag whether strict mode is active or not.
* @return error code or 0 (success)
*/
typedef Lib3MFResult (*PLib3MFWriter_SetStrictModeActivePtr) (Lib3MF_Writer pWriter, bool bStrictModeActive);

/**
* Queries whether the strict mode of the reader is active or not
*
* @param[in] pWriter - Writer instance.
* @param[out] pStrictModeActive - returns flag whether strict mode is active or not.
* @return error code or 0 (success)
*/
typedef Lib3MFResult (*PLib3MFWriter_GetStrictModeActivePtr) (Lib3MF_Writer pWriter, bool * pStrictModeActive);

/**
* Returns Warning and Error Information of the read process
*
* @param[in] pWriter - Writer instance.
* @param[in] nIndex - Index of the Warning. Valid values are 0 to WarningCount - 1
* @param[out] pErrorCode - filled with the error code of the warning
* @param[in] nWarningBufferSize - size of the buffer (including trailing 0)
* @param[out] pWarningNeededChars - will be filled with the count of the written bytes, or needed buffer size.
* @param[out] pWarningBuffer -  buffer of the message of the warning, may be NULL
* @return error code or 0 (success)
*/
typedef Lib3MFResult (*PLib3MFWriter_GetWarningPtr) (Lib3MF_Writer pWriter, Lib3MF_uint32 nIndex, Lib3MF_uint32 * pErrorCode, const Lib3MF_uint32 nWarningBufferSize, Lib3MF_uint32* pWarningNeededChars, char * pWarningBuffer);

/**
* Returns Warning and Error Count of the read process
*
* @param[in] pWriter - Writer instance.
* @param[out] pCount - filled with the count of the occurred warnings.
* @return error code or 0 (success)
*/
typedef Lib3MFResult (*PLib3MFWriter_GetWarningCountPtr) (Lib3MF_Writer pWriter, Lib3MF_uint32 * pCount);

/**
* Registers a callback to deal with data key encryption/decryption from keystore
*
* @param[in] pWriter - Writer instance.
* @param[in] pConsumerID - The ConsumerID to register for
* @param[in] pTheCallback - The callback to be callede for wrapping and encryption key
* @param[in] pUserData - Userdata that is passed to the callback function
* @return error code or 0 (success)
*/
typedef Lib3MFResult (*PLib3MFWriter_AddKeyWrappingCallbackPtr) (Lib3MF_Writer pWriter, const char * pConsumerID, Lib3MFKeyWrappingCallback pTheCallback, Lib3MF_pvoid pUserData);

/**
* Registers a callback to deal with encryption of content
*
* @param[in] pWriter - Writer instance.
* @param[in] pTheCallback - The callback used to encrypt content
* @param[in] pUserData - Userdata that is passed to the callback function
* @return error code or 0 (success)
*/
typedef Lib3MFResult (*PLib3MFWriter_SetContentEncryptionCallbackPtr) (Lib3MF_Writer pWriter, Lib3MFContentEncryptionCallback pTheCallback, Lib3MF_pvoid pUserData);

/*************************************************************************************************************************
 Class definition for Reader
**************************************************************************************************************************/

/**
* Reads a model from a file. The file type is specified by the Model Reader class
*
* @param[in] pReader - Reader instance.
* @param[in] pFilename - Filename to read from
* @return error code or 0 (success)
*/
typedef Lib3MFResult (*PLib3MFReader_ReadFromFilePtr) (Lib3MF_Reader pReader, const char * pFilename);

/**
* Reads a model from a memory buffer.
*
* @param[in] pReader - Reader instance.
* @param[in] nBufferBufferSize - Number of elements in buffer
* @param[in] pBufferBuffer - uint8 buffer of Buffer to read from
* @return error code or 0 (success)
*/
typedef Lib3MFResult (*PLib3MFReader_ReadFromBufferPtr) (Lib3MF_Reader pReader, Lib3MF_uint64 nBufferBufferSize, const Lib3MF_uint8 * pBufferBuffer);

/**
* Reads a model and from the data provided by a callback function
*
* @param[in] pReader - Reader instance.
* @param[in] pTheReadCallback - Callback to call for reading a data chunk
* @param[in] nStreamSize - number of bytes the callback returns
* @param[in] pTheSeekCallback - Callback to call for seeking in the stream.
* @param[in] pUserData - Userdata that is passed to the callback function
* @return error code or 0 (success)
*/
typedef Lib3MFResult (*PLib3MFReader_ReadFromCallbackPtr) (Lib3MF_Reader pReader, Lib3MFReadCallback pTheReadCallback, Lib3MF_uint64 nStreamSize, Lib3MFSeekCallback pTheSeekCallback, Lib3MF_pvoid pUserData);

/**
* Set the progress callback for calls to this writer
*
* @param[in] pReader - Reader instance.
* @param[in] pProgressCallback - pointer to the callback function.
* @param[in] pUserData - pointer to arbitrary user data that is passed without modification to the callback.
* @return error code or 0 (success)
*/
typedef Lib3MFResult (*PLib3MFReader_SetProgressCallbackPtr) (Lib3MF_Reader pReader, Lib3MFProgressCallback pProgressCallback, Lib3MF_pvoid pUserData);

/**
* Adds a relationship type which shall be read as attachment in memory while loading
*
* @param[in] pReader - Reader instance.
* @param[in] pRelationShipType - String of the relationship type
* @return error code or 0 (success)
*/
typedef Lib3MFResult (*PLib3MFReader_AddRelationToReadPtr) (Lib3MF_Reader pReader, const char * pRelationShipType);

/**
* Removes a relationship type which shall be read as attachment in memory while loading
*
* @param[in] pReader - Reader instance.
* @param[in] pRelationShipType - String of the relationship type
* @return error code or 0 (success)
*/
typedef Lib3MFResult (*PLib3MFReader_RemoveRelationToReadPtr) (Lib3MF_Reader pReader, const char * pRelationShipType);

/**
* Activates (deactivates) the strict mode of the reader.
*
* @param[in] pReader - Reader instance.
* @param[in] bStrictModeActive - flag whether strict mode is active or not.
* @return error code or 0 (success)
*/
typedef Lib3MFResult (*PLib3MFReader_SetStrictModeActivePtr) (Lib3MF_Reader pReader, bool bStrictModeActive);

/**
* Queries whether the strict mode of the reader is active or not
*
* @param[in] pReader - Reader instance.
* @param[out] pStrictModeActive - returns flag whether strict mode is active or not.
* @return error code or 0 (success)
*/
typedef Lib3MFResult (*PLib3MFReader_GetStrictModeActivePtr) (Lib3MF_Reader pReader, bool * pStrictModeActive);

/**
* Returns Warning and Error Information of the read process
*
* @param[in] pReader - Reader instance.
* @param[in] nIndex - Index of the Warning. Valid values are 0 to WarningCount - 1
* @param[out] pErrorCode - filled with the error code of the warning
* @param[in] nWarningBufferSize - size of the buffer (including trailing 0)
* @param[out] pWarningNeededChars - will be filled with the count of the written bytes, or needed buffer size.
* @param[out] pWarningBuffer -  buffer of the message of the warning, may be NULL
* @return error code or 0 (success)
*/
typedef Lib3MFResult (*PLib3MFReader_GetWarningPtr) (Lib3MF_Reader pReader, Lib3MF_uint32 nIndex, Lib3MF_uint32 * pErrorCode, const Lib3MF_uint32 nWarningBufferSize, Lib3MF_uint32* pWarningNeededChars, char * pWarningBuffer);

/**
* Returns Warning and Error Count of the read process
*
* @param[in] pReader - Reader instance.
* @param[out] pCount - filled with the count of the occurred warnings.
* @return error code or 0 (success)
*/
typedef Lib3MFResult (*PLib3MFReader_GetWarningCountPtr) (Lib3MF_Reader pReader, Lib3MF_uint32 * pCount);

/**
* Registers a callback to deal with key wrapping mechanism from keystore
*
* @param[in] pReader - Reader instance.
* @param[in] pConsumerID - The ConsumerID to register for
* @param[in] pTheCallback - The callback used to decrypt data key
* @param[in] pUserData - Userdata that is passed to the callback function
* @return error code or 0 (success)
*/
typedef Lib3MFResult (*PLib3MFReader_AddKeyWrappingCallbackPtr) (Lib3MF_Reader pReader, const char * pConsumerID, Lib3MFKeyWrappingCallback pTheCallback, Lib3MF_pvoid pUserData);

/**
* Registers a callback to deal with encryption of content
*
* @param[in] pReader - Reader instance.
* @param[in] pTheCallback - The callback used to encrypt content
* @param[in] pUserData - Userdata that is passed to the callback function
* @return error code or 0 (success)
*/
typedef Lib3MFResult (*PLib3MFReader_SetContentEncryptionCallbackPtr) (Lib3MF_Reader pReader, Lib3MFContentEncryptionCallback pTheCallback, Lib3MF_pvoid pUserData);

/*************************************************************************************************************************
 Class definition for PackagePart
**************************************************************************************************************************/

/**
* Returns the absolute path of this PackagePart.
*
* @param[in] pPackagePart - PackagePart instance.
* @param[in] nPathBufferSize - size of the buffer (including trailing 0)
* @param[out] pPathNeededChars - will be filled with the count of the written bytes, or needed buffer size.
* @param[out] pPathBuffer -  buffer of Returns the absolute path of this PackagePart, may be NULL
* @return error code or 0 (success)
*/
typedef Lib3MFResult (*PLib3MFPackagePart_GetPathPtr) (Lib3MF_PackagePart pPackagePart, const Lib3MF_uint32 nPathBufferSize, Lib3MF_uint32* pPathNeededChars, char * pPathBuffer);

/**
* Sets the absolute path of this PackagePart.
*
* @param[in] pPackagePart - PackagePart instance.
* @param[in] pPath - Sets the absolute path of this PackagePart.
* @return error code or 0 (success)
*/
typedef Lib3MFResult (*PLib3MFPackagePart_SetPathPtr) (Lib3MF_PackagePart pPackagePart, const char * pPath);

/*************************************************************************************************************************
 Class definition for Resource
**************************************************************************************************************************/

/**
* Retrieves the unique id of this resource within a package. This function will be removed in a later release in favor of GetUniqueResourceID
*
* @param[in] pResource - Resource instance.
* @param[out] pUniqueResourceID - Retrieves the unique id of this resource within a package.
* @return error code or 0 (success)
*/
typedef Lib3MFResult (*PLib3MFResource_GetResourceIDPtr) (Lib3MF_Resource pResource, Lib3MF_uint32 * pUniqueResourceID);

/**
* Retrieves the unique id of this resource within a package.
*
* @param[in] pResource - Resource instance.
* @param[out] pUniqueResourceID - Retrieves the unique id of this resource within a package.
* @return error code or 0 (success)
*/
typedef Lib3MFResult (*PLib3MFResource_GetUniqueResourceIDPtr) (Lib3MF_Resource pResource, Lib3MF_uint32 * pUniqueResourceID);

/**
* Returns the PackagePart within which this resource resides
*
* @param[in] pResource - Resource instance.
* @param[out] pPackagePart - the PackagePart within which this resource resides.
* @return error code or 0 (success)
*/
typedef Lib3MFResult (*PLib3MFResource_PackagePartPtr) (Lib3MF_Resource pResource, Lib3MF_PackagePart * pPackagePart);

/**
* Sets the new PackagePart within which this resource resides
*
* @param[in] pResource - Resource instance.
* @param[in] pPackagePart - the new PackagePart within which this resource resides.
* @return error code or 0 (success)
*/
typedef Lib3MFResult (*PLib3MFResource_SetPackagePartPtr) (Lib3MF_Resource pResource, Lib3MF_PackagePart pPackagePart);

/**
* Retrieves the id of this resource within a model.
*
* @param[in] pResource - Resource instance.
* @param[out] pModelResourceId - Retrieves the id of this resource within a model.
* @return error code or 0 (success)
*/
typedef Lib3MFResult (*PLib3MFResource_GetModelResourceIDPtr) (Lib3MF_Resource pResource, Lib3MF_uint32 * pModelResourceId);

/*************************************************************************************************************************
 Class definition for ResourceIterator
**************************************************************************************************************************/

/**
* Iterates to the next resource in the list.
*
* @param[in] pResourceIterator - ResourceIterator instance.
* @param[out] pHasNext - Iterates to the next resource in the list.
* @return error code or 0 (success)
*/
typedef Lib3MFResult (*PLib3MFResourceIterator_MoveNextPtr) (Lib3MF_ResourceIterator pResourceIterator, bool * pHasNext);

/**
* Iterates to the previous resource in the list.
*
* @param[in] pResourceIterator - ResourceIterator instance.
* @param[out] pHasPrevious - Iterates to the previous resource in the list.
* @return error code or 0 (success)
*/
typedef Lib3MFResult (*PLib3MFResourceIterator_MovePreviousPtr) (Lib3MF_ResourceIterator pResourceIterator, bool * pHasPrevious);

/**
* Returns the resource the iterator points at.
*
* @param[in] pResourceIterator - ResourceIterator instance.
* @param[out] pResource - returns the resource instance.
* @return error code or 0 (success)
*/
typedef Lib3MFResult (*PLib3MFResourceIterator_GetCurrentPtr) (Lib3MF_ResourceIterator pResourceIterator, Lib3MF_Resource * pResource);

/**
* Creates a new resource iterator with the same resource list.
*
* @param[in] pResourceIterator - ResourceIterator instance.
* @param[out] pOutResourceIterator - returns the cloned Iterator instance
* @return error code or 0 (success)
*/
typedef Lib3MFResult (*PLib3MFResourceIterator_ClonePtr) (Lib3MF_ResourceIterator pResourceIterator, Lib3MF_ResourceIterator * pOutResourceIterator);

/**
* Returns the number of resoucres the iterator captures.
*
* @param[in] pResourceIterator - ResourceIterator instance.
* @param[out] pCount - returns the number of resoucres the iterator captures.
* @return error code or 0 (success)
*/
typedef Lib3MFResult (*PLib3MFResourceIterator_CountPtr) (Lib3MF_ResourceIterator pResourceIterator, Lib3MF_uint64 * pCount);

/*************************************************************************************************************************
 Class definition for SliceStackIterator
**************************************************************************************************************************/

/**
* Returns the SliceStack the iterator points at.
*
* @param[in] pSliceStackIterator - SliceStackIterator instance.
* @param[out] pResource - returns the SliceStack instance.
* @return error code or 0 (success)
*/
typedef Lib3MFResult (*PLib3MFSliceStackIterator_GetCurrentSliceStackPtr) (Lib3MF_SliceStackIterator pSliceStackIterator, Lib3MF_SliceStack * pResource);

/*************************************************************************************************************************
 Class definition for ObjectIterator
**************************************************************************************************************************/

/**
* Returns the Object the iterator points at.
*
* @param[in] pObjectIterator - ObjectIterator instance.
* @param[out] pResource - returns the Object instance.
* @return error code or 0 (success)
*/
typedef Lib3MFResult (*PLib3MFObjectIterator_GetCurrentObjectPtr) (Lib3MF_ObjectIterator pObjectIterator, Lib3MF_Object * pResource);

/*************************************************************************************************************************
 Class definition for MeshObjectIterator
**************************************************************************************************************************/

/**
* Returns the MeshObject the iterator points at.
*
* @param[in] pMeshObjectIterator - MeshObjectIterator instance.
* @param[out] pResource - returns the MeshObject instance.
* @return error code or 0 (success)
*/
typedef Lib3MFResult (*PLib3MFMeshObjectIterator_GetCurrentMeshObjectPtr) (Lib3MF_MeshObjectIterator pMeshObjectIterator, Lib3MF_MeshObject * pResource);

/*************************************************************************************************************************
 Class definition for ComponentsObjectIterator
**************************************************************************************************************************/

/**
* Returns the ComponentsObject the iterator points at.
*
* @param[in] pComponentsObjectIterator - ComponentsObjectIterator instance.
* @param[out] pResource - returns the ComponentsObject instance.
* @return error code or 0 (success)
*/
typedef Lib3MFResult (*PLib3MFComponentsObjectIterator_GetCurrentComponentsObjectPtr) (Lib3MF_ComponentsObjectIterator pComponentsObjectIterator, Lib3MF_ComponentsObject * pResource);

/*************************************************************************************************************************
 Class definition for Texture2DIterator
**************************************************************************************************************************/

/**
* Returns the Texture2D the iterator points at.
*
* @param[in] pTexture2DIterator - Texture2DIterator instance.
* @param[out] pResource - returns the Texture2D instance.
* @return error code or 0 (success)
*/
typedef Lib3MFResult (*PLib3MFTexture2DIterator_GetCurrentTexture2DPtr) (Lib3MF_Texture2DIterator pTexture2DIterator, Lib3MF_Texture2D * pResource);

/*************************************************************************************************************************
 Class definition for BaseMaterialGroupIterator
**************************************************************************************************************************/

/**
* Returns the MaterialGroup the iterator points at.
*
* @param[in] pBaseMaterialGroupIterator - BaseMaterialGroupIterator instance.
* @param[out] pResource - returns the BaseMaterialGroup instance.
* @return error code or 0 (success)
*/
typedef Lib3MFResult (*PLib3MFBaseMaterialGroupIterator_GetCurrentBaseMaterialGroupPtr) (Lib3MF_BaseMaterialGroupIterator pBaseMaterialGroupIterator, Lib3MF_BaseMaterialGroup * pResource);

/*************************************************************************************************************************
 Class definition for ColorGroupIterator
**************************************************************************************************************************/

/**
* Returns the ColorGroup the iterator points at.
*
* @param[in] pColorGroupIterator - ColorGroupIterator instance.
* @param[out] pResource - returns the ColorGroup instance.
* @return error code or 0 (success)
*/
typedef Lib3MFResult (*PLib3MFColorGroupIterator_GetCurrentColorGroupPtr) (Lib3MF_ColorGroupIterator pColorGroupIterator, Lib3MF_ColorGroup * pResource);

/*************************************************************************************************************************
 Class definition for Texture2DGroupIterator
**************************************************************************************************************************/

/**
* Returns the Texture2DGroup the iterator points at.
*
* @param[in] pTexture2DGroupIterator - Texture2DGroupIterator instance.
* @param[out] pResource - returns the Texture2DGroup instance.
* @return error code or 0 (success)
*/
typedef Lib3MFResult (*PLib3MFTexture2DGroupIterator_GetCurrentTexture2DGroupPtr) (Lib3MF_Texture2DGroupIterator pTexture2DGroupIterator, Lib3MF_Texture2DGroup * pResource);

/*************************************************************************************************************************
 Class definition for CompositeMaterialsIterator
**************************************************************************************************************************/

/**
* Returns the CompositeMaterials the iterator points at.
*
* @param[in] pCompositeMaterialsIterator - CompositeMaterialsIterator instance.
* @param[out] pResource - returns the CompositeMaterials instance.
* @return error code or 0 (success)
*/
typedef Lib3MFResult (*PLib3MFCompositeMaterialsIterator_GetCurrentCompositeMaterialsPtr) (Lib3MF_CompositeMaterialsIterator pCompositeMaterialsIterator, Lib3MF_CompositeMaterials * pResource);

/*************************************************************************************************************************
 Class definition for MultiPropertyGroupIterator
**************************************************************************************************************************/

/**
* Returns the MultiPropertyGroup the iterator points at.
*
* @param[in] pMultiPropertyGroupIterator - MultiPropertyGroupIterator instance.
* @param[out] pResource - returns the MultiPropertyGroup instance.
* @return error code or 0 (success)
*/
typedef Lib3MFResult (*PLib3MFMultiPropertyGroupIterator_GetCurrentMultiPropertyGroupPtr) (Lib3MF_MultiPropertyGroupIterator pMultiPropertyGroupIterator, Lib3MF_MultiPropertyGroup * pResource);

/*************************************************************************************************************************
 Class definition for MetaData
**************************************************************************************************************************/

/**
* returns the namespace URL of the metadata
*
* @param[in] pMetaData - MetaData instance.
* @param[in] nNameSpaceBufferSize - size of the buffer (including trailing 0)
* @param[out] pNameSpaceNeededChars - will be filled with the count of the written bytes, or needed buffer size.
* @param[out] pNameSpaceBuffer -  buffer of the namespace URL of the metadata, may be NULL
* @return error code or 0 (success)
*/
typedef Lib3MFResult (*PLib3MFMetaData_GetNameSpacePtr) (Lib3MF_MetaData pMetaData, const Lib3MF_uint32 nNameSpaceBufferSize, Lib3MF_uint32* pNameSpaceNeededChars, char * pNameSpaceBuffer);

/**
* sets a new namespace URL of the metadata
*
* @param[in] pMetaData - MetaData instance.
* @param[in] pNameSpace - the new namespace URL of the metadata
* @return error code or 0 (success)
*/
typedef Lib3MFResult (*PLib3MFMetaData_SetNameSpacePtr) (Lib3MF_MetaData pMetaData, const char * pNameSpace);

/**
* returns the name of a metadata
*
* @param[in] pMetaData - MetaData instance.
* @param[in] nNameBufferSize - size of the buffer (including trailing 0)
* @param[out] pNameNeededChars - will be filled with the count of the written bytes, or needed buffer size.
* @param[out] pNameBuffer -  buffer of the name of the metadata, may be NULL
* @return error code or 0 (success)
*/
typedef Lib3MFResult (*PLib3MFMetaData_GetNamePtr) (Lib3MF_MetaData pMetaData, const Lib3MF_uint32 nNameBufferSize, Lib3MF_uint32* pNameNeededChars, char * pNameBuffer);

/**
* sets a new name of a metadata
*
* @param[in] pMetaData - MetaData instance.
* @param[in] pName - the new name of the metadata
* @return error code or 0 (success)
*/
typedef Lib3MFResult (*PLib3MFMetaData_SetNamePtr) (Lib3MF_MetaData pMetaData, const char * pName);

/**
* returns the (namespace+name) of a metadata
*
* @param[in] pMetaData - MetaData instance.
* @param[in] nKeyBufferSize - size of the buffer (including trailing 0)
* @param[out] pKeyNeededChars - will be filled with the count of the written bytes, or needed buffer size.
* @param[out] pKeyBuffer -  buffer of the key (namespace+name) of the metadata, may be NULL
* @return error code or 0 (success)
*/
typedef Lib3MFResult (*PLib3MFMetaData_GetKeyPtr) (Lib3MF_MetaData pMetaData, const Lib3MF_uint32 nKeyBufferSize, Lib3MF_uint32* pKeyNeededChars, char * pKeyBuffer);

/**
* returns, whether a metadata must be preserved
*
* @param[in] pMetaData - MetaData instance.
* @param[out] pMustPreserve - returns, whether a metadata must be preserved
* @return error code or 0 (success)
*/
typedef Lib3MFResult (*PLib3MFMetaData_GetMustPreservePtr) (Lib3MF_MetaData pMetaData, bool * pMustPreserve);

/**
* sets whether a metadata must be preserved
*
* @param[in] pMetaData - MetaData instance.
* @param[in] bMustPreserve - a new value whether a metadata must be preserved
* @return error code or 0 (success)
*/
typedef Lib3MFResult (*PLib3MFMetaData_SetMustPreservePtr) (Lib3MF_MetaData pMetaData, bool bMustPreserve);

/**
* returns the type of a metadata
*
* @param[in] pMetaData - MetaData instance.
* @param[in] nTypeBufferSize - size of the buffer (including trailing 0)
* @param[out] pTypeNeededChars - will be filled with the count of the written bytes, or needed buffer size.
* @param[out] pTypeBuffer -  buffer of the type of the metadata, may be NULL
* @return error code or 0 (success)
*/
typedef Lib3MFResult (*PLib3MFMetaData_GetTypePtr) (Lib3MF_MetaData pMetaData, const Lib3MF_uint32 nTypeBufferSize, Lib3MF_uint32* pTypeNeededChars, char * pTypeBuffer);

/**
* sets a new type of a metadata. This must be a simple XML type
*
* @param[in] pMetaData - MetaData instance.
* @param[in] pType - a new type of the metadata
* @return error code or 0 (success)
*/
typedef Lib3MFResult (*PLib3MFMetaData_SetTypePtr) (Lib3MF_MetaData pMetaData, const char * pType);

/**
* returns the value of the metadata
*
* @param[in] pMetaData - MetaData instance.
* @param[in] nValueBufferSize - size of the buffer (including trailing 0)
* @param[out] pValueNeededChars - will be filled with the count of the written bytes, or needed buffer size.
* @param[out] pValueBuffer -  buffer of the value of the metadata, may be NULL
* @return error code or 0 (success)
*/
typedef Lib3MFResult (*PLib3MFMetaData_GetValuePtr) (Lib3MF_MetaData pMetaData, const Lib3MF_uint32 nValueBufferSize, Lib3MF_uint32* pValueNeededChars, char * pValueBuffer);

/**
* sets a new value of the metadata
*
* @param[in] pMetaData - MetaData instance.
* @param[in] pValue - a new value of the metadata
* @return error code or 0 (success)
*/
typedef Lib3MFResult (*PLib3MFMetaData_SetValuePtr) (Lib3MF_MetaData pMetaData, const char * pValue);

/*************************************************************************************************************************
 Class definition for MetaDataGroup
**************************************************************************************************************************/

/**
* returns the number of metadata in this metadatagroup
*
* @param[in] pMetaDataGroup - MetaDataGroup instance.
* @param[out] pCount - returns the number metadata
* @return error code or 0 (success)
*/
typedef Lib3MFResult (*PLib3MFMetaDataGroup_GetMetaDataCountPtr) (Lib3MF_MetaDataGroup pMetaDataGroup, Lib3MF_uint32 * pCount);

/**
* returns a metadata value within this metadatagroup
*
* @param[in] pMetaDataGroup - MetaDataGroup instance.
* @param[in] nIndex - Index of the Metadata.
* @param[out] pMetaData - an instance of the metadata
* @return error code or 0 (success)
*/
typedef Lib3MFResult (*PLib3MFMetaDataGroup_GetMetaDataPtr) (Lib3MF_MetaDataGroup pMetaDataGroup, Lib3MF_uint32 nIndex, Lib3MF_MetaData * pMetaData);

/**
* returns a metadata value within this metadatagroup
*
* @param[in] pMetaDataGroup - MetaDataGroup instance.
* @param[in] pNameSpace - the namespace of the metadata
* @param[in] pName - the name of the Metadata
* @param[out] pMetaData - an instance of the metadata
* @return error code or 0 (success)
*/
typedef Lib3MFResult (*PLib3MFMetaDataGroup_GetMetaDataByKeyPtr) (Lib3MF_MetaDataGroup pMetaDataGroup, const char * pNameSpace, const char * pName, Lib3MF_MetaData * pMetaData);

/**
* removes metadata by index from the model.
*
* @param[in] pMetaDataGroup - MetaDataGroup instance.
* @param[in] nIndex -  Index of the metadata to remove
* @return error code or 0 (success)
*/
typedef Lib3MFResult (*PLib3MFMetaDataGroup_RemoveMetaDataByIndexPtr) (Lib3MF_MetaDataGroup pMetaDataGroup, Lib3MF_uint32 nIndex);

/**
* removes metadata from the model.
*
* @param[in] pMetaDataGroup - MetaDataGroup instance.
* @param[in] pTheMetaData - The metadata to remove
* @return error code or 0 (success)
*/
typedef Lib3MFResult (*PLib3MFMetaDataGroup_RemoveMetaDataPtr) (Lib3MF_MetaDataGroup pMetaDataGroup, Lib3MF_MetaData pTheMetaData);

/**
* adds a new metadata to this metadatagroup
*
* @param[in] pMetaDataGroup - MetaDataGroup instance.
* @param[in] pNameSpace - the namespace of the metadata
* @param[in] pName - the name of the metadata
* @param[in] pValue - the value of the metadata
* @param[in] pType - the type of the metadata
* @param[in] bMustPreserve - shuold the metadata be preserved
* @param[out] pMetaData - a new instance of the metadata
* @return error code or 0 (success)
*/
typedef Lib3MFResult (*PLib3MFMetaDataGroup_AddMetaDataPtr) (Lib3MF_MetaDataGroup pMetaDataGroup, const char * pNameSpace, const char * pName, const char * pValue, const char * pType, bool bMustPreserve, Lib3MF_MetaData * pMetaData);

/*************************************************************************************************************************
 Class definition for Object
**************************************************************************************************************************/

/**
* Retrieves an object's type
*
* @param[in] pObject - Object instance.
* @param[out] pObjectType - returns object type enum.
* @return error code or 0 (success)
*/
typedef Lib3MFResult (*PLib3MFObject_GetTypePtr) (Lib3MF_Object pObject, eLib3MFObjectType * pObjectType);

/**
* Sets an object's type
*
* @param[in] pObject - Object instance.
* @param[in] eObjectType - object type enum.
* @return error code or 0 (success)
*/
typedef Lib3MFResult (*PLib3MFObject_SetTypePtr) (Lib3MF_Object pObject, eLib3MFObjectType eObjectType);

/**
* Retrieves an object's name
*
* @param[in] pObject - Object instance.
* @param[in] nNameBufferSize - size of the buffer (including trailing 0)
* @param[out] pNameNeededChars - will be filled with the count of the written bytes, or needed buffer size.
* @param[out] pNameBuffer -  buffer of returns object name., may be NULL
* @return error code or 0 (success)
*/
typedef Lib3MFResult (*PLib3MFObject_GetNamePtr) (Lib3MF_Object pObject, const Lib3MF_uint32 nNameBufferSize, Lib3MF_uint32* pNameNeededChars, char * pNameBuffer);

/**
* Sets an object's name string
*
* @param[in] pObject - Object instance.
* @param[in] pName - new object name.
* @return error code or 0 (success)
*/
typedef Lib3MFResult (*PLib3MFObject_SetNamePtr) (Lib3MF_Object pObject, const char * pName);

/**
* Retrieves an object's part number
*
* @param[in] pObject - Object instance.
* @param[in] nPartNumberBufferSize - size of the buffer (including trailing 0)
* @param[out] pPartNumberNeededChars - will be filled with the count of the written bytes, or needed buffer size.
* @param[out] pPartNumberBuffer -  buffer of returns object part number., may be NULL
* @return error code or 0 (success)
*/
typedef Lib3MFResult (*PLib3MFObject_GetPartNumberPtr) (Lib3MF_Object pObject, const Lib3MF_uint32 nPartNumberBufferSize, Lib3MF_uint32* pPartNumberNeededChars, char * pPartNumberBuffer);

/**
* Sets an objects partnumber string
*
* @param[in] pObject - Object instance.
* @param[in] pPartNumber - new object part number.
* @return error code or 0 (success)
*/
typedef Lib3MFResult (*PLib3MFObject_SetPartNumberPtr) (Lib3MF_Object pObject, const char * pPartNumber);

/**
* Retrieves, if an object is a mesh object
*
* @param[in] pObject - Object instance.
* @param[out] pIsMeshObject - returns, whether the object is a mesh object
* @return error code or 0 (success)
*/
typedef Lib3MFResult (*PLib3MFObject_IsMeshObjectPtr) (Lib3MF_Object pObject, bool * pIsMeshObject);

/**
* Retrieves, if an object is a components object
*
* @param[in] pObject - Object instance.
* @param[out] pIsComponentsObject - returns, whether the object is a components object
* @return error code or 0 (success)
*/
typedef Lib3MFResult (*PLib3MFObject_IsComponentsObjectPtr) (Lib3MF_Object pObject, bool * pIsComponentsObject);

/**
* Retrieves, if the object is valid according to the core spec. For mesh objects, we distinguish between the type attribute of the object:In case of object type other, this always means false.In case of object type model or solidsupport, this means, if the mesh suffices all requirements of the core spec chapter 4.1.In case of object type support or surface, this always means true.A component objects is valid if and only if it contains at least one component and all child components are valid objects.
*
* @param[in] pObject - Object instance.
* @param[out] pIsValid - returns whether the object is a valid object description
* @return error code or 0 (success)
*/
typedef Lib3MFResult (*PLib3MFObject_IsValidPtr) (Lib3MF_Object pObject, bool * pIsValid);

/**
* Use an existing attachment as thumbnail for this object
*
* @param[in] pObject - Object instance.
* @param[in] pAttachment - Instance of a new or the existing thumbnailattachment object.
* @return error code or 0 (success)
*/
typedef Lib3MFResult (*PLib3MFObject_SetAttachmentAsThumbnailPtr) (Lib3MF_Object pObject, Lib3MF_Attachment pAttachment);

/**
* Get the attachment containing the object thumbnail.
*
* @param[in] pObject - Object instance.
* @param[out] pAttachment - Instance of the thumbnailattachment object or NULL.
* @return error code or 0 (success)
*/
typedef Lib3MFResult (*PLib3MFObject_GetThumbnailAttachmentPtr) (Lib3MF_Object pObject, Lib3MF_Attachment * pAttachment);

/**
* Clears the attachment. The attachment instance is not removed from the package.
*
* @param[in] pObject - Object instance.
* @return error code or 0 (success)
*/
typedef Lib3MFResult (*PLib3MFObject_ClearThumbnailAttachmentPtr) (Lib3MF_Object pObject);

/**
* Returns the outbox of a build item
*
* @param[in] pObject - Object instance.
* @param[out] pOutbox - Outbox of this build item
* @return error code or 0 (success)
*/
typedef Lib3MFResult (*PLib3MFObject_GetOutboxPtr) (Lib3MF_Object pObject, sLib3MFBox * pOutbox);

/**
* Retrieves an object's uuid string (see production extension specification)
*
* @param[in] pObject - Object instance.
* @param[out] pHasUUID - flag whether the build item has a UUID
* @param[in] nUUIDBufferSize - size of the buffer (including trailing 0)
* @param[out] pUUIDNeededChars - will be filled with the count of the written bytes, or needed buffer size.
* @param[out] pUUIDBuffer -  buffer of returns object uuid., may be NULL
* @return error code or 0 (success)
*/
typedef Lib3MFResult (*PLib3MFObject_GetUUIDPtr) (Lib3MF_Object pObject, bool * pHasUUID, const Lib3MF_uint32 nUUIDBufferSize, Lib3MF_uint32* pUUIDNeededChars, char * pUUIDBuffer);

/**
* Sets a build object's uuid string (see production extension specification)
*
* @param[in] pObject - Object instance.
* @param[in] pUUID - new object uuid string.
* @return error code or 0 (success)
*/
typedef Lib3MFResult (*PLib3MFObject_SetUUIDPtr) (Lib3MF_Object pObject, const char * pUUID);

/**
* Returns the metadatagroup of this object
*
* @param[in] pObject - Object instance.
* @param[out] pMetaDataGroup - returns an Instance of the metadatagroup of this object
* @return error code or 0 (success)
*/
typedef Lib3MFResult (*PLib3MFObject_GetMetaDataGroupPtr) (Lib3MF_Object pObject, Lib3MF_MetaDataGroup * pMetaDataGroup);

/**
* set the meshresolution of the mesh object
*
* @param[in] pObject - Object instance.
* @param[in] eMeshResolution - meshresolution of this object
* @return error code or 0 (success)
*/
typedef Lib3MFResult (*PLib3MFObject_SetSlicesMeshResolutionPtr) (Lib3MF_Object pObject, eLib3MFSlicesMeshResolution eMeshResolution);

/**
* get the meshresolution of the mesh object
*
* @param[in] pObject - Object instance.
* @param[out] pMeshResolution - meshresolution of this object
* @return error code or 0 (success)
*/
typedef Lib3MFResult (*PLib3MFObject_GetSlicesMeshResolutionPtr) (Lib3MF_Object pObject, eLib3MFSlicesMeshResolution * pMeshResolution);

/**
* returns whether the Object has a slice stack. If Recursive is true, also checks whether any references object has a slice stack
*
* @param[in] pObject - Object instance.
* @param[in] bRecursive - check also all referenced objects?
* @param[out] pHasSlices - does the object have a slice stack?
* @return error code or 0 (success)
*/
typedef Lib3MFResult (*PLib3MFObject_HasSlicesPtr) (Lib3MF_Object pObject, bool bRecursive, bool * pHasSlices);

/**
* unlinks the attached slicestack from this object. If no slice stack is attached, do noting.
*
* @param[in] pObject - Object instance.
* @return error code or 0 (success)
*/
typedef Lib3MFResult (*PLib3MFObject_ClearSliceStackPtr) (Lib3MF_Object pObject);

/**
* get the Slicestack attached to the object
*
* @param[in] pObject - Object instance.
* @param[out] pSliceStackInstance - returns the slicestack instance
* @return error code or 0 (success)
*/
typedef Lib3MFResult (*PLib3MFObject_GetSliceStackPtr) (Lib3MF_Object pObject, Lib3MF_SliceStack * pSliceStackInstance);

/**
* assigns a slicestack to the object
*
* @param[in] pObject - Object instance.
* @param[in] pSliceStackInstance - the new slice stack of this Object
* @return error code or 0 (success)
*/
typedef Lib3MFResult (*PLib3MFObject_AssignSliceStackPtr) (Lib3MF_Object pObject, Lib3MF_SliceStack pSliceStackInstance);

/*************************************************************************************************************************
 Class definition for MeshObject
**************************************************************************************************************************/

/**
* Returns the vertex count of a mesh object.
*
* @param[in] pMeshObject - MeshObject instance.
* @param[out] pVertexCount - filled with the vertex count.
* @return error code or 0 (success)
*/
typedef Lib3MFResult (*PLib3MFMeshObject_GetVertexCountPtr) (Lib3MF_MeshObject pMeshObject, Lib3MF_uint32 * pVertexCount);

/**
* Returns the triangle count of a mesh object.
*
* @param[in] pMeshObject - MeshObject instance.
* @param[out] pVertexCount - filled with the triangle count.
* @return error code or 0 (success)
*/
typedef Lib3MFResult (*PLib3MFMeshObject_GetTriangleCountPtr) (Lib3MF_MeshObject pMeshObject, Lib3MF_uint32 * pVertexCount);

/**
* Returns the vertex count of a mesh object.
*
* @param[in] pMeshObject - MeshObject instance.
* @param[in] nIndex - Index of the vertex (0 to vertexcount - 1)
* @param[out] pCoordinates - filled with the vertex coordinates.
* @return error code or 0 (success)
*/
typedef Lib3MFResult (*PLib3MFMeshObject_GetVertexPtr) (Lib3MF_MeshObject pMeshObject, Lib3MF_uint32 nIndex, sLib3MFPosition * pCoordinates);

/**
* Sets the coordinates of a single vertex of a mesh object
*
* @param[in] pMeshObject - MeshObject instance.
* @param[in] nIndex - Index of the vertex (0 to vertexcount - 1)
* @param[in] pCoordinates - contains the vertex coordinates.
* @return error code or 0 (success)
*/
typedef Lib3MFResult (*PLib3MFMeshObject_SetVertexPtr) (Lib3MF_MeshObject pMeshObject, Lib3MF_uint32 nIndex, const sLib3MFPosition * pCoordinates);

/**
* Adds a single vertex to a mesh object
*
* @param[in] pMeshObject - MeshObject instance.
* @param[in] pCoordinates - contains the vertex coordinates.
* @param[out] pNewIndex - Index of the new vertex
* @return error code or 0 (success)
*/
typedef Lib3MFResult (*PLib3MFMeshObject_AddVertexPtr) (Lib3MF_MeshObject pMeshObject, const sLib3MFPosition * pCoordinates, Lib3MF_uint32 * pNewIndex);

/**
* Obtains all vertex positions of a mesh object
*
* @param[in] pMeshObject - MeshObject instance.
* @param[in] nVerticesBufferSize - Number of elements in buffer
* @param[out] pVerticesNeededCount - will be filled with the count of the written elements, or needed buffer size.
* @param[out] pVerticesBuffer - Position  buffer of contains the vertex coordinates.
* @return error code or 0 (success)
*/
typedef Lib3MFResult (*PLib3MFMeshObject_GetVerticesPtr) (Lib3MF_MeshObject pMeshObject, const Lib3MF_uint64 nVerticesBufferSize, Lib3MF_uint64* pVerticesNeededCount, sLib3MFPosition * pVerticesBuffer);

/**
* Returns indices of a single triangle of a mesh object.
*
* @param[in] pMeshObject - MeshObject instance.
* @param[in] nIndex - Index of the triangle (0 to trianglecount - 1)
* @param[out] pIndices - filled with the triangle indices.
* @return error code or 0 (success)
*/
typedef Lib3MFResult (*PLib3MFMeshObject_GetTrianglePtr) (Lib3MF_MeshObject pMeshObject, Lib3MF_uint32 nIndex, sLib3MFTriangle * pIndices);

/**
* Sets the indices of a single triangle of a mesh object.
*
* @param[in] pMeshObject - MeshObject instance.
* @param[in] nIndex - Index of the triangle (0 to trianglecount - 1)
* @param[in] pIndices - contains the triangle indices.
* @return error code or 0 (success)
*/
typedef Lib3MFResult (*PLib3MFMeshObject_SetTrianglePtr) (Lib3MF_MeshObject pMeshObject, Lib3MF_uint32 nIndex, const sLib3MFTriangle * pIndices);

/**
* Adds a single triangle to a mesh object
*
* @param[in] pMeshObject - MeshObject instance.
* @param[in] pIndices - contains the triangle indices.
* @param[out] pNewIndex - Index of the new triangle
* @return error code or 0 (success)
*/
typedef Lib3MFResult (*PLib3MFMeshObject_AddTrianglePtr) (Lib3MF_MeshObject pMeshObject, const sLib3MFTriangle * pIndices, Lib3MF_uint32 * pNewIndex);

/**
* Get all triangles of a mesh object
*
* @param[in] pMeshObject - MeshObject instance.
* @param[in] nIndicesBufferSize - Number of elements in buffer
* @param[out] pIndicesNeededCount - will be filled with the count of the written elements, or needed buffer size.
* @param[out] pIndicesBuffer - Triangle  buffer of contains the triangle indices.
* @return error code or 0 (success)
*/
typedef Lib3MFResult (*PLib3MFMeshObject_GetTriangleIndicesPtr) (Lib3MF_MeshObject pMeshObject, const Lib3MF_uint64 nIndicesBufferSize, Lib3MF_uint64* pIndicesNeededCount, sLib3MFTriangle * pIndicesBuffer);

/**
* Sets the property at the object-level of the mesh object.
*
* @param[in] pMeshObject - MeshObject instance.
* @param[in] nUniqueResourceID - the object-level Property UniqueResourceID.
* @param[in] nPropertyID - the object-level PropertyID.
* @return error code or 0 (success)
*/
typedef Lib3MFResult (*PLib3MFMeshObject_SetObjectLevelPropertyPtr) (Lib3MF_MeshObject pMeshObject, Lib3MF_uint32 nUniqueResourceID, Lib3MF_uint32 nPropertyID);

/**
* Gets the property at the object-level of the mesh object.
*
* @param[in] pMeshObject - MeshObject instance.
* @param[out] pUniqueResourceID - the object-level Property UniqueResourceID.
* @param[out] pPropertyID - the object-level PropertyID.
* @param[out] pHasObjectLevelProperty - Has an object-level property been specified?
* @return error code or 0 (success)
*/
typedef Lib3MFResult (*PLib3MFMeshObject_GetObjectLevelPropertyPtr) (Lib3MF_MeshObject pMeshObject, Lib3MF_uint32 * pUniqueResourceID, Lib3MF_uint32 * pPropertyID, bool * pHasObjectLevelProperty);

/**
* Sets the properties of a single triangle of a mesh object.
*
* @param[in] pMeshObject - MeshObject instance.
* @param[in] nIndex - Index of the triangle (0 to trianglecount - 1)
* @param[in] pProperties - contains the triangle properties.
* @return error code or 0 (success)
*/
typedef Lib3MFResult (*PLib3MFMeshObject_SetTrianglePropertiesPtr) (Lib3MF_MeshObject pMeshObject, Lib3MF_uint32 nIndex, const sLib3MFTriangleProperties * pProperties);

/**
* Gets the properties of a single triangle of a mesh object.
*
* @param[in] pMeshObject - MeshObject instance.
* @param[in] nIndex - Index of the triangle (0 to trianglecount - 1)
* @param[out] pProperty - returns the triangle properties.
* @return error code or 0 (success)
*/
typedef Lib3MFResult (*PLib3MFMeshObject_GetTrianglePropertiesPtr) (Lib3MF_MeshObject pMeshObject, Lib3MF_uint32 nIndex, sLib3MFTriangleProperties * pProperty);

/**
* Sets the properties of all triangles of a mesh object. Sets the object level property to the first entry of the passed triangle properties, if not yet specified.
*
* @param[in] pMeshObject - MeshObject instance.
* @param[in] nPropertiesArrayBufferSize - Number of elements in buffer
* @param[in] pPropertiesArrayBuffer - TriangleProperties buffer of contains the triangle properties array. Must have trianglecount elements.
* @return error code or 0 (success)
*/
typedef Lib3MFResult (*PLib3MFMeshObject_SetAllTrianglePropertiesPtr) (Lib3MF_MeshObject pMeshObject, Lib3MF_uint64 nPropertiesArrayBufferSize, const sLib3MFTriangleProperties * pPropertiesArrayBuffer);

/**
* Gets the properties of all triangles of a mesh object.
*
* @param[in] pMeshObject - MeshObject instance.
* @param[in] nPropertiesArrayBufferSize - Number of elements in buffer
* @param[out] pPropertiesArrayNeededCount - will be filled with the count of the written elements, or needed buffer size.
* @param[out] pPropertiesArrayBuffer - TriangleProperties  buffer of returns the triangle properties array. Must have trianglecount elements.
* @return error code or 0 (success)
*/
typedef Lib3MFResult (*PLib3MFMeshObject_GetAllTrianglePropertiesPtr) (Lib3MF_MeshObject pMeshObject, const Lib3MF_uint64 nPropertiesArrayBufferSize, Lib3MF_uint64* pPropertiesArrayNeededCount, sLib3MFTriangleProperties * pPropertiesArrayBuffer);

/**
* Clears all properties of this mesh object (triangle and object-level).
*
* @param[in] pMeshObject - MeshObject instance.
* @return error code or 0 (success)
*/
typedef Lib3MFResult (*PLib3MFMeshObject_ClearAllPropertiesPtr) (Lib3MF_MeshObject pMeshObject);

/**
* Set all triangles of a mesh object
*
* @param[in] pMeshObject - MeshObject instance.
* @param[in] nVerticesBufferSize - Number of elements in buffer
* @param[in] pVerticesBuffer - Position buffer of contains the positions.
* @param[in] nIndicesBufferSize - Number of elements in buffer
* @param[in] pIndicesBuffer - Triangle buffer of contains the triangle indices.
* @return error code or 0 (success)
*/
typedef Lib3MFResult (*PLib3MFMeshObject_SetGeometryPtr) (Lib3MF_MeshObject pMeshObject, Lib3MF_uint64 nVerticesBufferSize, const sLib3MFPosition * pVerticesBuffer, Lib3MF_uint64 nIndicesBufferSize, const sLib3MFTriangle * pIndicesBuffer);

/**
* Retrieves, if an object describes a topologically oriented and manifold mesh, according to the core spec.
*
* @param[in] pMeshObject - MeshObject instance.
* @param[out] pIsManifoldAndOriented - returns, if the object is oriented and manifold.
* @return error code or 0 (success)
*/
typedef Lib3MFResult (*PLib3MFMeshObject_IsManifoldAndOrientedPtr) (Lib3MF_MeshObject pMeshObject, bool * pIsManifoldAndOriented);

/**
* Retrieves the BeamLattice within this MeshObject.
*
* @param[in] pMeshObject - MeshObject instance.
* @param[out] pTheBeamLattice - the BeamLattice within this MeshObject
* @return error code or 0 (success)
*/
typedef Lib3MFResult (*PLib3MFMeshObject_BeamLatticePtr) (Lib3MF_MeshObject pMeshObject, Lib3MF_BeamLattice * pTheBeamLattice);

/*************************************************************************************************************************
 Class definition for BeamLattice
**************************************************************************************************************************/

/**
* Returns the minimal length of beams for the beamlattice.
*
* @param[in] pBeamLattice - BeamLattice instance.
* @param[out] pMinLength - minimal length of beams for the beamlattice
* @return error code or 0 (success)
*/
typedef Lib3MFResult (*PLib3MFBeamLattice_GetMinLengthPtr) (Lib3MF_BeamLattice pBeamLattice, Lib3MF_double * pMinLength);

/**
* Sets the minimal length of beams for the beamlattice.
*
* @param[in] pBeamLattice - BeamLattice instance.
* @param[in] dMinLength - minimal length of beams for the beamlattice
* @return error code or 0 (success)
*/
typedef Lib3MFResult (*PLib3MFBeamLattice_SetMinLengthPtr) (Lib3MF_BeamLattice pBeamLattice, Lib3MF_double dMinLength);

/**
* Returns the clipping mode and the clipping-mesh for the beamlattice of this mesh.
*
* @param[in] pBeamLattice - BeamLattice instance.
* @param[out] pClipMode - contains the clip mode of this mesh
* @param[out] pUniqueResourceID - filled with the UniqueResourceID of the clipping mesh-object or an undefined value if pClipMode is MODELBEAMLATTICECLIPMODE_NONE
* @return error code or 0 (success)
*/
typedef Lib3MFResult (*PLib3MFBeamLattice_GetClippingPtr) (Lib3MF_BeamLattice pBeamLattice, eLib3MFBeamLatticeClipMode * pClipMode, Lib3MF_uint32 * pUniqueResourceID);

/**
* Sets the clipping mode and the clipping-mesh for the beamlattice of this mesh.
*
* @param[in] pBeamLattice - BeamLattice instance.
* @param[in] eClipMode - contains the clip mode of this mesh
* @param[in] nUniqueResourceID - the UniqueResourceID of the clipping mesh-object. This mesh-object has to be defined before setting the Clipping.
* @return error code or 0 (success)
*/
typedef Lib3MFResult (*PLib3MFBeamLattice_SetClippingPtr) (Lib3MF_BeamLattice pBeamLattice, eLib3MFBeamLatticeClipMode eClipMode, Lib3MF_uint32 nUniqueResourceID);

/**
* Returns the representation-mesh for the beamlattice of this mesh.
*
* @param[in] pBeamLattice - BeamLattice instance.
* @param[out] pHasRepresentation - flag whether the beamlattice has a representation mesh.
* @param[out] pUniqueResourceID - filled with the UniqueResourceID of the clipping mesh-object.
* @return error code or 0 (success)
*/
typedef Lib3MFResult (*PLib3MFBeamLattice_GetRepresentationPtr) (Lib3MF_BeamLattice pBeamLattice, bool * pHasRepresentation, Lib3MF_uint32 * pUniqueResourceID);

/**
* Sets the representation-mesh for the beamlattice of this mesh.
*
* @param[in] pBeamLattice - BeamLattice instance.
* @param[in] nUniqueResourceID - the UniqueResourceID of the representation mesh-object. This mesh-object has to be defined before setting the representation.
* @return error code or 0 (success)
*/
typedef Lib3MFResult (*PLib3MFBeamLattice_SetRepresentationPtr) (Lib3MF_BeamLattice pBeamLattice, Lib3MF_uint32 nUniqueResourceID);

/**
* Returns the ball mode and the default ball radius for the beamlattice of this mesh.
*
* @param[in] pBeamLattice - BeamLattice instance.
* @param[out] pBallMode - contains the ball mode of this mesh
* @param[out] pBallRadius - default ball radius of balls for the beamlattice
* @return error code or 0 (success)
*/
typedef Lib3MFResult (*PLib3MFBeamLattice_GetBallOptionsPtr) (Lib3MF_BeamLattice pBeamLattice, eLib3MFBeamLatticeBallMode * pBallMode, Lib3MF_double * pBallRadius);

/**
* Sets the ball mode and thedefault ball radius for the beamlattice.
*
* @param[in] pBeamLattice - BeamLattice instance.
* @param[in] eBallMode - contains the ball mode of this mesh
* @param[in] dBallRadius - default ball radius of balls for the beamlattice
* @return error code or 0 (success)
*/
typedef Lib3MFResult (*PLib3MFBeamLattice_SetBallOptionsPtr) (Lib3MF_BeamLattice pBeamLattice, eLib3MFBeamLatticeBallMode eBallMode, Lib3MF_double dBallRadius);

/**
* Returns the beam count of a mesh object.
*
* @param[in] pBeamLattice - BeamLattice instance.
* @param[out] pCount - filled with the beam count.
* @return error code or 0 (success)
*/
typedef Lib3MFResult (*PLib3MFBeamLattice_GetBeamCountPtr) (Lib3MF_BeamLattice pBeamLattice, Lib3MF_uint32 * pCount);

/**
* Returns indices, radii and capmodes of a single beam of a mesh object.
*
* @param[in] pBeamLattice - BeamLattice instance.
* @param[in] nIndex - Index of the beam (0 to beamcount - 1).
* @param[out] pBeamInfo - filled with the beam indices, radii and capmodes.
* @return error code or 0 (success)
*/
typedef Lib3MFResult (*PLib3MFBeamLattice_GetBeamPtr) (Lib3MF_BeamLattice pBeamLattice, Lib3MF_uint32 nIndex, sLib3MFBeam * pBeamInfo);

/**
* Adds a single beam to a mesh object.
*
* @param[in] pBeamLattice - BeamLattice instance.
* @param[in] pBeamInfo - contains the node indices, radii and capmodes.
* @param[out] pIndex - filled with the new Index of the beam.
* @return error code or 0 (success)
*/
typedef Lib3MFResult (*PLib3MFBeamLattice_AddBeamPtr) (Lib3MF_BeamLattice pBeamLattice, const sLib3MFBeam * pBeamInfo, Lib3MF_uint32 * pIndex);

/**
* Sets the indices, radii and capmodes of a single beam of a mesh object.
*
* @param[in] pBeamLattice - BeamLattice instance.
* @param[in] nIndex - Index of the beam (0 to beamcount - 1).
* @param[in] pBeamInfo - filled with the beam indices, radii and capmodes.
* @return error code or 0 (success)
*/
typedef Lib3MFResult (*PLib3MFBeamLattice_SetBeamPtr) (Lib3MF_BeamLattice pBeamLattice, Lib3MF_uint32 nIndex, const sLib3MFBeam * pBeamInfo);

/**
* Sets all beam indices, radii and capmodes of a mesh object.
*
* @param[in] pBeamLattice - BeamLattice instance.
* @param[in] nBeamInfoBufferSize - Number of elements in buffer
* @param[in] pBeamInfoBuffer - Beam buffer of contains information of a number of  beams
* @return error code or 0 (success)
*/
typedef Lib3MFResult (*PLib3MFBeamLattice_SetBeamsPtr) (Lib3MF_BeamLattice pBeamLattice, Lib3MF_uint64 nBeamInfoBufferSize, const sLib3MFBeam * pBeamInfoBuffer);

/**
* obtains all beam indices, radii and capmodes of a mesh object.
*
* @param[in] pBeamLattice - BeamLattice instance.
* @param[in] nBeamInfoBufferSize - Number of elements in buffer
* @param[out] pBeamInfoNeededCount - will be filled with the count of the written elements, or needed buffer size.
* @param[out] pBeamInfoBuffer - Beam  buffer of contains information of all beams
* @return error code or 0 (success)
*/
typedef Lib3MFResult (*PLib3MFBeamLattice_GetBeamsPtr) (Lib3MF_BeamLattice pBeamLattice, const Lib3MF_uint64 nBeamInfoBufferSize, Lib3MF_uint64* pBeamInfoNeededCount, sLib3MFBeam * pBeamInfoBuffer);

/**
* Returns the ball count of a mesh object.
*
* @param[in] pBeamLattice - BeamLattice instance.
* @param[out] pCount - filled with the ball count.
* @return error code or 0 (success)
*/
typedef Lib3MFResult (*PLib3MFBeamLattice_GetBallCountPtr) (Lib3MF_BeamLattice pBeamLattice, Lib3MF_uint32 * pCount);

/**
* Returns index and radius of a single ball of a mesh object.
*
* @param[in] pBeamLattice - BeamLattice instance.
* @param[in] nIndex - Index of the ball (0 to ballcount - 1).
* @param[out] pBallInfo - filled with the ball node index and radius.
* @return error code or 0 (success)
*/
typedef Lib3MFResult (*PLib3MFBeamLattice_GetBallPtr) (Lib3MF_BeamLattice pBeamLattice, Lib3MF_uint32 nIndex, sLib3MFBall * pBallInfo);

/**
* Adds a single ball to a mesh object.
*
* @param[in] pBeamLattice - BeamLattice instance.
* @param[in] pBallInfo - contains the node index and radius.
* @param[out] pIndex - filled with the new Index of the ball.
* @return error code or 0 (success)
*/
typedef Lib3MFResult (*PLib3MFBeamLattice_AddBallPtr) (Lib3MF_BeamLattice pBeamLattice, const sLib3MFBall * pBallInfo, Lib3MF_uint32 * pIndex);

/**
* Sets the index and radius of a single ball of a mesh object.
*
* @param[in] pBeamLattice - BeamLattice instance.
* @param[in] nIndex - Index of the ball (0 to ballcount - 1).
* @param[in] pBallInfo - filled with the ball node index and radius.
* @return error code or 0 (success)
*/
typedef Lib3MFResult (*PLib3MFBeamLattice_SetBallPtr) (Lib3MF_BeamLattice pBeamLattice, Lib3MF_uint32 nIndex, const sLib3MFBall * pBallInfo);

/**
* Sets all ball indices and radii of a mesh object.
*
* @param[in] pBeamLattice - BeamLattice instance.
* @param[in] nBallInfoBufferSize - Number of elements in buffer
* @param[in] pBallInfoBuffer - Ball buffer of contains information of a number of  balls
* @return error code or 0 (success)
*/
typedef Lib3MFResult (*PLib3MFBeamLattice_SetBallsPtr) (Lib3MF_BeamLattice pBeamLattice, Lib3MF_uint64 nBallInfoBufferSize, const sLib3MFBall * pBallInfoBuffer);

/**
* obtains all ball indices and radii of a mesh object.
*
* @param[in] pBeamLattice - BeamLattice instance.
* @param[in] nBallInfoBufferSize - Number of elements in buffer
* @param[out] pBallInfoNeededCount - will be filled with the count of the written elements, or needed buffer size.
* @param[out] pBallInfoBuffer - Ball  buffer of contains information of all balls
* @return error code or 0 (success)
*/
typedef Lib3MFResult (*PLib3MFBeamLattice_GetBallsPtr) (Lib3MF_BeamLattice pBeamLattice, const Lib3MF_uint64 nBallInfoBufferSize, Lib3MF_uint64* pBallInfoNeededCount, sLib3MFBall * pBallInfoBuffer);

/**
* Returns the number of beamsets of a mesh object.
*
* @param[in] pBeamLattice - BeamLattice instance.
* @param[out] pCount - filled with the beamset count.
* @return error code or 0 (success)
*/
typedef Lib3MFResult (*PLib3MFBeamLattice_GetBeamSetCountPtr) (Lib3MF_BeamLattice pBeamLattice, Lib3MF_uint32 * pCount);

/**
* Adds an empty beamset to a mesh object
*
* @param[in] pBeamLattice - BeamLattice instance.
* @param[out] pBeamSet - the new beamset
* @return error code or 0 (success)
*/
typedef Lib3MFResult (*PLib3MFBeamLattice_AddBeamSetPtr) (Lib3MF_BeamLattice pBeamLattice, Lib3MF_BeamSet * pBeamSet);

/**
* Returns a beamset of a mesh object
*
* @param[in] pBeamLattice - BeamLattice instance.
* @param[in] nIndex - index of the requested beamset (0 ... beamsetcount-1).
* @param[out] pBeamSet - the requested beamset
* @return error code or 0 (success)
*/
typedef Lib3MFResult (*PLib3MFBeamLattice_GetBeamSetPtr) (Lib3MF_BeamLattice pBeamLattice, Lib3MF_uint32 nIndex, Lib3MF_BeamSet * pBeamSet);

/*************************************************************************************************************************
 Class definition for Component
**************************************************************************************************************************/

/**
* Returns the Resource Instance of the component.
*
* @param[in] pComponent - Component instance.
* @param[out] pObjectResource - filled with the Resource Instance.
* @return error code or 0 (success)
*/
typedef Lib3MFResult (*PLib3MFComponent_GetObjectResourcePtr) (Lib3MF_Component pComponent, Lib3MF_Object * pObjectResource);

/**
* Returns the UniqueResourceID of the component.
*
* @param[in] pComponent - Component instance.
* @param[out] pUniqueResourceID - returns the UniqueResourceID.
* @return error code or 0 (success)
*/
typedef Lib3MFResult (*PLib3MFComponent_GetObjectResourceIDPtr) (Lib3MF_Component pComponent, Lib3MF_uint32 * pUniqueResourceID);

/**
* returns, whether a component has a UUID and, if true, the component's UUID
*
* @param[in] pComponent - Component instance.
* @param[out] pHasUUID - flag whether the component has a UUID
* @param[in] nUUIDBufferSize - size of the buffer (including trailing 0)
* @param[out] pUUIDNeededChars - will be filled with the count of the written bytes, or needed buffer size.
* @param[out] pUUIDBuffer -  buffer of the UUID as string of the form 'xxxxxxxx-xxxx-xxxx-xxxxxxxxxxxxxxxx', may be NULL
* @return error code or 0 (success)
*/
typedef Lib3MFResult (*PLib3MFComponent_GetUUIDPtr) (Lib3MF_Component pComponent, bool * pHasUUID, const Lib3MF_uint32 nUUIDBufferSize, Lib3MF_uint32* pUUIDNeededChars, char * pUUIDBuffer);

/**
* sets the component's UUID
*
* @param[in] pComponent - Component instance.
* @param[in] pUUID - the UUID as string of the form 'xxxxxxxx-xxxx-xxxx-xxxxxxxxxxxxxxxx'
* @return error code or 0 (success)
*/
typedef Lib3MFResult (*PLib3MFComponent_SetUUIDPtr) (Lib3MF_Component pComponent, const char * pUUID);

/**
* Returns, if the component has a different transformation than the identity matrix
*
* @param[in] pComponent - Component instance.
* @param[out] pHasTransform - if true is returned, the transformation is not equal than the identity
* @return error code or 0 (success)
*/
typedef Lib3MFResult (*PLib3MFComponent_HasTransformPtr) (Lib3MF_Component pComponent, bool * pHasTransform);

/**
* Returns the transformation matrix of the component.
*
* @param[in] pComponent - Component instance.
* @param[out] pTransform - filled with the component transformation matrix
* @return error code or 0 (success)
*/
typedef Lib3MFResult (*PLib3MFComponent_GetTransformPtr) (Lib3MF_Component pComponent, sLib3MFTransform * pTransform);

/**
* Sets the transformation matrix of the component.
*
* @param[in] pComponent - Component instance.
* @param[in] pTransform - new transformation matrix
* @return error code or 0 (success)
*/
typedef Lib3MFResult (*PLib3MFComponent_SetTransformPtr) (Lib3MF_Component pComponent, const sLib3MFTransform * pTransform);

/*************************************************************************************************************************
 Class definition for ComponentsObject
**************************************************************************************************************************/

/**
* Adds a new component to a components object.
*
* @param[in] pComponentsObject - ComponentsObject instance.
* @param[in] pObjectResource - object to add as component. Must not lead to circular references!
* @param[in] pTransform - optional transform matrix for the component.
* @param[out] pComponentInstance - new component instance
* @return error code or 0 (success)
*/
typedef Lib3MFResult (*PLib3MFComponentsObject_AddComponentPtr) (Lib3MF_ComponentsObject pComponentsObject, Lib3MF_Object pObjectResource, const sLib3MFTransform * pTransform, Lib3MF_Component * pComponentInstance);

/**
* Retrieves a component from a component object.
*
* @param[in] pComponentsObject - ComponentsObject instance.
* @param[in] nIndex - index of the component to retrieve (0 to componentcount - 1)
* @param[out] pComponentInstance - component instance
* @return error code or 0 (success)
*/
typedef Lib3MFResult (*PLib3MFComponentsObject_GetComponentPtr) (Lib3MF_ComponentsObject pComponentsObject, Lib3MF_uint32 nIndex, Lib3MF_Component * pComponentInstance);

/**
* Retrieves a component count of a component object.
*
* @param[in] pComponentsObject - ComponentsObject instance.
* @param[out] pCount - returns the component count
* @return error code or 0 (success)
*/
typedef Lib3MFResult (*PLib3MFComponentsObject_GetComponentCountPtr) (Lib3MF_ComponentsObject pComponentsObject, Lib3MF_uint32 * pCount);

/*************************************************************************************************************************
 Class definition for BeamSet
**************************************************************************************************************************/

/**
* Sets a beamset's name string
*
* @param[in] pBeamSet - BeamSet instance.
* @param[in] pName - new name of the beamset.
* @return error code or 0 (success)
*/
typedef Lib3MFResult (*PLib3MFBeamSet_SetNamePtr) (Lib3MF_BeamSet pBeamSet, const char * pName);

/**
* Retrieves a beamset's name string
*
* @param[in] pBeamSet - BeamSet instance.
* @param[in] nNameBufferSize - size of the buffer (including trailing 0)
* @param[out] pNameNeededChars - will be filled with the count of the written bytes, or needed buffer size.
* @param[out] pNameBuffer -  buffer of returns the name of the beamset., may be NULL
* @return error code or 0 (success)
*/
typedef Lib3MFResult (*PLib3MFBeamSet_GetNamePtr) (Lib3MF_BeamSet pBeamSet, const Lib3MF_uint32 nNameBufferSize, Lib3MF_uint32* pNameNeededChars, char * pNameBuffer);

/**
* Sets a beamset's identifier string
*
* @param[in] pBeamSet - BeamSet instance.
* @param[in] pIdentifier - new name of the beamset.
* @return error code or 0 (success)
*/
typedef Lib3MFResult (*PLib3MFBeamSet_SetIdentifierPtr) (Lib3MF_BeamSet pBeamSet, const char * pIdentifier);

/**
* Retrieves a beamset's identifier string
*
* @param[in] pBeamSet - BeamSet instance.
* @param[in] nIdentifierBufferSize - size of the buffer (including trailing 0)
* @param[out] pIdentifierNeededChars - will be filled with the count of the written bytes, or needed buffer size.
* @param[out] pIdentifierBuffer -  buffer of returns the identifier of the beamset., may be NULL
* @return error code or 0 (success)
*/
typedef Lib3MFResult (*PLib3MFBeamSet_GetIdentifierPtr) (Lib3MF_BeamSet pBeamSet, const Lib3MF_uint32 nIdentifierBufferSize, Lib3MF_uint32* pIdentifierNeededChars, char * pIdentifierBuffer);

/**
* Retrieves the reference count of a beamset
*
* @param[in] pBeamSet - BeamSet instance.
* @param[out] pCount - returns the reference count
* @return error code or 0 (success)
*/
typedef Lib3MFResult (*PLib3MFBeamSet_GetReferenceCountPtr) (Lib3MF_BeamSet pBeamSet, Lib3MF_uint32 * pCount);

/**
* Sets the references of a beamset
*
* @param[in] pBeamSet - BeamSet instance.
* @param[in] nReferencesBufferSize - Number of elements in buffer
* @param[in] pReferencesBuffer - uint32 buffer of the new indices of all beams in this beamset
* @return error code or 0 (success)
*/
typedef Lib3MFResult (*PLib3MFBeamSet_SetReferencesPtr) (Lib3MF_BeamSet pBeamSet, Lib3MF_uint64 nReferencesBufferSize, const Lib3MF_uint32 * pReferencesBuffer);

/**
* Retrieves the references of a beamset
*
* @param[in] pBeamSet - BeamSet instance.
* @param[in] nReferencesBufferSize - Number of elements in buffer
* @param[out] pReferencesNeededCount - will be filled with the count of the written elements, or needed buffer size.
* @param[out] pReferencesBuffer - uint32  buffer of retrieves the indices of all beams in this beamset
* @return error code or 0 (success)
*/
typedef Lib3MFResult (*PLib3MFBeamSet_GetReferencesPtr) (Lib3MF_BeamSet pBeamSet, const Lib3MF_uint64 nReferencesBufferSize, Lib3MF_uint64* pReferencesNeededCount, Lib3MF_uint32 * pReferencesBuffer);

/**
* Retrieves the ball reference count of a beamset
*
* @param[in] pBeamSet - BeamSet instance.
* @param[out] pCount - returns the ball reference count
* @return error code or 0 (success)
*/
typedef Lib3MFResult (*PLib3MFBeamSet_GetBallReferenceCountPtr) (Lib3MF_BeamSet pBeamSet, Lib3MF_uint32 * pCount);

/**
* Sets the ball references of a beamset
*
* @param[in] pBeamSet - BeamSet instance.
* @param[in] nBallReferencesBufferSize - Number of elements in buffer
* @param[in] pBallReferencesBuffer - uint32 buffer of the new indices of all balls in this beamset
* @return error code or 0 (success)
*/
typedef Lib3MFResult (*PLib3MFBeamSet_SetBallReferencesPtr) (Lib3MF_BeamSet pBeamSet, Lib3MF_uint64 nBallReferencesBufferSize, const Lib3MF_uint32 * pBallReferencesBuffer);

/**
* Retrieves the ball references of a beamset
*
* @param[in] pBeamSet - BeamSet instance.
* @param[in] nBallReferencesBufferSize - Number of elements in buffer
* @param[out] pBallReferencesNeededCount - will be filled with the count of the written elements, or needed buffer size.
* @param[out] pBallReferencesBuffer - uint32  buffer of retrieves the indices of all balls in this beamset
* @return error code or 0 (success)
*/
typedef Lib3MFResult (*PLib3MFBeamSet_GetBallReferencesPtr) (Lib3MF_BeamSet pBeamSet, const Lib3MF_uint64 nBallReferencesBufferSize, Lib3MF_uint64* pBallReferencesNeededCount, Lib3MF_uint32 * pBallReferencesBuffer);

/*************************************************************************************************************************
 Class definition for BaseMaterialGroup
**************************************************************************************************************************/

/**
* Retrieves the count of base materials in the material group.
*
* @param[in] pBaseMaterialGroup - BaseMaterialGroup instance.
* @param[out] pCount - returns the count of base materials.
* @return error code or 0 (success)
*/
typedef Lib3MFResult (*PLib3MFBaseMaterialGroup_GetCountPtr) (Lib3MF_BaseMaterialGroup pBaseMaterialGroup, Lib3MF_uint32 * pCount);

/**
* returns all the PropertyIDs of all materials in this group
*
* @param[in] pBaseMaterialGroup - BaseMaterialGroup instance.
* @param[in] nPropertyIDsBufferSize - Number of elements in buffer
* @param[out] pPropertyIDsNeededCount - will be filled with the count of the written elements, or needed buffer size.
* @param[out] pPropertyIDsBuffer - uint32  buffer of PropertyID of the material in the material group.
* @return error code or 0 (success)
*/
typedef Lib3MFResult (*PLib3MFBaseMaterialGroup_GetAllPropertyIDsPtr) (Lib3MF_BaseMaterialGroup pBaseMaterialGroup, const Lib3MF_uint64 nPropertyIDsBufferSize, Lib3MF_uint64* pPropertyIDsNeededCount, Lib3MF_uint32 * pPropertyIDsBuffer);

/**
* Adds a new material to the material group
*
* @param[in] pBaseMaterialGroup - BaseMaterialGroup instance.
* @param[in] pName - new name of the base material.
* @param[in] pDisplayColor - Display color of the material
* @param[out] pPropertyID - returns new PropertyID of the new material in the material group.
* @return error code or 0 (success)
*/
typedef Lib3MFResult (*PLib3MFBaseMaterialGroup_AddMaterialPtr) (Lib3MF_BaseMaterialGroup pBaseMaterialGroup, const char * pName, const sLib3MFColor * pDisplayColor, Lib3MF_uint32 * pPropertyID);

/**
* Removes a material from the material group.
*
* @param[in] pBaseMaterialGroup - BaseMaterialGroup instance.
* @param[in] nPropertyID - PropertyID of the material in the material group.
* @return error code or 0 (success)
*/
typedef Lib3MFResult (*PLib3MFBaseMaterialGroup_RemoveMaterialPtr) (Lib3MF_BaseMaterialGroup pBaseMaterialGroup, Lib3MF_uint32 nPropertyID);

/**
* Returns the base material's name
*
* @param[in] pBaseMaterialGroup - BaseMaterialGroup instance.
* @param[in] nPropertyID - PropertyID of the material in the material group.
* @param[in] nNameBufferSize - size of the buffer (including trailing 0)
* @param[out] pNameNeededChars - will be filled with the count of the written bytes, or needed buffer size.
* @param[out] pNameBuffer -  buffer of returns the name of the base material., may be NULL
* @return error code or 0 (success)
*/
typedef Lib3MFResult (*PLib3MFBaseMaterialGroup_GetNamePtr) (Lib3MF_BaseMaterialGroup pBaseMaterialGroup, Lib3MF_uint32 nPropertyID, const Lib3MF_uint32 nNameBufferSize, Lib3MF_uint32* pNameNeededChars, char * pNameBuffer);

/**
* Sets a base material's name
*
* @param[in] pBaseMaterialGroup - BaseMaterialGroup instance.
* @param[in] nPropertyID - PropertyID of the material in the material group.
* @param[in] pName - new name of the base material.
* @return error code or 0 (success)
*/
typedef Lib3MFResult (*PLib3MFBaseMaterialGroup_SetNamePtr) (Lib3MF_BaseMaterialGroup pBaseMaterialGroup, Lib3MF_uint32 nPropertyID, const char * pName);

/**
* Sets a base material's display color.
*
* @param[in] pBaseMaterialGroup - BaseMaterialGroup instance.
* @param[in] nPropertyID - PropertyID of the material in the material group.
* @param[in] pTheColor - The base material's display color
* @return error code or 0 (success)
*/
typedef Lib3MFResult (*PLib3MFBaseMaterialGroup_SetDisplayColorPtr) (Lib3MF_BaseMaterialGroup pBaseMaterialGroup, Lib3MF_uint32 nPropertyID, const sLib3MFColor * pTheColor);

/**
* Returns a base material's display color.
*
* @param[in] pBaseMaterialGroup - BaseMaterialGroup instance.
* @param[in] nPropertyID - PropertyID of the material in the material group.
* @param[out] pTheColor - The base material's display color
* @return error code or 0 (success)
*/
typedef Lib3MFResult (*PLib3MFBaseMaterialGroup_GetDisplayColorPtr) (Lib3MF_BaseMaterialGroup pBaseMaterialGroup, Lib3MF_uint32 nPropertyID, sLib3MFColor * pTheColor);

/*************************************************************************************************************************
 Class definition for ColorGroup
**************************************************************************************************************************/

/**
* Retrieves the count of base materials in this Color Group.
*
* @param[in] pColorGroup - ColorGroup instance.
* @param[out] pCount - returns the count of colors within this color group.
* @return error code or 0 (success)
*/
typedef Lib3MFResult (*PLib3MFColorGroup_GetCountPtr) (Lib3MF_ColorGroup pColorGroup, Lib3MF_uint32 * pCount);

/**
* returns all the PropertyIDs of all colors within this group
*
* @param[in] pColorGroup - ColorGroup instance.
* @param[in] nPropertyIDsBufferSize - Number of elements in buffer
* @param[out] pPropertyIDsNeededCount - will be filled with the count of the written elements, or needed buffer size.
* @param[out] pPropertyIDsBuffer - uint32  buffer of PropertyID of the color in the color group.
* @return error code or 0 (success)
*/
typedef Lib3MFResult (*PLib3MFColorGroup_GetAllPropertyIDsPtr) (Lib3MF_ColorGroup pColorGroup, const Lib3MF_uint64 nPropertyIDsBufferSize, Lib3MF_uint64* pPropertyIDsNeededCount, Lib3MF_uint32 * pPropertyIDsBuffer);

/**
* Adds a new value.
*
* @param[in] pColorGroup - ColorGroup instance.
* @param[in] pTheColor - The new color
* @param[out] pPropertyID - PropertyID of the new color within this color group.
* @return error code or 0 (success)
*/
typedef Lib3MFResult (*PLib3MFColorGroup_AddColorPtr) (Lib3MF_ColorGroup pColorGroup, const sLib3MFColor * pTheColor, Lib3MF_uint32 * pPropertyID);

/**
* Removes a color from the color group.
*
* @param[in] pColorGroup - ColorGroup instance.
* @param[in] nPropertyID - PropertyID of the color to be removed from the color group.
* @return error code or 0 (success)
*/
typedef Lib3MFResult (*PLib3MFColorGroup_RemoveColorPtr) (Lib3MF_ColorGroup pColorGroup, Lib3MF_uint32 nPropertyID);

/**
* Sets a color value.
*
* @param[in] pColorGroup - ColorGroup instance.
* @param[in] nPropertyID - PropertyID of a color within this color group.
* @param[in] pTheColor - The color
* @return error code or 0 (success)
*/
typedef Lib3MFResult (*PLib3MFColorGroup_SetColorPtr) (Lib3MF_ColorGroup pColorGroup, Lib3MF_uint32 nPropertyID, const sLib3MFColor * pTheColor);

/**
* Sets a color value.
*
* @param[in] pColorGroup - ColorGroup instance.
* @param[in] nPropertyID - PropertyID of a color within this color group.
* @param[out] pTheColor - The color
* @return error code or 0 (success)
*/
typedef Lib3MFResult (*PLib3MFColorGroup_GetColorPtr) (Lib3MF_ColorGroup pColorGroup, Lib3MF_uint32 nPropertyID, sLib3MFColor * pTheColor);

/*************************************************************************************************************************
 Class definition for Texture2DGroup
**************************************************************************************************************************/

/**
* Retrieves the count of tex2coords in the Texture2DGroup.
*
* @param[in] pTexture2DGroup - Texture2DGroup instance.
* @param[out] pCount - returns the count of tex2coords.
* @return error code or 0 (success)
*/
typedef Lib3MFResult (*PLib3MFTexture2DGroup_GetCountPtr) (Lib3MF_Texture2DGroup pTexture2DGroup, Lib3MF_uint32 * pCount);

/**
* returns all the PropertyIDs of all tex2coords in this Texture2DGroup
*
* @param[in] pTexture2DGroup - Texture2DGroup instance.
* @param[in] nPropertyIDsBufferSize - Number of elements in buffer
* @param[out] pPropertyIDsNeededCount - will be filled with the count of the written elements, or needed buffer size.
* @param[out] pPropertyIDsBuffer - uint32  buffer of PropertyID of the tex2coords in the Texture2DGroup.
* @return error code or 0 (success)
*/
typedef Lib3MFResult (*PLib3MFTexture2DGroup_GetAllPropertyIDsPtr) (Lib3MF_Texture2DGroup pTexture2DGroup, const Lib3MF_uint64 nPropertyIDsBufferSize, Lib3MF_uint64* pPropertyIDsNeededCount, Lib3MF_uint32 * pPropertyIDsBuffer);

/**
* Adds a new tex2coord to the Texture2DGroup
*
* @param[in] pTexture2DGroup - Texture2DGroup instance.
* @param[in] pUVCoordinate - The u/v-coordinate within the texture, horizontally right/vertically up from the origin in the lower left of the texture.
* @param[out] pPropertyID - returns new PropertyID of the new tex2coord in the Texture2DGroup.
* @return error code or 0 (success)
*/
typedef Lib3MFResult (*PLib3MFTexture2DGroup_AddTex2CoordPtr) (Lib3MF_Texture2DGroup pTexture2DGroup, const sLib3MFTex2Coord * pUVCoordinate, Lib3MF_uint32 * pPropertyID);

/**
* Obtains a tex2coord to the Texture2DGroup
*
* @param[in] pTexture2DGroup - Texture2DGroup instance.
* @param[in] nPropertyID - the PropertyID of the tex2coord in the Texture2DGroup.
* @param[out] pUVCoordinate - The u/v-coordinate within the texture, horizontally right/vertically up from the origin in the lower left of the texture.
* @return error code or 0 (success)
*/
typedef Lib3MFResult (*PLib3MFTexture2DGroup_GetTex2CoordPtr) (Lib3MF_Texture2DGroup pTexture2DGroup, Lib3MF_uint32 nPropertyID, sLib3MFTex2Coord * pUVCoordinate);

/**
* Removes a tex2coords from the Texture2DGroup.
*
* @param[in] pTexture2DGroup - Texture2DGroup instance.
* @param[in] nPropertyID - PropertyID of the tex2coords in the Texture2DGroup.
* @return error code or 0 (success)
*/
typedef Lib3MFResult (*PLib3MFTexture2DGroup_RemoveTex2CoordPtr) (Lib3MF_Texture2DGroup pTexture2DGroup, Lib3MF_uint32 nPropertyID);

/**
* Obtains the texture2D instance of this group.
*
* @param[in] pTexture2DGroup - Texture2DGroup instance.
* @param[out] pTexture2DInstance - the texture2D instance of this group.
* @return error code or 0 (success)
*/
typedef Lib3MFResult (*PLib3MFTexture2DGroup_GetTexture2DPtr) (Lib3MF_Texture2DGroup pTexture2DGroup, Lib3MF_Texture2D * pTexture2DInstance);

/*************************************************************************************************************************
 Class definition for CompositeMaterials
**************************************************************************************************************************/

/**
* Retrieves the count of Composite-s in the CompositeMaterials.
*
* @param[in] pCompositeMaterials - CompositeMaterials instance.
* @param[out] pCount - returns the count of Composite-s
* @return error code or 0 (success)
*/
typedef Lib3MFResult (*PLib3MFCompositeMaterials_GetCountPtr) (Lib3MF_CompositeMaterials pCompositeMaterials, Lib3MF_uint32 * pCount);

/**
* returns all the PropertyIDs of all Composite-Mixing Values in this CompositeMaterials
*
* @param[in] pCompositeMaterials - CompositeMaterials instance.
* @param[in] nPropertyIDsBufferSize - Number of elements in buffer
* @param[out] pPropertyIDsNeededCount - will be filled with the count of the written elements, or needed buffer size.
* @param[out] pPropertyIDsBuffer - uint32  buffer of PropertyID of the Composite-Mixing Values in the CompositeMaterials.
* @return error code or 0 (success)
*/
typedef Lib3MFResult (*PLib3MFCompositeMaterials_GetAllPropertyIDsPtr) (Lib3MF_CompositeMaterials pCompositeMaterials, const Lib3MF_uint64 nPropertyIDsBufferSize, Lib3MF_uint64* pPropertyIDsNeededCount, Lib3MF_uint32 * pPropertyIDsBuffer);

/**
* Obtains the BaseMaterialGroup instance of this CompositeMaterials.
*
* @param[in] pCompositeMaterials - CompositeMaterials instance.
* @param[out] pBaseMaterialGroupInstance - returns the BaseMaterialGroup instance of this CompositeMaterials
* @return error code or 0 (success)
*/
typedef Lib3MFResult (*PLib3MFCompositeMaterials_GetBaseMaterialGroupPtr) (Lib3MF_CompositeMaterials pCompositeMaterials, Lib3MF_BaseMaterialGroup * pBaseMaterialGroupInstance);

/**
* Adds a new Composite-Mixing Values to the CompositeMaterials.
*
* @param[in] pCompositeMaterials - CompositeMaterials instance.
* @param[in] nCompositeBufferSize - Number of elements in buffer
* @param[in] pCompositeBuffer - CompositeConstituent buffer of The Composite Constituents to be added as composite
* @param[out] pPropertyID - returns new PropertyID of the new Composite in the CompositeMaterials.
* @return error code or 0 (success)
*/
typedef Lib3MFResult (*PLib3MFCompositeMaterials_AddCompositePtr) (Lib3MF_CompositeMaterials pCompositeMaterials, Lib3MF_uint64 nCompositeBufferSize, const sLib3MFCompositeConstituent * pCompositeBuffer, Lib3MF_uint32 * pPropertyID);

/**
* Removes a Composite-Maxing Ratio from the CompositeMaterials.
*
* @param[in] pCompositeMaterials - CompositeMaterials instance.
* @param[in] nPropertyID - PropertyID of the  Composite-Mixing Values in the CompositeMaterials to be removed.
* @return error code or 0 (success)
*/
typedef Lib3MFResult (*PLib3MFCompositeMaterials_RemoveCompositePtr) (Lib3MF_CompositeMaterials pCompositeMaterials, Lib3MF_uint32 nPropertyID);

/**
* Obtains a Composite-Maxing Ratio of this CompositeMaterials.
*
* @param[in] pCompositeMaterials - CompositeMaterials instance.
* @param[in] nPropertyID - the PropertyID of the Composite-Maxing Ratio in the CompositeMaterials.
* @param[in] nCompositeBufferSize - Number of elements in buffer
* @param[out] pCompositeNeededCount - will be filled with the count of the written elements, or needed buffer size.
* @param[out] pCompositeBuffer - CompositeConstituent  buffer of The Composite-Mixing Values with the given PropertyID
* @return error code or 0 (success)
*/
typedef Lib3MFResult (*PLib3MFCompositeMaterials_GetCompositePtr) (Lib3MF_CompositeMaterials pCompositeMaterials, Lib3MF_uint32 nPropertyID, const Lib3MF_uint64 nCompositeBufferSize, Lib3MF_uint64* pCompositeNeededCount, sLib3MFCompositeConstituent * pCompositeBuffer);

/*************************************************************************************************************************
 Class definition for MultiPropertyGroup
**************************************************************************************************************************/

/**
* Retrieves the count of MultiProperty-s in the MultiPropertyGroup.
*
* @param[in] pMultiPropertyGroup - MultiPropertyGroup instance.
* @param[out] pCount - returns the count of MultiProperty-s
* @return error code or 0 (success)
*/
typedef Lib3MFResult (*PLib3MFMultiPropertyGroup_GetCountPtr) (Lib3MF_MultiPropertyGroup pMultiPropertyGroup, Lib3MF_uint32 * pCount);

/**
* returns all the PropertyIDs of all MultiProperty-s in this MultiPropertyGroup
*
* @param[in] pMultiPropertyGroup - MultiPropertyGroup instance.
* @param[in] nPropertyIDsBufferSize - Number of elements in buffer
* @param[out] pPropertyIDsNeededCount - will be filled with the count of the written elements, or needed buffer size.
* @param[out] pPropertyIDsBuffer - uint32  buffer of PropertyID of the MultiProperty-s in the MultiPropertyGroup.
* @return error code or 0 (success)
*/
typedef Lib3MFResult (*PLib3MFMultiPropertyGroup_GetAllPropertyIDsPtr) (Lib3MF_MultiPropertyGroup pMultiPropertyGroup, const Lib3MF_uint64 nPropertyIDsBufferSize, Lib3MF_uint64* pPropertyIDsNeededCount, Lib3MF_uint32 * pPropertyIDsBuffer);

/**
* Adds a new MultiProperty to the MultiPropertyGroup.
*
* @param[in] pMultiPropertyGroup - MultiPropertyGroup instance.
* @param[in] nPropertyIDsBufferSize - Number of elements in buffer
* @param[in] pPropertyIDsBuffer - uint32 buffer of The PropertyIDs of the new MultiProperty.
* @param[out] pPropertyID - returns the PropertyID of the new MultiProperty in the MultiPropertyGroup.
* @return error code or 0 (success)
*/
typedef Lib3MFResult (*PLib3MFMultiPropertyGroup_AddMultiPropertyPtr) (Lib3MF_MultiPropertyGroup pMultiPropertyGroup, Lib3MF_uint64 nPropertyIDsBufferSize, const Lib3MF_uint32 * pPropertyIDsBuffer, Lib3MF_uint32 * pPropertyID);

/**
* Sets the PropertyIDs of a MultiProperty.
*
* @param[in] pMultiPropertyGroup - MultiPropertyGroup instance.
* @param[in] nPropertyID - the PropertyID of the MultiProperty to be changed.
* @param[in] nPropertyIDsBufferSize - Number of elements in buffer
* @param[in] pPropertyIDsBuffer - uint32 buffer of The new PropertyIDs of the MultiProperty
* @return error code or 0 (success)
*/
typedef Lib3MFResult (*PLib3MFMultiPropertyGroup_SetMultiPropertyPtr) (Lib3MF_MultiPropertyGroup pMultiPropertyGroup, Lib3MF_uint32 nPropertyID, Lib3MF_uint64 nPropertyIDsBufferSize, const Lib3MF_uint32 * pPropertyIDsBuffer);

/**
* Obtains the PropertyIDs of a MultiProperty.
*
* @param[in] pMultiPropertyGroup - MultiPropertyGroup instance.
* @param[in] nPropertyID - the PropertyID of the MultiProperty to be queried.
* @param[in] nPropertyIDsBufferSize - Number of elements in buffer
* @param[out] pPropertyIDsNeededCount - will be filled with the count of the written elements, or needed buffer size.
* @param[out] pPropertyIDsBuffer - uint32  buffer of The PropertyIDs of the MultiProperty
* @return error code or 0 (success)
*/
typedef Lib3MFResult (*PLib3MFMultiPropertyGroup_GetMultiPropertyPtr) (Lib3MF_MultiPropertyGroup pMultiPropertyGroup, Lib3MF_uint32 nPropertyID, const Lib3MF_uint64 nPropertyIDsBufferSize, Lib3MF_uint64* pPropertyIDsNeededCount, Lib3MF_uint32 * pPropertyIDsBuffer);

/**
* Removes a MultiProperty from this MultiPropertyGroup.
*
* @param[in] pMultiPropertyGroup - MultiPropertyGroup instance.
* @param[in] nPropertyID - the PropertyID of the MultiProperty to be removed.
* @return error code or 0 (success)
*/
typedef Lib3MFResult (*PLib3MFMultiPropertyGroup_RemoveMultiPropertyPtr) (Lib3MF_MultiPropertyGroup pMultiPropertyGroup, Lib3MF_uint32 nPropertyID);

/**
* Retrieves the number of layers of this MultiPropertyGroup.
*
* @param[in] pMultiPropertyGroup - MultiPropertyGroup instance.
* @param[out] pCount - returns the number of layers
* @return error code or 0 (success)
*/
typedef Lib3MFResult (*PLib3MFMultiPropertyGroup_GetLayerCountPtr) (Lib3MF_MultiPropertyGroup pMultiPropertyGroup, Lib3MF_uint32 * pCount);

/**
* Adds a MultiPropertyLayer to this MultiPropertyGroup.
*
* @param[in] pMultiPropertyGroup - MultiPropertyGroup instance.
* @param[in] pTheLayer - The MultiPropertyLayer to add to this MultiPropertyGroup
* @param[out] pLayerIndex - returns the index of this MultiPropertyLayer
* @return error code or 0 (success)
*/
typedef Lib3MFResult (*PLib3MFMultiPropertyGroup_AddLayerPtr) (Lib3MF_MultiPropertyGroup pMultiPropertyGroup, const sLib3MFMultiPropertyLayer * pTheLayer, Lib3MF_uint32 * pLayerIndex);

/**
* Obtains a MultiPropertyLayer of this MultiPropertyGroup.
*
* @param[in] pMultiPropertyGroup - MultiPropertyGroup instance.
* @param[in] nLayerIndex - The Index of the MultiPropertyLayer queried
* @param[out] pTheLayer - The MultiPropertyLayer with index LayerIndex within MultiPropertyGroup
* @return error code or 0 (success)
*/
typedef Lib3MFResult (*PLib3MFMultiPropertyGroup_GetLayerPtr) (Lib3MF_MultiPropertyGroup pMultiPropertyGroup, Lib3MF_uint32 nLayerIndex, sLib3MFMultiPropertyLayer * pTheLayer);

/**
* Removes a MultiPropertyLayer from this MultiPropertyGroup.
*
* @param[in] pMultiPropertyGroup - MultiPropertyGroup instance.
* @param[in] nLayerIndex - The Index of the MultiPropertyLayer to be removed
* @return error code or 0 (success)
*/
typedef Lib3MFResult (*PLib3MFMultiPropertyGroup_RemoveLayerPtr) (Lib3MF_MultiPropertyGroup pMultiPropertyGroup, Lib3MF_uint32 nLayerIndex);

/*************************************************************************************************************************
 Class definition for Attachment
**************************************************************************************************************************/

/**
* Retrieves an attachment's package path. This function will be removed in a later release.
*
* @param[in] pAttachment - Attachment instance.
* @param[in] nPathBufferSize - size of the buffer (including trailing 0)
* @param[out] pPathNeededChars - will be filled with the count of the written bytes, or needed buffer size.
* @param[out] pPathBuffer -  buffer of returns the attachment's package path string, may be NULL
* @return error code or 0 (success)
*/
typedef Lib3MFResult (*PLib3MFAttachment_GetPathPtr) (Lib3MF_Attachment pAttachment, const Lib3MF_uint32 nPathBufferSize, Lib3MF_uint32* pPathNeededChars, char * pPathBuffer);

/**
* Sets an attachment's package path. This function will be removed in a later release.
*
* @param[in] pAttachment - Attachment instance.
* @param[in] pPath - new path of the attachment.
* @return error code or 0 (success)
*/
typedef Lib3MFResult (*PLib3MFAttachment_SetPathPtr) (Lib3MF_Attachment pAttachment, const char * pPath);

/**
* Returns the PackagePart that is this attachment.
*
* @param[in] pAttachment - Attachment instance.
* @param[out] pPackagePart - The PackagePart of this attachment.
* @return error code or 0 (success)
*/
typedef Lib3MFResult (*PLib3MFAttachment_PackagePartPtr) (Lib3MF_Attachment pAttachment, Lib3MF_PackagePart * pPackagePart);

/**
* Retrieves an attachment's relationship type
*
* @param[in] pAttachment - Attachment instance.
* @param[in] nPathBufferSize - size of the buffer (including trailing 0)
* @param[out] pPathNeededChars - will be filled with the count of the written bytes, or needed buffer size.
* @param[out] pPathBuffer -  buffer of returns the attachment's package relationship type string, may be NULL
* @return error code or 0 (success)
*/
typedef Lib3MFResult (*PLib3MFAttachment_GetRelationShipTypePtr) (Lib3MF_Attachment pAttachment, const Lib3MF_uint32 nPathBufferSize, Lib3MF_uint32* pPathNeededChars, char * pPathBuffer);

/**
* Sets an attachment's relationship type.
*
* @param[in] pAttachment - Attachment instance.
* @param[in] pPath - new relationship type string.
* @return error code or 0 (success)
*/
typedef Lib3MFResult (*PLib3MFAttachment_SetRelationShipTypePtr) (Lib3MF_Attachment pAttachment, const char * pPath);

/**
* Writes out the attachment as file.
*
* @param[in] pAttachment - Attachment instance.
* @param[in] pFileName - file to write into.
* @return error code or 0 (success)
*/
typedef Lib3MFResult (*PLib3MFAttachment_WriteToFilePtr) (Lib3MF_Attachment pAttachment, const char * pFileName);

/**
* Reads an attachment from a file.
*
* @param[in] pAttachment - Attachment instance.
* @param[in] pFileName - file to read from.
* @return error code or 0 (success)
*/
typedef Lib3MFResult (*PLib3MFAttachment_ReadFromFilePtr) (Lib3MF_Attachment pAttachment, const char * pFileName);

/**
* Retrieves the size of the attachment stream
*
* @param[in] pAttachment - Attachment instance.
* @param[out] pStreamSize - the stream size
* @return error code or 0 (success)
*/
typedef Lib3MFResult (*PLib3MFAttachment_GetStreamSizePtr) (Lib3MF_Attachment pAttachment, Lib3MF_uint64 * pStreamSize);

/**
* Writes out the attachment into a buffer
*
* @param[in] pAttachment - Attachment instance.
* @param[in] nBufferBufferSize - Number of elements in buffer
* @param[out] pBufferNeededCount - will be filled with the count of the written elements, or needed buffer size.
* @param[out] pBufferBuffer - uint8  buffer of Buffer to write into
* @return error code or 0 (success)
*/
typedef Lib3MFResult (*PLib3MFAttachment_WriteToBufferPtr) (Lib3MF_Attachment pAttachment, const Lib3MF_uint64 nBufferBufferSize, Lib3MF_uint64* pBufferNeededCount, Lib3MF_uint8 * pBufferBuffer);

/**
* Reads an attachment from a memory buffer
*
* @param[in] pAttachment - Attachment instance.
* @param[in] nBufferBufferSize - Number of elements in buffer
* @param[in] pBufferBuffer - uint8 buffer of Buffer to read from
* @return error code or 0 (success)
*/
typedef Lib3MFResult (*PLib3MFAttachment_ReadFromBufferPtr) (Lib3MF_Attachment pAttachment, Lib3MF_uint64 nBufferBufferSize, const Lib3MF_uint8 * pBufferBuffer);

/*************************************************************************************************************************
 Class definition for Texture2D
**************************************************************************************************************************/

/**
* Retrieves the attachment located at the path of the texture.
*
* @param[in] pTexture2D - Texture2D instance.
* @param[out] pAttachment - attachment that holds the texture's image information.
* @return error code or 0 (success)
*/
typedef Lib3MFResult (*PLib3MFTexture2D_GetAttachmentPtr) (Lib3MF_Texture2D pTexture2D, Lib3MF_Attachment * pAttachment);

/**
* Sets the texture's package path to the path of the attachment.
*
* @param[in] pTexture2D - Texture2D instance.
* @param[in] pAttachment - attachment that holds the texture's image information.
* @return error code or 0 (success)
*/
typedef Lib3MFResult (*PLib3MFTexture2D_SetAttachmentPtr) (Lib3MF_Texture2D pTexture2D, Lib3MF_Attachment pAttachment);

/**
* Retrieves a texture's content type.
*
* @param[in] pTexture2D - Texture2D instance.
* @param[out] pContentType - returns content type enum.
* @return error code or 0 (success)
*/
typedef Lib3MFResult (*PLib3MFTexture2D_GetContentTypePtr) (Lib3MF_Texture2D pTexture2D, eLib3MFTextureType * pContentType);

/**
* Retrieves a texture's content type.
*
* @param[in] pTexture2D - Texture2D instance.
* @param[in] eContentType - new Content Type
* @return error code or 0 (success)
*/
typedef Lib3MFResult (*PLib3MFTexture2D_SetContentTypePtr) (Lib3MF_Texture2D pTexture2D, eLib3MFTextureType eContentType);

/**
* Retrieves a texture's tilestyle type.
*
* @param[in] pTexture2D - Texture2D instance.
* @param[out] pTileStyleU - returns tilestyle type enum.
* @param[out] pTileStyleV - returns tilestyle type enum.
* @return error code or 0 (success)
*/
typedef Lib3MFResult (*PLib3MFTexture2D_GetTileStyleUVPtr) (Lib3MF_Texture2D pTexture2D, eLib3MFTextureTileStyle * pTileStyleU, eLib3MFTextureTileStyle * pTileStyleV);

/**
* Sets a texture's tilestyle type.
*
* @param[in] pTexture2D - Texture2D instance.
* @param[in] eTileStyleU - new tilestyle type enum.
* @param[in] eTileStyleV - new tilestyle type enum.
* @return error code or 0 (success)
*/
typedef Lib3MFResult (*PLib3MFTexture2D_SetTileStyleUVPtr) (Lib3MF_Texture2D pTexture2D, eLib3MFTextureTileStyle eTileStyleU, eLib3MFTextureTileStyle eTileStyleV);

/**
* Retrieves a texture's filter type.
*
* @param[in] pTexture2D - Texture2D instance.
* @param[out] pFilter - returns filter type enum.
* @return error code or 0 (success)
*/
typedef Lib3MFResult (*PLib3MFTexture2D_GetFilterPtr) (Lib3MF_Texture2D pTexture2D, eLib3MFTextureFilter * pFilter);

/**
* Sets a texture's filter type.
*
* @param[in] pTexture2D - Texture2D instance.
* @param[in] eFilter - sets new filter type enum.
* @return error code or 0 (success)
*/
typedef Lib3MFResult (*PLib3MFTexture2D_SetFilterPtr) (Lib3MF_Texture2D pTexture2D, eLib3MFTextureFilter eFilter);

/*************************************************************************************************************************
 Class definition for BuildItem
**************************************************************************************************************************/

/**
* Retrieves the object resource associated to a build item
*
* @param[in] pBuildItem - BuildItem instance.
* @param[out] pObjectResource - returns the associated resource instance
* @return error code or 0 (success)
*/
typedef Lib3MFResult (*PLib3MFBuildItem_GetObjectResourcePtr) (Lib3MF_BuildItem pBuildItem, Lib3MF_Object * pObjectResource);

/**
* returns, whether a build item has a UUID and, if true, the build item's UUID
*
* @param[in] pBuildItem - BuildItem instance.
* @param[out] pHasUUID - flag whether the build item has a UUID
* @param[in] nUUIDBufferSize - size of the buffer (including trailing 0)
* @param[out] pUUIDNeededChars - will be filled with the count of the written bytes, or needed buffer size.
* @param[out] pUUIDBuffer -  buffer of the UUID as string of the form 'xxxxxxxx-xxxx-xxxx-xxxxxxxxxxxxxxxx', may be NULL
* @return error code or 0 (success)
*/
typedef Lib3MFResult (*PLib3MFBuildItem_GetUUIDPtr) (Lib3MF_BuildItem pBuildItem, bool * pHasUUID, const Lib3MF_uint32 nUUIDBufferSize, Lib3MF_uint32* pUUIDNeededChars, char * pUUIDBuffer);

/**
* sets the build item's UUID
*
* @param[in] pBuildItem - BuildItem instance.
* @param[in] pUUID - the UUID as string of the form 'xxxxxxxx-xxxx-xxxx-xxxxxxxxxxxxxxxx'
* @return error code or 0 (success)
*/
typedef Lib3MFResult (*PLib3MFBuildItem_SetUUIDPtr) (Lib3MF_BuildItem pBuildItem, const char * pUUID);

/**
* Retrieves the object UniqueResourceID associated to a build item
*
* @param[in] pBuildItem - BuildItem instance.
* @param[out] pUniqueResourceID - returns the UniqueResourceID of the object
* @return error code or 0 (success)
*/
typedef Lib3MFResult (*PLib3MFBuildItem_GetObjectResourceIDPtr) (Lib3MF_BuildItem pBuildItem, Lib3MF_uint32 * pUniqueResourceID);

/**
* Checks, if a build item has a non-identity transformation matrix
*
* @param[in] pBuildItem - BuildItem instance.
* @param[out] pHasTransform - returns true, if the transformation matrix is not the identity
* @return error code or 0 (success)
*/
typedef Lib3MFResult (*PLib3MFBuildItem_HasObjectTransformPtr) (Lib3MF_BuildItem pBuildItem, bool * pHasTransform);

/**
* Retrieves a build item's transformation matrix.
*
* @param[in] pBuildItem - BuildItem instance.
* @param[out] pTransform - returns the transformation matrix
* @return error code or 0 (success)
*/
typedef Lib3MFResult (*PLib3MFBuildItem_GetObjectTransformPtr) (Lib3MF_BuildItem pBuildItem, sLib3MFTransform * pTransform);

/**
* Sets a build item's transformation matrix.
*
* @param[in] pBuildItem - BuildItem instance.
* @param[in] pTransform - new transformation matrix
* @return error code or 0 (success)
*/
typedef Lib3MFResult (*PLib3MFBuildItem_SetObjectTransformPtr) (Lib3MF_BuildItem pBuildItem, const sLib3MFTransform * pTransform);

/**
* Retrieves a build item's part number string
*
* @param[in] pBuildItem - BuildItem instance.
* @param[in] nPartNumberBufferSize - size of the buffer (including trailing 0)
* @param[out] pPartNumberNeededChars - will be filled with the count of the written bytes, or needed buffer size.
* @param[out] pPartNumberBuffer -  buffer of Returns a build item's part number string, may be NULL
* @return error code or 0 (success)
*/
typedef Lib3MFResult (*PLib3MFBuildItem_GetPartNumberPtr) (Lib3MF_BuildItem pBuildItem, const Lib3MF_uint32 nPartNumberBufferSize, Lib3MF_uint32* pPartNumberNeededChars, char * pPartNumberBuffer);

/**
* Sets a build item's part number string
*
* @param[in] pBuildItem - BuildItem instance.
* @param[in] pSetPartnumber - new part number string for referencing parts from the outside world
* @return error code or 0 (success)
*/
typedef Lib3MFResult (*PLib3MFBuildItem_SetPartNumberPtr) (Lib3MF_BuildItem pBuildItem, const char * pSetPartnumber);

/**
* Returns the metadatagroup of this build item
*
* @param[in] pBuildItem - BuildItem instance.
* @param[out] pMetaDataGroup - returns an Instance of the metadatagroup of this build item
* @return error code or 0 (success)
*/
typedef Lib3MFResult (*PLib3MFBuildItem_GetMetaDataGroupPtr) (Lib3MF_BuildItem pBuildItem, Lib3MF_MetaDataGroup * pMetaDataGroup);

/**
* Returns the outbox of a build item
*
* @param[in] pBuildItem - BuildItem instance.
* @param[out] pOutbox - Outbox of this build item
* @return error code or 0 (success)
*/
typedef Lib3MFResult (*PLib3MFBuildItem_GetOutboxPtr) (Lib3MF_BuildItem pBuildItem, sLib3MFBox * pOutbox);

/*************************************************************************************************************************
 Class definition for BuildItemIterator
**************************************************************************************************************************/

/**
* Iterates to the next build item in the list.
*
* @param[in] pBuildItemIterator - BuildItemIterator instance.
* @param[out] pHasNext - Iterates to the next build item in the list.
* @return error code or 0 (success)
*/
typedef Lib3MFResult (*PLib3MFBuildItemIterator_MoveNextPtr) (Lib3MF_BuildItemIterator pBuildItemIterator, bool * pHasNext);

/**
* Iterates to the previous build item in the list.
*
* @param[in] pBuildItemIterator - BuildItemIterator instance.
* @param[out] pHasPrevious - Iterates to the previous build item in the list.
* @return error code or 0 (success)
*/
typedef Lib3MFResult (*PLib3MFBuildItemIterator_MovePreviousPtr) (Lib3MF_BuildItemIterator pBuildItemIterator, bool * pHasPrevious);

/**
* Returns the build item the iterator points at.
*
* @param[in] pBuildItemIterator - BuildItemIterator instance.
* @param[out] pBuildItem - returns the build item instance.
* @return error code or 0 (success)
*/
typedef Lib3MFResult (*PLib3MFBuildItemIterator_GetCurrentPtr) (Lib3MF_BuildItemIterator pBuildItemIterator, Lib3MF_BuildItem * pBuildItem);

/**
* Creates a new build item iterator with the same build item list.
*
* @param[in] pBuildItemIterator - BuildItemIterator instance.
* @param[out] pOutBuildItemIterator - returns the cloned Iterator instance
* @return error code or 0 (success)
*/
typedef Lib3MFResult (*PLib3MFBuildItemIterator_ClonePtr) (Lib3MF_BuildItemIterator pBuildItemIterator, Lib3MF_BuildItemIterator * pOutBuildItemIterator);

/**
* Returns the number of build items the iterator captures.
*
* @param[in] pBuildItemIterator - BuildItemIterator instance.
* @param[out] pCount - returns the number of build items the iterator captures.
* @return error code or 0 (success)
*/
typedef Lib3MFResult (*PLib3MFBuildItemIterator_CountPtr) (Lib3MF_BuildItemIterator pBuildItemIterator, Lib3MF_uint64 * pCount);

/*************************************************************************************************************************
 Class definition for Slice
**************************************************************************************************************************/

/**
* Set all vertices of a slice. All polygons will be cleared.
*
* @param[in] pSlice - Slice instance.
* @param[in] nVerticesBufferSize - Number of elements in buffer
* @param[in] pVerticesBuffer - Position2D buffer of contains the positions.
* @return error code or 0 (success)
*/
typedef Lib3MFResult (*PLib3MFSlice_SetVerticesPtr) (Lib3MF_Slice pSlice, Lib3MF_uint64 nVerticesBufferSize, const sLib3MFPosition2D * pVerticesBuffer);

/**
* Get all vertices of a slice
*
* @param[in] pSlice - Slice instance.
* @param[in] nVerticesBufferSize - Number of elements in buffer
* @param[out] pVerticesNeededCount - will be filled with the count of the written elements, or needed buffer size.
* @param[out] pVerticesBuffer - Position2D  buffer of contains the positions.
* @return error code or 0 (success)
*/
typedef Lib3MFResult (*PLib3MFSlice_GetVerticesPtr) (Lib3MF_Slice pSlice, const Lib3MF_uint64 nVerticesBufferSize, Lib3MF_uint64* pVerticesNeededCount, sLib3MFPosition2D * pVerticesBuffer);

/**
* Get the number of vertices in a slice
*
* @param[in] pSlice - Slice instance.
* @param[out] pCount - the number of vertices in the slice
* @return error code or 0 (success)
*/
typedef Lib3MFResult (*PLib3MFSlice_GetVertexCountPtr) (Lib3MF_Slice pSlice, Lib3MF_uint64 * pCount);

/**
* Add a new polygon to this slice
*
* @param[in] pSlice - Slice instance.
* @param[in] nIndicesBufferSize - Number of elements in buffer
* @param[in] pIndicesBuffer - uint32 buffer of the new indices of the new polygon
* @param[out] pIndex - the index of the new polygon
* @return error code or 0 (success)
*/
typedef Lib3MFResult (*PLib3MFSlice_AddPolygonPtr) (Lib3MF_Slice pSlice, Lib3MF_uint64 nIndicesBufferSize, const Lib3MF_uint32 * pIndicesBuffer, Lib3MF_uint64 * pIndex);

/**
* Get the number of polygons in the slice
*
* @param[in] pSlice - Slice instance.
* @param[out] pCount - the number of polygons in the slice
* @return error code or 0 (success)
*/
typedef Lib3MFResult (*PLib3MFSlice_GetPolygonCountPtr) (Lib3MF_Slice pSlice, Lib3MF_uint64 * pCount);

/**
* Set all indices of a polygon
*
* @param[in] pSlice - Slice instance.
* @param[in] nIndex - the index of the polygon to manipulate
* @param[in] nIndicesBufferSize - Number of elements in buffer
* @param[in] pIndicesBuffer - uint32 buffer of the new indices of the index-th polygon
* @return error code or 0 (success)
*/
typedef Lib3MFResult (*PLib3MFSlice_SetPolygonIndicesPtr) (Lib3MF_Slice pSlice, Lib3MF_uint64 nIndex, Lib3MF_uint64 nIndicesBufferSize, const Lib3MF_uint32 * pIndicesBuffer);

/**
* Get all vertices of a slice
*
* @param[in] pSlice - Slice instance.
* @param[in] nIndex - the index of the polygon to manipulate
* @param[in] nIndicesBufferSize - Number of elements in buffer
* @param[out] pIndicesNeededCount - will be filled with the count of the written elements, or needed buffer size.
* @param[out] pIndicesBuffer - uint32  buffer of the indices of the index-th polygon 
* @return error code or 0 (success)
*/
typedef Lib3MFResult (*PLib3MFSlice_GetPolygonIndicesPtr) (Lib3MF_Slice pSlice, Lib3MF_uint64 nIndex, const Lib3MF_uint64 nIndicesBufferSize, Lib3MF_uint64* pIndicesNeededCount, Lib3MF_uint32 * pIndicesBuffer);

/**
* Get the number of vertices in a slice
*
* @param[in] pSlice - Slice instance.
* @param[in] nIndex - the index of the polygon to manipulate
* @param[out] pCount - the number of indices of the index-th polygon
* @return error code or 0 (success)
*/
typedef Lib3MFResult (*PLib3MFSlice_GetPolygonIndexCountPtr) (Lib3MF_Slice pSlice, Lib3MF_uint64 nIndex, Lib3MF_uint64 * pCount);

/**
* Get the upper Z-Coordinate of this slice.
*
* @param[in] pSlice - Slice instance.
* @param[out] pZTop - the upper Z-Coordinate of this slice
* @return error code or 0 (success)
*/
typedef Lib3MFResult (*PLib3MFSlice_GetZTopPtr) (Lib3MF_Slice pSlice, Lib3MF_double * pZTop);

/*************************************************************************************************************************
 Class definition for SliceStack
**************************************************************************************************************************/

/**
* Get the lower Z-Coordinate of the slice stack.
*
* @param[in] pSliceStack - SliceStack instance.
* @param[out] pZBottom - the lower Z-Coordinate the slice stack
* @return error code or 0 (success)
*/
typedef Lib3MFResult (*PLib3MFSliceStack_GetBottomZPtr) (Lib3MF_SliceStack pSliceStack, Lib3MF_double * pZBottom);

/**
* Returns the number of slices
*
* @param[in] pSliceStack - SliceStack instance.
* @param[out] pCount - the number of slices
* @return error code or 0 (success)
*/
typedef Lib3MFResult (*PLib3MFSliceStack_GetSliceCountPtr) (Lib3MF_SliceStack pSliceStack, Lib3MF_uint64 * pCount);

/**
* Query a slice from the slice stack
*
* @param[in] pSliceStack - SliceStack instance.
* @param[in] nSliceIndex - the index of the slice
* @param[out] pTheSlice - the Slice instance
* @return error code or 0 (success)
*/
typedef Lib3MFResult (*PLib3MFSliceStack_GetSlicePtr) (Lib3MF_SliceStack pSliceStack, Lib3MF_uint64 nSliceIndex, Lib3MF_Slice * pTheSlice);

/**
* Returns the number of slices
*
* @param[in] pSliceStack - SliceStack instance.
* @param[in] dZTop - upper Z coordinate of the slice
* @param[out] pTheSlice - a new Slice instance
* @return error code or 0 (success)
*/
typedef Lib3MFResult (*PLib3MFSliceStack_AddSlicePtr) (Lib3MF_SliceStack pSliceStack, Lib3MF_double dZTop, Lib3MF_Slice * pTheSlice);

/**
* Returns the number of slice refs
*
* @param[in] pSliceStack - SliceStack instance.
* @param[out] pCount - the number of slicereferences
* @return error code or 0 (success)
*/
typedef Lib3MFResult (*PLib3MFSliceStack_GetSliceRefCountPtr) (Lib3MF_SliceStack pSliceStack, Lib3MF_uint64 * pCount);

/**
* Adds another existing slicestack as sliceref in this slicestack
*
* @param[in] pSliceStack - SliceStack instance.
* @param[in] pTheSliceStack - the slicestack to use as sliceref
* @return error code or 0 (success)
*/
typedef Lib3MFResult (*PLib3MFSliceStack_AddSliceStackReferencePtr) (Lib3MF_SliceStack pSliceStack, Lib3MF_SliceStack pTheSliceStack);

/**
* Adds another existing slicestack as sliceref in this slicestack
*
* @param[in] pSliceStack - SliceStack instance.
* @param[in] nSliceRefIndex - the index of the slice ref
* @param[out] pTheSliceStack - the slicestack that is used as sliceref
* @return error code or 0 (success)
*/
typedef Lib3MFResult (*PLib3MFSliceStack_GetSliceStackReferencePtr) (Lib3MF_SliceStack pSliceStack, Lib3MF_uint64 nSliceRefIndex, Lib3MF_SliceStack * pTheSliceStack);

/**
* Removes the indirection of slices via slice-refs, i.e. creates the slices of all slice refs of this SliceStack as actual slices of this SliceStack. All previously existing slices or slicerefs will be removed.
*
* @param[in] pSliceStack - SliceStack instance.
* @return error code or 0 (success)
*/
typedef Lib3MFResult (*PLib3MFSliceStack_CollapseSliceReferencesPtr) (Lib3MF_SliceStack pSliceStack);

/**
* Sets the package path where this Slice should be stored. Input an empty string to reset the path
*
* @param[in] pSliceStack - SliceStack instance.
* @param[in] pPath - the package path where this Slice should be stored
* @return error code or 0 (success)
*/
typedef Lib3MFResult (*PLib3MFSliceStack_SetOwnPathPtr) (Lib3MF_SliceStack pSliceStack, const char * pPath);

/**
* Obtains the package path where this Slice should be stored. Returns an empty string if the slicestack is stored within the root model.
*
* @param[in] pSliceStack - SliceStack instance.
* @param[in] nPathBufferSize - size of the buffer (including trailing 0)
* @param[out] pPathNeededChars - will be filled with the count of the written bytes, or needed buffer size.
* @param[out] pPathBuffer -  buffer of the package path where this Slice will be stored, may be NULL
* @return error code or 0 (success)
*/
typedef Lib3MFResult (*PLib3MFSliceStack_GetOwnPathPtr) (Lib3MF_SliceStack pSliceStack, const Lib3MF_uint32 nPathBufferSize, Lib3MF_uint32* pPathNeededChars, char * pPathBuffer);

/*************************************************************************************************************************
 Class definition for Consumer
**************************************************************************************************************************/

/**
* Gets the consumerid
*
* @param[in] pConsumer - Consumer instance.
* @param[in] nConsumerIDBufferSize - size of the buffer (including trailing 0)
* @param[out] pConsumerIDNeededChars - will be filled with the count of the written bytes, or needed buffer size.
* @param[out] pConsumerIDBuffer -  buffer of A unique identifier for the consumers, may be NULL
* @return error code or 0 (success)
*/
typedef Lib3MFResult (*PLib3MFConsumer_GetConsumerIDPtr) (Lib3MF_Consumer pConsumer, const Lib3MF_uint32 nConsumerIDBufferSize, Lib3MF_uint32* pConsumerIDNeededChars, char * pConsumerIDBuffer);

/**
* Getts the keyid
*
* @param[in] pConsumer - Consumer instance.
* @param[in] nKeyIDBufferSize - size of the buffer (including trailing 0)
* @param[out] pKeyIDNeededChars - will be filled with the count of the written bytes, or needed buffer size.
* @param[out] pKeyIDBuffer -  buffer of The identifier for the key of this consumer, may be NULL
* @return error code or 0 (success)
*/
typedef Lib3MFResult (*PLib3MFConsumer_GetKeyIDPtr) (Lib3MF_Consumer pConsumer, const Lib3MF_uint32 nKeyIDBufferSize, Lib3MF_uint32* pKeyIDNeededChars, char * pKeyIDBuffer);

/**
* Gets the keyvalue associated with this consumer
*
* @param[in] pConsumer - Consumer instance.
* @param[in] nKeyValueBufferSize - size of the buffer (including trailing 0)
* @param[out] pKeyValueNeededChars - will be filled with the count of the written bytes, or needed buffer size.
* @param[out] pKeyValueBuffer -  buffer of The public key, when available, of this consumer, may be NULL
* @return error code or 0 (success)
*/
typedef Lib3MFResult (*PLib3MFConsumer_GetKeyValuePtr) (Lib3MF_Consumer pConsumer, const Lib3MF_uint32 nKeyValueBufferSize, Lib3MF_uint32* pKeyValueNeededChars, char * pKeyValueBuffer);

/*************************************************************************************************************************
 Class definition for AccessRight
**************************************************************************************************************************/

/**
* Gets the consumer associated with this access right
*
* @param[in] pAccessRight - AccessRight instance.
* @param[out] pConsumer - The consumer instance
* @return error code or 0 (success)
*/
typedef Lib3MFResult (*PLib3MFAccessRight_GetConsumerPtr) (Lib3MF_AccessRight pAccessRight, Lib3MF_Consumer * pConsumer);

/**
* Gets the associated encryption algorithm
*
* @param[in] pAccessRight - AccessRight instance.
* @param[out] pAlgorithm - The algorithm used for the key in this accessright
* @return error code or 0 (success)
*/
typedef Lib3MFResult (*PLib3MFAccessRight_GetWrappingAlgorithmPtr) (Lib3MF_AccessRight pAccessRight, eLib3MFWrappingAlgorithm * pAlgorithm);

/**
* Gets the associated mask generation function algorithm
*
* @param[in] pAccessRight - AccessRight instance.
* @param[out] pAlgorithm - The MFG1 algorithm
* @return error code or 0 (success)
*/
typedef Lib3MFResult (*PLib3MFAccessRight_GetMgfAlgorithmPtr) (Lib3MF_AccessRight pAccessRight, eLib3MFMgfAlgorithm * pAlgorithm);

/**
* Gets the digest method assoicated
*
* @param[in] pAccessRight - AccessRight instance.
* @param[out] pAlgorithm - The digest method for this accessright
* @return error code or 0 (success)
*/
typedef Lib3MFResult (*PLib3MFAccessRight_GetDigestMethodPtr) (Lib3MF_AccessRight pAccessRight, eLib3MFDigestMethod * pAlgorithm);

/*************************************************************************************************************************
 Class definition for ContentEncryptionParams
**************************************************************************************************************************/

/**
* Returns the encryption method to be used in this encryption process
*
* @param[in] pContentEncryptionParams - ContentEncryptionParams instance.
* @param[out] pAlgorithm - 
* @return error code or 0 (success)
*/
typedef Lib3MFResult (*PLib3MFContentEncryptionParams_GetEncryptionAlgorithmPtr) (Lib3MF_ContentEncryptionParams pContentEncryptionParams, eLib3MFEncryptionAlgorithm * pAlgorithm);

/**
* Gets the key for the resource associated
*
* @param[in] pContentEncryptionParams - ContentEncryptionParams instance.
* @param[in] nByteDataBufferSize - Number of elements in buffer
* @param[out] pByteDataNeededCount - will be filled with the count of the written elements, or needed buffer size.
* @param[out] pByteDataBuffer - uint8  buffer of Pointer to a buffer where to place the key.
* @return error code or 0 (success)
*/
typedef Lib3MFResult (*PLib3MFContentEncryptionParams_GetKeyPtr) (Lib3MF_ContentEncryptionParams pContentEncryptionParams, const Lib3MF_uint64 nByteDataBufferSize, Lib3MF_uint64* pByteDataNeededCount, Lib3MF_uint8 * pByteDataBuffer);

/**
* Gets the IV data
*
* @param[in] pContentEncryptionParams - ContentEncryptionParams instance.
* @param[in] nByteDataBufferSize - Number of elements in buffer
* @param[out] pByteDataNeededCount - will be filled with the count of the written elements, or needed buffer size.
* @param[out] pByteDataBuffer - uint8  buffer of Pointer to a buffer where to place the data.
* @return error code or 0 (success)
*/
typedef Lib3MFResult (*PLib3MFContentEncryptionParams_GetInitializationVectorPtr) (Lib3MF_ContentEncryptionParams pContentEncryptionParams, const Lib3MF_uint64 nByteDataBufferSize, Lib3MF_uint64* pByteDataNeededCount, Lib3MF_uint8 * pByteDataBuffer);

/**
* A handler descriptor that uniquely identifies the context of the resource. Each resource will be assigned a different value
*
* @param[in] pContentEncryptionParams - ContentEncryptionParams instance.
* @param[in] nByteDataBufferSize - Number of elements in buffer
* @param[out] pByteDataNeededCount - will be filled with the count of the written elements, or needed buffer size.
* @param[out] pByteDataBuffer - uint8  buffer of Pointer to a buffer where to place the data.
* @return error code or 0 (success)
*/
typedef Lib3MFResult (*PLib3MFContentEncryptionParams_GetAuthenticationTagPtr) (Lib3MF_ContentEncryptionParams pContentEncryptionParams, const Lib3MF_uint64 nByteDataBufferSize, Lib3MF_uint64* pByteDataNeededCount, Lib3MF_uint8 * pByteDataBuffer);

/**
* Sets the authentication tag
*
* @param[in] pContentEncryptionParams - ContentEncryptionParams instance.
* @param[in] nByteDataBufferSize - Number of elements in buffer
* @param[in] pByteDataBuffer - uint8 buffer of The authentication tag size
* @return error code or 0 (success)
*/
typedef Lib3MFResult (*PLib3MFContentEncryptionParams_SetAuthenticationTagPtr) (Lib3MF_ContentEncryptionParams pContentEncryptionParams, Lib3MF_uint64 nByteDataBufferSize, const Lib3MF_uint8 * pByteDataBuffer);

/**
* A handler descriptor that uniquely identifies the context of the resource. Each resource will be assigned a different value
*
* @param[in] pContentEncryptionParams - ContentEncryptionParams instance.
* @param[in] nByteDataBufferSize - Number of elements in buffer
* @param[out] pByteDataNeededCount - will be filled with the count of the written elements, or needed buffer size.
* @param[out] pByteDataBuffer - uint8  buffer of Buffer where the data will be placed
* @return error code or 0 (success)
*/
typedef Lib3MFResult (*PLib3MFContentEncryptionParams_GetAdditionalAuthenticationDataPtr) (Lib3MF_ContentEncryptionParams pContentEncryptionParams, const Lib3MF_uint64 nByteDataBufferSize, Lib3MF_uint64* pByteDataNeededCount, Lib3MF_uint8 * pByteDataBuffer);

/**
* A handler descriptor that uniquely identifies the context of the resource. Each resource will be assigned a different value
*
* @param[in] pContentEncryptionParams - ContentEncryptionParams instance.
* @param[out] pDescriptor - 
* @return error code or 0 (success)
*/
typedef Lib3MFResult (*PLib3MFContentEncryptionParams_GetDescriptorPtr) (Lib3MF_ContentEncryptionParams pContentEncryptionParams, Lib3MF_uint64 * pDescriptor);

/**
* Gets the resourcedatagroup keyuuid
*
* @param[in] pContentEncryptionParams - ContentEncryptionParams instance.
* @param[in] nUUIDBufferSize - size of the buffer (including trailing 0)
* @param[out] pUUIDNeededChars - will be filled with the count of the written bytes, or needed buffer size.
* @param[out] pUUIDBuffer -  buffer of The resourcedatagroup keyuuid that may be use to reference an external key, may be NULL
* @return error code or 0 (success)
*/
typedef Lib3MFResult (*PLib3MFContentEncryptionParams_GetKeyUUIDPtr) (Lib3MF_ContentEncryptionParams pContentEncryptionParams, const Lib3MF_uint32 nUUIDBufferSize, Lib3MF_uint32* pUUIDNeededChars, char * pUUIDBuffer);

/*************************************************************************************************************************
 Class definition for ResourceData
**************************************************************************************************************************/

/**
* Gets the encrypted part path
*
* @param[in] pResourceData - ResourceData instance.
* @param[out] pPath - The part path
* @return error code or 0 (success)
*/
typedef Lib3MFResult (*PLib3MFResourceData_GetPathPtr) (Lib3MF_ResourceData pResourceData, Lib3MF_PackagePart * pPath);

/**
* Gets the encryption algorithm used to encrypt this ResourceData
*
* @param[in] pResourceData - ResourceData instance.
* @param[out] pEncryptionAlgorithm - The encryption algorithm
* @return error code or 0 (success)
*/
typedef Lib3MFResult (*PLib3MFResourceData_GetEncryptionAlgorithmPtr) (Lib3MF_ResourceData pResourceData, eLib3MFEncryptionAlgorithm * pEncryptionAlgorithm);

/**
* Tells whether this ResourceData is compressed or not
*
* @param[in] pResourceData - ResourceData instance.
* @param[out] pCompression - The compression method
* @return error code or 0 (success)
*/
typedef Lib3MFResult (*PLib3MFResourceData_GetCompressionPtr) (Lib3MF_ResourceData pResourceData, eLib3MFCompression * pCompression);

/**
* Tells whether this ResourceData is compressed or not
*
* @param[in] pResourceData - ResourceData instance.
* @param[in] nByteDataBufferSize - Number of elements in buffer
* @param[out] pByteDataNeededCount - will be filled with the count of the written elements, or needed buffer size.
* @param[out] pByteDataBuffer - uint8  buffer of The compression method
* @return error code or 0 (success)
*/
typedef Lib3MFResult (*PLib3MFResourceData_GetAdditionalAuthenticationDataPtr) (Lib3MF_ResourceData pResourceData, const Lib3MF_uint64 nByteDataBufferSize, Lib3MF_uint64* pByteDataNeededCount, Lib3MF_uint8 * pByteDataBuffer);

/*************************************************************************************************************************
 Class definition for ResourceDataGroup
**************************************************************************************************************************/

/**
* Sets the resourcedatagroup keyuuid
*
* @param[in] pResourceDataGroup - ResourceDataGroup instance.
* @param[in] nUUIDBufferSize - size of the buffer (including trailing 0)
* @param[out] pUUIDNeededChars - will be filled with the count of the written bytes, or needed buffer size.
* @param[out] pUUIDBuffer -  buffer of The new resourcedatagroup keyuuid., may be NULL
* @return error code or 0 (success)
*/
typedef Lib3MFResult (*PLib3MFResourceDataGroup_GetKeyUUIDPtr) (Lib3MF_ResourceDataGroup pResourceDataGroup, const Lib3MF_uint32 nUUIDBufferSize, Lib3MF_uint32* pUUIDNeededChars, char * pUUIDBuffer);

/**
* Add accessright to resourcedatagroup element
*
* @param[in] pResourceDataGroup - ResourceDataGroup instance.
* @param[in] pConsumer - The Consumer reference
* @param[in] eWrappingAlgorithm - The key wrapping algorithm to be used
* @param[in] eMgfAlgorithm - The mask generation function to be used
* @param[in] eDigestMethod - The digest mechanism to be used
* @param[out] pTheAccessRight - The acess right instance
* @return error code or 0 (success)
*/
typedef Lib3MFResult (*PLib3MFResourceDataGroup_AddAccessRightPtr) (Lib3MF_ResourceDataGroup pResourceDataGroup, Lib3MF_Consumer pConsumer, eLib3MFWrappingAlgorithm eWrappingAlgorithm, eLib3MFMgfAlgorithm eMgfAlgorithm, eLib3MFDigestMethod eDigestMethod, Lib3MF_AccessRight * pTheAccessRight);

/**
* Finds the AccessRight associated with a Consumer
*
* @param[in] pResourceDataGroup - ResourceDataGroup instance.
* @param[in] pConsumer - The Consumer instance
* @param[out] pTheAccessRight - The AcessRight instance
* @return error code or 0 (success)
*/
typedef Lib3MFResult (*PLib3MFResourceDataGroup_FindAccessRightByConsumerPtr) (Lib3MF_ResourceDataGroup pResourceDataGroup, Lib3MF_Consumer pConsumer, Lib3MF_AccessRight * pTheAccessRight);

/**
* Removes access from a Consumer on this resource data group
*
* @param[in] pResourceDataGroup - ResourceDataGroup instance.
* @param[in] pConsumer - The Consumer instance
* @return error code or 0 (success)
*/
typedef Lib3MFResult (*PLib3MFResourceDataGroup_RemoveAccessRightPtr) (Lib3MF_ResourceDataGroup pResourceDataGroup, Lib3MF_Consumer pConsumer);

/*************************************************************************************************************************
 Class definition for KeyStore
**************************************************************************************************************************/

/**
* Adds a consumer to the keystore
*
* @param[in] pKeyStore - KeyStore instance.
* @param[in] pConsumerID - A unique identifier for the consumer
* @param[in] pKeyID - The id of the key of the consumer
* @param[in] pKeyValue - The public key for this consumer in PEM format
* @param[out] pConsumer - The consumer instance
* @return error code or 0 (success)
*/
typedef Lib3MFResult (*PLib3MFKeyStore_AddConsumerPtr) (Lib3MF_KeyStore pKeyStore, const char * pConsumerID, const char * pKeyID, const char * pKeyValue, Lib3MF_Consumer * pConsumer);

/**
* Gets the number of consumers in the keystore
*
* @param[in] pKeyStore - KeyStore instance.
* @param[out] pCount - The consumer count
* @return error code or 0 (success)
*/
typedef Lib3MFResult (*PLib3MFKeyStore_GetConsumerCountPtr) (Lib3MF_KeyStore pKeyStore, Lib3MF_uint64 * pCount);

/**
* Get a consumer from the keystore
*
* @param[in] pKeyStore - KeyStore instance.
* @param[in] nConsumerIndex - The index of the consumer
* @param[out] pConsumer - The consumer instance
* @return error code or 0 (success)
*/
typedef Lib3MFResult (*PLib3MFKeyStore_GetConsumerPtr) (Lib3MF_KeyStore pKeyStore, Lib3MF_uint64 nConsumerIndex, Lib3MF_Consumer * pConsumer);

/**
* Removes a consumer from the keystore
*
* @param[in] pKeyStore - KeyStore instance.
* @param[in] pConsumer - The consumer instance to remove
* @return error code or 0 (success)
*/
typedef Lib3MFResult (*PLib3MFKeyStore_RemoveConsumerPtr) (Lib3MF_KeyStore pKeyStore, Lib3MF_Consumer pConsumer);

/**
* Finds a consumer by ID
*
* @param[in] pKeyStore - KeyStore instance.
* @param[in] pConsumerID - The ID of the consumer
* @param[out] pConsumer - The consumer instance
* @return error code or 0 (success)
*/
typedef Lib3MFResult (*PLib3MFKeyStore_FindConsumerPtr) (Lib3MF_KeyStore pKeyStore, const char * pConsumerID, Lib3MF_Consumer * pConsumer);

/**
* Gets the number of resource data group in the keysore
*
* @param[in] pKeyStore - KeyStore instance.
* @param[out] pCount - The number of resource data available
* @return error code or 0 (success)
*/
typedef Lib3MFResult (*PLib3MFKeyStore_GetResourceDataGroupCountPtr) (Lib3MF_KeyStore pKeyStore, Lib3MF_uint64 * pCount);

/**
* Adds a resource data group into the keystore.
*
* @param[in] pKeyStore - KeyStore instance.
* @param[out] pResourceDataGroup - The resource data group instance
* @return error code or 0 (success)
*/
typedef Lib3MFResult (*PLib3MFKeyStore_AddResourceDataGroupPtr) (Lib3MF_KeyStore pKeyStore, Lib3MF_ResourceDataGroup * pResourceDataGroup);

/**
* Gets a resource data group
*
* @param[in] pKeyStore - KeyStore instance.
* @param[in] nResourceDataIndex - The index of the resource data
* @param[out] pResourceDataGroup - The resource data group instance
* @return error code or 0 (success)
*/
typedef Lib3MFResult (*PLib3MFKeyStore_GetResourceDataGroupPtr) (Lib3MF_KeyStore pKeyStore, Lib3MF_uint64 nResourceDataIndex, Lib3MF_ResourceDataGroup * pResourceDataGroup);

/**
* Removes a resource data group
*
* @param[in] pKeyStore - KeyStore instance.
* @param[in] pResourceDataGroup - The resource data group instance
* @return error code or 0 (success)
*/
typedef Lib3MFResult (*PLib3MFKeyStore_RemoveResourceDataGroupPtr) (Lib3MF_KeyStore pKeyStore, Lib3MF_ResourceDataGroup pResourceDataGroup);

/**
* Finds a resource data group that contains a particular resourcedata
*
* @param[in] pKeyStore - KeyStore instance.
* @param[in] pPartPath - The target path for the resourcedata hold by the resource data group
* @param[out] pResourceDataGroup - The data resource instance
* @return error code or 0 (success)
*/
typedef Lib3MFResult (*PLib3MFKeyStore_FindResourceDataGroupPtr) (Lib3MF_KeyStore pKeyStore, Lib3MF_PackagePart pPartPath, Lib3MF_ResourceDataGroup * pResourceDataGroup);

/**
* Add resourcedata to resourcedatagroup element
*
* @param[in] pKeyStore - KeyStore instance.
* @param[in] pResourceDataGroup - The resource data group where to add this resource data
* @param[in] pPartPath - The path of the part to be encrypted
* @param[in] eAlgorithm - The encryption algorithm to be used to encrypt this resource
* @param[in] eCompression - Whether compression should be used prior to encryption
* @param[in] nAdditionalAuthenticationDataBufferSize - Number of elements in buffer
* @param[in] pAdditionalAuthenticationDataBuffer - uint8 buffer of Additional data to be encrypted along the contents for better security
* @param[out] pResourceData - The data resource instance
* @return error code or 0 (success)
*/
typedef Lib3MFResult (*PLib3MFKeyStore_AddResourceDataPtr) (Lib3MF_KeyStore pKeyStore, Lib3MF_ResourceDataGroup pResourceDataGroup, Lib3MF_PackagePart pPartPath, eLib3MFEncryptionAlgorithm eAlgorithm, eLib3MFCompression eCompression, Lib3MF_uint64 nAdditionalAuthenticationDataBufferSize, const Lib3MF_uint8 * pAdditionalAuthenticationDataBuffer, Lib3MF_ResourceData * pResourceData);

/**
* Removes a resource data
*
* @param[in] pKeyStore - KeyStore instance.
* @param[in] pResourceData - The resource data to be removed
* @return error code or 0 (success)
*/
typedef Lib3MFResult (*PLib3MFKeyStore_RemoveResourceDataPtr) (Lib3MF_KeyStore pKeyStore, Lib3MF_ResourceData pResourceData);

/**
* Finds a resource data on this resource group
*
* @param[in] pKeyStore - KeyStore instance.
* @param[in] pResourcePath - The target path for the resourcedata
* @param[out] pResourceData - The resource data instance
* @return error code or 0 (success)
*/
typedef Lib3MFResult (*PLib3MFKeyStore_FindResourceDataPtr) (Lib3MF_KeyStore pKeyStore, Lib3MF_PackagePart pResourcePath, Lib3MF_ResourceData * pResourceData);

/**
* Gets the number of resource data in the keysore
*
* @param[in] pKeyStore - KeyStore instance.
* @param[out] pCount - The number of resource data available
* @return error code or 0 (success)
*/
typedef Lib3MFResult (*PLib3MFKeyStore_GetResourceDataCountPtr) (Lib3MF_KeyStore pKeyStore, Lib3MF_uint64 * pCount);

/**
* Gets a resource data
*
* @param[in] pKeyStore - KeyStore instance.
* @param[in] nResourceDataIndex - The index of the resource data
* @param[out] pResourceData - The data resource instance
* @return error code or 0 (success)
*/
typedef Lib3MFResult (*PLib3MFKeyStore_GetResourceDataPtr) (Lib3MF_KeyStore pKeyStore, Lib3MF_uint64 nResourceDataIndex, Lib3MF_ResourceData * pResourceData);

/**
* Gets the keystore UUID
*
* @param[in] pKeyStore - KeyStore instance.
* @param[out] pHasUUID - flag whether the keystore has a UUID
* @param[in] nUUIDBufferSize - size of the buffer (including trailing 0)
* @param[out] pUUIDNeededChars - will be filled with the count of the written bytes, or needed buffer size.
* @param[out] pUUIDBuffer -  buffer of returns the keystore uuid., may be NULL
* @return error code or 0 (success)
*/
typedef Lib3MFResult (*PLib3MFKeyStore_GetUUIDPtr) (Lib3MF_KeyStore pKeyStore, bool * pHasUUID, const Lib3MF_uint32 nUUIDBufferSize, Lib3MF_uint32* pUUIDNeededChars, char * pUUIDBuffer);

/**
* Sets the keystore UUID
*
* @param[in] pKeyStore - KeyStore instance.
* @param[in] pUUID - The new keystore uuid.
* @return error code or 0 (success)
*/
typedef Lib3MFResult (*PLib3MFKeyStore_SetUUIDPtr) (Lib3MF_KeyStore pKeyStore, const char * pUUID);

/*************************************************************************************************************************
 Class definition for Model
**************************************************************************************************************************/

/**
* Returns the PackagePart within the OPC package that holds the root model.
*
* @param[in] pModel - Model instance.
* @param[out] pRootModelPart - the PackagePart within the OPC package that holds the model-file
* @return error code or 0 (success)
*/
typedef Lib3MFResult (*PLib3MFModel_RootModelPartPtr) (Lib3MF_Model pModel, Lib3MF_PackagePart * pRootModelPart);

/**
* Returns a new PackagePart for use within the OPC package.
*
* @param[in] pModel - Model instance.
* @param[in] pAbsolutePath - the absolute Path (physical location) within the OPC package
* @param[out] pModelPart - the new PackagePart within the OPC package
* @return error code or 0 (success)
*/
typedef Lib3MFResult (*PLib3MFModel_FindOrCreatePackagePartPtr) (Lib3MF_Model pModel, const char * pAbsolutePath, Lib3MF_PackagePart * pModelPart);

/**
* sets the units of a model.
*
* @param[in] pModel - Model instance.
* @param[in] eUnit - Unit enum value for the model unit
* @return error code or 0 (success)
*/
typedef Lib3MFResult (*PLib3MFModel_SetUnitPtr) (Lib3MF_Model pModel, eLib3MFModelUnit eUnit);

/**
* returns the units of a model.
*
* @param[in] pModel - Model instance.
* @param[out] pUnit - Unit enum value for the model unit
* @return error code or 0 (success)
*/
typedef Lib3MFResult (*PLib3MFModel_GetUnitPtr) (Lib3MF_Model pModel, eLib3MFModelUnit * pUnit);

/**
* retrieves the language of a model
*
* @param[in] pModel - Model instance.
* @param[in] nLanguageBufferSize - size of the buffer (including trailing 0)
* @param[out] pLanguageNeededChars - will be filled with the count of the written bytes, or needed buffer size.
* @param[out] pLanguageBuffer -  buffer of language identifier, may be NULL
* @return error code or 0 (success)
*/
typedef Lib3MFResult (*PLib3MFModel_GetLanguagePtr) (Lib3MF_Model pModel, const Lib3MF_uint32 nLanguageBufferSize, Lib3MF_uint32* pLanguageNeededChars, char * pLanguageBuffer);

/**
* sets the language of a model
*
* @param[in] pModel - Model instance.
* @param[in] pLanguage - language identifier
* @return error code or 0 (success)
*/
typedef Lib3MFResult (*PLib3MFModel_SetLanguagePtr) (Lib3MF_Model pModel, const char * pLanguage);

/**
* creates a model writer instance for a specific file type
*
* @param[in] pModel - Model instance.
* @param[in] pWriterClass -  string identifier for the file type
* @param[out] pWriterInstance -  string identifier for the file type
* @return error code or 0 (success)
*/
typedef Lib3MFResult (*PLib3MFModel_QueryWriterPtr) (Lib3MF_Model pModel, const char * pWriterClass, Lib3MF_Writer * pWriterInstance);

/**
* creates a model reader instance for a specific file type
*
* @param[in] pModel - Model instance.
* @param[in] pReaderClass -  string identifier for the file type
* @param[out] pReaderInstance -  string identifier for the file type
* @return error code or 0 (success)
*/
typedef Lib3MFResult (*PLib3MFModel_QueryReaderPtr) (Lib3MF_Model pModel, const char * pReaderClass, Lib3MF_Reader * pReaderInstance);

/**
* finds a model texture by its UniqueResourceID
*
* @param[in] pModel - Model instance.
* @param[in] nUniqueResourceID - UniqueResourceID
* @param[out] pTextureInstance - returns the texture2d instance
* @return error code or 0 (success)
*/
typedef Lib3MFResult (*PLib3MFModel_GetTexture2DByIDPtr) (Lib3MF_Model pModel, Lib3MF_uint32 nUniqueResourceID, Lib3MF_Texture2D * pTextureInstance);

/**
* returns a Property's type
*
* @param[in] pModel - Model instance.
* @param[in] nUniqueResourceID - Resource ID of the Property to Query
* @param[out] pThePropertyType - returns a Property's type
* @return error code or 0 (success)
*/
typedef Lib3MFResult (*PLib3MFModel_GetPropertyTypeByIDPtr) (Lib3MF_Model pModel, Lib3MF_uint32 nUniqueResourceID, eLib3MFPropertyType * pThePropertyType);

/**
* finds a model base material group by its UniqueResourceID
*
* @param[in] pModel - Model instance.
* @param[in] nUniqueResourceID - UniqueResourceID
* @param[out] pBaseMaterialGroupInstance - returns the BaseMaterialGroup instance
* @return error code or 0 (success)
*/
typedef Lib3MFResult (*PLib3MFModel_GetBaseMaterialGroupByIDPtr) (Lib3MF_Model pModel, Lib3MF_uint32 nUniqueResourceID, Lib3MF_BaseMaterialGroup * pBaseMaterialGroupInstance);

/**
* finds a model texture2d group by its UniqueResourceID
*
* @param[in] pModel - Model instance.
* @param[in] nUniqueResourceID - UniqueResourceID
* @param[out] pTexture2DGroupInstance - returns the Texture2DGroup instance
* @return error code or 0 (success)
*/
typedef Lib3MFResult (*PLib3MFModel_GetTexture2DGroupByIDPtr) (Lib3MF_Model pModel, Lib3MF_uint32 nUniqueResourceID, Lib3MF_Texture2DGroup * pTexture2DGroupInstance);

/**
* finds a model CompositeMaterials by its UniqueResourceID
*
* @param[in] pModel - Model instance.
* @param[in] nUniqueResourceID - UniqueResourceID
* @param[out] pCompositeMaterialsInstance - returns the CompositeMaterials instance
* @return error code or 0 (success)
*/
typedef Lib3MFResult (*PLib3MFModel_GetCompositeMaterialsByIDPtr) (Lib3MF_Model pModel, Lib3MF_uint32 nUniqueResourceID, Lib3MF_CompositeMaterials * pCompositeMaterialsInstance);

/**
* finds a model MultiPropertyGroup by its UniqueResourceID
*
* @param[in] pModel - Model instance.
* @param[in] nUniqueResourceID - UniqueResourceID
* @param[out] pMultiPropertyGroupInstance - returns the MultiPropertyGroup instance
* @return error code or 0 (success)
*/
typedef Lib3MFResult (*PLib3MFModel_GetMultiPropertyGroupByIDPtr) (Lib3MF_Model pModel, Lib3MF_uint32 nUniqueResourceID, Lib3MF_MultiPropertyGroup * pMultiPropertyGroupInstance);

/**
* finds a mesh object by its UniqueResourceID
*
* @param[in] pModel - Model instance.
* @param[in] nUniqueResourceID - UniqueResourceID
* @param[out] pMeshObjectInstance - returns the mesh object instance
* @return error code or 0 (success)
*/
typedef Lib3MFResult (*PLib3MFModel_GetMeshObjectByIDPtr) (Lib3MF_Model pModel, Lib3MF_uint32 nUniqueResourceID, Lib3MF_MeshObject * pMeshObjectInstance);

/**
* finds a components object by its UniqueResourceID
*
* @param[in] pModel - Model instance.
* @param[in] nUniqueResourceID - UniqueResourceID
* @param[out] pComponentsObjectInstance - returns the components object instance
* @return error code or 0 (success)
*/
typedef Lib3MFResult (*PLib3MFModel_GetComponentsObjectByIDPtr) (Lib3MF_Model pModel, Lib3MF_uint32 nUniqueResourceID, Lib3MF_ComponentsObject * pComponentsObjectInstance);

/**
* finds a model color group by its UniqueResourceID
*
* @param[in] pModel - Model instance.
* @param[in] nUniqueResourceID - UniqueResourceID
* @param[out] pColorGroupInstance - returns the ColorGroup instance
* @return error code or 0 (success)
*/
typedef Lib3MFResult (*PLib3MFModel_GetColorGroupByIDPtr) (Lib3MF_Model pModel, Lib3MF_uint32 nUniqueResourceID, Lib3MF_ColorGroup * pColorGroupInstance);

/**
* finds a model slicestack by its UniqueResourceID
*
* @param[in] pModel - Model instance.
* @param[in] nUniqueResourceID - UniqueResourceID
* @param[out] pSliceStacInstance - returns the slicestack instance
* @return error code or 0 (success)
*/
typedef Lib3MFResult (*PLib3MFModel_GetSliceStackByIDPtr) (Lib3MF_Model pModel, Lib3MF_uint32 nUniqueResourceID, Lib3MF_SliceStack * pSliceStacInstance);

/**
* returns, whether a build has a UUID and, if true, the build's UUID
*
* @param[in] pModel - Model instance.
* @param[out] pHasUUID - flag whether the build has a UUID
* @param[in] nUUIDBufferSize - size of the buffer (including trailing 0)
* @param[out] pUUIDNeededChars - will be filled with the count of the written bytes, or needed buffer size.
* @param[out] pUUIDBuffer -  buffer of the UUID as string of the form 'xxxxxxxx-xxxx-xxxx-xxxxxxxxxxxxxxxx', may be NULL
* @return error code or 0 (success)
*/
typedef Lib3MFResult (*PLib3MFModel_GetBuildUUIDPtr) (Lib3MF_Model pModel, bool * pHasUUID, const Lib3MF_uint32 nUUIDBufferSize, Lib3MF_uint32* pUUIDNeededChars, char * pUUIDBuffer);

/**
* sets the build's UUID
*
* @param[in] pModel - Model instance.
* @param[in] pUUID - the UUID as string of the form 'xxxxxxxx-xxxx-xxxx-xxxxxxxxxxxxxxxx'
* @return error code or 0 (success)
*/
typedef Lib3MFResult (*PLib3MFModel_SetBuildUUIDPtr) (Lib3MF_Model pModel, const char * pUUID);

/**
* creates a build item iterator instance with all build items.
*
* @param[in] pModel - Model instance.
* @param[out] pBuildItemIterator - returns the iterator instance.
* @return error code or 0 (success)
*/
typedef Lib3MFResult (*PLib3MFModel_GetBuildItemsPtr) (Lib3MF_Model pModel, Lib3MF_BuildItemIterator * pBuildItemIterator);

/**
* Returns the outbox of a Model
*
* @param[in] pModel - Model instance.
* @param[out] pOutbox - Outbox of this Model
* @return error code or 0 (success)
*/
typedef Lib3MFResult (*PLib3MFModel_GetOutboxPtr) (Lib3MF_Model pModel, sLib3MFBox * pOutbox);

/**
* creates a resource iterator instance with all resources.
*
* @param[in] pModel - Model instance.
* @param[out] pResourceIterator - returns the iterator instance.
* @return error code or 0 (success)
*/
typedef Lib3MFResult (*PLib3MFModel_GetResourcesPtr) (Lib3MF_Model pModel, Lib3MF_ResourceIterator * pResourceIterator);

/**
* creates a resource iterator instance with all object resources.
*
* @param[in] pModel - Model instance.
* @param[out] pResourceIterator - returns the iterator instance.
* @return error code or 0 (success)
*/
typedef Lib3MFResult (*PLib3MFModel_GetObjectsPtr) (Lib3MF_Model pModel, Lib3MF_ObjectIterator * pResourceIterator);

/**
* creates a resource iterator instance with all mesh object resources.
*
* @param[in] pModel - Model instance.
* @param[out] pResourceIterator - returns the iterator instance.
* @return error code or 0 (success)
*/
typedef Lib3MFResult (*PLib3MFModel_GetMeshObjectsPtr) (Lib3MF_Model pModel, Lib3MF_MeshObjectIterator * pResourceIterator);

/**
* creates a resource iterator instance with all components object resources.
*
* @param[in] pModel - Model instance.
* @param[out] pResourceIterator - returns the iterator instance.
* @return error code or 0 (success)
*/
typedef Lib3MFResult (*PLib3MFModel_GetComponentsObjectsPtr) (Lib3MF_Model pModel, Lib3MF_ComponentsObjectIterator * pResourceIterator);

/**
* creates a Texture2DIterator instance with all texture2d resources.
*
* @param[in] pModel - Model instance.
* @param[out] pResourceIterator - returns the iterator instance.
* @return error code or 0 (success)
*/
typedef Lib3MFResult (*PLib3MFModel_GetTexture2DsPtr) (Lib3MF_Model pModel, Lib3MF_Texture2DIterator * pResourceIterator);

/**
* creates a BaseMaterialGroupIterator instance with all base material resources.
*
* @param[in] pModel - Model instance.
* @param[out] pResourceIterator - returns the iterator instance.
* @return error code or 0 (success)
*/
typedef Lib3MFResult (*PLib3MFModel_GetBaseMaterialGroupsPtr) (Lib3MF_Model pModel, Lib3MF_BaseMaterialGroupIterator * pResourceIterator);

/**
* creates a ColorGroupIterator instance with all ColorGroup resources.
*
* @param[in] pModel - Model instance.
* @param[out] pResourceIterator - returns the iterator instance.
* @return error code or 0 (success)
*/
typedef Lib3MFResult (*PLib3MFModel_GetColorGroupsPtr) (Lib3MF_Model pModel, Lib3MF_ColorGroupIterator * pResourceIterator);

/**
* creates a Texture2DGroupIterator instance with all base material resources.
*
* @param[in] pModel - Model instance.
* @param[out] pResourceIterator - returns the iterator instance.
* @return error code or 0 (success)
*/
typedef Lib3MFResult (*PLib3MFModel_GetTexture2DGroupsPtr) (Lib3MF_Model pModel, Lib3MF_Texture2DGroupIterator * pResourceIterator);

/**
* creates a CompositeMaterialsIterator instance with all CompositeMaterials resources.
*
* @param[in] pModel - Model instance.
* @param[out] pResourceIterator - returns the iterator instance.
* @return error code or 0 (success)
*/
typedef Lib3MFResult (*PLib3MFModel_GetCompositeMaterialsPtr) (Lib3MF_Model pModel, Lib3MF_CompositeMaterialsIterator * pResourceIterator);

/**
* creates a MultiPropertyGroupsIterator instance with all MultiPropertyGroup resources.
*
* @param[in] pModel - Model instance.
* @param[out] pResourceIterator - returns the iterator instance.
* @return error code or 0 (success)
*/
typedef Lib3MFResult (*PLib3MFModel_GetMultiPropertyGroupsPtr) (Lib3MF_Model pModel, Lib3MF_MultiPropertyGroupIterator * pResourceIterator);

/**
* creates a resource iterator instance with all slice stack resources.
*
* @param[in] pModel - Model instance.
* @param[out] pResourceIterator - returns the iterator instance.
* @return error code or 0 (success)
*/
typedef Lib3MFResult (*PLib3MFModel_GetSliceStacksPtr) (Lib3MF_Model pModel, Lib3MF_SliceStackIterator * pResourceIterator);

/**
* Merges all components and objects which are referenced by a build item into a mesh. The memory is duplicated and a new model is created.
*
* @param[in] pModel - Model instance.
* @param[out] pMergedModelInstance - returns the merged model instance
* @return error code or 0 (success)
*/
typedef Lib3MFResult (*PLib3MFModel_MergeToModelPtr) (Lib3MF_Model pModel, Lib3MF_Model * pMergedModelInstance);

/**
* adds an empty mesh object to the model.
*
* @param[in] pModel - Model instance.
* @param[out] pMeshObjectInstance -  returns the mesh object instance
* @return error code or 0 (success)
*/
typedef Lib3MFResult (*PLib3MFModel_AddMeshObjectPtr) (Lib3MF_Model pModel, Lib3MF_MeshObject * pMeshObjectInstance);

/**
* adds an empty component object to the model.
*
* @param[in] pModel - Model instance.
* @param[out] pComponentsObjectInstance -  returns the components object instance
* @return error code or 0 (success)
*/
typedef Lib3MFResult (*PLib3MFModel_AddComponentsObjectPtr) (Lib3MF_Model pModel, Lib3MF_ComponentsObject * pComponentsObjectInstance);

/**
* creates a new model slicestack by its id
*
* @param[in] pModel - Model instance.
* @param[in] dZBottom - Bottom Z value of the slicestack
* @param[out] pSliceStackInstance - returns the new slicestack instance
* @return error code or 0 (success)
*/
typedef Lib3MFResult (*PLib3MFModel_AddSliceStackPtr) (Lib3MF_Model pModel, Lib3MF_double dZBottom, Lib3MF_SliceStack * pSliceStackInstance);

/**
* adds a texture2d resource to the model. Its path is given by that of an existing attachment.
*
* @param[in] pModel - Model instance.
* @param[in] pTextureAttachment - attachment containing the image data.
* @param[out] pTexture2DInstance - returns the new texture instance.
* @return error code or 0 (success)
*/
typedef Lib3MFResult (*PLib3MFModel_AddTexture2DFromAttachmentPtr) (Lib3MF_Model pModel, Lib3MF_Attachment pTextureAttachment, Lib3MF_Texture2D * pTexture2DInstance);

/**
* adds an empty BaseMaterialGroup resource to the model.
*
* @param[in] pModel - Model instance.
* @param[out] pBaseMaterialGroupInstance - returns the new base material instance.
* @return error code or 0 (success)
*/
typedef Lib3MFResult (*PLib3MFModel_AddBaseMaterialGroupPtr) (Lib3MF_Model pModel, Lib3MF_BaseMaterialGroup * pBaseMaterialGroupInstance);

/**
* adds an empty ColorGroup resource to the model.
*
* @param[in] pModel - Model instance.
* @param[out] pColorGroupInstance - returns the new ColorGroup instance.
* @return error code or 0 (success)
*/
typedef Lib3MFResult (*PLib3MFModel_AddColorGroupPtr) (Lib3MF_Model pModel, Lib3MF_ColorGroup * pColorGroupInstance);

/**
* adds an empty Texture2DGroup resource to the model.
*
* @param[in] pModel - Model instance.
* @param[in] pTexture2DInstance - The texture2D instance of the created Texture2DGroup.
* @param[out] pTexture2DGroupInstance - returns the new Texture2DGroup instance.
* @return error code or 0 (success)
*/
typedef Lib3MFResult (*PLib3MFModel_AddTexture2DGroupPtr) (Lib3MF_Model pModel, Lib3MF_Texture2D pTexture2DInstance, Lib3MF_Texture2DGroup * pTexture2DGroupInstance);

/**
* adds an empty CompositeMaterials resource to the model.
*
* @param[in] pModel - Model instance.
* @param[in] pBaseMaterialGroupInstance - The BaseMaterialGroup instance of the created CompositeMaterials.
* @param[out] pCompositeMaterialsInstance - returns the new CompositeMaterials instance.
* @return error code or 0 (success)
*/
typedef Lib3MFResult (*PLib3MFModel_AddCompositeMaterialsPtr) (Lib3MF_Model pModel, Lib3MF_BaseMaterialGroup pBaseMaterialGroupInstance, Lib3MF_CompositeMaterials * pCompositeMaterialsInstance);

/**
* adds an empty MultiPropertyGroup resource to the model.
*
* @param[in] pModel - Model instance.
* @param[out] pMultiPropertyGroupInstance - returns the new MultiPropertyGroup instance.
* @return error code or 0 (success)
*/
typedef Lib3MFResult (*PLib3MFModel_AddMultiPropertyGroupPtr) (Lib3MF_Model pModel, Lib3MF_MultiPropertyGroup * pMultiPropertyGroupInstance);

/**
* adds a build item to the model.
*
* @param[in] pModel - Model instance.
* @param[in] pObject - Object instance.
* @param[in] pTransform - Transformation matrix.
* @param[out] pBuildItemInstance - returns the build item instance.
* @return error code or 0 (success)
*/
typedef Lib3MFResult (*PLib3MFModel_AddBuildItemPtr) (Lib3MF_Model pModel, Lib3MF_Object pObject, const sLib3MFTransform * pTransform, Lib3MF_BuildItem * pBuildItemInstance);

/**
* removes a build item from the model
*
* @param[in] pModel - Model instance.
* @param[in] pBuildItemInstance - Build item to remove.
* @return error code or 0 (success)
*/
typedef Lib3MFResult (*PLib3MFModel_RemoveBuildItemPtr) (Lib3MF_Model pModel, Lib3MF_BuildItem pBuildItemInstance);

/**
* Returns the metadata of the model as MetaDataGroup
*
* @param[in] pModel - Model instance.
* @param[out] pTheMetaDataGroup - returns an Instance of the metadatagroup of the model
* @return error code or 0 (success)
*/
typedef Lib3MFResult (*PLib3MFModel_GetMetaDataGroupPtr) (Lib3MF_Model pModel, Lib3MF_MetaDataGroup * pTheMetaDataGroup);

/**
* adds an attachment stream to the model. The OPC part will be related to the model stream with a certain relationship type.
*
* @param[in] pModel - Model instance.
* @param[in] pURI - Path of the attachment
* @param[in] pRelationShipType - Relationship type of the attachment
* @param[out] pAttachmentInstance - Instance of the attachment object
* @return error code or 0 (success)
*/
typedef Lib3MFResult (*PLib3MFModel_AddAttachmentPtr) (Lib3MF_Model pModel, const char * pURI, const char * pRelationShipType, Lib3MF_Attachment * pAttachmentInstance);

/**
* Removes attachment from the model.
*
* @param[in] pModel - Model instance.
* @param[in] pAttachmentInstance - Attachment instance to remove
* @return error code or 0 (success)
*/
typedef Lib3MFResult (*PLib3MFModel_RemoveAttachmentPtr) (Lib3MF_Model pModel, Lib3MF_Attachment pAttachmentInstance);

/**
* retrieves an attachment stream object from the model..
*
* @param[in] pModel - Model instance.
* @param[in] nIndex - Index of the attachment stream
* @param[out] pAttachmentInstance - Instance of the attachment object
* @return error code or 0 (success)
*/
typedef Lib3MFResult (*PLib3MFModel_GetAttachmentPtr) (Lib3MF_Model pModel, Lib3MF_uint32 nIndex, Lib3MF_Attachment * pAttachmentInstance);

/**
* retrieves an attachment stream object from the model.
*
* @param[in] pModel - Model instance.
* @param[in] pURI - Path URI in the package
* @param[out] pAttachmentInstance - Instance of the attachment object
* @return error code or 0 (success)
*/
typedef Lib3MFResult (*PLib3MFModel_FindAttachmentPtr) (Lib3MF_Model pModel, const char * pURI, Lib3MF_Attachment * pAttachmentInstance);

/**
* retrieves the number of attachments of the model.
*
* @param[in] pModel - Model instance.
* @param[out] pAttachmentCount - Returns the number of attachments.
* @return error code or 0 (success)
*/
typedef Lib3MFResult (*PLib3MFModel_GetAttachmentCountPtr) (Lib3MF_Model pModel, Lib3MF_uint32 * pAttachmentCount);

/**
* Retrieve whether the OPC package contains a package thumbnail.
*
* @param[in] pModel - Model instance.
* @param[out] pHasThumbnail - returns whether the OPC package contains a package thumbnail
* @return error code or 0 (success)
*/
typedef Lib3MFResult (*PLib3MFModel_HasPackageThumbnailAttachmentPtr) (Lib3MF_Model pModel, bool * pHasThumbnail);

/**
* Create a new or the existing package thumbnail for the OPC package.
*
* @param[in] pModel - Model instance.
* @param[out] pAttachment - Instance of a new or the existing thumbnailattachment object.
* @return error code or 0 (success)
*/
typedef Lib3MFResult (*PLib3MFModel_CreatePackageThumbnailAttachmentPtr) (Lib3MF_Model pModel, Lib3MF_Attachment * pAttachment);

/**
* Get the attachment to the OPC package containing the package thumbnail.
*
* @param[in] pModel - Model instance.
* @param[out] pAttachment - Instance of the thumbnailattachment object or NULL.
* @return error code or 0 (success)
*/
typedef Lib3MFResult (*PLib3MFModel_GetPackageThumbnailAttachmentPtr) (Lib3MF_Model pModel, Lib3MF_Attachment * pAttachment);

/**
* Remove the attachment to the OPC package containing the package thumbnail.
*
* @param[in] pModel - Model instance.
* @return error code or 0 (success)
*/
typedef Lib3MFResult (*PLib3MFModel_RemovePackageThumbnailAttachmentPtr) (Lib3MF_Model pModel);

/**
* Adds a new Content Type to the model.
*
* @param[in] pModel - Model instance.
* @param[in] pExtension - File Extension
* @param[in] pContentType - Content Type Identifier
* @return error code or 0 (success)
*/
typedef Lib3MFResult (*PLib3MFModel_AddCustomContentTypePtr) (Lib3MF_Model pModel, const char * pExtension, const char * pContentType);

/**
* Removes a custom Content Type from the model (UTF8 version).
*
* @param[in] pModel - Model instance.
* @param[in] pExtension - File Extension
* @return error code or 0 (success)
*/
typedef Lib3MFResult (*PLib3MFModel_RemoveCustomContentTypePtr) (Lib3MF_Model pModel, const char * pExtension);

/**
* Sets the random number generator callback for use in the library
*
* @param[in] pModel - Model instance.
* @param[in] pTheCallback - The callback used to generate random numbers
* @param[in] pUserData - Userdata to be passed to the callback function
* @return error code or 0 (success)
*/
typedef Lib3MFResult (*PLib3MFModel_SetRandomNumberCallbackPtr) (Lib3MF_Model pModel, Lib3MFRandomNumberCallback pTheCallback, Lib3MF_pvoid pUserData);

/**
* Gets the keystore associated with this model
*
* @param[in] pModel - Model instance.
* @param[out] pKeyStore - The package keystore
* @return error code or 0 (success)
*/
typedef Lib3MFResult (*PLib3MFModel_GetKeyStorePtr) (Lib3MF_Model pModel, Lib3MF_KeyStore * pKeyStore);

/*************************************************************************************************************************
 Global functions
**************************************************************************************************************************/

/**
* retrieves the binary version of this library.
*
* @param[out] pMajor - returns the major version of this library
* @param[out] pMinor - returns the minor version of this library
* @param[out] pMicro - returns the micro version of this library
* @return error code or 0 (success)
*/
typedef Lib3MFResult (*PLib3MFGetLibraryVersionPtr) (Lib3MF_uint32 * pMajor, Lib3MF_uint32 * pMinor, Lib3MF_uint32 * pMicro);

/**
* retrieves prerelease information of this library.
*
* @param[out] pHasPrereleaseInfo - Does the library provide prerelease version?
* @param[in] nPrereleaseInfoBufferSize - size of the buffer (including trailing 0)
* @param[out] pPrereleaseInfoNeededChars - will be filled with the count of the written bytes, or needed buffer size.
* @param[out] pPrereleaseInfoBuffer -  buffer of retrieves prerelease information of this library., may be NULL
* @return error code or 0 (success)
*/
typedef Lib3MFResult (*PLib3MFGetPrereleaseInformationPtr) (bool * pHasPrereleaseInfo, const Lib3MF_uint32 nPrereleaseInfoBufferSize, Lib3MF_uint32* pPrereleaseInfoNeededChars, char * pPrereleaseInfoBuffer);

/**
* retrieves build information of this library.
*
* @param[out] pHasBuildInfo - Does the library provide build version?
* @param[in] nBuildInformationBufferSize - size of the buffer (including trailing 0)
* @param[out] pBuildInformationNeededChars - will be filled with the count of the written bytes, or needed buffer size.
* @param[out] pBuildInformationBuffer -  buffer of retrieves build information of this library., may be NULL
* @return error code or 0 (success)
*/
typedef Lib3MFResult (*PLib3MFGetBuildInformationPtr) (bool * pHasBuildInfo, const Lib3MF_uint32 nBuildInformationBufferSize, Lib3MF_uint32* pBuildInformationNeededChars, char * pBuildInformationBuffer);

/**
* retrieves whether a specification is supported, and if so, which version.
*
* @param[in] pSpecificationURL - URL of extension to check
* @param[out] pIsSupported - returns whether this specification is supported
* @param[out] pMajor - returns the major version of the extension (if IsSupported)
* @param[out] pMinor - returns the minor version of the extension (if IsSupported)
* @param[out] pMicro - returns the micro version of the extension (if IsSupported)
* @return error code or 0 (success)
*/
typedef Lib3MFResult (*PLib3MFGetSpecificationVersionPtr) (const char * pSpecificationURL, bool * pIsSupported, Lib3MF_uint32 * pMajor, Lib3MF_uint32 * pMinor, Lib3MF_uint32 * pMicro);

/**
* creates an empty model instance.
*
* @param[out] pModel - returns an empty model instance
* @return error code or 0 (success)
*/
typedef Lib3MFResult (*PLib3MFCreateModelPtr) (Lib3MF_Model * pModel);

/**
* releases shared ownership of an object instance
*
* @param[in] pInstance - the object instance to release
* @return error code or 0 (success)
*/
typedef Lib3MFResult (*PLib3MFReleasePtr) (Lib3MF_Base pInstance);

/**
* acquires shared ownership of an object instance
*
* @param[in] pInstance - the object instance to acquire
* @return error code or 0 (success)
*/
typedef Lib3MFResult (*PLib3MFAcquirePtr) (Lib3MF_Base pInstance);

/**
* Sets the journal file path
*
* @param[in] pJournalPath - File name of the journal file
* @return error code or 0 (success)
*/
typedef Lib3MFResult (*PLib3MFSetJournalPtr) (const char * pJournalPath);

/**
* Retrieves the last error string of an instance
*
* @param[in] pInstance - Object where the error occured.
* @param[in] nLastErrorStringBufferSize - size of the buffer (including trailing 0)
* @param[out] pLastErrorStringNeededChars - will be filled with the count of the written bytes, or needed buffer size.
* @param[out] pLastErrorStringBuffer -  buffer of Last Error String, may be NULL
* @param[out] pHasLastError - Returns if the instance has a last error.
* @return error code or 0 (success)
*/
typedef Lib3MFResult (*PLib3MFGetLastErrorPtr) (Lib3MF_Base pInstance, const Lib3MF_uint32 nLastErrorStringBufferSize, Lib3MF_uint32* pLastErrorStringNeededChars, char * pLastErrorStringBuffer, bool * pHasLastError);

/**
* Return an English text for a progress identifier.|Note: this is the only function you can call from your callback function.
*
* @param[in] eTheProgressIdentifier - the progress identifier that is passed to the callback function
* @param[in] nProgressMessageBufferSize - size of the buffer (including trailing 0)
* @param[out] pProgressMessageNeededChars - will be filled with the count of the written bytes, or needed buffer size.
* @param[out] pProgressMessageBuffer -  buffer of English text for the progress identifier, may be NULL
* @return error code or 0 (success)
*/
typedef Lib3MFResult (*PLib3MFRetrieveProgressMessagePtr) (eLib3MFProgressIdentifier eTheProgressIdentifier, const Lib3MF_uint32 nProgressMessageBufferSize, Lib3MF_uint32* pProgressMessageNeededChars, char * pProgressMessageBuffer);

/**
* Creates a Color from uint8 RGBA values
*
* @param[in] nRed - Red value of color (0-255)
* @param[in] nGreen - Green value of color (0-255)
* @param[in] nBlue - Blue value of color (0-255)
* @param[in] nAlpha - Alpha value of color (0-255)
* @param[out] pTheColor - Assembled color
* @return error code or 0 (success)
*/
typedef Lib3MFResult (*PLib3MFRGBAToColorPtr) (Lib3MF_uint8 nRed, Lib3MF_uint8 nGreen, Lib3MF_uint8 nBlue, Lib3MF_uint8 nAlpha, sLib3MFColor * pTheColor);

/**
* Creates a Color from uint8 RGBA values
*
* @param[in] fRed - Red value of color (0-1)
* @param[in] fGreen - Green value of color (0-1)
* @param[in] fBlue - Blue value of color (0-1)
* @param[in] fAlpha - Alpha value of color (0-1)
* @param[out] pTheColor - Assembled color
* @return error code or 0 (success)
*/
typedef Lib3MFResult (*PLib3MFFloatRGBAToColorPtr) (Lib3MF_single fRed, Lib3MF_single fGreen, Lib3MF_single fBlue, Lib3MF_single fAlpha, sLib3MFColor * pTheColor);

/**
* Calculates uint8-RGBA-values from a Color
*
* @param[in] pTheColor - Color to handle
* @param[out] pRed - Red value of color (0-255)
* @param[out] pGreen - Green value of color (0-255)
* @param[out] pBlue - Blue value of color (0-255)
* @param[out] pAlpha - Alpha value of color (0-255)
* @return error code or 0 (success)
*/
typedef Lib3MFResult (*PLib3MFColorToRGBAPtr) (const sLib3MFColor * pTheColor, Lib3MF_uint8 * pRed, Lib3MF_uint8 * pGreen, Lib3MF_uint8 * pBlue, Lib3MF_uint8 * pAlpha);

/**
* Calculates float-RGBA-values from a Color
*
* @param[in] pTheColor - Color to handle
* @param[out] pRed - Red value of color (0-1)
* @param[out] pGreen - Green value of color (0-1)
* @param[out] pBlue - Blue value of color (0-1)
* @param[out] pAlpha - Alpha value of color (0-1)
* @return error code or 0 (success)
*/
typedef Lib3MFResult (*PLib3MFColorToFloatRGBAPtr) (const sLib3MFColor * pTheColor, Lib3MF_single * pRed, Lib3MF_single * pGreen, Lib3MF_single * pBlue, Lib3MF_single * pAlpha);

/**
* Creates an identity transform
*
* @param[out] pTransform - Transformation matrix.
* @return error code or 0 (success)
*/
typedef Lib3MFResult (*PLib3MFGetIdentityTransformPtr) (sLib3MFTransform * pTransform);

/**
* Creates a uniform scale transform
*
* @param[in] fFactor - Factor in X, Y and Z
* @param[out] pTransform - Transformation matrix.
* @return error code or 0 (success)
*/
typedef Lib3MFResult (*PLib3MFGetUniformScaleTransformPtr) (Lib3MF_single fFactor, sLib3MFTransform * pTransform);

/**
* Creates a scale transform
*
* @param[in] fFactorX - Factor in X
* @param[in] fFactorY - Factor in Y
* @param[in] fFactorZ - Factor in Z
* @param[out] pTransform - Transformation matrix.
* @return error code or 0 (success)
*/
typedef Lib3MFResult (*PLib3MFGetScaleTransformPtr) (Lib3MF_single fFactorX, Lib3MF_single fFactorY, Lib3MF_single fFactorZ, sLib3MFTransform * pTransform);

/**
* Creates an translation transform
*
* @param[in] fVectorX - Translation in X
* @param[in] fVectorY - Translation in Y
* @param[in] fVectorZ - Translation in Z
* @param[out] pTransform - Transformation matrix.
* @return error code or 0 (success)
*/
typedef Lib3MFResult (*PLib3MFGetTranslationTransformPtr) (Lib3MF_single fVectorX, Lib3MF_single fVectorY, Lib3MF_single fVectorZ, sLib3MFTransform * pTransform);

/*************************************************************************************************************************
 Function Table Structure
**************************************************************************************************************************/

typedef struct {
	void * m_LibraryHandle;
	PLib3MFWriter_WriteToFilePtr m_Writer_WriteToFile;
	PLib3MFWriter_GetStreamSizePtr m_Writer_GetStreamSize;
	PLib3MFWriter_WriteToBufferPtr m_Writer_WriteToBuffer;
	PLib3MFWriter_WriteToCallbackPtr m_Writer_WriteToCallback;
	PLib3MFWriter_SetProgressCallbackPtr m_Writer_SetProgressCallback;
	PLib3MFWriter_GetDecimalPrecisionPtr m_Writer_GetDecimalPrecision;
	PLib3MFWriter_SetDecimalPrecisionPtr m_Writer_SetDecimalPrecision;
	PLib3MFWriter_SetStrictModeActivePtr m_Writer_SetStrictModeActive;
	PLib3MFWriter_GetStrictModeActivePtr m_Writer_GetStrictModeActive;
	PLib3MFWriter_GetWarningPtr m_Writer_GetWarning;
	PLib3MFWriter_GetWarningCountPtr m_Writer_GetWarningCount;
	PLib3MFWriter_AddKeyWrappingCallbackPtr m_Writer_AddKeyWrappingCallback;
	PLib3MFWriter_SetContentEncryptionCallbackPtr m_Writer_SetContentEncryptionCallback;
	PLib3MFReader_ReadFromFilePtr m_Reader_ReadFromFile;
	PLib3MFReader_ReadFromBufferPtr m_Reader_ReadFromBuffer;
	PLib3MFReader_ReadFromCallbackPtr m_Reader_ReadFromCallback;
	PLib3MFReader_SetProgressCallbackPtr m_Reader_SetProgressCallback;
	PLib3MFReader_AddRelationToReadPtr m_Reader_AddRelationToRead;
	PLib3MFReader_RemoveRelationToReadPtr m_Reader_RemoveRelationToRead;
	PLib3MFReader_SetStrictModeActivePtr m_Reader_SetStrictModeActive;
	PLib3MFReader_GetStrictModeActivePtr m_Reader_GetStrictModeActive;
	PLib3MFReader_GetWarningPtr m_Reader_GetWarning;
	PLib3MFReader_GetWarningCountPtr m_Reader_GetWarningCount;
	PLib3MFReader_AddKeyWrappingCallbackPtr m_Reader_AddKeyWrappingCallback;
	PLib3MFReader_SetContentEncryptionCallbackPtr m_Reader_SetContentEncryptionCallback;
	PLib3MFPackagePart_GetPathPtr m_PackagePart_GetPath;
	PLib3MFPackagePart_SetPathPtr m_PackagePart_SetPath;
	PLib3MFResource_GetResourceIDPtr m_Resource_GetResourceID;
	PLib3MFResource_GetUniqueResourceIDPtr m_Resource_GetUniqueResourceID;
	PLib3MFResource_PackagePartPtr m_Resource_PackagePart;
	PLib3MFResource_SetPackagePartPtr m_Resource_SetPackagePart;
	PLib3MFResource_GetModelResourceIDPtr m_Resource_GetModelResourceID;
	PLib3MFResourceIterator_MoveNextPtr m_ResourceIterator_MoveNext;
	PLib3MFResourceIterator_MovePreviousPtr m_ResourceIterator_MovePrevious;
	PLib3MFResourceIterator_GetCurrentPtr m_ResourceIterator_GetCurrent;
	PLib3MFResourceIterator_ClonePtr m_ResourceIterator_Clone;
	PLib3MFResourceIterator_CountPtr m_ResourceIterator_Count;
	PLib3MFSliceStackIterator_GetCurrentSliceStackPtr m_SliceStackIterator_GetCurrentSliceStack;
	PLib3MFObjectIterator_GetCurrentObjectPtr m_ObjectIterator_GetCurrentObject;
	PLib3MFMeshObjectIterator_GetCurrentMeshObjectPtr m_MeshObjectIterator_GetCurrentMeshObject;
	PLib3MFComponentsObjectIterator_GetCurrentComponentsObjectPtr m_ComponentsObjectIterator_GetCurrentComponentsObject;
	PLib3MFTexture2DIterator_GetCurrentTexture2DPtr m_Texture2DIterator_GetCurrentTexture2D;
	PLib3MFBaseMaterialGroupIterator_GetCurrentBaseMaterialGroupPtr m_BaseMaterialGroupIterator_GetCurrentBaseMaterialGroup;
	PLib3MFColorGroupIterator_GetCurrentColorGroupPtr m_ColorGroupIterator_GetCurrentColorGroup;
	PLib3MFTexture2DGroupIterator_GetCurrentTexture2DGroupPtr m_Texture2DGroupIterator_GetCurrentTexture2DGroup;
	PLib3MFCompositeMaterialsIterator_GetCurrentCompositeMaterialsPtr m_CompositeMaterialsIterator_GetCurrentCompositeMaterials;
	PLib3MFMultiPropertyGroupIterator_GetCurrentMultiPropertyGroupPtr m_MultiPropertyGroupIterator_GetCurrentMultiPropertyGroup;
	PLib3MFMetaData_GetNameSpacePtr m_MetaData_GetNameSpace;
	PLib3MFMetaData_SetNameSpacePtr m_MetaData_SetNameSpace;
	PLib3MFMetaData_GetNamePtr m_MetaData_GetName;
	PLib3MFMetaData_SetNamePtr m_MetaData_SetName;
	PLib3MFMetaData_GetKeyPtr m_MetaData_GetKey;
	PLib3MFMetaData_GetMustPreservePtr m_MetaData_GetMustPreserve;
	PLib3MFMetaData_SetMustPreservePtr m_MetaData_SetMustPreserve;
	PLib3MFMetaData_GetTypePtr m_MetaData_GetType;
	PLib3MFMetaData_SetTypePtr m_MetaData_SetType;
	PLib3MFMetaData_GetValuePtr m_MetaData_GetValue;
	PLib3MFMetaData_SetValuePtr m_MetaData_SetValue;
	PLib3MFMetaDataGroup_GetMetaDataCountPtr m_MetaDataGroup_GetMetaDataCount;
	PLib3MFMetaDataGroup_GetMetaDataPtr m_MetaDataGroup_GetMetaData;
	PLib3MFMetaDataGroup_GetMetaDataByKeyPtr m_MetaDataGroup_GetMetaDataByKey;
	PLib3MFMetaDataGroup_RemoveMetaDataByIndexPtr m_MetaDataGroup_RemoveMetaDataByIndex;
	PLib3MFMetaDataGroup_RemoveMetaDataPtr m_MetaDataGroup_RemoveMetaData;
	PLib3MFMetaDataGroup_AddMetaDataPtr m_MetaDataGroup_AddMetaData;
	PLib3MFObject_GetTypePtr m_Object_GetType;
	PLib3MFObject_SetTypePtr m_Object_SetType;
	PLib3MFObject_GetNamePtr m_Object_GetName;
	PLib3MFObject_SetNamePtr m_Object_SetName;
	PLib3MFObject_GetPartNumberPtr m_Object_GetPartNumber;
	PLib3MFObject_SetPartNumberPtr m_Object_SetPartNumber;
	PLib3MFObject_IsMeshObjectPtr m_Object_IsMeshObject;
	PLib3MFObject_IsComponentsObjectPtr m_Object_IsComponentsObject;
	PLib3MFObject_IsValidPtr m_Object_IsValid;
	PLib3MFObject_SetAttachmentAsThumbnailPtr m_Object_SetAttachmentAsThumbnail;
	PLib3MFObject_GetThumbnailAttachmentPtr m_Object_GetThumbnailAttachment;
	PLib3MFObject_ClearThumbnailAttachmentPtr m_Object_ClearThumbnailAttachment;
	PLib3MFObject_GetOutboxPtr m_Object_GetOutbox;
	PLib3MFObject_GetUUIDPtr m_Object_GetUUID;
	PLib3MFObject_SetUUIDPtr m_Object_SetUUID;
	PLib3MFObject_GetMetaDataGroupPtr m_Object_GetMetaDataGroup;
	PLib3MFObject_SetSlicesMeshResolutionPtr m_Object_SetSlicesMeshResolution;
	PLib3MFObject_GetSlicesMeshResolutionPtr m_Object_GetSlicesMeshResolution;
	PLib3MFObject_HasSlicesPtr m_Object_HasSlices;
	PLib3MFObject_ClearSliceStackPtr m_Object_ClearSliceStack;
	PLib3MFObject_GetSliceStackPtr m_Object_GetSliceStack;
	PLib3MFObject_AssignSliceStackPtr m_Object_AssignSliceStack;
	PLib3MFMeshObject_GetVertexCountPtr m_MeshObject_GetVertexCount;
	PLib3MFMeshObject_GetTriangleCountPtr m_MeshObject_GetTriangleCount;
	PLib3MFMeshObject_GetVertexPtr m_MeshObject_GetVertex;
	PLib3MFMeshObject_SetVertexPtr m_MeshObject_SetVertex;
	PLib3MFMeshObject_AddVertexPtr m_MeshObject_AddVertex;
	PLib3MFMeshObject_GetVerticesPtr m_MeshObject_GetVertices;
	PLib3MFMeshObject_GetTrianglePtr m_MeshObject_GetTriangle;
	PLib3MFMeshObject_SetTrianglePtr m_MeshObject_SetTriangle;
	PLib3MFMeshObject_AddTrianglePtr m_MeshObject_AddTriangle;
	PLib3MFMeshObject_GetTriangleIndicesPtr m_MeshObject_GetTriangleIndices;
	PLib3MFMeshObject_SetObjectLevelPropertyPtr m_MeshObject_SetObjectLevelProperty;
	PLib3MFMeshObject_GetObjectLevelPropertyPtr m_MeshObject_GetObjectLevelProperty;
	PLib3MFMeshObject_SetTrianglePropertiesPtr m_MeshObject_SetTriangleProperties;
	PLib3MFMeshObject_GetTrianglePropertiesPtr m_MeshObject_GetTriangleProperties;
	PLib3MFMeshObject_SetAllTrianglePropertiesPtr m_MeshObject_SetAllTriangleProperties;
	PLib3MFMeshObject_GetAllTrianglePropertiesPtr m_MeshObject_GetAllTriangleProperties;
	PLib3MFMeshObject_ClearAllPropertiesPtr m_MeshObject_ClearAllProperties;
	PLib3MFMeshObject_SetGeometryPtr m_MeshObject_SetGeometry;
	PLib3MFMeshObject_IsManifoldAndOrientedPtr m_MeshObject_IsManifoldAndOriented;
	PLib3MFMeshObject_BeamLatticePtr m_MeshObject_BeamLattice;
	PLib3MFBeamLattice_GetMinLengthPtr m_BeamLattice_GetMinLength;
	PLib3MFBeamLattice_SetMinLengthPtr m_BeamLattice_SetMinLength;
	PLib3MFBeamLattice_GetClippingPtr m_BeamLattice_GetClipping;
	PLib3MFBeamLattice_SetClippingPtr m_BeamLattice_SetClipping;
	PLib3MFBeamLattice_GetRepresentationPtr m_BeamLattice_GetRepresentation;
	PLib3MFBeamLattice_SetRepresentationPtr m_BeamLattice_SetRepresentation;
	PLib3MFBeamLattice_GetBallOptionsPtr m_BeamLattice_GetBallOptions;
	PLib3MFBeamLattice_SetBallOptionsPtr m_BeamLattice_SetBallOptions;
	PLib3MFBeamLattice_GetBeamCountPtr m_BeamLattice_GetBeamCount;
	PLib3MFBeamLattice_GetBeamPtr m_BeamLattice_GetBeam;
	PLib3MFBeamLattice_AddBeamPtr m_BeamLattice_AddBeam;
	PLib3MFBeamLattice_SetBeamPtr m_BeamLattice_SetBeam;
	PLib3MFBeamLattice_SetBeamsPtr m_BeamLattice_SetBeams;
	PLib3MFBeamLattice_GetBeamsPtr m_BeamLattice_GetBeams;
	PLib3MFBeamLattice_GetBallCountPtr m_BeamLattice_GetBallCount;
	PLib3MFBeamLattice_GetBallPtr m_BeamLattice_GetBall;
	PLib3MFBeamLattice_AddBallPtr m_BeamLattice_AddBall;
	PLib3MFBeamLattice_SetBallPtr m_BeamLattice_SetBall;
	PLib3MFBeamLattice_SetBallsPtr m_BeamLattice_SetBalls;
	PLib3MFBeamLattice_GetBallsPtr m_BeamLattice_GetBalls;
	PLib3MFBeamLattice_GetBeamSetCountPtr m_BeamLattice_GetBeamSetCount;
	PLib3MFBeamLattice_AddBeamSetPtr m_BeamLattice_AddBeamSet;
	PLib3MFBeamLattice_GetBeamSetPtr m_BeamLattice_GetBeamSet;
	PLib3MFComponent_GetObjectResourcePtr m_Component_GetObjectResource;
	PLib3MFComponent_GetObjectResourceIDPtr m_Component_GetObjectResourceID;
	PLib3MFComponent_GetUUIDPtr m_Component_GetUUID;
	PLib3MFComponent_SetUUIDPtr m_Component_SetUUID;
	PLib3MFComponent_HasTransformPtr m_Component_HasTransform;
	PLib3MFComponent_GetTransformPtr m_Component_GetTransform;
	PLib3MFComponent_SetTransformPtr m_Component_SetTransform;
	PLib3MFComponentsObject_AddComponentPtr m_ComponentsObject_AddComponent;
	PLib3MFComponentsObject_GetComponentPtr m_ComponentsObject_GetComponent;
	PLib3MFComponentsObject_GetComponentCountPtr m_ComponentsObject_GetComponentCount;
	PLib3MFBeamSet_SetNamePtr m_BeamSet_SetName;
	PLib3MFBeamSet_GetNamePtr m_BeamSet_GetName;
	PLib3MFBeamSet_SetIdentifierPtr m_BeamSet_SetIdentifier;
	PLib3MFBeamSet_GetIdentifierPtr m_BeamSet_GetIdentifier;
	PLib3MFBeamSet_GetReferenceCountPtr m_BeamSet_GetReferenceCount;
	PLib3MFBeamSet_SetReferencesPtr m_BeamSet_SetReferences;
	PLib3MFBeamSet_GetReferencesPtr m_BeamSet_GetReferences;
	PLib3MFBeamSet_GetBallReferenceCountPtr m_BeamSet_GetBallReferenceCount;
	PLib3MFBeamSet_SetBallReferencesPtr m_BeamSet_SetBallReferences;
	PLib3MFBeamSet_GetBallReferencesPtr m_BeamSet_GetBallReferences;
	PLib3MFBaseMaterialGroup_GetCountPtr m_BaseMaterialGroup_GetCount;
	PLib3MFBaseMaterialGroup_GetAllPropertyIDsPtr m_BaseMaterialGroup_GetAllPropertyIDs;
	PLib3MFBaseMaterialGroup_AddMaterialPtr m_BaseMaterialGroup_AddMaterial;
	PLib3MFBaseMaterialGroup_RemoveMaterialPtr m_BaseMaterialGroup_RemoveMaterial;
	PLib3MFBaseMaterialGroup_GetNamePtr m_BaseMaterialGroup_GetName;
	PLib3MFBaseMaterialGroup_SetNamePtr m_BaseMaterialGroup_SetName;
	PLib3MFBaseMaterialGroup_SetDisplayColorPtr m_BaseMaterialGroup_SetDisplayColor;
	PLib3MFBaseMaterialGroup_GetDisplayColorPtr m_BaseMaterialGroup_GetDisplayColor;
	PLib3MFColorGroup_GetCountPtr m_ColorGroup_GetCount;
	PLib3MFColorGroup_GetAllPropertyIDsPtr m_ColorGroup_GetAllPropertyIDs;
	PLib3MFColorGroup_AddColorPtr m_ColorGroup_AddColor;
	PLib3MFColorGroup_RemoveColorPtr m_ColorGroup_RemoveColor;
	PLib3MFColorGroup_SetColorPtr m_ColorGroup_SetColor;
	PLib3MFColorGroup_GetColorPtr m_ColorGroup_GetColor;
	PLib3MFTexture2DGroup_GetCountPtr m_Texture2DGroup_GetCount;
	PLib3MFTexture2DGroup_GetAllPropertyIDsPtr m_Texture2DGroup_GetAllPropertyIDs;
	PLib3MFTexture2DGroup_AddTex2CoordPtr m_Texture2DGroup_AddTex2Coord;
	PLib3MFTexture2DGroup_GetTex2CoordPtr m_Texture2DGroup_GetTex2Coord;
	PLib3MFTexture2DGroup_RemoveTex2CoordPtr m_Texture2DGroup_RemoveTex2Coord;
	PLib3MFTexture2DGroup_GetTexture2DPtr m_Texture2DGroup_GetTexture2D;
	PLib3MFCompositeMaterials_GetCountPtr m_CompositeMaterials_GetCount;
	PLib3MFCompositeMaterials_GetAllPropertyIDsPtr m_CompositeMaterials_GetAllPropertyIDs;
	PLib3MFCompositeMaterials_GetBaseMaterialGroupPtr m_CompositeMaterials_GetBaseMaterialGroup;
	PLib3MFCompositeMaterials_AddCompositePtr m_CompositeMaterials_AddComposite;
	PLib3MFCompositeMaterials_RemoveCompositePtr m_CompositeMaterials_RemoveComposite;
	PLib3MFCompositeMaterials_GetCompositePtr m_CompositeMaterials_GetComposite;
	PLib3MFMultiPropertyGroup_GetCountPtr m_MultiPropertyGroup_GetCount;
	PLib3MFMultiPropertyGroup_GetAllPropertyIDsPtr m_MultiPropertyGroup_GetAllPropertyIDs;
	PLib3MFMultiPropertyGroup_AddMultiPropertyPtr m_MultiPropertyGroup_AddMultiProperty;
	PLib3MFMultiPropertyGroup_SetMultiPropertyPtr m_MultiPropertyGroup_SetMultiProperty;
	PLib3MFMultiPropertyGroup_GetMultiPropertyPtr m_MultiPropertyGroup_GetMultiProperty;
	PLib3MFMultiPropertyGroup_RemoveMultiPropertyPtr m_MultiPropertyGroup_RemoveMultiProperty;
	PLib3MFMultiPropertyGroup_GetLayerCountPtr m_MultiPropertyGroup_GetLayerCount;
	PLib3MFMultiPropertyGroup_AddLayerPtr m_MultiPropertyGroup_AddLayer;
	PLib3MFMultiPropertyGroup_GetLayerPtr m_MultiPropertyGroup_GetLayer;
	PLib3MFMultiPropertyGroup_RemoveLayerPtr m_MultiPropertyGroup_RemoveLayer;
	PLib3MFAttachment_GetPathPtr m_Attachment_GetPath;
	PLib3MFAttachment_SetPathPtr m_Attachment_SetPath;
	PLib3MFAttachment_PackagePartPtr m_Attachment_PackagePart;
	PLib3MFAttachment_GetRelationShipTypePtr m_Attachment_GetRelationShipType;
	PLib3MFAttachment_SetRelationShipTypePtr m_Attachment_SetRelationShipType;
	PLib3MFAttachment_WriteToFilePtr m_Attachment_WriteToFile;
	PLib3MFAttachment_ReadFromFilePtr m_Attachment_ReadFromFile;
	PLib3MFAttachment_GetStreamSizePtr m_Attachment_GetStreamSize;
	PLib3MFAttachment_WriteToBufferPtr m_Attachment_WriteToBuffer;
	PLib3MFAttachment_ReadFromBufferPtr m_Attachment_ReadFromBuffer;
	PLib3MFTexture2D_GetAttachmentPtr m_Texture2D_GetAttachment;
	PLib3MFTexture2D_SetAttachmentPtr m_Texture2D_SetAttachment;
	PLib3MFTexture2D_GetContentTypePtr m_Texture2D_GetContentType;
	PLib3MFTexture2D_SetContentTypePtr m_Texture2D_SetContentType;
	PLib3MFTexture2D_GetTileStyleUVPtr m_Texture2D_GetTileStyleUV;
	PLib3MFTexture2D_SetTileStyleUVPtr m_Texture2D_SetTileStyleUV;
	PLib3MFTexture2D_GetFilterPtr m_Texture2D_GetFilter;
	PLib3MFTexture2D_SetFilterPtr m_Texture2D_SetFilter;
	PLib3MFBuildItem_GetObjectResourcePtr m_BuildItem_GetObjectResource;
	PLib3MFBuildItem_GetUUIDPtr m_BuildItem_GetUUID;
	PLib3MFBuildItem_SetUUIDPtr m_BuildItem_SetUUID;
	PLib3MFBuildItem_GetObjectResourceIDPtr m_BuildItem_GetObjectResourceID;
	PLib3MFBuildItem_HasObjectTransformPtr m_BuildItem_HasObjectTransform;
	PLib3MFBuildItem_GetObjectTransformPtr m_BuildItem_GetObjectTransform;
	PLib3MFBuildItem_SetObjectTransformPtr m_BuildItem_SetObjectTransform;
	PLib3MFBuildItem_GetPartNumberPtr m_BuildItem_GetPartNumber;
	PLib3MFBuildItem_SetPartNumberPtr m_BuildItem_SetPartNumber;
	PLib3MFBuildItem_GetMetaDataGroupPtr m_BuildItem_GetMetaDataGroup;
	PLib3MFBuildItem_GetOutboxPtr m_BuildItem_GetOutbox;
	PLib3MFBuildItemIterator_MoveNextPtr m_BuildItemIterator_MoveNext;
	PLib3MFBuildItemIterator_MovePreviousPtr m_BuildItemIterator_MovePrevious;
	PLib3MFBuildItemIterator_GetCurrentPtr m_BuildItemIterator_GetCurrent;
	PLib3MFBuildItemIterator_ClonePtr m_BuildItemIterator_Clone;
	PLib3MFBuildItemIterator_CountPtr m_BuildItemIterator_Count;
	PLib3MFSlice_SetVerticesPtr m_Slice_SetVertices;
	PLib3MFSlice_GetVerticesPtr m_Slice_GetVertices;
	PLib3MFSlice_GetVertexCountPtr m_Slice_GetVertexCount;
	PLib3MFSlice_AddPolygonPtr m_Slice_AddPolygon;
	PLib3MFSlice_GetPolygonCountPtr m_Slice_GetPolygonCount;
	PLib3MFSlice_SetPolygonIndicesPtr m_Slice_SetPolygonIndices;
	PLib3MFSlice_GetPolygonIndicesPtr m_Slice_GetPolygonIndices;
	PLib3MFSlice_GetPolygonIndexCountPtr m_Slice_GetPolygonIndexCount;
	PLib3MFSlice_GetZTopPtr m_Slice_GetZTop;
	PLib3MFSliceStack_GetBottomZPtr m_SliceStack_GetBottomZ;
	PLib3MFSliceStack_GetSliceCountPtr m_SliceStack_GetSliceCount;
	PLib3MFSliceStack_GetSlicePtr m_SliceStack_GetSlice;
	PLib3MFSliceStack_AddSlicePtr m_SliceStack_AddSlice;
	PLib3MFSliceStack_GetSliceRefCountPtr m_SliceStack_GetSliceRefCount;
	PLib3MFSliceStack_AddSliceStackReferencePtr m_SliceStack_AddSliceStackReference;
	PLib3MFSliceStack_GetSliceStackReferencePtr m_SliceStack_GetSliceStackReference;
	PLib3MFSliceStack_CollapseSliceReferencesPtr m_SliceStack_CollapseSliceReferences;
	PLib3MFSliceStack_SetOwnPathPtr m_SliceStack_SetOwnPath;
	PLib3MFSliceStack_GetOwnPathPtr m_SliceStack_GetOwnPath;
	PLib3MFConsumer_GetConsumerIDPtr m_Consumer_GetConsumerID;
	PLib3MFConsumer_GetKeyIDPtr m_Consumer_GetKeyID;
	PLib3MFConsumer_GetKeyValuePtr m_Consumer_GetKeyValue;
	PLib3MFAccessRight_GetConsumerPtr m_AccessRight_GetConsumer;
	PLib3MFAccessRight_GetWrappingAlgorithmPtr m_AccessRight_GetWrappingAlgorithm;
	PLib3MFAccessRight_GetMgfAlgorithmPtr m_AccessRight_GetMgfAlgorithm;
	PLib3MFAccessRight_GetDigestMethodPtr m_AccessRight_GetDigestMethod;
	PLib3MFContentEncryptionParams_GetEncryptionAlgorithmPtr m_ContentEncryptionParams_GetEncryptionAlgorithm;
	PLib3MFContentEncryptionParams_GetKeyPtr m_ContentEncryptionParams_GetKey;
	PLib3MFContentEncryptionParams_GetInitializationVectorPtr m_ContentEncryptionParams_GetInitializationVector;
	PLib3MFContentEncryptionParams_GetAuthenticationTagPtr m_ContentEncryptionParams_GetAuthenticationTag;
	PLib3MFContentEncryptionParams_SetAuthenticationTagPtr m_ContentEncryptionParams_SetAuthenticationTag;
	PLib3MFContentEncryptionParams_GetAdditionalAuthenticationDataPtr m_ContentEncryptionParams_GetAdditionalAuthenticationData;
	PLib3MFContentEncryptionParams_GetDescriptorPtr m_ContentEncryptionParams_GetDescriptor;
	PLib3MFContentEncryptionParams_GetKeyUUIDPtr m_ContentEncryptionParams_GetKeyUUID;
	PLib3MFResourceData_GetPathPtr m_ResourceData_GetPath;
	PLib3MFResourceData_GetEncryptionAlgorithmPtr m_ResourceData_GetEncryptionAlgorithm;
	PLib3MFResourceData_GetCompressionPtr m_ResourceData_GetCompression;
	PLib3MFResourceData_GetAdditionalAuthenticationDataPtr m_ResourceData_GetAdditionalAuthenticationData;
	PLib3MFResourceDataGroup_GetKeyUUIDPtr m_ResourceDataGroup_GetKeyUUID;
	PLib3MFResourceDataGroup_AddAccessRightPtr m_ResourceDataGroup_AddAccessRight;
	PLib3MFResourceDataGroup_FindAccessRightByConsumerPtr m_ResourceDataGroup_FindAccessRightByConsumer;
	PLib3MFResourceDataGroup_RemoveAccessRightPtr m_ResourceDataGroup_RemoveAccessRight;
	PLib3MFKeyStore_AddConsumerPtr m_KeyStore_AddConsumer;
	PLib3MFKeyStore_GetConsumerCountPtr m_KeyStore_GetConsumerCount;
	PLib3MFKeyStore_GetConsumerPtr m_KeyStore_GetConsumer;
	PLib3MFKeyStore_RemoveConsumerPtr m_KeyStore_RemoveConsumer;
	PLib3MFKeyStore_FindConsumerPtr m_KeyStore_FindConsumer;
	PLib3MFKeyStore_GetResourceDataGroupCountPtr m_KeyStore_GetResourceDataGroupCount;
	PLib3MFKeyStore_AddResourceDataGroupPtr m_KeyStore_AddResourceDataGroup;
	PLib3MFKeyStore_GetResourceDataGroupPtr m_KeyStore_GetResourceDataGroup;
	PLib3MFKeyStore_RemoveResourceDataGroupPtr m_KeyStore_RemoveResourceDataGroup;
	PLib3MFKeyStore_FindResourceDataGroupPtr m_KeyStore_FindResourceDataGroup;
	PLib3MFKeyStore_AddResourceDataPtr m_KeyStore_AddResourceData;
	PLib3MFKeyStore_RemoveResourceDataPtr m_KeyStore_RemoveResourceData;
	PLib3MFKeyStore_FindResourceDataPtr m_KeyStore_FindResourceData;
	PLib3MFKeyStore_GetResourceDataCountPtr m_KeyStore_GetResourceDataCount;
	PLib3MFKeyStore_GetResourceDataPtr m_KeyStore_GetResourceData;
	PLib3MFKeyStore_GetUUIDPtr m_KeyStore_GetUUID;
	PLib3MFKeyStore_SetUUIDPtr m_KeyStore_SetUUID;
	PLib3MFModel_RootModelPartPtr m_Model_RootModelPart;
	PLib3MFModel_FindOrCreatePackagePartPtr m_Model_FindOrCreatePackagePart;
	PLib3MFModel_SetUnitPtr m_Model_SetUnit;
	PLib3MFModel_GetUnitPtr m_Model_GetUnit;
	PLib3MFModel_GetLanguagePtr m_Model_GetLanguage;
	PLib3MFModel_SetLanguagePtr m_Model_SetLanguage;
	PLib3MFModel_QueryWriterPtr m_Model_QueryWriter;
	PLib3MFModel_QueryReaderPtr m_Model_QueryReader;
	PLib3MFModel_GetTexture2DByIDPtr m_Model_GetTexture2DByID;
	PLib3MFModel_GetPropertyTypeByIDPtr m_Model_GetPropertyTypeByID;
	PLib3MFModel_GetBaseMaterialGroupByIDPtr m_Model_GetBaseMaterialGroupByID;
	PLib3MFModel_GetTexture2DGroupByIDPtr m_Model_GetTexture2DGroupByID;
	PLib3MFModel_GetCompositeMaterialsByIDPtr m_Model_GetCompositeMaterialsByID;
	PLib3MFModel_GetMultiPropertyGroupByIDPtr m_Model_GetMultiPropertyGroupByID;
	PLib3MFModel_GetMeshObjectByIDPtr m_Model_GetMeshObjectByID;
	PLib3MFModel_GetComponentsObjectByIDPtr m_Model_GetComponentsObjectByID;
	PLib3MFModel_GetColorGroupByIDPtr m_Model_GetColorGroupByID;
	PLib3MFModel_GetSliceStackByIDPtr m_Model_GetSliceStackByID;
	PLib3MFModel_GetBuildUUIDPtr m_Model_GetBuildUUID;
	PLib3MFModel_SetBuildUUIDPtr m_Model_SetBuildUUID;
	PLib3MFModel_GetBuildItemsPtr m_Model_GetBuildItems;
	PLib3MFModel_GetOutboxPtr m_Model_GetOutbox;
	PLib3MFModel_GetResourcesPtr m_Model_GetResources;
	PLib3MFModel_GetObjectsPtr m_Model_GetObjects;
	PLib3MFModel_GetMeshObjectsPtr m_Model_GetMeshObjects;
	PLib3MFModel_GetComponentsObjectsPtr m_Model_GetComponentsObjects;
	PLib3MFModel_GetTexture2DsPtr m_Model_GetTexture2Ds;
	PLib3MFModel_GetBaseMaterialGroupsPtr m_Model_GetBaseMaterialGroups;
	PLib3MFModel_GetColorGroupsPtr m_Model_GetColorGroups;
	PLib3MFModel_GetTexture2DGroupsPtr m_Model_GetTexture2DGroups;
	PLib3MFModel_GetCompositeMaterialsPtr m_Model_GetCompositeMaterials;
	PLib3MFModel_GetMultiPropertyGroupsPtr m_Model_GetMultiPropertyGroups;
	PLib3MFModel_GetSliceStacksPtr m_Model_GetSliceStacks;
	PLib3MFModel_MergeToModelPtr m_Model_MergeToModel;
	PLib3MFModel_AddMeshObjectPtr m_Model_AddMeshObject;
	PLib3MFModel_AddComponentsObjectPtr m_Model_AddComponentsObject;
	PLib3MFModel_AddSliceStackPtr m_Model_AddSliceStack;
	PLib3MFModel_AddTexture2DFromAttachmentPtr m_Model_AddTexture2DFromAttachment;
	PLib3MFModel_AddBaseMaterialGroupPtr m_Model_AddBaseMaterialGroup;
	PLib3MFModel_AddColorGroupPtr m_Model_AddColorGroup;
	PLib3MFModel_AddTexture2DGroupPtr m_Model_AddTexture2DGroup;
	PLib3MFModel_AddCompositeMaterialsPtr m_Model_AddCompositeMaterials;
	PLib3MFModel_AddMultiPropertyGroupPtr m_Model_AddMultiPropertyGroup;
	PLib3MFModel_AddBuildItemPtr m_Model_AddBuildItem;
	PLib3MFModel_RemoveBuildItemPtr m_Model_RemoveBuildItem;
	PLib3MFModel_GetMetaDataGroupPtr m_Model_GetMetaDataGroup;
	PLib3MFModel_AddAttachmentPtr m_Model_AddAttachment;
	PLib3MFModel_RemoveAttachmentPtr m_Model_RemoveAttachment;
	PLib3MFModel_GetAttachmentPtr m_Model_GetAttachment;
	PLib3MFModel_FindAttachmentPtr m_Model_FindAttachment;
	PLib3MFModel_GetAttachmentCountPtr m_Model_GetAttachmentCount;
	PLib3MFModel_HasPackageThumbnailAttachmentPtr m_Model_HasPackageThumbnailAttachment;
	PLib3MFModel_CreatePackageThumbnailAttachmentPtr m_Model_CreatePackageThumbnailAttachment;
	PLib3MFModel_GetPackageThumbnailAttachmentPtr m_Model_GetPackageThumbnailAttachment;
	PLib3MFModel_RemovePackageThumbnailAttachmentPtr m_Model_RemovePackageThumbnailAttachment;
	PLib3MFModel_AddCustomContentTypePtr m_Model_AddCustomContentType;
	PLib3MFModel_RemoveCustomContentTypePtr m_Model_RemoveCustomContentType;
	PLib3MFModel_SetRandomNumberCallbackPtr m_Model_SetRandomNumberCallback;
	PLib3MFModel_GetKeyStorePtr m_Model_GetKeyStore;
	PLib3MFGetLibraryVersionPtr m_GetLibraryVersion;
	PLib3MFGetPrereleaseInformationPtr m_GetPrereleaseInformation;
	PLib3MFGetBuildInformationPtr m_GetBuildInformation;
	PLib3MFGetSpecificationVersionPtr m_GetSpecificationVersion;
	PLib3MFCreateModelPtr m_CreateModel;
	PLib3MFReleasePtr m_Release;
	PLib3MFAcquirePtr m_Acquire;
	PLib3MFSetJournalPtr m_SetJournal;
	PLib3MFGetLastErrorPtr m_GetLastError;
	PLib3MFRetrieveProgressMessagePtr m_RetrieveProgressMessage;
	PLib3MFRGBAToColorPtr m_RGBAToColor;
	PLib3MFFloatRGBAToColorPtr m_FloatRGBAToColor;
	PLib3MFColorToRGBAPtr m_ColorToRGBA;
	PLib3MFColorToFloatRGBAPtr m_ColorToFloatRGBA;
	PLib3MFGetIdentityTransformPtr m_GetIdentityTransform;
	PLib3MFGetUniformScaleTransformPtr m_GetUniformScaleTransform;
	PLib3MFGetScaleTransformPtr m_GetScaleTransform;
	PLib3MFGetTranslationTransformPtr m_GetTranslationTransform;
} sLib3MFDynamicWrapperTable;

/*************************************************************************************************************************
 Load DLL dynamically
**************************************************************************************************************************/
Lib3MFResult InitLib3MFWrapperTable(sLib3MFDynamicWrapperTable * pWrapperTable);
Lib3MFResult ReleaseLib3MFWrapperTable(sLib3MFDynamicWrapperTable * pWrapperTable);
Lib3MFResult LoadLib3MFWrapperTable(sLib3MFDynamicWrapperTable * pWrapperTable, const char * pLibraryFileName);

#endif // __LIB3MF_DYNAMICHEADER

