//B. Vandeportaele 2021
//paramètres des mors schunk
epaisseur=6.2;
largeur=14;
hauteur=12; //pas bien mesuré

//corps de la pince
x_corps_pince=40.5;
y_corps_pince=22;
z_corps_pince=88;
//connecteur pince/robot
diametre_connecteur_pince=60;
h_connecteur_pince_bas=9.5;
h_connecteur_pince_haut=11.5;  



jeu=0.6;
eps=0.01;

//ecart_doigt=10; //old


ecart_doigt_ferme=15.5; //ecart entre intérieur des mors pince fermée
ecart_doigt_ouvert=28.2; //ecart entre intérieur des mors pince ouverte      
       
resolutionpart=60;//default value for the constant printerpart, it can be changed through command line using -D
//https://en.wikibooks.org/wiki/OpenSCAD_User_Manual/Using_OpenSCAD_in_a_command_line_environment
//use compile.sh to generate the stl files in stl/ subdirectory
resolution=resolutionpart;  //assign the constant value to a variable to be able to test it, even if the constant hasn't been defined in command line


dimcube=57;

////////////////////////////////////////
module rubikscube(){
translate([-dimcube/2,-dimcube/2,-dimcube-10])   
cube([dimcube,dimcube,dimcube]);
}
////////////////////////////////////////

///////////////////////////////////////// 
module vis(jeu){ //jeu= diametre a ajouter par rapport au dimension de la vrai vis
  hauteur_tete=4.3;
  hauteur_filetage=9+0.2; //+0.2 pour que le modèle déborde et n'affleure pas lors de difference          
  union(){   
    translate([0,0,hauteur_tete/2])
      cylinder(h = hauteur_tete, d = 8.5+jeu, center = true,$fn=resolution);   //tête
    translate([0,0,hauteur_tete+ hauteur_filetage/2-0.1])
      cylinder(h = hauteur_filetage, d = 4+jeu, center = true,$fn=resolution);   //filetage          
  }
}
/////////////////////////////////////////      
module mors_schunk_et_vis(jeu_largeur=0){  //jeu_largeur=2 pour faire le trou dans pièce plastique, 0 pour la vraie piece  
  translate([-epaisseur,-largeur/2,0])     
    union(){
      translate([0,- jeu_largeur/2,0])     
        cube([epaisseur,largeur+jeu_largeur,hauteur],center=false);  
      translate([-8,largeur/2,hauteur/2])     
        rotate(90,[0,1,0])
          vis(1);
    }
}
///////////////////////////////////////// 
module pince(position,jeu_largeur=0){//jeu_largeur=2 pour faire le trou dans pièce plastique, 0 pour la vraie piece  
  /*
  if (position==0) {//fermé
    ecart_doigt=ecart_doigt_ferme;
  }else{
    ecart_doigt=ecart_doigt_ouvert;
  }*/
  ecart_doigt=position*ecart_doigt_ouvert+(1-position)*ecart_doigt_ferme;
  
  //ecart_doigt=0; pour debuf, les mors doivent se toucher: OK
  echo(ecart_doigt);
   color([0.5,0.5,0.5,1]){
  for (i=[0:1])       
    rotate([0,0,180*i])
      translate([-ecart_doigt/2,0,0])  
        mors_schunk_et_vis(jeu_largeur);
  translate([-x_corps_pince/2,-y_corps_pince/2,hauteur])     
     cube([x_corps_pince,y_corps_pince,z_corps_pince],center=false);  
  //translate

  translate([0,0,hauteur+z_corps_pince+h_connecteur_pince_bas/2])     
    cylinder(h = h_connecteur_pince_bas, d = diametre_connecteur_pince, center = true,$fn=resolution);
  translate([0,0,hauteur+z_corps_pince+h_connecteur_pince_bas+h_connecteur_pince_haut/2])     
    cylinder(h = h_connecteur_pince_haut, d = diametre_connecteur_pince, center = true,$fn=resolution);          
  }
}
///////////////////////////////////////// 
module bouchon(diametre){
    //diametre=40 pour prévoir le TPU entre bouchon et gripper PLA
    //diametre 32 utilisé pour le gripper AIP
  translate([0,0,-12])    
    cylinder(h = 10.8, d = diametre, center = true,$fn=resolution);   
}
/////////////////////////////////////////  
module gripperiut(){
  color([0,0,1,1])
  difference(){
    union(){
      //translate([0,0,-8])    
      //  cylinder(h = 10.8+5, d = 32+20, center = true,$fn=resolution);   //diametre 32 utilisé pour le gripper AIP
      translate([0,0,-(10+dimcube*0.55)/2])             
        cube([dimcube+10*2,20,10+dimcube*0.55],center=true);
      for (i=[0:1])          
        rotate([0,0,180*i])
          translate([11,-10,-0.1])
            cube([10,20,12],center=false); 
    }
    pince(0,2);
    //bouchon(40); 
    rubikscube();
    videentrepince();
  }
}
///////////////////////////////////////// 
module gripperiutouvert(){
    for (i=[-1:2:1]){
    translate([i*7,0,0])  
    difference(){
         gripperiut();
         translate([(i+1)*-50,-50,-50]) 
           cube([100,100,100],center=false); 
     }
 }
}
///////////////////////////////////////// 
module videentrepince(){
    cube([21.8,55,50],center=true);     
}
///////////////////////////////////////// 
module morsTPU(){
   color([1,0,0,1])
    difference(){
    bouchon(38);  //1mm de colle entre pince et mors
    translate([0,0,-1]) bouchon(32);  //le bouchon un peu plus bas
    videentrepince(); //la séparation
  }    
}
///////////////////////////////////////// 
module morsTPUouvert(){
        for (i=[-1:2:1]){
    translate([i*7,0,0])  
    difference(){
         morsTPU();
         translate([(i+1)*-50,-50,-30]) 
          cube([100,100,100],center=false); 
     }
 }
}
/////////////////////////////// 
  
printerpart=0;//default value for the constant printerpart, it can be changed through command line using -D
//https://en.wikibooks.org/wiki/OpenSCAD_User_Manual/Using_OpenSCAD_in_a_command_line_environment
//use compile.sh to generate the stl files in stl/ subdirectory
type=printerpart;  //assign the constant value to a variable to be able to test it, even if the constant hasn't been defined in command line
//pour visualisation de l'assemblage

if (type==0)
 {
  
         gripperiutouvert();
  }
  
  ////////////////////////////////////
//pour impression via script compile.sh
/*if (type==1)
    rotate ([180,0,0])  piece();
if (type==2)
       rotate ([180,0,0])   caoutchoucgripper();
  */
  
  //pince référencée pour être mise sur SRS (z=0 au handle, handler en z=140 et axe z dans la direction bride vers mors)
 if (type==2){ //pince ouverte
     translate([0,0,hauteur+z_corps_pince+h_connecteur_pince_bas+h_connecteur_pince_haut])
       rotate ([180,0,0]) {
         pince(1,0); //pince ouverte
         gripperiutouvert();
         //morsTPUouvert();
       }
 }
 if (type==3){ //pince fermée
     translate([0,0,hauteur+z_corps_pince+h_connecteur_pince_bas+h_connecteur_pince_haut])
       rotate ([180,0,0]) {
         pince(0,0); //pince fermée
         gripperiut();
         //morsTPU();
        }
 }
 if (type==4){ //pour impression partie PLA pince IUT, rendre avec F6  
     gripperiut();
 }
/*if (type==5){ //pour impression partie TPU pince IUT , rendre avec F6
  rotate ([180,0,0]) 
    morsTPU();
}
*/
if (type==6){//assemblage complet pour visu en couleur avec F5 , rendre avec F6
  color([0,0,1])       gripperiut();
  //color([1,0,0])       morsTPU();    
      rubikscube();
  color([0.5,0.5,0.5]) pince(0,0);
}