/*! \file lib_io_tp.cpp
    \brief Premier TD pour le CESI.
    \author Bertrand Vandeportaele IUT GEII
    \date  28/10/2021
*/  
#include "lib_io_tp.h"
bool SIMULATION=true; //si cette variable est true, alors la librairie utilise les composants registres
//à décalage en simulation sur Wokwi, sinon elle utilise les composants PCF8574 de la carte de TP
//Pour les composants I2C:
#include <Wire.h>
#define SLAVE_ADDR_8574_A (0x38+6)
#define SLAVE_ADDR_8574_B (0x38+7)
//Pour les composants en simulation:
//Librairie pour registres à décalage sur Wokwi.com
/*mix de 
https://wokwi.com/arduino/projects/313005664351814210
et de
https://wokwi.com/arduino/projects/301188813482361352
*/
// Pin definitions:
const int datapin_in = 9;   /* Q7 */
const int clockpin_in =  8;  /* CP */
const int latchpin_in = 4;  /* PL */
const int datapin_out = 5; 
const int clockpin_out = 6;
const int latchpin_out = 7;
/////////////////////////////////////////////////////// 
/*!
 * \brief Fonction d'initialisation des ressources matérielles pour accéder aux ports d'entrée/sortie
*/
void SetupES(void){
  Wire.begin();
  delay(100);
  //teste si un composant 8574 est présent sur la carte
  for (byte addr=0x38;addr<=0x3f;addr++){
    Wire.requestFrom(addr, (byte)1);// demande la lecture d'1 octet depuis l'adresse du pérpiphérique
    if (Wire.available()==1) {
        Wire.read(); 
        SIMULATION=false;  //Utilisation des composants I2C plutot que des registres à décalage
        //Serial.print("premier composant i2c trouvé a:");Serial.println(addr,HEX);
        break;
    }     
  }
  if (SIMULATION==false){
    delay(100);
    Wire.beginTransmission((byte)SLAVE_ADDR_8574_B);Wire.write((byte)0xff);Wire.endTransmission();//configure le composant B en entrée
  }else{
    pinMode(datapin_in, INPUT);
    pinMode(clockpin_in, OUTPUT);
    pinMode(latchpin_in, OUTPUT);
    // Set the three SPI pins to be outputs:
    pinMode(datapin_out, OUTPUT);
    pinMode(clockpin_out, OUTPUT);  
    pinMode(latchpin_out, OUTPUT);  
  }
}
///////////////////////////////////////////////////////
/*!
 * \brief Fonction de lecture du port d'entrée
 * @return valeur 8 bits lue sur le port
*/
unsigned char readPort(void){
   if (SIMULATION==false){
     Wire.requestFrom((byte)SLAVE_ADDR_8574_B, (byte)1);// demande la lecture d'1 octet depuis l'adresse du pérpiphérique
      if (Wire.available()==1) //si l'octet est disponible
          return Wire.read(); // lire l'octet
      else
          return 0;
   }else{
     unsigned char val=0;
     // Step 1: Sample
     digitalWrite(latchpin_in, LOW);
     digitalWrite(latchpin_in, HIGH);
     for (int i = 0; i < 8; i++) {
       int bit = digitalRead(datapin_in);
       val=(val<<1)|bit;
       digitalWrite(clockpin_in, HIGH); // Shift out the next bit
       digitalWrite(clockpin_in, LOW);
     }
     return val;
   }
}
///////////////////////////////////////////////////////
/*!
 * \brief Fonction d'écriture vers le port de sortie
 * @param value valeur 8 bits à écrire sur le port
*/
void writePort(unsigned char value){
//cette fonction pilote les 8 leds avec la valeur 8bits fournie dans le paramètre valeur 
   if (SIMULATION==false){  
     Wire.beginTransmission((byte)SLAVE_ADDR_8574_A);//démarre la transmission avec l'adresse du pérpiphérique
     Wire.write(~(byte)value);     //envoie la donnée complémentée car les LEDs s'allument à l'état 0
     Wire.endTransmission();
   }else{
     shiftOut(datapin_out, clockpin_out, MSBFIRST, value); //Send "data" to the shift register
     //Toggle the latchpin_out to make "data" appear at the outputs
     digitalWrite(latchpin_out, HIGH); 
     digitalWrite(latchpin_out, LOW);  
   }
}
/////////////////////////////////////////////////////// 
